/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;

public final class ChangeTypeInStringLiteral
extends Recipe {
    @Option(displayName="Old fully-qualified type name", description="Fully-qualified class name of the original type.", example="org.junit.Assume")
    private final String oldFullyQualifiedTypeName;
    @Option(displayName="New fully-qualified type name", description="Fully-qualified class name of the replacement type, or the name of a primitive such as \"int\". The `OuterClassName$NestedClassName` naming convention should be used for nested classes.", example="org.junit.jupiter.api.Assumptions")
    private final String newFullyQualifiedTypeName;

    public String getDisplayName() {
        return "Change type in String literals";
    }

    public Validated<Object> validate() {
        return Validated.none().and(Validated.notBlank((String)"oldPackageName", (String)this.oldFullyQualifiedTypeName)).and(Validated.required((String)"newPackageName", (Object)this.newFullyQualifiedTypeName));
    }

    public String getDescription() {
        return "Change a given type to another when used in a String literal.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final Pattern stringLiteralPattern = Pattern.compile("\\b" + this.oldFullyQualifiedTypeName + "\\b");
        return new JavaVisitor<ExecutionContext>(){

            @Override
            public J visitLiteral(J.Literal literal, ExecutionContext ctx) {
                Matcher matcher;
                J.Literal lit = literal;
                if (literal.getType() == JavaType.Primitive.String && lit.getValue() != null && (matcher = stringLiteralPattern.matcher((String)lit.getValue())).find()) {
                    lit = lit.withValue(matcher.replaceAll(ChangeTypeInStringLiteral.this.newFullyQualifiedTypeName)).withValueSource(stringLiteralPattern.matcher(lit.getValueSource()).replaceAll(ChangeTypeInStringLiteral.this.newFullyQualifiedTypeName));
                }
                return super.visitLiteral(lit, ctx);
            }
        };
    }

    @Generated
    public ChangeTypeInStringLiteral(String oldFullyQualifiedTypeName, String newFullyQualifiedTypeName) {
        this.oldFullyQualifiedTypeName = oldFullyQualifiedTypeName;
        this.newFullyQualifiedTypeName = newFullyQualifiedTypeName;
    }

    @Generated
    public String getOldFullyQualifiedTypeName() {
        return this.oldFullyQualifiedTypeName;
    }

    @Generated
    public String getNewFullyQualifiedTypeName() {
        return this.newFullyQualifiedTypeName;
    }

    @NonNull
    @Generated
    public String toString() {
        return "ChangeTypeInStringLiteral(oldFullyQualifiedTypeName=" + this.getOldFullyQualifiedTypeName() + ", newFullyQualifiedTypeName=" + this.getNewFullyQualifiedTypeName() + ")";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChangeTypeInStringLiteral)) {
            return false;
        }
        ChangeTypeInStringLiteral other = (ChangeTypeInStringLiteral)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$oldFullyQualifiedTypeName = this.getOldFullyQualifiedTypeName();
        String other$oldFullyQualifiedTypeName = other.getOldFullyQualifiedTypeName();
        if (this$oldFullyQualifiedTypeName == null ? other$oldFullyQualifiedTypeName != null : !this$oldFullyQualifiedTypeName.equals(other$oldFullyQualifiedTypeName)) {
            return false;
        }
        String this$newFullyQualifiedTypeName = this.getNewFullyQualifiedTypeName();
        String other$newFullyQualifiedTypeName = other.getNewFullyQualifiedTypeName();
        return !(this$newFullyQualifiedTypeName == null ? other$newFullyQualifiedTypeName != null : !this$newFullyQualifiedTypeName.equals(other$newFullyQualifiedTypeName));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ChangeTypeInStringLiteral;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $oldFullyQualifiedTypeName = this.getOldFullyQualifiedTypeName();
        result = result * 59 + ($oldFullyQualifiedTypeName == null ? 43 : $oldFullyQualifiedTypeName.hashCode());
        String $newFullyQualifiedTypeName = this.getNewFullyQualifiedTypeName();
        result = result * 59 + ($newFullyQualifiedTypeName == null ? 43 : $newFullyQualifiedTypeName.hashCode());
        return result;
    }
}

