/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.service;

import java.util.Collections;
import java.util.concurrent.atomic.AtomicInteger;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.Incubating;
import org.openrewrite.PrintOutputCapture;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaPrinter;
import org.openrewrite.java.search.SemanticallyEqual;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JContainer;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;

@Incubating(since="8.63.0")
public class SourcePositionService {
    public int computeColumnToAlignTo(Cursor cursor, int continuation) {
        final Cursor alignWith = this.alignsWith(cursor);
        if (alignWith == null) {
            Cursor newLinedElementCursor = this.computeNewLinedCursorElement(cursor.getParentTreeCursor());
            return ((J)newLinedElementCursor.getValue()).getPrefix().getIndent().length() + continuation;
        }
        Cursor newLinedElementCursor = this.computeNewLinedCursorElement(alignWith);
        if (alignWith == newLinedElementCursor) {
            Cursor parentCursor = this.computeNewLinedCursorElement(newLinedElementCursor.getParentTreeCursor());
            return ((J)parentCursor.getValue()).getPrefix().getIndent().length() + continuation;
        }
        if (newLinedElementCursor.getValue() instanceof J) {
            J j = (J)newLinedElementCursor.getValue();
            final AtomicInteger indentation = new AtomicInteger(-1);
            JavaPrinter javaPrinter = new JavaPrinter<TreeVisitor<?, ?>>(){

                @Override
                public J visitVariableDeclarations(J.VariableDeclarations multiVariable, PrintOutputCapture<TreeVisitor<?, ?>> p) {
                    if (multiVariable == alignWith.getValue() || SemanticallyEqual.areEqual(multiVariable, (J)alignWith.getValue())) {
                        this.beforeSyntax(multiVariable, Space.Location.VARIABLE_DECLARATIONS_PREFIX, p);
                        this.visitSpace(Space.EMPTY, Space.Location.ANNOTATIONS, p);
                        indentation.set(p.getOut().length());
                        return multiVariable;
                    }
                    return super.visitVariableDeclarations(multiVariable, p);
                }

                @Override
                public J visitMethodInvocation(J.MethodInvocation method, PrintOutputCapture<TreeVisitor<?, ?>> p) {
                    if (method == alignWith.getValue() || SemanticallyEqual.areEqual(method, (J)alignWith.getValue())) {
                        this.beforeSyntax(method, Space.Location.METHOD_INVOCATION_PREFIX, p);
                        this.visitRightPadded(method.getPadding().getSelect(), JRightPadded.Location.METHOD_SELECT, "", p);
                        indentation.set(p.getOut().length());
                        return method;
                    }
                    return super.visitMethodInvocation(method, p);
                }
            };
            PrintOutputCapture printLine = new PrintOutputCapture<TreeVisitor<?, ?>>(javaPrinter, PrintOutputCapture.MarkerPrinter.SANITIZED){

                public PrintOutputCapture<TreeVisitor<?, ?>> append(@Nullable String text) {
                    if (text != null && text.contains("\n")) {
                        this.out.setLength(0);
                        text = text.substring(text.lastIndexOf("\n") + 1);
                    }
                    return super.append(text);
                }
            };
            javaPrinter.visit(j, printLine, cursor.getParentOrThrow());
            return indentation.get();
        }
        throw new RuntimeException("Unable to calculate length due to unexpected cursor value: " + newLinedElementCursor.getValue().getClass());
    }

    public int computeTreeLength(Cursor cursor) {
        Cursor newLinedElementCursor = this.computeNewLinedCursorElement(cursor);
        if (newLinedElementCursor.getValue() instanceof J) {
            J j = (J)newLinedElementCursor.getValue();
            TreeVisitor printer = j.printer(cursor);
            PrintOutputCapture capture = new PrintOutputCapture((Object)printer, PrintOutputCapture.MarkerPrinter.SANITIZED);
            printer.visit((Tree)this.trimPrefix(j), (Object)capture, cursor.getParentOrThrow());
            return capture.getOut().length() + this.getSuffixLength(j);
        }
        throw new RuntimeException("Unable to calculate length due to unexpected cursor value: " + newLinedElementCursor.getValue().getClass());
    }

    private int getSuffixLength(J tree) {
        if (tree instanceof Statement && this.needsSemicolon((Statement)tree)) {
            return 1;
        }
        return 0;
    }

    private boolean needsSemicolon(Statement statement) {
        return statement instanceof J.MethodInvocation || statement instanceof J.VariableDeclarations || statement instanceof J.Assignment || statement instanceof J.Package || statement instanceof J.Return || statement instanceof J.Import || statement instanceof J.Assert;
    }

    private J trimPrefix(J tree) {
        return tree.withPrefix(Space.build(tree.getPrefix().getIndent(), Collections.emptyList()));
    }

    private Cursor computeNewLinedCursorElement(Cursor cursor) {
        Object cursorValue = cursor.getValue();
        while (cursorValue instanceof J.MethodInvocation && ((J.MethodInvocation)cursorValue).getSelect() instanceof J.MethodInvocation) {
            cursorValue = ((J.MethodInvocation)cursorValue).getSelect();
        }
        if (cursorValue instanceof J) {
            J j = (J)cursorValue;
            boolean hasNewLine = j.getPrefix().getWhitespace().contains("\n") || j.getComments().stream().anyMatch(c -> c.getSuffix().contains("\n"));
            Cursor parent = cursor.getParentTreeCursor();
            boolean isCompilationUnit = parent.getValue() instanceof J.CompilationUnit;
            if (!hasNewLine && !isCompilationUnit) {
                return this.computeNewLinedCursorElement(parent);
            }
        }
        return cursor;
    }

    private @Nullable Cursor alignsWith(Cursor cursor) {
        J cursorValue = (J)cursor.getValue();
        for (Cursor parent = cursor; parent != null && !(parent.getValue() instanceof SourceFile); parent = parent.getParent()) {
            Object parentValue = parent.getValue();
            if (parentValue instanceof JContainer) {
                JContainer container = (JContainer)parent.getValue();
                if (!container.getElements().stream().anyMatch(e -> e == cursorValue || SemanticallyEqual.areEqual(e, cursorValue))) continue;
                J firstElement = (J)container.getElements().get(0);
                if (!firstElement.getPrefix().getLastWhitespace().contains("\n")) {
                    if (firstElement == cursorValue || SemanticallyEqual.areEqual(firstElement, cursorValue)) {
                        return cursor;
                    }
                    return new Cursor(parent, (Object)firstElement);
                }
                return null;
            }
            if (!(parentValue instanceof J.MethodInvocation)) continue;
            while (((J.MethodInvocation)parentValue).getSelect() instanceof J.MethodInvocation) {
                parentValue = ((J.MethodInvocation)parentValue).getSelect();
                parent = new Cursor(parent, parentValue);
            }
            J.MethodInvocation method = (J.MethodInvocation)parentValue;
            if (!parent.getPathAsStream(o -> o instanceof J.MethodInvocation).anyMatch(value -> value == cursorValue || SemanticallyEqual.areEqual((J)value, cursorValue))) continue;
            if (method.getPadding().getSelect() != null && !method.getPadding().getSelect().getAfter().getLastWhitespace().contains("\n")) {
                return parent;
            }
            return null;
        }
        return null;
    }
}

