/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.tree.J;

public final class ChangePackageInStringLiteral
extends Recipe {
    @Option(displayName="Old package name", description="The package name to replace.", example="com.yourorg.foo")
    private final String oldPackageName;
    @Option(displayName="New package name", description="New package name to replace the old package name with.", example="com.yourorg.bar")
    private final String newPackageName;

    public String getInstanceNameSuffix() {
        return String.format("`%s` to `%s`", this.oldPackageName, this.newPackageName);
    }

    public String getDisplayName() {
        return "Rename package name in String literals";
    }

    public String getDescription() {
        return "A recipe that will rename a package name in String literals.";
    }

    public Validated<Object> validate() {
        return Validated.none().and(Validated.notBlank((String)"oldPackageName", (String)this.oldPackageName)).and(Validated.required((String)"newPackageName", (Object)this.newPackageName));
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final Pattern stringLiteralPattern = Pattern.compile("\\b" + this.oldPackageName + "\\b");
        return new JavaVisitor<ExecutionContext>(){

            @Override
            public J visitLiteral(J.Literal literal, ExecutionContext ctx) {
                Matcher matcher;
                J.Literal lit = literal;
                if (lit.getValue() instanceof String && (matcher = stringLiteralPattern.matcher((String)lit.getValue())).find()) {
                    lit = lit.withValue(matcher.replaceAll(ChangePackageInStringLiteral.this.newPackageName)).withValueSource(stringLiteralPattern.matcher(lit.getValueSource()).replaceAll(ChangePackageInStringLiteral.this.newPackageName));
                }
                return super.visitLiteral(lit, ctx);
            }
        };
    }

    @Generated
    public ChangePackageInStringLiteral(String oldPackageName, String newPackageName) {
        this.oldPackageName = oldPackageName;
        this.newPackageName = newPackageName;
    }

    @Generated
    public String getOldPackageName() {
        return this.oldPackageName;
    }

    @Generated
    public String getNewPackageName() {
        return this.newPackageName;
    }

    @NonNull
    @Generated
    public String toString() {
        return "ChangePackageInStringLiteral(oldPackageName=" + this.getOldPackageName() + ", newPackageName=" + this.getNewPackageName() + ")";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChangePackageInStringLiteral)) {
            return false;
        }
        ChangePackageInStringLiteral other = (ChangePackageInStringLiteral)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$oldPackageName = this.getOldPackageName();
        String other$oldPackageName = other.getOldPackageName();
        if (this$oldPackageName == null ? other$oldPackageName != null : !this$oldPackageName.equals(other$oldPackageName)) {
            return false;
        }
        String this$newPackageName = this.getNewPackageName();
        String other$newPackageName = other.getNewPackageName();
        return !(this$newPackageName == null ? other$newPackageName != null : !this$newPackageName.equals(other$newPackageName));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ChangePackageInStringLiteral;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $oldPackageName = this.getOldPackageName();
        result = result * 59 + ($oldPackageName == null ? 43 : $oldPackageName.hashCode());
        String $newPackageName = this.getNewPackageName();
        result = result * 59 + ($newPackageName == null ? 43 : $newPackageName.hashCode());
        return result;
    }
}

