/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.service;

import java.util.Collections;
import org.openrewrite.Cursor;
import org.openrewrite.Incubating;
import org.openrewrite.PrintOutputCapture;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;

@Incubating(since="8.63.0")
public class SourcePositionService {
    public int computeTreeLength(Cursor cursor) {
        Object cursorValue = cursor.getValue();
        if (cursorValue instanceof J) {
            J j = (J)cursorValue;
            boolean hasNewLine = j.getPrefix().getWhitespace().contains("\n") || j.getComments().stream().anyMatch(c -> c.getSuffix().contains("\n"));
            Cursor parent = cursor.getParentTreeCursor();
            boolean isCompilationUnit = parent.getValue() instanceof J.CompilationUnit;
            if (!hasNewLine && !isCompilationUnit) {
                return this.computeTreeLength(parent);
            }
            TreeVisitor printer = j.printer(cursor);
            PrintOutputCapture capture = new PrintOutputCapture((Object)printer, PrintOutputCapture.MarkerPrinter.SANITIZED);
            printer.visit((Tree)this.trimPrefix(j), (Object)capture, cursor.getParentOrThrow());
            return capture.getOut().length() + this.getSuffixLength(j);
        }
        throw new RuntimeException("Unable to calculate length due to unexpected cursor value: " + cursorValue.getClass());
    }

    private int getSuffixLength(J tree) {
        if (tree instanceof Statement && this.needsSemicolon((Statement)tree)) {
            return 1;
        }
        return 0;
    }

    private boolean needsSemicolon(Statement statement) {
        return statement instanceof J.MethodInvocation || statement instanceof J.VariableDeclarations || statement instanceof J.Assignment || statement instanceof J.Package || statement instanceof J.Return || statement instanceof J.Import || statement instanceof J.Assert;
    }

    private J trimPrefix(J tree) {
        Space prefix = tree.getPrefix();
        String whitespace = prefix.getLastWhitespace().replaceFirst("^.*\\n*", "");
        prefix = prefix.withComments(Collections.emptyList()).withWhitespace(whitespace);
        return tree.withPrefix(prefix);
    }
}

