/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Validated;
import org.openrewrite.java.PatternTypeNameMatcher;
import org.openrewrite.java.TypeMatcher;
import org.openrewrite.java.TypeNameMatcher;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TypeUtils;

public class MethodMatcher {
    public static final String METHOD_PATTERN_DECLARATIONS_DESCRIPTION = "A [method pattern](https://docs.openrewrite.org/reference/method-patterns) is used to find matching method declarations. For example, to find all method declarations in the Guava library, use the pattern: `com.google.common..*#*(..)`.<br/><br/>The pattern format is `<PACKAGE>#<METHOD_NAME>(<ARGS>)`. <br/><br/>`..*` includes all subpackages of `com.google.common`. <br/>`*(..)` matches any method name with any number of arguments. <br/><br/>For more specific queries, like Guava's `ImmutableMap`, use `com.google.common.collect.ImmutableMap#*(..)` to narrow down the results.";
    public static final String METHOD_PATTERN_INVOCATIONS_DESCRIPTION = "A [method pattern](https://docs.openrewrite.org/reference/method-patterns) is used to find matching method invocations. For example, to find all method invocations in the Guava library, use the pattern: `com.google.common..*#*(..)`.<br/><br/>The pattern format is `<PACKAGE>#<METHOD_NAME>(<ARGS>)`. <br/><br/>`..*` includes all subpackages of `com.google.common`. <br/>`*(..)` matches any method name with any number of arguments. <br/><br/>For more specific queries, like Guava's `ImmutableMap`, use `com.google.common.collect.ImmutableMap#*(..)` to narrow down the results.";
    @Deprecated
    public static final String METHOD_PATTERN_DESCRIPTION = "A [method pattern](https://docs.openrewrite.org/reference/method-patterns) is used to find matching method invocations. For example, to find all method invocations in the Guava library, use the pattern: `com.google.common..*#*(..)`.<br/><br/>The pattern format is `<PACKAGE>#<METHOD_NAME>(<ARGS>)`. <br/><br/>`..*` includes all subpackages of `com.google.common`. <br/>`*(..)` matches any method name with any number of arguments. <br/><br/>For more specific queries, like Guava's `ImmutableMap`, use `com.google.common.collect.ImmutableMap#*(..)` to narrow down the results.";
    private TypeMatcher typeMatcher;
    private MethodNameMatcher methodNameMatcher;
    private List<ArgumentMatcher> argumentMatchers;
    private int varArgsPosition = -1;
    private final boolean matchOverrides;

    public MethodMatcher(String methodPattern, @Nullable Boolean matchOverrides) {
        this(methodPattern, Boolean.TRUE.equals(matchOverrides));
    }

    public MethodMatcher(String methodPattern, boolean matchOverrides) {
        this.matchOverrides = matchOverrides;
        String patternToUse = methodPattern;
        boolean retryWithPound = false;
        try {
            this.parsePattern(patternToUse);
        }
        catch (IllegalArgumentException e) {
            int lastDot;
            int lastParen = methodPattern.lastIndexOf(40);
            if (lastParen > 0 && (lastDot = methodPattern.lastIndexOf(46, lastParen)) > 0 && lastDot < lastParen - 1) {
                patternToUse = methodPattern.substring(0, lastDot) + "#" + methodPattern.substring(lastDot + 1);
                retryWithPound = true;
            }
            if (retryWithPound) {
                try {
                    this.parsePattern(patternToUse);
                }
                catch (Exception retryException) {
                    throw e;
                }
            }
            throw e;
        }
    }

    private void parsePattern(String methodPattern) {
        Parser parser = new Parser(methodPattern);
        parser.parse();
        this.typeMatcher = parser.typeMatcher;
        this.methodNameMatcher = parser.methodNameMatcher;
        this.argumentMatchers = parser.argumentMatchers;
        this.varArgsPosition = parser.varArgsPosition;
    }

    public static Validated<String> validate(@Nullable String signature) {
        String property = "methodPattern";
        try {
            if (signature != null) {
                new MethodMatcher(signature, null);
            }
            return Validated.valid((String)property, (Object)signature);
        }
        catch (Throwable throwable) {
            return Validated.invalid((String)property, (Object)signature, (String)("Tried to construct a method matcher with an invalid method pattern. An example of a good method pattern is `java.util.List add(..)`. " + throwable.getMessage()), (Throwable)throwable);
        }
    }

    public MethodMatcher(J.MethodDeclaration method, boolean matchOverrides) {
        this(MethodMatcher.methodPattern(method), matchOverrides);
    }

    public MethodMatcher(String methodPattern) {
        this(methodPattern, false);
    }

    public MethodMatcher(J.MethodDeclaration method) {
        this(method, false);
    }

    public MethodMatcher(JavaType.Method method) {
        this(MethodMatcher.methodPattern(method), false);
    }

    private boolean matchesTargetTypeName(String fullyQualifiedTypeName) {
        return this.typeMatcher.matchesQualifiedName(fullyQualifiedTypeName);
    }

    boolean matchesTargetType(JavaType type) {
        if (this.typeMatcher.matches(type)) {
            return true;
        }
        if (this.matchOverrides && type instanceof JavaType.FullyQualified) {
            return TypeUtils.isOfTypeWithName((JavaType.FullyQualified)type, this.matchOverrides, this::matchesTargetTypeName);
        }
        return false;
    }

    private boolean matchesMethodName(String name) {
        return this.methodNameMatcher.matches(name);
    }

    private boolean matchesParameterTypes(List<JavaType> parameterTypes) {
        return this.matchesParameterTypesWithMatchers(parameterTypes);
    }

    private boolean matchesParameterTypesWithMatchers(List<JavaType> types) {
        int i;
        if (this.varArgsPosition == -1) {
            if (types.size() != this.argumentMatchers.size()) {
                return false;
            }
            for (int i2 = 0; i2 < types.size(); ++i2) {
                ArgumentMatcher matcher = this.argumentMatchers.get(i2);
                if (matcher.matches(types.get(i2))) continue;
                return false;
            }
            return true;
        }
        int beforeCount = this.varArgsPosition;
        int afterCount = this.argumentMatchers.size() - this.varArgsPosition - 1;
        if (types.size() < beforeCount + afterCount) {
            return false;
        }
        for (int i3 = 0; i3 < beforeCount; ++i3) {
            if (this.argumentMatchers.get(i3).matches(types.get(i3))) continue;
            return false;
        }
        ArgumentMatcher varargsMatcher = this.argumentMatchers.get(this.varArgsPosition);
        for (i = beforeCount; i < types.size() - afterCount; ++i) {
            if (varargsMatcher.matches(types.get(i))) continue;
            return false;
        }
        for (i = 0; i < afterCount; ++i) {
            int typeIndex = types.size() - afterCount + i;
            int matcherIndex = this.varArgsPosition + 1 + i;
            if (this.argumentMatchers.get(matcherIndex).matches(types.get(typeIndex))) continue;
            return false;
        }
        return true;
    }

    public boolean matches(@Nullable JavaType.Method type) {
        if (type == null) {
            return false;
        }
        if (!this.matchesMethodName(type.getName())) {
            return false;
        }
        if (!this.matchesParameterCount(type.getParameterTypes().size())) {
            return false;
        }
        if (!this.matchesTargetType(type.getDeclaringType())) {
            return false;
        }
        return this.matchesParameterTypes(type.getParameterTypes());
    }

    private boolean matchesParameterCount(int actualArgCount) {
        return this.varArgsPosition == -1 ? actualArgCount == this.argumentMatchers.size() : actualArgCount >= this.argumentMatchers.size() - 1;
    }

    public boolean matches(@Nullable MethodCall methodCall) {
        if (methodCall == null) {
            return false;
        }
        return this.matches(methodCall.getMethodType());
    }

    public boolean matches(@Nullable Expression maybeMethod) {
        return maybeMethod instanceof MethodCall && this.matches((MethodCall)maybeMethod);
    }

    public boolean matches(J.MethodDeclaration method, J.ClassDeclaration enclosing) {
        if (enclosing.getType() == null || !this.matchesTargetType(enclosing.getType())) {
            return false;
        }
        if (method.getMethodType() != null && !this.matchesMethodName(method.getMethodType().getName())) {
            return false;
        }
        List<JavaType> parameterTypes = method.getParameters().stream().map(MethodMatcher::variableDeclarationsType).filter(Objects::nonNull).collect(Collectors.toList());
        return this.matchesParameterTypes(parameterTypes);
    }

    public boolean matches(J.MethodDeclaration method, J.NewClass enclosing) {
        if (enclosing.getType() == null) {
            return false;
        }
        if (!TypeUtils.isAssignableTo(this::matchesTargetType, enclosing.getType())) {
            return false;
        }
        if (method.getMethodType() != null && !this.matchesMethodName(method.getMethodType().getName())) {
            return false;
        }
        List<JavaType> parameterTypes = method.getParameters().stream().map(MethodMatcher::variableDeclarationsType).filter(Objects::nonNull).collect(Collectors.toList());
        return this.matchesParameterTypes(parameterTypes);
    }

    private static @Nullable JavaType variableDeclarationsType(Statement v) {
        if (v instanceof J.VariableDeclarations) {
            J.VariableDeclarations vd = (J.VariableDeclarations)v;
            List<J.VariableDeclarations.NamedVariable> variables = vd.getVariables();
            if (!variables.isEmpty() && variables.get(0).getType() != null) {
                return variables.get(0).getType();
            }
            if (vd.getTypeAsFullyQualified() != null) {
                return vd.getTypeAsFullyQualified();
            }
            return vd.getTypeExpression() != null ? vd.getTypeExpression().getType() : null;
        }
        return null;
    }

    public boolean matches( @Nullable J.MethodInvocation method, boolean matchUnknownTypes) {
        if (method == null) {
            return false;
        }
        if (method.getMethodType() == null) {
            return matchUnknownTypes && this.matchesAllowingUnknownTypes(method);
        }
        return this.matches(method.getMethodType());
    }

    private boolean matchesAllowingUnknownTypes(J.MethodInvocation method) {
        J.Identifier select;
        if (!this.matchesMethodName(method.getSimpleName())) {
            return false;
        }
        int actualArgCount = method.getArguments().size();
        if (!this.matchesParameterCount(actualArgCount)) {
            return false;
        }
        if (method.getSelect() instanceof J.Identifier && !this.typeMatcher.matchesSimpleName((select = (J.Identifier)method.getSelect()).getSimpleName())) {
            return false;
        }
        return this.matchesArgumentsAllowingUnknownTypes(method);
    }

    private boolean matchesArgumentsAllowingUnknownTypes(J.MethodInvocation method) {
        int i;
        List<Expression> arguments = method.getArguments();
        if (this.varArgsPosition == -1) {
            if (arguments.size() != this.argumentMatchers.size()) {
                return false;
            }
            for (int i2 = 0; i2 < arguments.size(); ++i2) {
                if (this.argumentMatchers.get(i2).matchesUnknown(arguments.get(i2).getType())) continue;
                return false;
            }
            return true;
        }
        int beforeCount = this.varArgsPosition;
        int afterCount = this.argumentMatchers.size() - this.varArgsPosition - 1;
        if (arguments.size() < beforeCount + afterCount) {
            return false;
        }
        for (int i3 = 0; i3 < beforeCount; ++i3) {
            if (this.argumentMatchers.get(i3).matchesUnknown(arguments.get(i3).getType())) continue;
            return false;
        }
        ArgumentMatcher varargsMatcher = this.argumentMatchers.get(this.varArgsPosition);
        for (i = beforeCount; i < arguments.size() - afterCount; ++i) {
            if (varargsMatcher.matchesUnknown(arguments.get(i).getType())) continue;
            return false;
        }
        for (i = 0; i < afterCount; ++i) {
            int argIndex = arguments.size() - afterCount + i;
            int matcherIndex = this.varArgsPosition + 1 + i;
            if (this.argumentMatchers.get(matcherIndex).matchesUnknown(arguments.get(argIndex).getType())) continue;
            return false;
        }
        return true;
    }

    public boolean isFullyQualifiedClassReference(J.FieldAccess fieldAccess) {
        if (!this.methodNameMatcher.matches(fieldAccess.getName().getSimpleName())) {
            return false;
        }
        Expression target = fieldAccess.getTarget();
        if (target instanceof J.Identifier) {
            String simpleName = ((J.Identifier)target).getSimpleName();
            return this.typeMatcher.matchesSimpleName(simpleName);
        }
        if (target instanceof J.FieldAccess) {
            StringBuilder builder = new StringBuilder();
            while (target instanceof J.FieldAccess) {
                builder.insert(0, ((J.FieldAccess)target).getSimpleName());
                builder.insert(0, '.');
                target = ((J.FieldAccess)target).getTarget();
            }
            if (target instanceof J.Identifier) {
                builder.insert(0, ((J.Identifier)target).getSimpleName());
            }
            return this.typeMatcher.matchesQualifiedName(builder.toString());
        }
        return false;
    }

    private static @Nullable String typePattern(JavaType type) {
        if (type instanceof JavaType.Primitive) {
            if (type.equals(JavaType.Primitive.String)) {
                return ((JavaType.Primitive)type).getClassName();
            }
            return ((JavaType.Primitive)type).getKeyword();
        }
        if (type instanceof JavaType.Unknown) {
            return "*";
        }
        if (type instanceof JavaType.FullyQualified) {
            return ((JavaType.FullyQualified)type).getFullyQualifiedName();
        }
        if (type instanceof JavaType.Array) {
            JavaType elemType = ((JavaType.Array)type).getElemType();
            return MethodMatcher.typePattern(elemType) + "[]";
        }
        return null;
    }

    public static String methodPattern(J.MethodDeclaration method) {
        assert (method.getMethodType() != null);
        return MethodMatcher.methodPattern(method.getMethodType());
    }

    public static String methodPattern(JavaType.Method method) {
        StringJoiner parameters = new StringJoiner(", ", "(", ")");
        for (JavaType javaType : method.getParameterTypes()) {
            String s = MethodMatcher.typePattern(javaType);
            if (s == null) continue;
            parameters.add(s);
        }
        return MethodMatcher.typePattern(method.getDeclaringType()) + " " + method.getName() + parameters;
    }

    public String toString() {
        StringJoiner arguments = new StringJoiner(", ", "(", ")");
        for (ArgumentMatcher argumentMatcher : this.argumentMatchers) {
            arguments.add(argumentMatcher.toString());
        }
        return this.typeMatcher + " " + this.methodNameMatcher + arguments;
    }

    static @Nullable String extractTypeName(JavaType type) {
        if (type instanceof JavaType.Primitive) {
            JavaType.Primitive primitive = (JavaType.Primitive)type;
            if (primitive == JavaType.Primitive.String) {
                return primitive.getClassName();
            }
            return primitive.getKeyword();
        }
        if (type instanceof JavaType.FullyQualified) {
            return ((JavaType.FullyQualified)type).getFullyQualifiedName();
        }
        return null;
    }

    static @Nullable JavaType unwrapArrays(JavaType type, int expectedArrayDepth, boolean expectVarargs) {
        while (expectedArrayDepth > 0 && type instanceof JavaType.Array) {
            type = ((JavaType.Array)type).getElemType();
            --expectedArrayDepth;
        }
        if (expectedArrayDepth > 0) {
            return null;
        }
        if (expectVarargs) {
            if (type instanceof JavaType.Array) {
                type = ((JavaType.Array)type).getElemType();
            } else {
                return null;
            }
        }
        return type instanceof JavaType.Unknown ? null : type;
    }

    @Generated
    public boolean isMatchOverrides() {
        return this.matchOverrides;
    }

    static class Parser {
        private final String pattern;
        private TypeMatcher typeMatcher;
        private MethodNameMatcher methodNameMatcher;
        private List<ArgumentMatcher> argumentMatchers;
        private int varArgsPosition = -1;
        private boolean hasWildcardVarArgs = false;

        void parse() {
            int openParen = this.pattern.indexOf(40);
            if (openParen == -1) {
                throw new IllegalArgumentException("Invalid method pattern - missing '(': " + this.pattern);
            }
            int closeParen = this.pattern.lastIndexOf(41);
            if (closeParen == -1 || closeParen <= openParen) {
                throw new IllegalArgumentException("Invalid method pattern - missing or misplaced ')': " + this.pattern);
            }
            int separator = this.pattern.lastIndexOf(35, openParen);
            if (separator == -1 && (separator = this.pattern.lastIndexOf(32, openParen)) == -1) {
                throw new IllegalArgumentException("Invalid method pattern - missing type/method separator: " + this.pattern);
            }
            String typePattern = this.pattern.substring(0, separator).trim();
            if (typePattern.isEmpty()) {
                throw new IllegalArgumentException("Invalid method pattern - empty type pattern: " + this.pattern);
            }
            this.typeMatcher = this.parseTypeMatcher(typePattern);
            String methodName = this.pattern.substring(separator + 1, openParen).trim();
            if (methodName.isEmpty()) {
                throw new IllegalArgumentException("Invalid method pattern - empty method name: " + this.pattern);
            }
            this.methodNameMatcher = this.parseMethodNameMatcher(methodName);
            String argsString = this.pattern.substring(openParen + 1, closeParen).trim();
            this.parseArguments(argsString);
        }

        private TypeMatcher parseTypeMatcher(String typePattern) {
            TypeMatcher.ParsedType parsed = this.parseType(typePattern);
            if ("*".equals(parsed.getBaseType()) && parsed.getArrayDimensions() == 0) {
                return WildcardTypeMatcher.INSTANCE;
            }
            TypeNameMatcher nameMatcher = TypeNameMatcher.fromPattern(parsed.getBaseType());
            if (nameMatcher instanceof PatternTypeNameMatcher && ((PatternTypeNameMatcher)nameMatcher).isFullWildcard() && parsed.getArrayDimensions() == 0) {
                return WildcardTypeMatcher.INSTANCE;
            }
            return new StandardTypeMatcher(nameMatcher, parsed.getArrayDimensions());
        }

        private TypeMatcher.ParsedType parseType(String typePattern) {
            return org.openrewrite.java.TypeMatcher.parseTypePattern(typePattern);
        }

        private MethodNameMatcher parseMethodNameMatcher(String methodName) {
            if ("<constructor>".equals(methodName) || "<init>".equals(methodName)) {
                return new ConstructorMethodNameMatcher(methodName);
            }
            if ("<default>".equals(methodName)) {
                return new ExactMethodNameMatcher("<default>");
            }
            if (methodName.contains("*")) {
                boolean isFullWildcard = "*".equals(methodName);
                return new PatternMethodNameMatcher(methodName, isFullWildcard);
            }
            return new ExactMethodNameMatcher(methodName);
        }

        private void parseArguments(String argsString) {
            int commaPos;
            this.argumentMatchers = new ArrayList<ArgumentMatcher>();
            this.varArgsPosition = -1;
            if (argsString.isEmpty()) {
                return;
            }
            if ("..".equals(argsString)) {
                this.argumentMatchers.add(WildcardVarArgsMatcher.INSTANCE);
                this.varArgsPosition = 0;
                return;
            }
            int start = 0;
            while ((commaPos = argsString.indexOf(44, start)) != -1) {
                this.processArgument(argsString.substring(start, commaPos).trim());
                start = commaPos + 1;
            }
            this.processArgument(argsString.substring(start).trim());
        }

        private void processArgument(String arg) {
            if (arg.isEmpty()) {
                return;
            }
            if ("..".equals(arg)) {
                if (this.hasWildcardVarArgs) {
                    throw new IllegalArgumentException("Invalid method pattern - only one wildcard varargs (..) is allowed: " + this.pattern);
                }
                this.hasWildcardVarArgs = true;
                if (this.varArgsPosition == -1) {
                    this.varArgsPosition = this.argumentMatchers.size();
                }
                this.argumentMatchers.add(WildcardVarArgsMatcher.INSTANCE);
            } else if ("*".equals(arg)) {
                this.argumentMatchers.add(WildcardMatcher.INSTANCE);
            } else if (arg.endsWith("...")) {
                ArgumentMatcher baseMatcher;
                String baseType = arg.substring(0, arg.length() - 3).trim();
                if (this.varArgsPosition == -1) {
                    this.varArgsPosition = this.argumentMatchers.size();
                }
                if ((baseMatcher = this.parseArgumentMatcher(baseType)) instanceof StandardArgumentMatcher) {
                    this.argumentMatchers.add(new VarArgsMatcher((StandardArgumentMatcher)baseMatcher));
                } else {
                    this.argumentMatchers.add(baseMatcher);
                }
            } else {
                this.argumentMatchers.add(this.parseArgumentMatcher(arg));
            }
        }

        private ArgumentMatcher parseArgumentMatcher(String typePattern) {
            if ("*".equals(typePattern)) {
                return WildcardMatcher.INSTANCE;
            }
            TypeMatcher.ParsedType parsed = this.parseType(typePattern);
            TypeNameMatcher nameMatcher = TypeNameMatcher.fromPattern(parsed.getBaseType());
            return new StandardArgumentMatcher(nameMatcher, parsed.getArrayDimensions());
        }

        @Generated
        public Parser(String pattern) {
            this.pattern = pattern;
        }
    }

    static interface TypeMatcher {
        public boolean matches(JavaType var1);

        public boolean matchesQualifiedName(String var1);

        public boolean matchesSimpleName(String var1);
    }

    static interface MethodNameMatcher {
        public boolean matches(String var1);
    }

    static interface ArgumentMatcher {
        public boolean matches(JavaType var1);

        public boolean matchesUnknown(@Nullable JavaType var1);
    }

    static enum WildcardVarArgsMatcher implements ArgumentMatcher
    {
        INSTANCE;


        @Override
        public boolean matches(JavaType type) {
            return true;
        }

        @Override
        public boolean matchesUnknown(@Nullable JavaType type) {
            return true;
        }

        public String toString() {
            return "..";
        }
    }

    static class VarArgsMatcher
    implements ArgumentMatcher {
        private final StandardArgumentMatcher elementMatcher;

        @Override
        public boolean matches(JavaType type) {
            JavaType elemType;
            if (type instanceof JavaType.Array && this.elementMatcher.matches(elemType = ((JavaType.Array)type).getElemType())) {
                return true;
            }
            return this.elementMatcher.matches(type);
        }

        @Override
        public boolean matchesUnknown(@Nullable JavaType type) {
            if (type == null || type instanceof JavaType.Unknown) {
                return true;
            }
            return this.matches(type);
        }

        public String toString() {
            return this.elementMatcher + "...";
        }

        @Generated
        public VarArgsMatcher(StandardArgumentMatcher elementMatcher) {
            this.elementMatcher = elementMatcher;
        }
    }

    static enum WildcardMatcher implements ArgumentMatcher
    {
        INSTANCE;


        @Override
        public boolean matches(JavaType type) {
            return true;
        }

        @Override
        public boolean matchesUnknown(@Nullable JavaType type) {
            return true;
        }

        public String toString() {
            return "*";
        }
    }

    static class StandardArgumentMatcher
    implements ArgumentMatcher {
        final TypeNameMatcher nameMatcher;
        final int arrayDimensions;

        @Override
        public boolean matches(JavaType type) {
            if ((type = MethodMatcher.unwrapArrays(type, this.arrayDimensions, false)) == null) {
                return false;
            }
            String typeName = MethodMatcher.extractTypeName(type);
            return typeName != null && this.nameMatcher.matches(typeName);
        }

        @Override
        public boolean matchesUnknown(@Nullable JavaType type) {
            if (type == null || type instanceof JavaType.Unknown) {
                return true;
            }
            return this.matches(type);
        }

        public String toString() {
            return this.nameMatcher.toString();
        }

        @Generated
        public StandardArgumentMatcher(TypeNameMatcher nameMatcher, int arrayDimensions) {
            this.nameMatcher = nameMatcher;
            this.arrayDimensions = arrayDimensions;
        }
    }

    static class PatternMethodNameMatcher
    implements MethodNameMatcher {
        private final String pattern;
        private final boolean isFullWildcard;

        @Override
        public boolean matches(String methodName) {
            return this.isFullWildcard || this.matchesMethodPattern(this.pattern, methodName, 0, 0);
        }

        private boolean matchesMethodPattern(String pattern, String text, int pIdx, int tIdx) {
            int pLength = pattern.length();
            int tLength = text.length();
            while (pIdx < pLength) {
                char p;
                if (tIdx >= tLength) {
                    while (pIdx < pLength && pattern.charAt(pIdx) == '*') {
                        ++pIdx;
                    }
                    return pIdx >= pLength;
                }
                if ((p = pattern.charAt(pIdx++)) == '*') {
                    if (pIdx >= pLength) {
                        return true;
                    }
                    if (this.matchesMethodPattern(pattern, text, pIdx, tIdx)) {
                        return true;
                    }
                    while (tIdx < tLength) {
                        if (!this.matchesMethodPattern(pattern, text, pIdx, ++tIdx)) continue;
                        return true;
                    }
                    return false;
                }
                if (text.charAt(tIdx) != p) {
                    return false;
                }
                ++tIdx;
            }
            return tIdx >= tLength;
        }

        public String toString() {
            return this.pattern;
        }

        @Generated
        public PatternMethodNameMatcher(String pattern, boolean isFullWildcard) {
            this.pattern = pattern;
            this.isFullWildcard = isFullWildcard;
        }
    }

    static class ConstructorMethodNameMatcher
    implements MethodNameMatcher {
        private final String originalName;

        @Override
        public boolean matches(String name) {
            return "<constructor>".equals(name);
        }

        public String toString() {
            return "<init>".equals(this.originalName) ? "<constructor>" : this.originalName;
        }

        @Generated
        public ConstructorMethodNameMatcher(String originalName) {
            this.originalName = originalName;
        }
    }

    static class ExactMethodNameMatcher
    implements MethodNameMatcher {
        private final String methodName;

        @Override
        public boolean matches(String name) {
            return this.methodName.equals(name);
        }

        public String toString() {
            return this.methodName;
        }

        @Generated
        public ExactMethodNameMatcher(String methodName) {
            this.methodName = methodName;
        }
    }

    static enum WildcardTypeMatcher implements TypeMatcher
    {
        INSTANCE;


        @Override
        public boolean matches(@Nullable JavaType type) {
            return true;
        }

        @Override
        public boolean matchesQualifiedName(String qualifiedName) {
            return true;
        }

        @Override
        public boolean matchesSimpleName(String simpleName) {
            return true;
        }

        public String toString() {
            return "*";
        }
    }

    static class StandardTypeMatcher
    implements TypeMatcher {
        private final TypeNameMatcher nameMatcher;
        private final int arrayDimensions;

        @Override
        public boolean matches(JavaType type) {
            if ((type = MethodMatcher.unwrapArrays(type, this.arrayDimensions, false)) == null) {
                return false;
            }
            String typeName = MethodMatcher.extractTypeName(type);
            return typeName != null && this.nameMatcher.matches(typeName);
        }

        @Override
        public boolean matchesQualifiedName(String qualifiedName) {
            return this.nameMatcher.matches(qualifiedName);
        }

        @Override
        public boolean matchesSimpleName(String simpleName) {
            return this.nameMatcher.matchesSimpleName(simpleName);
        }

        public String toString() {
            return this.nameMatcher.toString();
        }

        @Generated
        public StandardTypeMatcher(TypeNameMatcher nameMatcher, int arrayDimensions) {
            this.nameMatcher = nameMatcher;
            this.arrayDimensions = arrayDimensions;
        }
    }
}

