/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.tree;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.function.UnaryOperator;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.internal.rpc.JavaReceiver;
import org.openrewrite.java.internal.rpc.JavaSender;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.Space;
import org.openrewrite.marker.Markers;

public final class JRightPadded<T> {
    private static JavaSender RPC_SENDER = new JavaSender();
    private static JavaReceiver RPC_RECEIVER = new JavaReceiver();
    private final T element;
    private final Space after;
    private final Markers markers;

    public JRightPadded<T> map(UnaryOperator<T> map) {
        return this.withElement(map.apply(this.element));
    }

    public static <T> List<T> getElements(@Nullable List<JRightPadded<T>> ls) {
        if (ls == null) {
            return Collections.emptyList();
        }
        ArrayList<T> list = new ArrayList<T>(ls.size());
        for (JRightPadded<T> l : ls) {
            if (l == null) continue;
            T elem = l.getElement();
            list.add(elem);
        }
        return list;
    }

    public static <T> @Nullable JRightPadded<T> withElement(@Nullable JRightPadded<T> before, @Nullable T element) {
        if (element == null) {
            return null;
        }
        if (before == null) {
            return new JRightPadded<T>(element, Space.EMPTY, Markers.EMPTY);
        }
        return before.withElement(element);
    }

    public static <J2 extends J> List<JRightPadded<J2>> withElements(List<JRightPadded<J2>> before, List<J2> elements) {
        if (elements.size() == before.size()) {
            boolean hasChanges = false;
            for (int i = 0; i < before.size(); ++i) {
                if (before.get(i).getElement() == elements.get(i)) continue;
                hasChanges = true;
                break;
            }
            if (!hasChanges) {
                return before;
            }
        } else if (elements.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<JRightPadded<J2>> after = new ArrayList<JRightPadded<J2>>(elements.size());
        HashMap<UUID, JRightPadded<J2>> beforeById = new HashMap<UUID, JRightPadded<J2>>((int)Math.ceil((double)elements.size() / 0.75));
        for (JRightPadded<J2> j : before) {
            if (beforeById.put(((J)j.getElement()).getId(), j) == null) continue;
            throw new IllegalStateException("Duplicate key");
        }
        for (J t : elements) {
            JRightPadded found = (JRightPadded)beforeById.get(t.getId());
            if (found != null) {
                after.add(found.withElement(t));
                continue;
            }
            after.add(new JRightPadded<J>(t, Space.EMPTY, Markers.EMPTY));
        }
        return after;
    }

    public static <T> JRightPadded<T> build(T element) {
        return new JRightPadded<T>(element, Space.EMPTY, Markers.EMPTY);
    }

    public String toString() {
        return "JRightPadded(element=" + this.element + ", after=" + this.after + ')';
    }

    @Generated
    public JRightPadded(T element, Space after, Markers markers) {
        this.element = element;
        this.after = after;
        this.markers = markers;
    }

    @Generated
    public T getElement() {
        return this.element;
    }

    @Generated
    public Space getAfter() {
        return this.after;
    }

    @Generated
    public Markers getMarkers() {
        return this.markers;
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        return o instanceof JRightPadded;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }

    @NonNull
    @Generated
    public JRightPadded<T> withElement(T element) {
        return this.element == element ? this : new JRightPadded<T>(element, this.after, this.markers);
    }

    @NonNull
    @Generated
    public JRightPadded<T> withAfter(Space after) {
        return this.after == after ? this : new JRightPadded<T>(this.element, after, this.markers);
    }

    @NonNull
    @Generated
    public JRightPadded<T> withMarkers(Markers markers) {
        return this.markers == markers ? this : new JRightPadded<T>(this.element, this.after, markers);
    }

    public static enum Location {
        ANNOTATION_ARGUMENT(Space.Location.ANNOTATION_ARGUMENT_SUFFIX),
        ARRAY_INDEX(Space.Location.ARRAY_INDEX_SUFFIX),
        BLOCK_STATEMENT(Space.Location.BLOCK_STATEMENT_SUFFIX),
        CASE(Space.Location.CASE_SUFFIX),
        CASE_EXPRESSION(Space.Location.CASE_EXPRESSION),
        CASE_LABEL(Space.Location.CASE_LABEL),
        CASE_BODY(Space.Location.CASE_BODY),
        CATCH_ALTERNATIVE(Space.Location.CATCH_ALTERNATIVE_SUFFIX),
        DIMENSION(Space.Location.DIMENSION_SUFFIX),
        ENUM_VALUE(Space.Location.ENUM_VALUE_SUFFIX),
        FOR_BODY(Space.Location.FOR_BODY_SUFFIX),
        FOR_CONDITION(Space.Location.FOR_CONDITION_SUFFIX),
        FOR_INIT(Space.Location.FOR_INIT_SUFFIX),
        FOR_UPDATE(Space.Location.FOR_UPDATE_SUFFIX),
        FOREACH_VARIABLE(Space.Location.FOREACH_VARIABLE_SUFFIX),
        FOREACH_ITERABLE(Space.Location.FOREACH_ITERABLE_SUFFIX),
        IF_ELSE(Space.Location.IF_ELSE_SUFFIX),
        IF_THEN(Space.Location.IF_THEN_SUFFIX),
        IMPLEMENTS(Space.Location.IMPLEMENTS_SUFFIX),
        DECONSTRUCTION_PATTERN_NESTED(Space.Location.DECONSTRUCTION_PATTERN_NESTED_SUFFIX),
        PERMITS(Space.Location.PERMITS_SUFFIX),
        IMPORT(Space.Location.IMPORT_SUFFIX),
        INSTANCEOF(Space.Location.INSTANCEOF_SUFFIX),
        LABEL(Space.Location.LABEL_SUFFIX),
        LAMBDA_PARAM(Space.Location.LAMBDA_PARAMETER),
        LANGUAGE_EXTENSION(Space.Location.LANGUAGE_EXTENSION),
        MEMBER_REFERENCE_CONTAINING(Space.Location.MEMBER_REFERENCE_CONTAINING),
        METHOD_DECLARATION_PARAMETER(Space.Location.METHOD_DECLARATION_PARAMETER_SUFFIX),
        METHOD_INVOCATION_ARGUMENT(Space.Location.METHOD_INVOCATION_ARGUMENT_SUFFIX),
        METHOD_SELECT(Space.Location.METHOD_SELECT_SUFFIX),
        NAMED_VARIABLE(Space.Location.NAMED_VARIABLE_SUFFIX),
        NEW_ARRAY_INITIALIZER(Space.Location.NEW_ARRAY_INITIALIZER_SUFFIX),
        NEW_CLASS_ARGUMENTS(Space.Location.NEW_CLASS_ARGUMENTS_SUFFIX),
        NEW_CLASS_ENCLOSING(Space.Location.NEW_CLASS_ENCLOSING_SUFFIX),
        NULLABLE(Space.Location.NULLABLE_TYPE_SUFFIX),
        PACKAGE(Space.Location.PACKAGE_SUFFIX),
        PARENTHESES(Space.Location.PARENTHESES_SUFFIX),
        RECORD_STATE_VECTOR(Space.Location.RECORD_STATE_VECTOR_SUFFIX),
        STATIC_INIT(Space.Location.STATIC_INIT_SUFFIX),
        THROWS(Space.Location.THROWS_SUFFIX),
        TRY_RESOURCE(Space.Location.TRY_RESOURCE_SUFFIX),
        TYPE_PARAMETER(Space.Location.TYPE_PARAMETER_SUFFIX),
        TYPE_BOUND(Space.Location.TYPE_BOUND_SUFFIX),
        WHILE_BODY(Space.Location.WHILE_BODY_SUFFIX),
        ANY(Space.Location.ANY);

        private final Space.Location afterLocation;

        private Location(Space.Location afterLocation) {
            this.afterLocation = afterLocation;
        }

        public Space.Location getAfterLocation() {
            return this.afterLocation;
        }
    }
}

