/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.tree;

import java.util.Collections;
import java.util.List;
import java.util.UUID;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.PrintOutputCapture;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.JavadocPrinter;
import org.openrewrite.java.JavadocVisitor;
import org.openrewrite.java.tree.Comment;
import org.openrewrite.java.tree.J;
import org.openrewrite.marker.Markers;

public interface Javadoc
extends Tree {
    default public <R extends Tree, P> R accept(TreeVisitor<R, P> v, P p) {
        return (R)this.acceptJavadoc((JavadocVisitor)v, p);
    }

    default public <P> boolean isAcceptable(TreeVisitor<?, P> v, P p) {
        return v instanceof JavadocVisitor;
    }

    default public <P> @Nullable Javadoc acceptJavadoc(JavadocVisitor<P> v, P p) {
        return (Javadoc)v.defaultValue(this, p);
    }

    default public <P> TreeVisitor<?, PrintOutputCapture<P>> printer(Cursor cursor) {
        return new JavadocPrinter();
    }

    public static final class Reference
    implements Javadoc {
        private final UUID id;
        private final @Nullable Markers markers;
        private final @Nullable J tree;
        private final @Nullable List<Javadoc> lineBreaks;

        public Markers getMarkers() {
            return this.markers == null ? Markers.EMPTY : this.markers;
        }

        public List<Javadoc> getLineBreaks() {
            return this.lineBreaks == null ? Collections.emptyList() : this.lineBreaks;
        }

        @Override
        public <P> Javadoc acceptJavadoc(JavadocVisitor<P> v, P p) {
            return v.visitReference(this, p);
        }

        @Generated
        public Reference(UUID id, @Nullable Markers markers, @Nullable J tree, @Nullable List<Javadoc> lineBreaks) {
            this.id = id;
            this.markers = markers;
            this.tree = tree;
            this.lineBreaks = lineBreaks;
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Generated
        public @Nullable J getTree() {
            return this.tree;
        }

        @NonNull
        @Generated
        public String toString() {
            return "Javadoc.Reference(id=" + this.getId() + ", markers=" + this.getMarkers() + ", tree=" + this.getTree() + ", lineBreaks=" + this.getLineBreaks() + ")";
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Reference)) {
                return false;
            }
            Reference other = (Reference)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @NonNull
        @Generated
        public Reference withId(UUID id) {
            return this.id == id ? this : new Reference(id, this.markers, this.tree, this.lineBreaks);
        }

        @NonNull
        @Generated
        public Reference withMarkers(@Nullable Markers markers) {
            return this.markers == markers ? this : new Reference(this.id, markers, this.tree, this.lineBreaks);
        }

        @NonNull
        @Generated
        public Reference withTree(@Nullable J tree) {
            return this.tree == tree ? this : new Reference(this.id, this.markers, tree, this.lineBreaks);
        }

        @NonNull
        @Generated
        public Reference withLineBreaks(@Nullable List<Javadoc> lineBreaks) {
            return this.lineBreaks == lineBreaks ? this : new Reference(this.id, this.markers, this.tree, lineBreaks);
        }
    }

    public static final class Version
    implements Javadoc {
        private final UUID id;
        private final Markers markers;
        private final List<Javadoc> body;

        @Override
        public <P> Javadoc acceptJavadoc(JavadocVisitor<P> v, P p) {
            return v.visitVersion(this, p);
        }

        @Generated
        public Version(UUID id, Markers markers, List<Javadoc> body) {
            this.id = id;
            this.markers = markers;
            this.body = body;
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @Generated
        public List<Javadoc> getBody() {
            return this.body;
        }

        @NonNull
        @Generated
        public String toString() {
            return "Javadoc.Version(id=" + this.getId() + ", markers=" + this.getMarkers() + ", body=" + this.getBody() + ")";
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Version)) {
                return false;
            }
            Version other = (Version)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @NonNull
        @Generated
        public Version withId(UUID id) {
            return this.id == id ? this : new Version(id, this.markers, this.body);
        }

        @NonNull
        @Generated
        public Version withMarkers(Markers markers) {
            return this.markers == markers ? this : new Version(this.id, markers, this.body);
        }

        @NonNull
        @Generated
        public Version withBody(List<Javadoc> body) {
            return this.body == body ? this : new Version(this.id, this.markers, body);
        }
    }

    public static final class Uses
    implements Javadoc {
        private final UUID id;
        private final Markers markers;
        private final List<Javadoc> beforeServiceType;
        private final J serviceType;
        private final List<Javadoc> description;

        @Override
        public <P> Javadoc acceptJavadoc(JavadocVisitor<P> v, P p) {
            return v.visitUses(this, p);
        }

        @Generated
        public Uses(UUID id, Markers markers, List<Javadoc> beforeServiceType, J serviceType, List<Javadoc> description) {
            this.id = id;
            this.markers = markers;
            this.beforeServiceType = beforeServiceType;
            this.serviceType = serviceType;
            this.description = description;
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @Generated
        public List<Javadoc> getBeforeServiceType() {
            return this.beforeServiceType;
        }

        @Generated
        public J getServiceType() {
            return this.serviceType;
        }

        @Generated
        public List<Javadoc> getDescription() {
            return this.description;
        }

        @NonNull
        @Generated
        public String toString() {
            return "Javadoc.Uses(id=" + this.getId() + ", markers=" + this.getMarkers() + ", beforeServiceType=" + this.getBeforeServiceType() + ", serviceType=" + this.getServiceType() + ", description=" + this.getDescription() + ")";
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Uses)) {
                return false;
            }
            Uses other = (Uses)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @NonNull
        @Generated
        public Uses withId(UUID id) {
            return this.id == id ? this : new Uses(id, this.markers, this.beforeServiceType, this.serviceType, this.description);
        }

        @NonNull
        @Generated
        public Uses withMarkers(Markers markers) {
            return this.markers == markers ? this : new Uses(this.id, markers, this.beforeServiceType, this.serviceType, this.description);
        }

        @NonNull
        @Generated
        public Uses withBeforeServiceType(List<Javadoc> beforeServiceType) {
            return this.beforeServiceType == beforeServiceType ? this : new Uses(this.id, this.markers, beforeServiceType, this.serviceType, this.description);
        }

        @NonNull
        @Generated
        public Uses withServiceType(J serviceType) {
            return this.serviceType == serviceType ? this : new Uses(this.id, this.markers, this.beforeServiceType, serviceType, this.description);
        }

        @NonNull
        @Generated
        public Uses withDescription(List<Javadoc> description) {
            return this.description == description ? this : new Uses(this.id, this.markers, this.beforeServiceType, this.serviceType, description);
        }
    }

    public static final class UnknownInline
    implements Javadoc {
        private final UUID id;
        private final Markers markers;
        private final String name;
        private final List<Javadoc> content;
        private final List<Javadoc> endBrace;

        @Override
        public <P> Javadoc acceptJavadoc(JavadocVisitor<P> v, P p) {
            return v.visitUnknownInline(this, p);
        }

        @Generated
        public UnknownInline(UUID id, Markers markers, String name, List<Javadoc> content, List<Javadoc> endBrace) {
            this.id = id;
            this.markers = markers;
            this.name = name;
            this.content = content;
            this.endBrace = endBrace;
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public List<Javadoc> getContent() {
            return this.content;
        }

        @Generated
        public List<Javadoc> getEndBrace() {
            return this.endBrace;
        }

        @NonNull
        @Generated
        public String toString() {
            return "Javadoc.UnknownInline(id=" + this.getId() + ", markers=" + this.getMarkers() + ", name=" + this.getName() + ", content=" + this.getContent() + ", endBrace=" + this.getEndBrace() + ")";
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UnknownInline)) {
                return false;
            }
            UnknownInline other = (UnknownInline)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @NonNull
        @Generated
        public UnknownInline withId(UUID id) {
            return this.id == id ? this : new UnknownInline(id, this.markers, this.name, this.content, this.endBrace);
        }

        @NonNull
        @Generated
        public UnknownInline withMarkers(Markers markers) {
            return this.markers == markers ? this : new UnknownInline(this.id, markers, this.name, this.content, this.endBrace);
        }

        @NonNull
        @Generated
        public UnknownInline withName(String name) {
            return this.name == name ? this : new UnknownInline(this.id, this.markers, name, this.content, this.endBrace);
        }

        @NonNull
        @Generated
        public UnknownInline withContent(List<Javadoc> content) {
            return this.content == content ? this : new UnknownInline(this.id, this.markers, this.name, content, this.endBrace);
        }

        @NonNull
        @Generated
        public UnknownInline withEndBrace(List<Javadoc> endBrace) {
            return this.endBrace == endBrace ? this : new UnknownInline(this.id, this.markers, this.name, this.content, endBrace);
        }
    }

    public static final class UnknownBlock
    implements Javadoc {
        private final UUID id;
        private final Markers markers;
        private final String name;
        private final List<Javadoc> content;

        @Override
        public <P> Javadoc acceptJavadoc(JavadocVisitor<P> v, P p) {
            return v.visitUnknownBlock(this, p);
        }

        @Generated
        public UnknownBlock(UUID id, Markers markers, String name, List<Javadoc> content) {
            this.id = id;
            this.markers = markers;
            this.name = name;
            this.content = content;
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public List<Javadoc> getContent() {
            return this.content;
        }

        @NonNull
        @Generated
        public String toString() {
            return "Javadoc.UnknownBlock(id=" + this.getId() + ", markers=" + this.getMarkers() + ", name=" + this.getName() + ", content=" + this.getContent() + ")";
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UnknownBlock)) {
                return false;
            }
            UnknownBlock other = (UnknownBlock)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @NonNull
        @Generated
        public UnknownBlock withId(UUID id) {
            return this.id == id ? this : new UnknownBlock(id, this.markers, this.name, this.content);
        }

        @NonNull
        @Generated
        public UnknownBlock withMarkers(Markers markers) {
            return this.markers == markers ? this : new UnknownBlock(this.id, markers, this.name, this.content);
        }

        @NonNull
        @Generated
        public UnknownBlock withName(String name) {
            return this.name == name ? this : new UnknownBlock(this.id, this.markers, name, this.content);
        }

        @NonNull
        @Generated
        public UnknownBlock withContent(List<Javadoc> content) {
            return this.content == content ? this : new UnknownBlock(this.id, this.markers, this.name, content);
        }
    }

    public static final class Throws
    implements Javadoc {
        private final UUID id;
        private final Markers markers;
        private final boolean throwsKeyword;
        private final List<Javadoc> spaceBeforeExceptionName;
        private final J exceptionName;
        private final List<Javadoc> description;

        @Override
        public <P> Javadoc acceptJavadoc(JavadocVisitor<P> v, P p) {
            return v.visitThrows(this, p);
        }

        @Generated
        public Throws(UUID id, Markers markers, boolean throwsKeyword, List<Javadoc> spaceBeforeExceptionName, J exceptionName, List<Javadoc> description) {
            this.id = id;
            this.markers = markers;
            this.throwsKeyword = throwsKeyword;
            this.spaceBeforeExceptionName = spaceBeforeExceptionName;
            this.exceptionName = exceptionName;
            this.description = description;
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @Generated
        public boolean isThrowsKeyword() {
            return this.throwsKeyword;
        }

        @Generated
        public List<Javadoc> getSpaceBeforeExceptionName() {
            return this.spaceBeforeExceptionName;
        }

        @Generated
        public J getExceptionName() {
            return this.exceptionName;
        }

        @Generated
        public List<Javadoc> getDescription() {
            return this.description;
        }

        @NonNull
        @Generated
        public String toString() {
            return "Javadoc.Throws(id=" + this.getId() + ", markers=" + this.getMarkers() + ", throwsKeyword=" + this.isThrowsKeyword() + ", spaceBeforeExceptionName=" + this.getSpaceBeforeExceptionName() + ", exceptionName=" + this.getExceptionName() + ", description=" + this.getDescription() + ")";
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Throws)) {
                return false;
            }
            Throws other = (Throws)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @NonNull
        @Generated
        public Throws withId(UUID id) {
            return this.id == id ? this : new Throws(id, this.markers, this.throwsKeyword, this.spaceBeforeExceptionName, this.exceptionName, this.description);
        }

        @NonNull
        @Generated
        public Throws withMarkers(Markers markers) {
            return this.markers == markers ? this : new Throws(this.id, markers, this.throwsKeyword, this.spaceBeforeExceptionName, this.exceptionName, this.description);
        }

        @NonNull
        @Generated
        public Throws withThrowsKeyword(boolean throwsKeyword) {
            return this.throwsKeyword == throwsKeyword ? this : new Throws(this.id, this.markers, throwsKeyword, this.spaceBeforeExceptionName, this.exceptionName, this.description);
        }

        @NonNull
        @Generated
        public Throws withSpaceBeforeExceptionName(List<Javadoc> spaceBeforeExceptionName) {
            return this.spaceBeforeExceptionName == spaceBeforeExceptionName ? this : new Throws(this.id, this.markers, this.throwsKeyword, spaceBeforeExceptionName, this.exceptionName, this.description);
        }

        @NonNull
        @Generated
        public Throws withExceptionName(J exceptionName) {
            return this.exceptionName == exceptionName ? this : new Throws(this.id, this.markers, this.throwsKeyword, this.spaceBeforeExceptionName, exceptionName, this.description);
        }

        @NonNull
        @Generated
        public Throws withDescription(List<Javadoc> description) {
            return this.description == description ? this : new Throws(this.id, this.markers, this.throwsKeyword, this.spaceBeforeExceptionName, this.exceptionName, description);
        }
    }

    public static final class Text
    implements Javadoc {
        private final UUID id;
        private final Markers markers;
        private final String text;

        @Override
        public <P> Javadoc acceptJavadoc(JavadocVisitor<P> v, P p) {
            return v.visitText(this, p);
        }

        @Generated
        public Text(UUID id, Markers markers, String text) {
            this.id = id;
            this.markers = markers;
            this.text = text;
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @Generated
        public String getText() {
            return this.text;
        }

        @NonNull
        @Generated
        public String toString() {
            return "Javadoc.Text(id=" + this.getId() + ", markers=" + this.getMarkers() + ", text=" + this.getText() + ")";
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Text)) {
                return false;
            }
            Text other = (Text)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @NonNull
        @Generated
        public Text withId(UUID id) {
            return this.id == id ? this : new Text(id, this.markers, this.text);
        }

        @NonNull
        @Generated
        public Text withMarkers(Markers markers) {
            return this.markers == markers ? this : new Text(this.id, markers, this.text);
        }

        @NonNull
        @Generated
        public Text withText(String text) {
            return this.text == text ? this : new Text(this.id, this.markers, text);
        }
    }

    public static final class Summary
    implements Javadoc {
        private final UUID id;
        private final Markers markers;
        private final List<Javadoc> summary;
        private final List<Javadoc> beforeBrace;

        @Override
        public <P> Javadoc acceptJavadoc(JavadocVisitor<P> v, P p) {
            return v.visitSummary(this, p);
        }

        @Generated
        public Summary(UUID id, Markers markers, List<Javadoc> summary, List<Javadoc> beforeBrace) {
            this.id = id;
            this.markers = markers;
            this.summary = summary;
            this.beforeBrace = beforeBrace;
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @Generated
        public List<Javadoc> getSummary() {
            return this.summary;
        }

        @Generated
        public List<Javadoc> getBeforeBrace() {
            return this.beforeBrace;
        }

        @NonNull
        @Generated
        public String toString() {
            return "Javadoc.Summary(id=" + this.getId() + ", markers=" + this.getMarkers() + ", summary=" + this.getSummary() + ", beforeBrace=" + this.getBeforeBrace() + ")";
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Summary)) {
                return false;
            }
            Summary other = (Summary)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @NonNull
        @Generated
        public Summary withId(UUID id) {
            return this.id == id ? this : new Summary(id, this.markers, this.summary, this.beforeBrace);
        }

        @NonNull
        @Generated
        public Summary withMarkers(Markers markers) {
            return this.markers == markers ? this : new Summary(this.id, markers, this.summary, this.beforeBrace);
        }

        @NonNull
        @Generated
        public Summary withSummary(List<Javadoc> summary) {
            return this.summary == summary ? this : new Summary(this.id, this.markers, summary, this.beforeBrace);
        }

        @NonNull
        @Generated
        public Summary withBeforeBrace(List<Javadoc> beforeBrace) {
            return this.beforeBrace == beforeBrace ? this : new Summary(this.id, this.markers, this.summary, beforeBrace);
        }
    }

    public static final class Snippet
    implements Javadoc {
        private final UUID id;
        private final Markers markers;
        private final List<Javadoc> attributes;
        private final List<Javadoc> content;
        private final List<Javadoc> endBrace;

        @Override
        public <P> Javadoc acceptJavadoc(JavadocVisitor<P> v, P p) {
            return v.visitSnippet(this, p);
        }

        @Generated
        public Snippet(UUID id, Markers markers, List<Javadoc> attributes, List<Javadoc> content, List<Javadoc> endBrace) {
            this.id = id;
            this.markers = markers;
            this.attributes = attributes;
            this.content = content;
            this.endBrace = endBrace;
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @Generated
        public List<Javadoc> getAttributes() {
            return this.attributes;
        }

        @Generated
        public List<Javadoc> getContent() {
            return this.content;
        }

        @Generated
        public List<Javadoc> getEndBrace() {
            return this.endBrace;
        }

        @NonNull
        @Generated
        public String toString() {
            return "Javadoc.Snippet(id=" + this.getId() + ", markers=" + this.getMarkers() + ", attributes=" + this.getAttributes() + ", content=" + this.getContent() + ", endBrace=" + this.getEndBrace() + ")";
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Snippet)) {
                return false;
            }
            Snippet other = (Snippet)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @NonNull
        @Generated
        public Snippet withId(UUID id) {
            return this.id == id ? this : new Snippet(id, this.markers, this.attributes, this.content, this.endBrace);
        }

        @NonNull
        @Generated
        public Snippet withMarkers(Markers markers) {
            return this.markers == markers ? this : new Snippet(this.id, markers, this.attributes, this.content, this.endBrace);
        }

        @NonNull
        @Generated
        public Snippet withAttributes(List<Javadoc> attributes) {
            return this.attributes == attributes ? this : new Snippet(this.id, this.markers, attributes, this.content, this.endBrace);
        }

        @NonNull
        @Generated
        public Snippet withContent(List<Javadoc> content) {
            return this.content == content ? this : new Snippet(this.id, this.markers, this.attributes, content, this.endBrace);
        }

        @NonNull
        @Generated
        public Snippet withEndBrace(List<Javadoc> endBrace) {
            return this.endBrace == endBrace ? this : new Snippet(this.id, this.markers, this.attributes, this.content, endBrace);
        }
    }

    public static final class StartElement
    implements Javadoc {
        private final UUID id;
        private final Markers markers;
        private final String name;
        private final List<Javadoc> attributes;
        private final boolean selfClosing;
        private final List<Javadoc> spaceBeforeEndBracket;

        @Override
        public <P> Javadoc acceptJavadoc(JavadocVisitor<P> v, P p) {
            return v.visitStartElement(this, p);
        }

        @Generated
        public StartElement(UUID id, Markers markers, String name, List<Javadoc> attributes, boolean selfClosing, List<Javadoc> spaceBeforeEndBracket) {
            this.id = id;
            this.markers = markers;
            this.name = name;
            this.attributes = attributes;
            this.selfClosing = selfClosing;
            this.spaceBeforeEndBracket = spaceBeforeEndBracket;
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public List<Javadoc> getAttributes() {
            return this.attributes;
        }

        @Generated
        public boolean isSelfClosing() {
            return this.selfClosing;
        }

        @Generated
        public List<Javadoc> getSpaceBeforeEndBracket() {
            return this.spaceBeforeEndBracket;
        }

        @NonNull
        @Generated
        public String toString() {
            return "Javadoc.StartElement(id=" + this.getId() + ", markers=" + this.getMarkers() + ", name=" + this.getName() + ", attributes=" + this.getAttributes() + ", selfClosing=" + this.isSelfClosing() + ", spaceBeforeEndBracket=" + this.getSpaceBeforeEndBracket() + ")";
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof StartElement)) {
                return false;
            }
            StartElement other = (StartElement)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @NonNull
        @Generated
        public StartElement withId(UUID id) {
            return this.id == id ? this : new StartElement(id, this.markers, this.name, this.attributes, this.selfClosing, this.spaceBeforeEndBracket);
        }

        @NonNull
        @Generated
        public StartElement withMarkers(Markers markers) {
            return this.markers == markers ? this : new StartElement(this.id, markers, this.name, this.attributes, this.selfClosing, this.spaceBeforeEndBracket);
        }

        @NonNull
        @Generated
        public StartElement withName(String name) {
            return this.name == name ? this : new StartElement(this.id, this.markers, name, this.attributes, this.selfClosing, this.spaceBeforeEndBracket);
        }

        @NonNull
        @Generated
        public StartElement withAttributes(List<Javadoc> attributes) {
            return this.attributes == attributes ? this : new StartElement(this.id, this.markers, this.name, attributes, this.selfClosing, this.spaceBeforeEndBracket);
        }

        @NonNull
        @Generated
        public StartElement withSelfClosing(boolean selfClosing) {
            return this.selfClosing == selfClosing ? this : new StartElement(this.id, this.markers, this.name, this.attributes, selfClosing, this.spaceBeforeEndBracket);
        }

        @NonNull
        @Generated
        public StartElement withSpaceBeforeEndBracket(List<Javadoc> spaceBeforeEndBracket) {
            return this.spaceBeforeEndBracket == spaceBeforeEndBracket ? this : new StartElement(this.id, this.markers, this.name, this.attributes, this.selfClosing, spaceBeforeEndBracket);
        }
    }

    public static final class Since
    implements Javadoc {
        private final UUID id;
        private final Markers markers;
        private final List<Javadoc> description;

        @Override
        public <P> Javadoc acceptJavadoc(JavadocVisitor<P> v, P p) {
            return v.visitSince(this, p);
        }

        @Generated
        public Since(UUID id, Markers markers, List<Javadoc> description) {
            this.id = id;
            this.markers = markers;
            this.description = description;
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @Generated
        public List<Javadoc> getDescription() {
            return this.description;
        }

        @NonNull
        @Generated
        public String toString() {
            return "Javadoc.Since(id=" + this.getId() + ", markers=" + this.getMarkers() + ", description=" + this.getDescription() + ")";
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Since)) {
                return false;
            }
            Since other = (Since)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @NonNull
        @Generated
        public Since withId(UUID id) {
            return this.id == id ? this : new Since(id, this.markers, this.description);
        }

        @NonNull
        @Generated
        public Since withMarkers(Markers markers) {
            return this.markers == markers ? this : new Since(this.id, markers, this.description);
        }

        @NonNull
        @Generated
        public Since withDescription(List<Javadoc> description) {
            return this.description == description ? this : new Since(this.id, this.markers, description);
        }
    }

    public static final class SerialField
    implements Javadoc {
        private final UUID id;
        private final Markers markers;
        private final J.Identifier name;
        private final J type;
        private final List<Javadoc> description;

        @Override
        public <P> Javadoc acceptJavadoc(JavadocVisitor<P> v, P p) {
            return v.visitSerialField(this, p);
        }

        @Generated
        public SerialField(UUID id, Markers markers, J.Identifier name, J type, List<Javadoc> description) {
            this.id = id;
            this.markers = markers;
            this.name = name;
            this.type = type;
            this.description = description;
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @Generated
        public J.Identifier getName() {
            return this.name;
        }

        @Generated
        public J getType() {
            return this.type;
        }

        @Generated
        public List<Javadoc> getDescription() {
            return this.description;
        }

        @NonNull
        @Generated
        public String toString() {
            return "Javadoc.SerialField(id=" + this.getId() + ", markers=" + this.getMarkers() + ", name=" + this.getName() + ", type=" + this.getType() + ", description=" + this.getDescription() + ")";
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SerialField)) {
                return false;
            }
            SerialField other = (SerialField)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @NonNull
        @Generated
        public SerialField withId(UUID id) {
            return this.id == id ? this : new SerialField(id, this.markers, this.name, this.type, this.description);
        }

        @NonNull
        @Generated
        public SerialField withMarkers(Markers markers) {
            return this.markers == markers ? this : new SerialField(this.id, markers, this.name, this.type, this.description);
        }

        @NonNull
        @Generated
        public SerialField withName(J.Identifier name) {
            return this.name == name ? this : new SerialField(this.id, this.markers, name, this.type, this.description);
        }

        @NonNull
        @Generated
        public SerialField withType(J type) {
            return this.type == type ? this : new SerialField(this.id, this.markers, this.name, type, this.description);
        }

        @NonNull
        @Generated
        public SerialField withDescription(List<Javadoc> description) {
            return this.description == description ? this : new SerialField(this.id, this.markers, this.name, this.type, description);
        }
    }

    public static final class SerialData
    implements Javadoc {
        private final UUID id;
        private final Markers markers;
        private final List<Javadoc> description;

        @Override
        public <P> Javadoc acceptJavadoc(JavadocVisitor<P> v, P p) {
            return v.visitSerialData(this, p);
        }

        @Generated
        public SerialData(UUID id, Markers markers, List<Javadoc> description) {
            this.id = id;
            this.markers = markers;
            this.description = description;
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @Generated
        public List<Javadoc> getDescription() {
            return this.description;
        }

        @NonNull
        @Generated
        public String toString() {
            return "Javadoc.SerialData(id=" + this.getId() + ", markers=" + this.getMarkers() + ", description=" + this.getDescription() + ")";
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SerialData)) {
                return false;
            }
            SerialData other = (SerialData)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @NonNull
        @Generated
        public SerialData withId(UUID id) {
            return this.id == id ? this : new SerialData(id, this.markers, this.description);
        }

        @NonNull
        @Generated
        public SerialData withMarkers(Markers markers) {
            return this.markers == markers ? this : new SerialData(this.id, markers, this.description);
        }

        @NonNull
        @Generated
        public SerialData withDescription(List<Javadoc> description) {
            return this.description == description ? this : new SerialData(this.id, this.markers, description);
        }
    }

    public static final class Serial
    implements Javadoc {
        private final UUID id;
        private final Markers markers;
        private final List<Javadoc> description;

        @Override
        public <P> Javadoc acceptJavadoc(JavadocVisitor<P> v, P p) {
            return v.visitSerial(this, p);
        }

        @Generated
        public Serial(UUID id, Markers markers, List<Javadoc> description) {
            this.id = id;
            this.markers = markers;
            this.description = description;
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @Generated
        public List<Javadoc> getDescription() {
            return this.description;
        }

        @NonNull
        @Generated
        public String toString() {
            return "Javadoc.Serial(id=" + this.getId() + ", markers=" + this.getMarkers() + ", description=" + this.getDescription() + ")";
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Serial)) {
                return false;
            }
            Serial other = (Serial)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @NonNull
        @Generated
        public Serial withId(UUID id) {
            return this.id == id ? this : new Serial(id, this.markers, this.description);
        }

        @NonNull
        @Generated
        public Serial withMarkers(Markers markers) {
            return this.markers == markers ? this : new Serial(this.id, markers, this.description);
        }

        @NonNull
        @Generated
        public Serial withDescription(List<Javadoc> description) {
            return this.description == description ? this : new Serial(this.id, this.markers, description);
        }
    }

    public static final class See
    implements Javadoc {
        private final UUID id;
        private final Markers markers;
        private final List<Javadoc> spaceBeforeTree;
        private final @Nullable J tree;
        private @Nullable Reference treeReference;
        private final List<Javadoc> reference;

        public @Nullable Reference getTreeReference() {
            if (this.tree != null && this.treeReference == null) {
                this.treeReference = new Reference(Tree.randomId(), Markers.EMPTY, this.tree, null);
            }
            return this.treeReference;
        }

        @Override
        public <P> Javadoc acceptJavadoc(JavadocVisitor<P> v, P p) {
            return v.visitSee(this, p);
        }

        @Generated
        public See(UUID id, Markers markers, List<Javadoc> spaceBeforeTree, @Nullable J tree, @Nullable Reference treeReference, List<Javadoc> reference) {
            this.id = id;
            this.markers = markers;
            this.spaceBeforeTree = spaceBeforeTree;
            this.tree = tree;
            this.treeReference = treeReference;
            this.reference = reference;
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @Generated
        public List<Javadoc> getSpaceBeforeTree() {
            return this.spaceBeforeTree;
        }

        @Generated
        public @Nullable J getTree() {
            return this.tree;
        }

        @Generated
        public List<Javadoc> getReference() {
            return this.reference;
        }

        @NonNull
        @Generated
        public String toString() {
            return "Javadoc.See(id=" + this.getId() + ", markers=" + this.getMarkers() + ", spaceBeforeTree=" + this.getSpaceBeforeTree() + ", tree=" + this.getTree() + ", treeReference=" + this.getTreeReference() + ", reference=" + this.getReference() + ")";
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof See)) {
                return false;
            }
            See other = (See)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @NonNull
        @Generated
        public See withId(UUID id) {
            return this.id == id ? this : new See(id, this.markers, this.spaceBeforeTree, this.tree, this.treeReference, this.reference);
        }

        @NonNull
        @Generated
        public See withMarkers(Markers markers) {
            return this.markers == markers ? this : new See(this.id, markers, this.spaceBeforeTree, this.tree, this.treeReference, this.reference);
        }

        @NonNull
        @Generated
        public See withSpaceBeforeTree(List<Javadoc> spaceBeforeTree) {
            return this.spaceBeforeTree == spaceBeforeTree ? this : new See(this.id, this.markers, spaceBeforeTree, this.tree, this.treeReference, this.reference);
        }

        @NonNull
        @Generated
        public See withTree(@Nullable J tree) {
            return this.tree == tree ? this : new See(this.id, this.markers, this.spaceBeforeTree, tree, this.treeReference, this.reference);
        }

        @NonNull
        @Generated
        public See withTreeReference(@Nullable Reference treeReference) {
            return this.treeReference == treeReference ? this : new See(this.id, this.markers, this.spaceBeforeTree, this.tree, treeReference, this.reference);
        }

        @NonNull
        @Generated
        public See withReference(List<Javadoc> reference) {
            return this.reference == reference ? this : new See(this.id, this.markers, this.spaceBeforeTree, this.tree, this.treeReference, reference);
        }
    }

    public static final class Return
    implements Javadoc {
        private final UUID id;
        private final Markers markers;
        private final List<Javadoc> description;

        @Override
        public <P> Javadoc acceptJavadoc(JavadocVisitor<P> v, P p) {
            return v.visitReturn(this, p);
        }

        @Generated
        public Return(UUID id, Markers markers, List<Javadoc> description) {
            this.id = id;
            this.markers = markers;
            this.description = description;
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @Generated
        public List<Javadoc> getDescription() {
            return this.description;
        }

        @NonNull
        @Generated
        public String toString() {
            return "Javadoc.Return(id=" + this.getId() + ", markers=" + this.getMarkers() + ", description=" + this.getDescription() + ")";
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Return)) {
                return false;
            }
            Return other = (Return)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @NonNull
        @Generated
        public Return withId(UUID id) {
            return this.id == id ? this : new Return(id, this.markers, this.description);
        }

        @NonNull
        @Generated
        public Return withMarkers(Markers markers) {
            return this.markers == markers ? this : new Return(this.id, markers, this.description);
        }

        @NonNull
        @Generated
        public Return withDescription(List<Javadoc> description) {
            return this.description == description ? this : new Return(this.id, this.markers, description);
        }
    }

    public static final class Provides
    implements Javadoc {
        private final UUID id;
        private final Markers markers;
        private final List<Javadoc> spaceBeforeServiceType;
        private final J serviceType;
        private final List<Javadoc> description;

        @Override
        public <P> Javadoc acceptJavadoc(JavadocVisitor<P> v, P p) {
            return v.visitProvides(this, p);
        }

        @Generated
        public Provides(UUID id, Markers markers, List<Javadoc> spaceBeforeServiceType, J serviceType, List<Javadoc> description) {
            this.id = id;
            this.markers = markers;
            this.spaceBeforeServiceType = spaceBeforeServiceType;
            this.serviceType = serviceType;
            this.description = description;
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @Generated
        public List<Javadoc> getSpaceBeforeServiceType() {
            return this.spaceBeforeServiceType;
        }

        @Generated
        public J getServiceType() {
            return this.serviceType;
        }

        @Generated
        public List<Javadoc> getDescription() {
            return this.description;
        }

        @NonNull
        @Generated
        public String toString() {
            return "Javadoc.Provides(id=" + this.getId() + ", markers=" + this.getMarkers() + ", spaceBeforeServiceType=" + this.getSpaceBeforeServiceType() + ", serviceType=" + this.getServiceType() + ", description=" + this.getDescription() + ")";
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Provides)) {
                return false;
            }
            Provides other = (Provides)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @NonNull
        @Generated
        public Provides withId(UUID id) {
            return this.id == id ? this : new Provides(id, this.markers, this.spaceBeforeServiceType, this.serviceType, this.description);
        }

        @NonNull
        @Generated
        public Provides withMarkers(Markers markers) {
            return this.markers == markers ? this : new Provides(this.id, markers, this.spaceBeforeServiceType, this.serviceType, this.description);
        }

        @NonNull
        @Generated
        public Provides withSpaceBeforeServiceType(List<Javadoc> spaceBeforeServiceType) {
            return this.spaceBeforeServiceType == spaceBeforeServiceType ? this : new Provides(this.id, this.markers, spaceBeforeServiceType, this.serviceType, this.description);
        }

        @NonNull
        @Generated
        public Provides withServiceType(J serviceType) {
            return this.serviceType == serviceType ? this : new Provides(this.id, this.markers, this.spaceBeforeServiceType, serviceType, this.description);
        }

        @NonNull
        @Generated
        public Provides withDescription(List<Javadoc> description) {
            return this.description == description ? this : new Provides(this.id, this.markers, this.spaceBeforeServiceType, this.serviceType, description);
        }
    }

    public static final class Parameter
    implements Javadoc {
        private final UUID id;
        private final Markers markers;
        private final List<Javadoc> spaceBeforeName;
        private final @Nullable J name;
        private @Nullable Reference nameReference;
        private final List<Javadoc> description;

        public @Nullable Reference getNameReference() {
            if (this.name != null && this.nameReference == null) {
                this.nameReference = new Reference(Tree.randomId(), Markers.EMPTY, this.name, null);
            }
            return this.nameReference;
        }

        @Override
        public <P> Javadoc acceptJavadoc(JavadocVisitor<P> v, P p) {
            return v.visitParameter(this, p);
        }

        @Generated
        public Parameter(UUID id, Markers markers, List<Javadoc> spaceBeforeName, @Nullable J name, @Nullable Reference nameReference, List<Javadoc> description) {
            this.id = id;
            this.markers = markers;
            this.spaceBeforeName = spaceBeforeName;
            this.name = name;
            this.nameReference = nameReference;
            this.description = description;
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @Generated
        public List<Javadoc> getSpaceBeforeName() {
            return this.spaceBeforeName;
        }

        @Generated
        public @Nullable J getName() {
            return this.name;
        }

        @Generated
        public List<Javadoc> getDescription() {
            return this.description;
        }

        @NonNull
        @Generated
        public String toString() {
            return "Javadoc.Parameter(id=" + this.getId() + ", markers=" + this.getMarkers() + ", spaceBeforeName=" + this.getSpaceBeforeName() + ", name=" + this.getName() + ", nameReference=" + this.getNameReference() + ", description=" + this.getDescription() + ")";
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Parameter)) {
                return false;
            }
            Parameter other = (Parameter)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @NonNull
        @Generated
        public Parameter withId(UUID id) {
            return this.id == id ? this : new Parameter(id, this.markers, this.spaceBeforeName, this.name, this.nameReference, this.description);
        }

        @NonNull
        @Generated
        public Parameter withMarkers(Markers markers) {
            return this.markers == markers ? this : new Parameter(this.id, markers, this.spaceBeforeName, this.name, this.nameReference, this.description);
        }

        @NonNull
        @Generated
        public Parameter withSpaceBeforeName(List<Javadoc> spaceBeforeName) {
            return this.spaceBeforeName == spaceBeforeName ? this : new Parameter(this.id, this.markers, spaceBeforeName, this.name, this.nameReference, this.description);
        }

        @NonNull
        @Generated
        public Parameter withName(@Nullable J name) {
            return this.name == name ? this : new Parameter(this.id, this.markers, this.spaceBeforeName, name, this.nameReference, this.description);
        }

        @NonNull
        @Generated
        public Parameter withNameReference(@Nullable Reference nameReference) {
            return this.nameReference == nameReference ? this : new Parameter(this.id, this.markers, this.spaceBeforeName, this.name, nameReference, this.description);
        }

        @NonNull
        @Generated
        public Parameter withDescription(List<Javadoc> description) {
            return this.description == description ? this : new Parameter(this.id, this.markers, this.spaceBeforeName, this.name, this.nameReference, description);
        }
    }

    public static final class Literal
    implements Javadoc {
        private final UUID id;
        private final Markers markers;
        private final boolean code;
        private final List<Javadoc> description;
        private final List<Javadoc> endBrace;

        @Override
        public <P> Javadoc acceptJavadoc(JavadocVisitor<P> v, P p) {
            return v.visitLiteral(this, p);
        }

        @Generated
        public Literal(UUID id, Markers markers, boolean code, List<Javadoc> description, List<Javadoc> endBrace) {
            this.id = id;
            this.markers = markers;
            this.code = code;
            this.description = description;
            this.endBrace = endBrace;
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @Generated
        public boolean isCode() {
            return this.code;
        }

        @Generated
        public List<Javadoc> getDescription() {
            return this.description;
        }

        @Generated
        public List<Javadoc> getEndBrace() {
            return this.endBrace;
        }

        @NonNull
        @Generated
        public String toString() {
            return "Javadoc.Literal(id=" + this.getId() + ", markers=" + this.getMarkers() + ", code=" + this.isCode() + ", description=" + this.getDescription() + ", endBrace=" + this.getEndBrace() + ")";
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Literal)) {
                return false;
            }
            Literal other = (Literal)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @NonNull
        @Generated
        public Literal withId(UUID id) {
            return this.id == id ? this : new Literal(id, this.markers, this.code, this.description, this.endBrace);
        }

        @NonNull
        @Generated
        public Literal withMarkers(Markers markers) {
            return this.markers == markers ? this : new Literal(this.id, markers, this.code, this.description, this.endBrace);
        }

        @NonNull
        @Generated
        public Literal withCode(boolean code) {
            return this.code == code ? this : new Literal(this.id, this.markers, code, this.description, this.endBrace);
        }

        @NonNull
        @Generated
        public Literal withDescription(List<Javadoc> description) {
            return this.description == description ? this : new Literal(this.id, this.markers, this.code, description, this.endBrace);
        }

        @NonNull
        @Generated
        public Literal withEndBrace(List<Javadoc> endBrace) {
            return this.endBrace == endBrace ? this : new Literal(this.id, this.markers, this.code, this.description, endBrace);
        }
    }

    public static final class Link
    implements Javadoc {
        private final UUID id;
        private final Markers markers;
        private final boolean plain;
        private final List<Javadoc> spaceBeforeTree;
        private final @Nullable J tree;
        private @Nullable Reference treeReference;
        private final List<Javadoc> label;
        private final List<Javadoc> endBrace;

        public @Nullable Reference getTreeReference() {
            if (this.tree != null && this.treeReference == null) {
                this.treeReference = new Reference(Tree.randomId(), Markers.EMPTY, this.tree, null);
            }
            return this.treeReference;
        }

        @Override
        public <P> Javadoc acceptJavadoc(JavadocVisitor<P> v, P p) {
            return v.visitLink(this, p);
        }

        @Generated
        public Link(UUID id, Markers markers, boolean plain, List<Javadoc> spaceBeforeTree, @Nullable J tree, @Nullable Reference treeReference, List<Javadoc> label, List<Javadoc> endBrace) {
            this.id = id;
            this.markers = markers;
            this.plain = plain;
            this.spaceBeforeTree = spaceBeforeTree;
            this.tree = tree;
            this.treeReference = treeReference;
            this.label = label;
            this.endBrace = endBrace;
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @Generated
        public boolean isPlain() {
            return this.plain;
        }

        @Generated
        public List<Javadoc> getSpaceBeforeTree() {
            return this.spaceBeforeTree;
        }

        @Generated
        public @Nullable J getTree() {
            return this.tree;
        }

        @Generated
        public List<Javadoc> getLabel() {
            return this.label;
        }

        @Generated
        public List<Javadoc> getEndBrace() {
            return this.endBrace;
        }

        @NonNull
        @Generated
        public String toString() {
            return "Javadoc.Link(id=" + this.getId() + ", markers=" + this.getMarkers() + ", plain=" + this.isPlain() + ", spaceBeforeTree=" + this.getSpaceBeforeTree() + ", tree=" + this.getTree() + ", treeReference=" + this.getTreeReference() + ", label=" + this.getLabel() + ", endBrace=" + this.getEndBrace() + ")";
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Link)) {
                return false;
            }
            Link other = (Link)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @NonNull
        @Generated
        public Link withId(UUID id) {
            return this.id == id ? this : new Link(id, this.markers, this.plain, this.spaceBeforeTree, this.tree, this.treeReference, this.label, this.endBrace);
        }

        @NonNull
        @Generated
        public Link withMarkers(Markers markers) {
            return this.markers == markers ? this : new Link(this.id, markers, this.plain, this.spaceBeforeTree, this.tree, this.treeReference, this.label, this.endBrace);
        }

        @NonNull
        @Generated
        public Link withPlain(boolean plain) {
            return this.plain == plain ? this : new Link(this.id, this.markers, plain, this.spaceBeforeTree, this.tree, this.treeReference, this.label, this.endBrace);
        }

        @NonNull
        @Generated
        public Link withSpaceBeforeTree(List<Javadoc> spaceBeforeTree) {
            return this.spaceBeforeTree == spaceBeforeTree ? this : new Link(this.id, this.markers, this.plain, spaceBeforeTree, this.tree, this.treeReference, this.label, this.endBrace);
        }

        @NonNull
        @Generated
        public Link withTree(@Nullable J tree) {
            return this.tree == tree ? this : new Link(this.id, this.markers, this.plain, this.spaceBeforeTree, tree, this.treeReference, this.label, this.endBrace);
        }

        @NonNull
        @Generated
        public Link withTreeReference(@Nullable Reference treeReference) {
            return this.treeReference == treeReference ? this : new Link(this.id, this.markers, this.plain, this.spaceBeforeTree, this.tree, treeReference, this.label, this.endBrace);
        }

        @NonNull
        @Generated
        public Link withLabel(List<Javadoc> label) {
            return this.label == label ? this : new Link(this.id, this.markers, this.plain, this.spaceBeforeTree, this.tree, this.treeReference, label, this.endBrace);
        }

        @NonNull
        @Generated
        public Link withEndBrace(List<Javadoc> endBrace) {
            return this.endBrace == endBrace ? this : new Link(this.id, this.markers, this.plain, this.spaceBeforeTree, this.tree, this.treeReference, this.label, endBrace);
        }
    }

    public static final class LineBreak
    implements Javadoc {
        private final UUID id;
        private final String margin;
        private final Markers markers;

        @Override
        public <P> Javadoc acceptJavadoc(JavadocVisitor<P> v, P p) {
            return v.visitLineBreak(this, p);
        }

        public LineBreak withMargin(String margin) {
            if (margin.equals(this.margin)) {
                return this;
            }
            return new LineBreak(this.id, margin, this.markers);
        }

        public LineBreak withMarkers(Markers markers) {
            if (markers == this.markers) {
                return this;
            }
            return new LineBreak(this.id, this.margin, markers);
        }

        @Generated
        public LineBreak(UUID id, String margin, Markers markers) {
            this.id = id;
            this.margin = margin;
            this.markers = markers;
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Generated
        public String getMargin() {
            return this.margin;
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @NonNull
        @Generated
        public String toString() {
            return "Javadoc.LineBreak(id=" + this.getId() + ", margin=" + this.getMargin() + ", markers=" + this.getMarkers() + ")";
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LineBreak)) {
                return false;
            }
            LineBreak other = (LineBreak)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @NonNull
        @Generated
        public LineBreak withId(UUID id) {
            return this.id == id ? this : new LineBreak(id, this.margin, this.markers);
        }
    }

    public static final class InlinedValue
    implements Javadoc {
        private final UUID id;
        private final Markers markers;
        private final List<Javadoc> spaceBeforeTree;
        private final @Nullable J tree;
        private final List<Javadoc> endBrace;

        @Override
        public <P> Javadoc acceptJavadoc(JavadocVisitor<P> v, P p) {
            return v.visitInlinedValue(this, p);
        }

        @Generated
        public InlinedValue(UUID id, Markers markers, List<Javadoc> spaceBeforeTree, @Nullable J tree, List<Javadoc> endBrace) {
            this.id = id;
            this.markers = markers;
            this.spaceBeforeTree = spaceBeforeTree;
            this.tree = tree;
            this.endBrace = endBrace;
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @Generated
        public List<Javadoc> getSpaceBeforeTree() {
            return this.spaceBeforeTree;
        }

        @Generated
        public @Nullable J getTree() {
            return this.tree;
        }

        @Generated
        public List<Javadoc> getEndBrace() {
            return this.endBrace;
        }

        @NonNull
        @Generated
        public String toString() {
            return "Javadoc.InlinedValue(id=" + this.getId() + ", markers=" + this.getMarkers() + ", spaceBeforeTree=" + this.getSpaceBeforeTree() + ", tree=" + this.getTree() + ", endBrace=" + this.getEndBrace() + ")";
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof InlinedValue)) {
                return false;
            }
            InlinedValue other = (InlinedValue)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @NonNull
        @Generated
        public InlinedValue withId(UUID id) {
            return this.id == id ? this : new InlinedValue(id, this.markers, this.spaceBeforeTree, this.tree, this.endBrace);
        }

        @NonNull
        @Generated
        public InlinedValue withMarkers(Markers markers) {
            return this.markers == markers ? this : new InlinedValue(this.id, markers, this.spaceBeforeTree, this.tree, this.endBrace);
        }

        @NonNull
        @Generated
        public InlinedValue withSpaceBeforeTree(List<Javadoc> spaceBeforeTree) {
            return this.spaceBeforeTree == spaceBeforeTree ? this : new InlinedValue(this.id, this.markers, spaceBeforeTree, this.tree, this.endBrace);
        }

        @NonNull
        @Generated
        public InlinedValue withTree(@Nullable J tree) {
            return this.tree == tree ? this : new InlinedValue(this.id, this.markers, this.spaceBeforeTree, tree, this.endBrace);
        }

        @NonNull
        @Generated
        public InlinedValue withEndBrace(List<Javadoc> endBrace) {
            return this.endBrace == endBrace ? this : new InlinedValue(this.id, this.markers, this.spaceBeforeTree, this.tree, endBrace);
        }
    }

    public static final class Index
    implements Javadoc {
        private final UUID id;
        private final Markers markers;
        private final List<Javadoc> searchTerm;
        private final List<Javadoc> description;
        private final List<Javadoc> endBrace;

        @Override
        public <P> Javadoc acceptJavadoc(JavadocVisitor<P> v, P p) {
            return v.visitIndex(this, p);
        }

        @Generated
        public Index(UUID id, Markers markers, List<Javadoc> searchTerm, List<Javadoc> description, List<Javadoc> endBrace) {
            this.id = id;
            this.markers = markers;
            this.searchTerm = searchTerm;
            this.description = description;
            this.endBrace = endBrace;
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @Generated
        public List<Javadoc> getSearchTerm() {
            return this.searchTerm;
        }

        @Generated
        public List<Javadoc> getDescription() {
            return this.description;
        }

        @Generated
        public List<Javadoc> getEndBrace() {
            return this.endBrace;
        }

        @NonNull
        @Generated
        public String toString() {
            return "Javadoc.Index(id=" + this.getId() + ", markers=" + this.getMarkers() + ", searchTerm=" + this.getSearchTerm() + ", description=" + this.getDescription() + ", endBrace=" + this.getEndBrace() + ")";
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Index)) {
                return false;
            }
            Index other = (Index)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @NonNull
        @Generated
        public Index withId(UUID id) {
            return this.id == id ? this : new Index(id, this.markers, this.searchTerm, this.description, this.endBrace);
        }

        @NonNull
        @Generated
        public Index withMarkers(Markers markers) {
            return this.markers == markers ? this : new Index(this.id, markers, this.searchTerm, this.description, this.endBrace);
        }

        @NonNull
        @Generated
        public Index withSearchTerm(List<Javadoc> searchTerm) {
            return this.searchTerm == searchTerm ? this : new Index(this.id, this.markers, searchTerm, this.description, this.endBrace);
        }

        @NonNull
        @Generated
        public Index withDescription(List<Javadoc> description) {
            return this.description == description ? this : new Index(this.id, this.markers, this.searchTerm, description, this.endBrace);
        }

        @NonNull
        @Generated
        public Index withEndBrace(List<Javadoc> endBrace) {
            return this.endBrace == endBrace ? this : new Index(this.id, this.markers, this.searchTerm, this.description, endBrace);
        }
    }

    public static final class Hidden
    implements Javadoc {
        private final UUID id;
        private final Markers markers;
        private final List<Javadoc> body;

        @Override
        public <P> Javadoc acceptJavadoc(JavadocVisitor<P> v, P p) {
            return v.visitHidden(this, p);
        }

        @Generated
        public Hidden(UUID id, Markers markers, List<Javadoc> body) {
            this.id = id;
            this.markers = markers;
            this.body = body;
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @Generated
        public List<Javadoc> getBody() {
            return this.body;
        }

        @NonNull
        @Generated
        public String toString() {
            return "Javadoc.Hidden(id=" + this.getId() + ", markers=" + this.getMarkers() + ", body=" + this.getBody() + ")";
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Hidden)) {
                return false;
            }
            Hidden other = (Hidden)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @NonNull
        @Generated
        public Hidden withId(UUID id) {
            return this.id == id ? this : new Hidden(id, this.markers, this.body);
        }

        @NonNull
        @Generated
        public Hidden withMarkers(Markers markers) {
            return this.markers == markers ? this : new Hidden(this.id, markers, this.body);
        }

        @NonNull
        @Generated
        public Hidden withBody(List<Javadoc> body) {
            return this.body == body ? this : new Hidden(this.id, this.markers, body);
        }
    }

    public static final class InheritDoc
    implements Javadoc {
        private final UUID id;
        private final Markers markers;
        private final List<Javadoc> endBrace;

        @Override
        public <P> Javadoc acceptJavadoc(JavadocVisitor<P> v, P p) {
            return v.visitInheritDoc(this, p);
        }

        @Generated
        public InheritDoc(UUID id, Markers markers, List<Javadoc> endBrace) {
            this.id = id;
            this.markers = markers;
            this.endBrace = endBrace;
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @Generated
        public List<Javadoc> getEndBrace() {
            return this.endBrace;
        }

        @NonNull
        @Generated
        public String toString() {
            return "Javadoc.InheritDoc(id=" + this.getId() + ", markers=" + this.getMarkers() + ", endBrace=" + this.getEndBrace() + ")";
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof InheritDoc)) {
                return false;
            }
            InheritDoc other = (InheritDoc)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @NonNull
        @Generated
        public InheritDoc withId(UUID id) {
            return this.id == id ? this : new InheritDoc(id, this.markers, this.endBrace);
        }

        @NonNull
        @Generated
        public InheritDoc withMarkers(Markers markers) {
            return this.markers == markers ? this : new InheritDoc(this.id, markers, this.endBrace);
        }

        @NonNull
        @Generated
        public InheritDoc withEndBrace(List<Javadoc> endBrace) {
            return this.endBrace == endBrace ? this : new InheritDoc(this.id, this.markers, endBrace);
        }
    }

    public static final class Erroneous
    implements Javadoc {
        private final UUID id;
        private final Markers markers;
        private final List<Javadoc> text;

        @Override
        public <P> Javadoc acceptJavadoc(JavadocVisitor<P> v, P p) {
            return v.visitErroneous(this, p);
        }

        @Generated
        public Erroneous(UUID id, Markers markers, List<Javadoc> text) {
            this.id = id;
            this.markers = markers;
            this.text = text;
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @Generated
        public List<Javadoc> getText() {
            return this.text;
        }

        @NonNull
        @Generated
        public String toString() {
            return "Javadoc.Erroneous(id=" + this.getId() + ", markers=" + this.getMarkers() + ", text=" + this.getText() + ")";
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Erroneous)) {
                return false;
            }
            Erroneous other = (Erroneous)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @NonNull
        @Generated
        public Erroneous withId(UUID id) {
            return this.id == id ? this : new Erroneous(id, this.markers, this.text);
        }

        @NonNull
        @Generated
        public Erroneous withMarkers(Markers markers) {
            return this.markers == markers ? this : new Erroneous(this.id, markers, this.text);
        }

        @NonNull
        @Generated
        public Erroneous withText(List<Javadoc> text) {
            return this.text == text ? this : new Erroneous(this.id, this.markers, text);
        }
    }

    public static final class DocType
    implements Javadoc {
        private final UUID id;
        private final Markers markers;
        private final List<Javadoc> text;

        @Override
        public <P> Javadoc acceptJavadoc(JavadocVisitor<P> v, P p) {
            return v.visitDocType(this, p);
        }

        @Generated
        public DocType(UUID id, Markers markers, List<Javadoc> text) {
            this.id = id;
            this.markers = markers;
            this.text = text;
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @Generated
        public List<Javadoc> getText() {
            return this.text;
        }

        @NonNull
        @Generated
        public String toString() {
            return "Javadoc.DocType(id=" + this.getId() + ", markers=" + this.getMarkers() + ", text=" + this.getText() + ")";
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DocType)) {
                return false;
            }
            DocType other = (DocType)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @NonNull
        @Generated
        public DocType withId(UUID id) {
            return this.id == id ? this : new DocType(id, this.markers, this.text);
        }

        @NonNull
        @Generated
        public DocType withMarkers(Markers markers) {
            return this.markers == markers ? this : new DocType(this.id, markers, this.text);
        }

        @NonNull
        @Generated
        public DocType withText(List<Javadoc> text) {
            return this.text == text ? this : new DocType(this.id, this.markers, text);
        }
    }

    public static final class DocRoot
    implements Javadoc {
        private final UUID id;
        private final Markers markers;
        private final List<Javadoc> endBrace;

        @Override
        public <P> Javadoc acceptJavadoc(JavadocVisitor<P> v, P p) {
            return v.visitDocRoot(this, p);
        }

        @Generated
        public DocRoot(UUID id, Markers markers, List<Javadoc> endBrace) {
            this.id = id;
            this.markers = markers;
            this.endBrace = endBrace;
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @Generated
        public List<Javadoc> getEndBrace() {
            return this.endBrace;
        }

        @NonNull
        @Generated
        public String toString() {
            return "Javadoc.DocRoot(id=" + this.getId() + ", markers=" + this.getMarkers() + ", endBrace=" + this.getEndBrace() + ")";
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DocRoot)) {
                return false;
            }
            DocRoot other = (DocRoot)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @NonNull
        @Generated
        public DocRoot withId(UUID id) {
            return this.id == id ? this : new DocRoot(id, this.markers, this.endBrace);
        }

        @NonNull
        @Generated
        public DocRoot withMarkers(Markers markers) {
            return this.markers == markers ? this : new DocRoot(this.id, markers, this.endBrace);
        }

        @NonNull
        @Generated
        public DocRoot withEndBrace(List<Javadoc> endBrace) {
            return this.endBrace == endBrace ? this : new DocRoot(this.id, this.markers, endBrace);
        }
    }

    public static final class DocComment
    implements Javadoc,
    Comment {
        private final UUID id;
        private final Markers markers;
        private final List<Javadoc> body;
        private final String suffix;

        public DocComment withSuffix(String suffix) {
            if (!suffix.equals(this.suffix)) {
                return new DocComment(this.id, this.markers, this.body, suffix);
            }
            return this;
        }

        @Override
        public boolean isMultiline() {
            return true;
        }

        @Override
        public <P> Javadoc acceptJavadoc(JavadocVisitor<P> v, P p) {
            return v.visitDocComment(this, p);
        }

        @Override
        public <P> void printComment(Cursor cursor, PrintOutputCapture<P> print) {
            new JavadocPrinter().visit(this, print, cursor);
        }

        @Generated
        public DocComment(UUID id, Markers markers, List<Javadoc> body, String suffix) {
            this.id = id;
            this.markers = markers;
            this.body = body;
            this.suffix = suffix;
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Override
        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @Generated
        public List<Javadoc> getBody() {
            return this.body;
        }

        @Override
        @Generated
        public String getSuffix() {
            return this.suffix;
        }

        @NonNull
        @Generated
        public String toString() {
            return "Javadoc.DocComment(id=" + this.getId() + ", markers=" + this.getMarkers() + ", body=" + this.getBody() + ", suffix=" + this.getSuffix() + ")";
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DocComment)) {
                return false;
            }
            DocComment other = (DocComment)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @NonNull
        @Generated
        public DocComment withId(UUID id) {
            return this.id == id ? this : new DocComment(id, this.markers, this.body, this.suffix);
        }

        @NonNull
        @Generated
        public DocComment withMarkers(Markers markers) {
            return this.markers == markers ? this : new DocComment(this.id, markers, this.body, this.suffix);
        }

        @NonNull
        @Generated
        public DocComment withBody(List<Javadoc> body) {
            return this.body == body ? this : new DocComment(this.id, this.markers, body, this.suffix);
        }
    }

    public static final class EndElement
    implements Javadoc {
        private final UUID id;
        private final Markers markers;
        private final String name;
        private final List<Javadoc> spaceBeforeEndBracket;

        @Override
        public <P> Javadoc acceptJavadoc(JavadocVisitor<P> v, P p) {
            return v.visitEndElement(this, p);
        }

        @Generated
        public EndElement(UUID id, Markers markers, String name, List<Javadoc> spaceBeforeEndBracket) {
            this.id = id;
            this.markers = markers;
            this.name = name;
            this.spaceBeforeEndBracket = spaceBeforeEndBracket;
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public List<Javadoc> getSpaceBeforeEndBracket() {
            return this.spaceBeforeEndBracket;
        }

        @NonNull
        @Generated
        public String toString() {
            return "Javadoc.EndElement(id=" + this.getId() + ", markers=" + this.getMarkers() + ", name=" + this.getName() + ", spaceBeforeEndBracket=" + this.getSpaceBeforeEndBracket() + ")";
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof EndElement)) {
                return false;
            }
            EndElement other = (EndElement)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @NonNull
        @Generated
        public EndElement withId(UUID id) {
            return this.id == id ? this : new EndElement(id, this.markers, this.name, this.spaceBeforeEndBracket);
        }

        @NonNull
        @Generated
        public EndElement withMarkers(Markers markers) {
            return this.markers == markers ? this : new EndElement(this.id, markers, this.name, this.spaceBeforeEndBracket);
        }

        @NonNull
        @Generated
        public EndElement withName(String name) {
            return this.name == name ? this : new EndElement(this.id, this.markers, name, this.spaceBeforeEndBracket);
        }

        @NonNull
        @Generated
        public EndElement withSpaceBeforeEndBracket(List<Javadoc> spaceBeforeEndBracket) {
            return this.spaceBeforeEndBracket == spaceBeforeEndBracket ? this : new EndElement(this.id, this.markers, this.name, spaceBeforeEndBracket);
        }
    }

    public static final class Deprecated
    implements Javadoc {
        private final UUID id;
        private final Markers markers;
        private final List<Javadoc> description;

        @Override
        public <P> Javadoc acceptJavadoc(JavadocVisitor<P> v, P p) {
            return v.visitDeprecated(this, p);
        }

        @Generated
        public Deprecated(UUID id, Markers markers, List<Javadoc> description) {
            this.id = id;
            this.markers = markers;
            this.description = description;
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @Generated
        public List<Javadoc> getDescription() {
            return this.description;
        }

        @NonNull
        @Generated
        public String toString() {
            return "Javadoc.Deprecated(id=" + this.getId() + ", markers=" + this.getMarkers() + ", description=" + this.getDescription() + ")";
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Deprecated)) {
                return false;
            }
            Deprecated other = (Deprecated)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @NonNull
        @Generated
        public Deprecated withId(UUID id) {
            return this.id == id ? this : new Deprecated(id, this.markers, this.description);
        }

        @NonNull
        @Generated
        public Deprecated withMarkers(Markers markers) {
            return this.markers == markers ? this : new Deprecated(this.id, markers, this.description);
        }

        @NonNull
        @Generated
        public Deprecated withDescription(List<Javadoc> description) {
            return this.description == description ? this : new Deprecated(this.id, this.markers, description);
        }
    }

    public static final class Author
    implements Javadoc {
        private final UUID id;
        private final Markers markers;
        private final List<Javadoc> name;

        @Override
        public <P> Javadoc acceptJavadoc(JavadocVisitor<P> v, P p) {
            return v.visitAuthor(this, p);
        }

        @Generated
        public Author(UUID id, Markers markers, List<Javadoc> name) {
            this.id = id;
            this.markers = markers;
            this.name = name;
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @Generated
        public List<Javadoc> getName() {
            return this.name;
        }

        @NonNull
        @Generated
        public String toString() {
            return "Javadoc.Author(id=" + this.getId() + ", markers=" + this.getMarkers() + ", name=" + this.getName() + ")";
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Author)) {
                return false;
            }
            Author other = (Author)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @NonNull
        @Generated
        public Author withId(UUID id) {
            return this.id == id ? this : new Author(id, this.markers, this.name);
        }

        @NonNull
        @Generated
        public Author withMarkers(Markers markers) {
            return this.markers == markers ? this : new Author(this.id, markers, this.name);
        }

        @NonNull
        @Generated
        public Author withName(List<Javadoc> name) {
            return this.name == name ? this : new Author(this.id, this.markers, name);
        }
    }

    public static final class Attribute
    implements Javadoc {
        private final UUID id;
        private final Markers markers;
        private final String name;
        private final @Nullable List<Javadoc> spaceBeforeEqual;
        private final @Nullable List<Javadoc> value;

        @Override
        public <P> Javadoc acceptJavadoc(JavadocVisitor<P> v, P p) {
            return v.visitAttribute(this, p);
        }

        @Generated
        public Attribute(UUID id, Markers markers, String name, @Nullable List<Javadoc> spaceBeforeEqual, @Nullable List<Javadoc> value) {
            this.id = id;
            this.markers = markers;
            this.name = name;
            this.spaceBeforeEqual = spaceBeforeEqual;
            this.value = value;
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public @Nullable List<Javadoc> getSpaceBeforeEqual() {
            return this.spaceBeforeEqual;
        }

        @Generated
        public @Nullable List<Javadoc> getValue() {
            return this.value;
        }

        @NonNull
        @Generated
        public String toString() {
            return "Javadoc.Attribute(id=" + this.getId() + ", markers=" + this.getMarkers() + ", name=" + this.getName() + ", spaceBeforeEqual=" + this.getSpaceBeforeEqual() + ", value=" + this.getValue() + ")";
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Attribute)) {
                return false;
            }
            Attribute other = (Attribute)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @NonNull
        @Generated
        public Attribute withId(UUID id) {
            return this.id == id ? this : new Attribute(id, this.markers, this.name, this.spaceBeforeEqual, this.value);
        }

        @NonNull
        @Generated
        public Attribute withMarkers(Markers markers) {
            return this.markers == markers ? this : new Attribute(this.id, markers, this.name, this.spaceBeforeEqual, this.value);
        }

        @NonNull
        @Generated
        public Attribute withName(String name) {
            return this.name == name ? this : new Attribute(this.id, this.markers, name, this.spaceBeforeEqual, this.value);
        }

        @NonNull
        @Generated
        public Attribute withSpaceBeforeEqual(@Nullable List<Javadoc> spaceBeforeEqual) {
            return this.spaceBeforeEqual == spaceBeforeEqual ? this : new Attribute(this.id, this.markers, this.name, spaceBeforeEqual, this.value);
        }

        @NonNull
        @Generated
        public Attribute withValue(@Nullable List<Javadoc> value) {
            return this.value == value ? this : new Attribute(this.id, this.markers, this.name, this.spaceBeforeEqual, value);
        }
    }
}

