/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.tools.checkstyle;

import java.io.Serializable;
import org.openrewrite.tools.checkstyle.Checker;
import org.openrewrite.tools.checkstyle.TreeWalker;

public class ThreadModeSettings
implements Serializable {
    public static final String CHECKER_MODULE_NAME = Checker.class.getSimpleName();
    public static final String MULTI_THREAD_CHECKER_MODULE_NAME = Checker.class.getSimpleName();
    public static final String TREE_WALKER_MODULE_NAME = TreeWalker.class.getSimpleName();
    public static final String MULTI_THREAD_TREE_WALKER_MODULE_NAME = TreeWalker.class.getSimpleName();
    public static final ThreadModeSettings SINGLE_THREAD_MODE_INSTANCE = new ThreadModeSettings(1, 1);
    private static final long serialVersionUID = 1L;
    private final int checkerThreadsNumber;
    private final int treeWalkerThreadsNumber;

    public ThreadModeSettings(int checkerThreadsNumber, int treeWalkerThreadsNumber) {
        this.checkerThreadsNumber = checkerThreadsNumber;
        this.treeWalkerThreadsNumber = treeWalkerThreadsNumber;
    }

    public int getCheckerThreadsNumber() {
        return this.checkerThreadsNumber;
    }

    public int getTreeWalkerThreadsNumber() {
        return this.treeWalkerThreadsNumber;
    }

    public final String resolveName(String name) {
        if (this.checkerThreadsNumber > 1) {
            if (CHECKER_MODULE_NAME.equals(name)) {
                throw new IllegalArgumentException("Multi thread mode for Checker module is not implemented");
            }
            if (TREE_WALKER_MODULE_NAME.equals(name)) {
                throw new IllegalArgumentException("Multi thread mode for TreeWalker module is not implemented");
            }
        }
        return name;
    }
}

