/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.tools.checkstyle.checks.indentation;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashSet;
import java.util.Set;
import org.openrewrite.tools.checkstyle.FileStatefulCheck;
import org.openrewrite.tools.checkstyle.api.AbstractCheck;
import org.openrewrite.tools.checkstyle.api.DetailAST;
import org.openrewrite.tools.checkstyle.checks.indentation.AbstractExpressionHandler;
import org.openrewrite.tools.checkstyle.checks.indentation.HandlerFactory;
import org.openrewrite.tools.checkstyle.checks.indentation.LineWrappingHandler;
import org.openrewrite.tools.checkstyle.checks.indentation.PrimordialHandler;

@FileStatefulCheck
public class IndentationCheck
extends AbstractCheck {
    public static final String MSG_ERROR = "indentation.error";
    public static final String MSG_ERROR_MULTI = "indentation.error.multi";
    public static final String MSG_CHILD_ERROR = "indentation.child.error";
    public static final String MSG_CHILD_ERROR_MULTI = "indentation.child.error.multi";
    private static final int DEFAULT_INDENTATION = 4;
    private final Deque<AbstractExpressionHandler> handlers = new ArrayDeque<AbstractExpressionHandler>();
    private final LineWrappingHandler lineWrappingHandler = new LineWrappingHandler(this);
    private final HandlerFactory handlerFactory = new HandlerFactory();
    private Set<Integer> incorrectIndentationLines;
    private int basicOffset = 4;
    private int caseIndent = 4;
    private int braceAdjustment;
    private int throwsIndent = 4;
    private int arrayInitIndent = 4;
    private int lineWrappingIndentation = 4;
    private boolean forceStrictCondition;

    public boolean isForceStrictCondition() {
        return this.forceStrictCondition;
    }

    public void setForceStrictCondition(boolean value) {
        this.forceStrictCondition = value;
    }

    public void setBasicOffset(int basicOffset) {
        this.basicOffset = basicOffset;
    }

    public int getBasicOffset() {
        return this.basicOffset;
    }

    public void setBraceAdjustment(int adjustmentAmount) {
        this.braceAdjustment = adjustmentAmount;
    }

    public int getBraceAdjustment() {
        return this.braceAdjustment;
    }

    public void setCaseIndent(int amount) {
        this.caseIndent = amount;
    }

    public int getCaseIndent() {
        return this.caseIndent;
    }

    public void setThrowsIndent(int throwsIndent) {
        this.throwsIndent = throwsIndent;
    }

    public int getThrowsIndent() {
        return this.throwsIndent;
    }

    public void setArrayInitIndent(int arrayInitIndent) {
        this.arrayInitIndent = arrayInitIndent;
    }

    public int getArrayInitIndent() {
        return this.arrayInitIndent;
    }

    public int getLineWrappingIndentation() {
        return this.lineWrappingIndentation;
    }

    public void setLineWrappingIndentation(int lineWrappingIndentation) {
        this.lineWrappingIndentation = lineWrappingIndentation;
    }

    public void indentationLog(DetailAST ast, String key, Object ... args) {
        if (!this.incorrectIndentationLines.contains(ast.getLineNo())) {
            this.incorrectIndentationLines.add(ast.getLineNo());
            this.log(ast, key, args);
        }
    }

    public int getIndentationTabWidth() {
        return this.getTabWidth();
    }

    @Override
    public int[] getDefaultTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getRequiredTokens() {
        return this.handlerFactory.getHandledTypes();
    }

    @Override
    public void beginTree(DetailAST ast) {
        this.handlerFactory.clearCreatedHandlers();
        this.handlers.clear();
        PrimordialHandler primordialHandler = new PrimordialHandler(this);
        this.handlers.push(primordialHandler);
        primordialHandler.checkIndentation();
        this.incorrectIndentationLines = new HashSet<Integer>();
    }

    @Override
    public void visitToken(DetailAST ast) {
        AbstractExpressionHandler handler = this.handlerFactory.getHandler(this, ast, this.handlers.peek());
        this.handlers.push(handler);
        handler.checkIndentation();
    }

    @Override
    public void leaveToken(DetailAST ast) {
        this.handlers.pop();
    }

    public LineWrappingHandler getLineWrappingHandler() {
        return this.lineWrappingHandler;
    }

    public final HandlerFactory getHandlerFactory() {
        return this.handlerFactory;
    }
}

