/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.Collections;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.RemoveImport;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.Space;
import org.openrewrite.marker.Markers;

public class NoStaticImport
extends Recipe {
    @Option(displayName="Method pattern", description="To find all method invocations in the Guava library, use the pattern `com.google.common..*#*(..)`. The pattern format is `<PACKAGE>#<METHOD_NAME>(<ARGS>)`. `..*` includes all subpackages of `com.google.common`. `*(..)` matches any method name with any number of arguments. For more specific queries, like Guava's `ImmutableMap`, use `com.google.common.collect.ImmutableMap#*(..)` to narrow down the results.", example="java.util.Collections emptyList()")
    private final String methodPattern;

    public String getDisplayName() {
        return "Remove static import";
    }

    public String getDescription() {
        return "Removes static imports and replaces them with qualified references. For example, `emptyList()` becomes `Collections.emptyList()`.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check(new UsesMethod(this.methodPattern), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            @Override
            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J m;
                MethodMatcher methodMatcher = new MethodMatcher(NoStaticImport.this.methodPattern);
                if (methodMatcher.matches((MethodCall)(m = super.visitMethodInvocation(method, ctx))) && ((J.MethodInvocation)m).getSelect() == null && ((J.MethodInvocation)m).getMethodType() != null) {
                    if (((J.MethodInvocation)m).getName().getSimpleName().equals("super")) {
                        return m;
                    }
                    JavaType.FullyQualified receiverType = ((J.MethodInvocation)m).getMethodType().getDeclaringType();
                    RemoveImport op = new RemoveImport(receiverType.getFullyQualifiedName() + "." + method.getSimpleName(), true);
                    if (!this.getAfterVisit().contains((Object)op)) {
                        this.doAfterVisit(op);
                    }
                    J.ClassDeclaration enclosingClass = (J.ClassDeclaration)this.getCursor().firstEnclosing(J.ClassDeclaration.class);
                    if ("java.lang.Object".equals(receiverType.getFullyQualifiedName()) || enclosingClass == null || enclosingClass.getType() == null || enclosingClass.getType().equals(receiverType) || enclosingClass.getType().getOwningClass() != null && enclosingClass.getType().getOwningClass().equals(receiverType) || enclosingClass.getType().getSupertype() != null && enclosingClass.getType().getSupertype().equals(receiverType)) {
                        return m;
                    }
                    this.maybeAddImport(receiverType.getFullyQualifiedName());
                    m = ((J.MethodInvocation)m).withSelect(new J.Identifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, Collections.emptyList(), receiverType.getClassName(), receiverType, null));
                }
                return m;
            }
        });
    }

    @NonNull
    @Generated
    public String toString() {
        return "NoStaticImport(methodPattern=" + this.getMethodPattern() + ")";
    }

    @Generated
    public String getMethodPattern() {
        return this.methodPattern;
    }

    @Generated
    public NoStaticImport(String methodPattern) {
        this.methodPattern = methodPattern;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NoStaticImport)) {
            return false;
        }
        NoStaticImport other = (NoStaticImport)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$methodPattern = this.getMethodPattern();
        String other$methodPattern = other.getMethodPattern();
        return !(this$methodPattern == null ? other$methodPattern != null : !this$methodPattern.equals(other$methodPattern));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof NoStaticImport;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $methodPattern = this.getMethodPattern();
        result = result * 59 + ($methodPattern == null ? 43 : $methodPattern.hashCode());
        return result;
    }
}

