/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.Collections;
import java.util.LinkedHashSet;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Flag;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.Space;
import org.openrewrite.marker.Markers;

public final class ChangeMethodTargetToVariable
extends Recipe {
    @Option(displayName="Method pattern", description="To find all method invocations in the Guava library, use the pattern `com.google.common..*#*(..)`. The pattern format is `<PACKAGE>#<METHOD_NAME>(<ARGS>)`. `..*` includes all subpackages of `com.google.common`. `*(..)` matches any method name with any number of arguments. For more specific queries, like Guava's `ImmutableMap`, use `com.google.common.collect.ImmutableMap#*(..)` to narrow down the results.", example="org.mycorp.A method(..)")
    private final String methodPattern;
    @Option(displayName="Variable name", description="Name of variable to use as target for the modified method invocation.", example="foo")
    private final String variableName;
    @Option(displayName="Variable type", description="Type attribution to use for the return type of the modified method invocation.", example="java.lang.String")
    private final String variableType;
    @Option(displayName="Match on overrides", description="When enabled, find methods that are overrides of the method pattern.", required=false)
    private final @Nullable Boolean matchOverrides;

    public String getDisplayName() {
        return "Change method target to variable";
    }

    public String getDescription() {
        return "Change method invocations to method calls on a variable.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check(new UsesMethod(this.methodPattern, this.matchOverrides), (TreeVisitor)new ChangeMethodTargetToVariableVisitor(new MethodMatcher(this.methodPattern, this.matchOverrides), JavaType.ShallowClass.build(this.variableType)));
    }

    @Generated
    public ChangeMethodTargetToVariable(String methodPattern, String variableName, String variableType, @Nullable Boolean matchOverrides) {
        this.methodPattern = methodPattern;
        this.variableName = variableName;
        this.variableType = variableType;
        this.matchOverrides = matchOverrides;
    }

    @Generated
    public String getMethodPattern() {
        return this.methodPattern;
    }

    @Generated
    public String getVariableName() {
        return this.variableName;
    }

    @Generated
    public String getVariableType() {
        return this.variableType;
    }

    @Generated
    public @Nullable Boolean getMatchOverrides() {
        return this.matchOverrides;
    }

    @NonNull
    @Generated
    public String toString() {
        return "ChangeMethodTargetToVariable(methodPattern=" + this.getMethodPattern() + ", variableName=" + this.getVariableName() + ", variableType=" + this.getVariableType() + ", matchOverrides=" + this.getMatchOverrides() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChangeMethodTargetToVariable)) {
            return false;
        }
        ChangeMethodTargetToVariable other = (ChangeMethodTargetToVariable)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$matchOverrides = this.getMatchOverrides();
        Boolean other$matchOverrides = other.getMatchOverrides();
        if (this$matchOverrides == null ? other$matchOverrides != null : !((Object)this$matchOverrides).equals(other$matchOverrides)) {
            return false;
        }
        String this$methodPattern = this.getMethodPattern();
        String other$methodPattern = other.getMethodPattern();
        if (this$methodPattern == null ? other$methodPattern != null : !this$methodPattern.equals(other$methodPattern)) {
            return false;
        }
        String this$variableName = this.getVariableName();
        String other$variableName = other.getVariableName();
        if (this$variableName == null ? other$variableName != null : !this$variableName.equals(other$variableName)) {
            return false;
        }
        String this$variableType = this.getVariableType();
        String other$variableType = other.getVariableType();
        return !(this$variableType == null ? other$variableType != null : !this$variableType.equals(other$variableType));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof ChangeMethodTargetToVariable;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $matchOverrides = this.getMatchOverrides();
        result = result * 59 + ($matchOverrides == null ? 43 : ((Object)$matchOverrides).hashCode());
        String $methodPattern = this.getMethodPattern();
        result = result * 59 + ($methodPattern == null ? 43 : $methodPattern.hashCode());
        String $variableName = this.getVariableName();
        result = result * 59 + ($variableName == null ? 43 : $variableName.hashCode());
        String $variableType = this.getVariableType();
        result = result * 59 + ($variableType == null ? 43 : $variableType.hashCode());
        return result;
    }

    private class ChangeMethodTargetToVariableVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private final MethodMatcher methodMatcher;
        private final JavaType.Class variableType;

        private ChangeMethodTargetToVariableVisitor(MethodMatcher methodMatcher, JavaType.Class variableType) {
            this.methodMatcher = methodMatcher;
            this.variableType = variableType;
        }

        @Override
        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
            J m = super.visitMethodInvocation(method, ctx);
            if (this.methodMatcher.matches((MethodCall)m)) {
                JavaType.Method methodType = null;
                if (((J.MethodInvocation)m).getMethodType() != null) {
                    this.maybeRemoveImport(((J.MethodInvocation)m).getMethodType().getDeclaringType());
                    LinkedHashSet<Flag> flags = new LinkedHashSet<Flag>(((J.MethodInvocation)m).getMethodType().getFlags());
                    flags.remove((Object)Flag.Static);
                    methodType = ((J.MethodInvocation)m).getMethodType().withDeclaringType(this.variableType).withFlags(flags);
                }
                m = ((J.MethodInvocation)m).withSelect(new J.Identifier(Tree.randomId(), ((J.MethodInvocation)m).getSelect() == null ? Space.EMPTY : ((J.MethodInvocation)m).getSelect().getPrefix(), Markers.EMPTY, Collections.emptyList(), ChangeMethodTargetToVariable.this.variableName, this.variableType, null)).withMethodType(methodType).withName(((J.MethodInvocation)m).getName().withType(methodType));
            }
            return m;
        }
    }
}

