/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.tools.checkstyle.checks.indentation;

import org.openrewrite.tools.checkstyle.api.DetailAST;
import org.openrewrite.tools.checkstyle.checks.indentation.AbstractExpressionHandler;
import org.openrewrite.tools.checkstyle.checks.indentation.BlockParentHandler;
import org.openrewrite.tools.checkstyle.checks.indentation.IndentLevel;
import org.openrewrite.tools.checkstyle.checks.indentation.IndentationCheck;

public class SynchronizedHandler
extends BlockParentHandler {
    private final boolean methodModifier;

    public SynchronizedHandler(IndentationCheck indentCheck, DetailAST ast, AbstractExpressionHandler parent) {
        super(indentCheck, "synchronized", ast, parent);
        this.methodModifier = SynchronizedHandler.isMethodModifier(ast);
    }

    @Override
    public void checkIndentation() {
        if (!this.methodModifier) {
            super.checkIndentation();
            this.checkSynchronizedExpr();
            this.checkWrappingIndentation(this.getMainAst(), SynchronizedHandler.getSynchronizedStatementRightParen(this.getMainAst()));
        }
    }

    private void checkSynchronizedExpr() {
        DetailAST syncAst = this.getMainAst().findFirstToken(76).getNextSibling();
        IndentLevel expected = new IndentLevel(this.getIndent(), this.getBasicOffset());
        this.checkExpressionSubtree(syncAst, expected, false, false);
    }

    private static boolean isMethodModifier(DetailAST ast) {
        return ast.getParent().getType() == 5;
    }

    private static DetailAST getSynchronizedStatementRightParen(DetailAST syncStatementAST) {
        return syncStatementAST.findFirstToken(77);
    }
}

