/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.tools.checkstyle.checks.indentation;

import org.openrewrite.tools.checkstyle.api.DetailAST;
import org.openrewrite.tools.checkstyle.checks.indentation.AbstractExpressionHandler;
import org.openrewrite.tools.checkstyle.checks.indentation.IndentLevel;
import org.openrewrite.tools.checkstyle.checks.indentation.IndentationCheck;
import org.openrewrite.tools.checkstyle.utils.TokenUtil;

public class BlockParentHandler
extends AbstractExpressionHandler {
    private static final int[] CHECKED_CHILDREN = new int[]{10, 28, 159, 6, 86, 88, 90, 87, 43, 42};

    public BlockParentHandler(IndentationCheck indentCheck, String name, DetailAST ast, AbstractExpressionHandler parent) {
        super(indentCheck, name, ast, parent);
    }

    protected int[] getCheckedChildren() {
        return (int[])CHECKED_CHILDREN.clone();
    }

    protected DetailAST getTopLevelAst() {
        return this.getMainAst();
    }

    protected void checkTopLevelToken() {
        DetailAST topLevel = this.getTopLevelAst();
        if (topLevel != null && !this.getIndent().isAcceptable(this.expandedTabsColumnNo(topLevel)) && this.isOnStartOfLine(topLevel)) {
            this.logError(topLevel, "", this.expandedTabsColumnNo(topLevel));
        }
    }

    private boolean hasCurlies() {
        return this.getLeftCurly() != null && this.getRightCurly() != null;
    }

    protected DetailAST getLeftCurly() {
        return this.getMainAst().findFirstToken(7);
    }

    protected DetailAST getRightCurly() {
        DetailAST slist = this.getMainAst().findFirstToken(7);
        return slist.findFirstToken(73);
    }

    private void checkLeftCurly() {
        DetailAST lcurly = this.getLeftCurly();
        int lcurlyPos = this.expandedTabsColumnNo(lcurly);
        if (!this.curlyIndent().isAcceptable(lcurlyPos) && this.isOnStartOfLine(lcurly)) {
            this.logError(lcurly, "lcurly", lcurlyPos, this.curlyIndent());
        }
    }

    protected IndentLevel curlyIndent() {
        DetailAST lcurly = this.getLeftCurly();
        IndentLevel expIndentLevel = new IndentLevel(this.getIndent(), this.getBraceAdjustment());
        if (!this.isOnStartOfLine(lcurly) || lcurly.getParent().getType() == 11) {
            expIndentLevel = new IndentLevel(this.getIndent(), 0);
        }
        return expIndentLevel;
    }

    protected boolean canChildrenBeNested() {
        return false;
    }

    private void checkRightCurly() {
        DetailAST rcurly = this.getRightCurly();
        int rcurlyPos = this.expandedTabsColumnNo(rcurly);
        if (!this.curlyIndent().isAcceptable(rcurlyPos) && this.isOnStartOfLine(rcurly)) {
            this.logError(rcurly, "rcurly", rcurlyPos, this.curlyIndent());
        }
    }

    protected DetailAST getNonListChild() {
        return this.getMainAst().findFirstToken(77).getNextSibling();
    }

    private void checkNonListChild() {
        DetailAST nonList = this.getNonListChild();
        if (nonList != null) {
            IndentLevel expected = new IndentLevel(this.getIndent(), this.getBasicOffset());
            this.checkExpressionSubtree(nonList, expected, false, false);
            DetailAST nonListStartAst = BlockParentHandler.getFirstAstNode(nonList);
            if (nonList != nonListStartAst) {
                this.checkExpressionSubtree(nonListStartAst, expected, false, false);
            }
        }
    }

    protected DetailAST getListChild() {
        return this.getMainAst().findFirstToken(7);
    }

    private DetailAST getRightParen() {
        return this.getMainAst().findFirstToken(77);
    }

    private DetailAST getLeftParen() {
        return this.getMainAst().findFirstToken(76);
    }

    @Override
    public void checkIndentation() {
        DetailAST listChild;
        this.checkTopLevelToken();
        this.checkLeftParen(this.getLeftParen());
        this.checkRightParen(this.getLeftParen(), this.getRightParen());
        if (this.hasCurlies()) {
            this.checkLeftCurly();
            this.checkRightCurly();
        }
        if ((listChild = this.getListChild()) == null) {
            this.checkNonListChild();
        } else if (!this.hasCurlies() || !TokenUtil.areOnSameLine(this.getLeftCurly(), this.getRightCurly())) {
            this.checkChildren(listChild, this.getCheckedChildren(), this.getChildrenExpectedIndent(), true, this.canChildrenBeNested());
        }
    }

    protected IndentLevel getChildrenExpectedIndent() {
        IndentLevel indentLevel = new IndentLevel(this.getIndent(), this.getBasicOffset());
        if (this.getIndent().isMultiLevel() && this.hasCurlies()) {
            if (this.isOnStartOfLine(this.getLeftCurly())) {
                indentLevel = new IndentLevel(this.expandedTabsColumnNo(this.getLeftCurly()) + this.getBasicOffset());
            } else if (this.isOnStartOfLine(this.getRightCurly())) {
                IndentLevel level = new IndentLevel(this.curlyIndent(), this.getBasicOffset());
                indentLevel = IndentLevel.addAcceptable(level, level.getFirstIndentLevel() + this.getLineWrappingIndent());
            }
        }
        if (this.hasCurlies() && this.isOnStartOfLine(this.getLeftCurly())) {
            indentLevel = IndentLevel.addAcceptable(indentLevel, this.curlyIndent().getFirstIndentLevel() + this.getBasicOffset());
        }
        return indentLevel;
    }

    @Override
    public IndentLevel getSuggestedChildIndent(AbstractExpressionHandler child) {
        return this.getChildrenExpectedIndent();
    }

    private int getLineWrappingIndent() {
        return this.getIndentCheck().getLineWrappingIndentation();
    }
}

