/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.search;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.ScanningRecipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.marker.JavaVersion;
import org.openrewrite.java.tree.J;
import org.openrewrite.marker.SearchResult;
import org.openrewrite.semver.Semver;
import org.openrewrite.semver.VersionComparator;

public final class HasMinimumJavaVersion
extends ScanningRecipe<AtomicReference<JavaVersion>> {
    @Option(displayName="Java version", description="An exact version number or node-style semver selector used to select the version number.", example="17.X")
    private final String version;
    @Option(displayName="Version check against target compatibility", description="The source and target compatibility versions can be different. This option allows you to check against the target compatibility version instead of the source compatibility version.", example="17.X", required=false)
    private final @Nullable Boolean checkTargetCompatibility;

    public String getDisplayName() {
        return "Find the oldest Java version in use";
    }

    public String getDescription() {
        return "The oldest Java version in use is the lowest Java version in use in any source set of any subproject of a repository. It is possible that, for example, the main source set of a project uses Java 8, but a test source set uses Java 17. In this case, the oldest Java version in use is Java 8.";
    }

    public Validated<Object> validate() {
        Validated validated = super.validate();
        if (this.version != null) {
            validated = validated.and(Semver.validate((String)this.version, null));
        }
        return validated;
    }

    public AtomicReference<JavaVersion> getInitialValue(ExecutionContext ctx) {
        return new AtomicReference<JavaVersion>();
    }

    public TreeVisitor<?, ExecutionContext> getScanner(final AtomicReference<JavaVersion> acc) {
        return new JavaIsoVisitor<ExecutionContext>(){

            @Override
            public J.CompilationUnit visitCompilationUnit(J.CompilationUnit cu, ExecutionContext ctx) {
                cu.getMarkers().findFirst(JavaVersion.class).ifPresent(javaVersion -> acc.updateAndGet(current -> {
                    if (current == null || javaVersion.getMajorVersion() < current.getMajorVersion()) {
                        return javaVersion;
                    }
                    return current;
                }));
                return cu;
            }
        };
    }

    public TreeVisitor<?, ExecutionContext> getVisitor(final AtomicReference<JavaVersion> acc) {
        VersionComparator versionComparator = Objects.requireNonNull((VersionComparator)Semver.validate((String)this.version, null).getValue());
        return Preconditions.check((boolean)this.minimumVersionInRange(acc, versionComparator), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            @Override
            public J.CompilationUnit visitCompilationUnit(J.CompilationUnit cu, ExecutionContext ctx) {
                return cu.getMarkers().findFirst(JavaVersion.class).filter(javaVersion -> acc.get() != null && javaVersion.getMajorVersion() == ((JavaVersion)acc.get()).getMajorVersion()).map(javaVersion -> (J.CompilationUnit)SearchResult.found((Tree)cu, (String)("Java version " + javaVersion.getMajorVersion()))).orElse(cu);
            }
        });
    }

    private boolean minimumVersionInRange(AtomicReference<JavaVersion> acc, VersionComparator versionComparator) {
        return acc.get() != null && versionComparator.isValid(null, Integer.toString(Boolean.TRUE.equals(this.checkTargetCompatibility) ? acc.get().getMajorReleaseVersion() : acc.get().getMajorVersion()));
    }

    @Generated
    public HasMinimumJavaVersion(String version, @Nullable Boolean checkTargetCompatibility) {
        this.version = version;
        this.checkTargetCompatibility = checkTargetCompatibility;
    }

    @Generated
    public String getVersion() {
        return this.version;
    }

    @Generated
    public @Nullable Boolean getCheckTargetCompatibility() {
        return this.checkTargetCompatibility;
    }

    @NonNull
    @Generated
    public String toString() {
        return "HasMinimumJavaVersion(version=" + this.getVersion() + ", checkTargetCompatibility=" + this.getCheckTargetCompatibility() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HasMinimumJavaVersion)) {
            return false;
        }
        HasMinimumJavaVersion other = (HasMinimumJavaVersion)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$checkTargetCompatibility = this.getCheckTargetCompatibility();
        Boolean other$checkTargetCompatibility = other.getCheckTargetCompatibility();
        if (this$checkTargetCompatibility == null ? other$checkTargetCompatibility != null : !((Object)this$checkTargetCompatibility).equals(other$checkTargetCompatibility)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        return !(this$version == null ? other$version != null : !this$version.equals(other$version));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof HasMinimumJavaVersion;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $checkTargetCompatibility = this.getCheckTargetCompatibility();
        result = result * 59 + ($checkTargetCompatibility == null ? 43 : ((Object)$checkTargetCompatibility).hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        return result;
    }
}

