/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.List;
import java.util.function.UnaryOperator;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.PrintOutputCapture;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.JavadocVisitor;
import org.openrewrite.java.marker.LeadingBrace;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JContainer;
import org.openrewrite.java.tree.JLeftPadded;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.Javadoc;
import org.openrewrite.java.tree.Space;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.Markers;

public class JavadocPrinter<P>
extends JavadocVisitor<PrintOutputCapture<P>> {
    private static final UnaryOperator<String> JAVADOC_MARKER_WRAPPER = out -> "~~" + out + (out.isEmpty() ? "" : "~~") + ">";
    private static final UnaryOperator<String> JAVA_MARKER_WRAPPER = out -> "/*~~" + out + (out.isEmpty() ? "" : "~~") + ">*/";

    public JavadocPrinter() {
        super(new JavadocJavaPrinter());
    }

    @Override
    public Javadoc visitAttribute(Javadoc.Attribute attribute, PrintOutputCapture<P> p) {
        this.beforeSyntax(attribute, p);
        p.append(attribute.getName());
        if (attribute.getSpaceBeforeEqual() != null && !attribute.getSpaceBeforeEqual().isEmpty()) {
            this.visit(attribute.getSpaceBeforeEqual(), p);
            if (attribute.getValue() != null) {
                p.append('=');
                this.visit(attribute.getValue(), p);
            }
        }
        this.afterSyntax(attribute, p);
        return attribute;
    }

    @Override
    public Javadoc visitAuthor(Javadoc.Author author, PrintOutputCapture<P> p) {
        this.beforeSyntax(author, p);
        p.append("@author");
        this.visit(author.getName(), p);
        this.afterSyntax(author, p);
        return author;
    }

    @Override
    public Javadoc visitDeprecated(Javadoc.Deprecated deprecated, PrintOutputCapture<P> p) {
        this.beforeSyntax(deprecated, p);
        p.append("@deprecated");
        this.visit(deprecated.getDescription(), p);
        this.afterSyntax(deprecated, p);
        return deprecated;
    }

    @Override
    public Javadoc visitDocComment(Javadoc.DocComment javadoc, PrintOutputCapture<P> p) {
        this.beforeSyntax(javadoc, p, JAVA_MARKER_WRAPPER);
        p.append("/**");
        this.visit(javadoc.getBody(), p);
        p.append("*/");
        this.afterSyntax(javadoc, p);
        return javadoc;
    }

    @Override
    public Javadoc visitDocRoot(Javadoc.DocRoot docRoot, PrintOutputCapture<P> p) {
        this.beforeSyntax(docRoot, p, JAVA_MARKER_WRAPPER);
        p.append("{@docRoot");
        this.visit(docRoot.getEndBrace(), p);
        this.afterSyntax(docRoot, p);
        return docRoot;
    }

    @Override
    public Javadoc visitDocType(Javadoc.DocType docType, PrintOutputCapture<P> p) {
        this.beforeSyntax(docType, p);
        p.append("<!doctype");
        this.visit(docType.getText(), p);
        p.append('>');
        this.afterSyntax(docType, p);
        return docType;
    }

    @Override
    public Javadoc visitEndElement(Javadoc.EndElement endElement, PrintOutputCapture<P> p) {
        this.beforeSyntax(endElement, p);
        p.append("</").append(endElement.getName());
        this.visit(endElement.getSpaceBeforeEndBracket(), p);
        p.append('>');
        this.afterSyntax(endElement, p);
        return endElement;
    }

    @Override
    public Javadoc visitErroneous(Javadoc.Erroneous erroneous, PrintOutputCapture<P> p) {
        this.beforeSyntax(erroneous, p, JAVA_MARKER_WRAPPER);
        this.visit(erroneous.getText(), p);
        this.afterSyntax(erroneous, p);
        return erroneous;
    }

    @Override
    public Javadoc visitHidden(Javadoc.Hidden hidden, PrintOutputCapture<P> p) {
        this.beforeSyntax(hidden, p, JAVA_MARKER_WRAPPER);
        p.append("@hidden");
        this.visit(hidden.getBody(), p);
        this.afterSyntax(hidden, p);
        return hidden;
    }

    @Override
    public Javadoc visitIndex(Javadoc.Index index, PrintOutputCapture<P> p) {
        this.beforeSyntax(index, p, JAVA_MARKER_WRAPPER);
        p.append("{@index");
        this.visit(index.getSearchTerm(), p);
        this.visit(index.getDescription(), p);
        this.visit(index.getEndBrace(), p);
        this.afterSyntax(index, p);
        return index;
    }

    @Override
    public Javadoc visitInheritDoc(Javadoc.InheritDoc inheritDoc, PrintOutputCapture<P> p) {
        this.beforeSyntax(inheritDoc, p);
        p.append("{@inheritDoc");
        this.visit(inheritDoc.getEndBrace(), p);
        this.afterSyntax(inheritDoc, p);
        return inheritDoc;
    }

    @Override
    public Javadoc visitInlinedValue(Javadoc.InlinedValue value, PrintOutputCapture<P> p) {
        this.beforeSyntax(value, p);
        p.append("{@value");
        this.visit(value.getSpaceBeforeTree(), p);
        this.javaVisitorVisit(value.getTree(), p);
        this.visit(value.getEndBrace(), p);
        this.afterSyntax(value, p);
        return value;
    }

    @Override
    public Javadoc visitLineBreak(Javadoc.LineBreak lineBreak, PrintOutputCapture<P> p) {
        this.beforeSyntax(lineBreak, p, JAVA_MARKER_WRAPPER);
        p.append(lineBreak.getMargin());
        this.afterSyntax(lineBreak, p);
        return lineBreak;
    }

    @Override
    public Javadoc visitLink(Javadoc.Link link, PrintOutputCapture<P> p) {
        this.beforeSyntax(link, p);
        p.append(link.isPlain() ? "{@linkplain" : "{@link");
        this.visit(link.getSpaceBeforeTree(), p);
        this.visit(link.getTreeReference(), p);
        this.visit(link.getLabel(), p);
        this.visit(link.getEndBrace(), p);
        this.afterSyntax(link, p);
        return link;
    }

    @Override
    public Javadoc visitLiteral(Javadoc.Literal literal, PrintOutputCapture<P> p) {
        this.beforeSyntax(literal, p);
        p.append(literal.isCode() ? "{@code" : "{@literal");
        this.visit(literal.getDescription(), p);
        this.visit(literal.getEndBrace(), p);
        this.afterSyntax(literal, p);
        return literal;
    }

    @Override
    public Javadoc visitParameter(Javadoc.Parameter parameter, PrintOutputCapture<P> p) {
        this.beforeSyntax(parameter, p);
        p.append("@param");
        this.visit(parameter.getSpaceBeforeName(), p);
        this.visit(parameter.getNameReference(), p);
        this.visit(parameter.getDescription(), p);
        this.afterSyntax(parameter, p);
        return parameter;
    }

    @Override
    public Javadoc visitProvides(Javadoc.Provides provides, PrintOutputCapture<P> p) {
        this.beforeSyntax(provides, p);
        p.append("@provides");
        this.visit(provides.getSpaceBeforeServiceType(), p);
        this.javaVisitorVisit(provides.getServiceType(), p);
        this.visit(provides.getDescription(), p);
        this.afterSyntax(provides, p);
        return provides;
    }

    @Override
    public Javadoc visitReturn(Javadoc.Return aReturn, PrintOutputCapture<P> p) {
        this.beforeSyntax(aReturn, p);
        if (aReturn.getMarkers().findFirst(LeadingBrace.class).isPresent()) {
            p.append("{");
        }
        p.append("@return");
        this.visit(aReturn.getDescription(), p);
        this.afterSyntax(aReturn, p);
        return aReturn;
    }

    @Override
    public Javadoc visitSee(Javadoc.See see, PrintOutputCapture<P> p) {
        this.beforeSyntax(see, p);
        p.append("@see");
        this.visit(see.getSpaceBeforeTree(), p);
        this.visit(see.getTreeReference(), p);
        this.visit(see.getReference(), p);
        this.afterSyntax(see, p);
        return see;
    }

    @Override
    public Javadoc visitSerial(Javadoc.Serial serial, PrintOutputCapture<P> p) {
        this.beforeSyntax(serial, p);
        p.append("@serial");
        this.visit(serial.getDescription(), p);
        this.afterSyntax(serial, p);
        return serial;
    }

    @Override
    public Javadoc visitSerialData(Javadoc.SerialData serialData, PrintOutputCapture<P> p) {
        this.beforeSyntax(serialData, p);
        p.append("@serialData");
        this.visit(serialData.getDescription(), p);
        this.afterSyntax(serialData, p);
        return serialData;
    }

    @Override
    public Javadoc visitSerialField(Javadoc.SerialField serialField, PrintOutputCapture<P> p) {
        this.beforeSyntax(serialField, p);
        p.append("@serialField");
        this.javaVisitorVisit(serialField.getName(), p);
        this.javaVisitorVisit(serialField.getType(), p);
        this.visit(serialField.getDescription(), p);
        this.afterSyntax(serialField, p);
        return serialField;
    }

    @Override
    public Javadoc visitSince(Javadoc.Since since, PrintOutputCapture<P> p) {
        this.beforeSyntax(since, p);
        p.append("@since");
        this.visit(since.getDescription(), p);
        this.afterSyntax(since, p);
        return since;
    }

    @Override
    public Javadoc visitStartElement(Javadoc.StartElement startElement, PrintOutputCapture<P> p) {
        this.beforeSyntax(startElement, p);
        p.append('<').append(startElement.getName());
        this.visit(startElement.getAttributes(), p);
        this.visit(startElement.getSpaceBeforeEndBracket(), p);
        if (startElement.isSelfClosing()) {
            p.append('/');
        }
        p.append('>');
        this.afterSyntax(startElement, p);
        return startElement;
    }

    @Override
    public Javadoc visitSummary(Javadoc.Summary summary, PrintOutputCapture<P> p) {
        this.beforeSyntax(summary, p);
        p.append("{@summary");
        this.visit(summary.getSummary(), p);
        this.visit(summary.getBeforeBrace(), p);
        this.afterSyntax(summary, p);
        return summary;
    }

    @Override
    public Javadoc visitText(Javadoc.Text text, PrintOutputCapture<P> p) {
        this.beforeSyntax(text, p);
        p.append(text.getText());
        this.afterSyntax(text, p);
        return text;
    }

    @Override
    public Javadoc visitThrows(Javadoc.Throws aThrows, PrintOutputCapture<P> p) {
        this.beforeSyntax(aThrows, p);
        p.append(aThrows.isThrowsKeyword() ? "@throws" : "@exception");
        this.visit(aThrows.getSpaceBeforeExceptionName(), p);
        this.javaVisitorVisit(aThrows.getExceptionName(), p);
        this.visit(aThrows.getDescription(), p);
        this.afterSyntax(aThrows, p);
        return aThrows;
    }

    @Override
    public Javadoc visitUnknownBlock(Javadoc.UnknownBlock unknownBlock, PrintOutputCapture<P> p) {
        this.beforeSyntax(unknownBlock, p);
        p.append("@").append(unknownBlock.getName());
        this.visit(unknownBlock.getContent(), p);
        this.afterSyntax(unknownBlock, p);
        return unknownBlock;
    }

    @Override
    public Javadoc visitUnknownInline(Javadoc.UnknownInline unknownInline, PrintOutputCapture<P> p) {
        this.beforeSyntax(unknownInline, p);
        p.append("{@").append(unknownInline.getName());
        this.visit(unknownInline.getContent(), p);
        this.visit(unknownInline.getEndBrace(), p);
        this.afterSyntax(unknownInline, p);
        return unknownInline;
    }

    @Override
    public Javadoc visitUses(Javadoc.Uses uses, PrintOutputCapture<P> p) {
        this.beforeSyntax(uses, p);
        p.append("@uses");
        this.visit(uses.getBeforeServiceType(), p);
        this.javaVisitorVisit(uses.getServiceType(), p);
        this.visit(uses.getDescription(), p);
        this.afterSyntax(uses, p);
        return uses;
    }

    @Override
    public Javadoc visitVersion(Javadoc.Version since, PrintOutputCapture<P> p) {
        this.beforeSyntax(since, p);
        p.append("@version");
        this.visit(since.getBody(), p);
        this.afterSyntax(since, p);
        return since;
    }

    public void visit(@Nullable List<? extends Javadoc> nodes, PrintOutputCapture<P> p) {
        if (nodes != null) {
            for (Javadoc javadoc : nodes) {
                this.visit(javadoc, p);
            }
        }
    }

    @Override
    public Javadoc visitReference(Javadoc.Reference reference, PrintOutputCapture<P> p) {
        this.getCursor().putMessageOnFirstEnclosing(Javadoc.DocComment.class, "JAVADOC_LINE_BREAKS", reference.getLineBreaks());
        this.getCursor().putMessageOnFirstEnclosing(Javadoc.DocComment.class, "JAVADOC_LINE_BREAK_INDEX", (Object)0);
        this.javaVisitorVisit(reference.getTree(), p);
        this.afterSyntax(reference, p);
        return reference;
    }

    private void beforeSyntax(Javadoc j, PrintOutputCapture<P> p) {
        this.beforeSyntax(j, p, JAVADOC_MARKER_WRAPPER);
    }

    private void beforeSyntax(Javadoc j, PrintOutputCapture<P> p, UnaryOperator<String> commentWrapper) {
        this.beforeSyntax(j.getMarkers(), p, commentWrapper);
    }

    private void beforeSyntax(Markers markers, PrintOutputCapture<P> p, UnaryOperator<String> commentWrapper) {
        this.visitMarkers(markers, p);
        for (Marker marker : markers.getMarkers()) {
            p.append(p.getMarkerPrinter().beforeSyntax(marker, new Cursor(this.getCursor(), (Object)marker), commentWrapper));
        }
    }

    private void afterSyntax(Javadoc j, PrintOutputCapture<P> p) {
        this.afterSyntax(j.getMarkers(), p);
    }

    private void afterSyntax(Markers markers, PrintOutputCapture<P> p) {
        for (Marker marker : markers.getMarkers()) {
            p.append(p.getMarkerPrinter().afterSyntax(marker, new Cursor(this.getCursor(), (Object)marker), JAVADOC_MARKER_WRAPPER));
        }
    }

    static class JavadocJavaPrinter<P>
    extends JavaVisitor<PrintOutputCapture<P>> {
        JavadocJavaPrinter() {
        }

        @Override
        public J visitMethodInvocation(J.MethodInvocation method, PrintOutputCapture<P> p) {
            this.beforeSyntax(method, Space.Location.IDENTIFIER_PREFIX, p);
            this.visit(method.getSelect(), p);
            if (method.getSelect() != null) {
                p.append('#');
            }
            p.append(method.getSimpleName());
            this.visitContainer("(", method.getPadding().getArguments(), JContainer.Location.METHOD_INVOCATION_ARGUMENTS, ",", ")", p);
            this.afterSyntax(method, p);
            return method;
        }

        @Override
        public J visitIdentifier(J.Identifier ident, PrintOutputCapture<P> p) {
            this.beforeSyntax(ident, Space.Location.IDENTIFIER_PREFIX, p);
            p.append(ident.getSimpleName());
            this.afterSyntax(ident, p);
            return ident;
        }

        @Override
        public J visitFieldAccess(J.FieldAccess fieldAccess, PrintOutputCapture<P> p) {
            this.beforeSyntax(fieldAccess, Space.Location.FIELD_ACCESS_PREFIX, p);
            this.visit(fieldAccess.getTarget(), p);
            this.visitLeftPadded(".", fieldAccess.getPadding().getName(), JLeftPadded.Location.FIELD_ACCESS_NAME, p);
            this.afterSyntax(fieldAccess, p);
            return fieldAccess;
        }

        @Override
        public J visitMemberReference(J.MemberReference memberRef, PrintOutputCapture<P> p) {
            this.beforeSyntax(memberRef, Space.Location.MEMBER_REFERENCE_PREFIX, p);
            this.visit(memberRef.getContaining(), p);
            this.visitLeftPadded("#", memberRef.getPadding().getReference(), JLeftPadded.Location.MEMBER_REFERENCE_NAME, p);
            this.afterSyntax(memberRef, p);
            return memberRef;
        }

        @Override
        public J visitArrayType(J.ArrayType arrayType, PrintOutputCapture<P> p) {
            this.beforeSyntax(arrayType, Space.Location.ARRAY_TYPE_PREFIX, p);
            this.visit(arrayType.getElementType(), p);
            this.visit(arrayType.getAnnotations(), p);
            if (arrayType.getDimension() != null) {
                this.visitSpace(arrayType.getDimension().getBefore(), Space.Location.DIMENSION_PREFIX, p);
                p.append('[');
                this.visitSpace(arrayType.getDimension().getElement(), Space.Location.DIMENSION, p);
                p.append(']');
            }
            this.afterSyntax(arrayType, p);
            return arrayType;
        }

        @Override
        public J visitParameterizedType(J.ParameterizedType type, PrintOutputCapture<P> p) {
            this.beforeSyntax(type, Space.Location.IDENTIFIER_PREFIX, p);
            this.visit(type.getClazz(), p);
            this.visitContainer("<", type.getPadding().getTypeParameters(), JContainer.Location.TYPE_PARAMETERS, ",", ">", p);
            this.afterSyntax(type, p);
            return type;
        }

        @Override
        public J visitTypeParameter(J.TypeParameter typeParam, PrintOutputCapture<P> p) {
            this.beforeSyntax(typeParam, Space.Location.TYPE_PARAMETERS_PREFIX, p);
            p.append("<");
            this.visit(typeParam.getName(), p);
            p.append(">");
            this.afterSyntax(typeParam, p);
            return typeParam;
        }

        @Override
        public Space visitSpace(Space space, Space.Location loc, PrintOutputCapture<P> p) {
            List lineBreaks = (List)this.getCursor().getNearestMessage("JAVADOC_LINE_BREAKS");
            Integer index = (Integer)this.getCursor().getNearestMessage("JAVADOC_LINE_BREAK_INDEX");
            String whitespace = space.getWhitespace();
            if (lineBreaks != null && !lineBreaks.isEmpty() && index != null && whitespace.contains("\n")) {
                for (int i = 0; i < whitespace.length(); ++i) {
                    char c = whitespace.charAt(i);
                    if (c == '\n') {
                        this.visitLineBreak((Javadoc.LineBreak)lineBreaks.get(index), p);
                        Integer n = index;
                        index = index + 1;
                        continue;
                    }
                    p.append(c);
                }
                this.getCursor().putMessageOnFirstEnclosing(Javadoc.DocComment.class, "JAVADOC_LINE_BREAK_INDEX", (Object)index);
            } else {
                p.append(whitespace);
            }
            return space;
        }

        private void visitLineBreak(Javadoc.LineBreak lineBreak, PrintOutputCapture<P> p) {
            this.beforeSyntax(Space.EMPTY, lineBreak.getMarkers(), null, p);
            p.append(lineBreak.getMargin());
            this.afterSyntax(lineBreak.getMarkers(), p);
        }

        private void visitLeftPadded(@Nullable String prefix, @Nullable JLeftPadded<? extends J> leftPadded, JLeftPadded.Location location, PrintOutputCapture<P> p) {
            if (leftPadded != null) {
                this.visitSpace(leftPadded.getBefore(), location.getBeforeLocation(), p);
                if (prefix != null) {
                    p.append(prefix);
                }
                this.visit(leftPadded.getElement(), p);
            }
        }

        private void visitContainer(String before, @Nullable JContainer<? extends J> container, JContainer.Location location, String suffixBetween, @Nullable String after, PrintOutputCapture<P> p) {
            if (container == null) {
                return;
            }
            this.visitSpace(container.getBefore(), location.getBeforeLocation(), p);
            p.append(before);
            this.visitRightPadded(container.getPadding().getElements(), location.getElementLocation(), suffixBetween, p);
            p.append(after == null ? "" : after);
        }

        private void visitRightPadded(List<? extends JRightPadded<? extends J>> nodes, JRightPadded.Location location, String suffixBetween, PrintOutputCapture<P> p) {
            for (int i = 0; i < nodes.size(); ++i) {
                JRightPadded<? extends J> node = nodes.get(i);
                this.visit(node.getElement(), p);
                this.visitSpace(node.getAfter(), location.getAfterLocation(), p);
                if (i >= nodes.size() - 1) continue;
                p.append(suffixBetween);
            }
        }

        private void beforeSyntax(J j, Space.Location loc, PrintOutputCapture<P> p) {
            this.beforeSyntax(j.getPrefix(), j.getMarkers(), loc, p);
        }

        private void beforeSyntax(Space prefix, Markers markers, @Nullable Space.Location loc, PrintOutputCapture<P> p) {
            for (Marker marker : markers.getMarkers()) {
                p.append(p.getMarkerPrinter().beforePrefix(marker, new Cursor(this.getCursor(), (Object)marker), JAVADOC_MARKER_WRAPPER));
            }
            if (loc != null) {
                this.visitSpace(prefix, loc, p);
            }
            this.visitMarkers(markers, p);
            for (Marker marker : markers.getMarkers()) {
                p.append(p.getMarkerPrinter().beforeSyntax(marker, new Cursor(this.getCursor(), (Object)marker), JAVADOC_MARKER_WRAPPER));
            }
        }

        private void afterSyntax(J j, PrintOutputCapture<P> p) {
            this.afterSyntax(j.getMarkers(), p);
        }

        private void afterSyntax(Markers markers, PrintOutputCapture<P> p) {
            for (Marker marker : markers.getMarkers()) {
                p.append(p.getMarkerPrinter().afterSyntax(marker, new Cursor(this.getCursor(), (Object)marker), JAVADOC_MARKER_WRAPPER));
            }
        }
    }
}

