/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.regex.Pattern;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.TypeVisitor;
import org.openrewrite.java.internal.grammar.MethodSignatureLexer;
import org.openrewrite.java.internal.grammar.MethodSignatureParser;
import org.openrewrite.java.internal.grammar.MethodSignatureParserBaseVisitor;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.java.tree.TypeUtils;

public class TypeMatcher {
    private Pattern targetTypePattern;
    private final String signature;
    private final boolean matchInherited;

    public TypeMatcher(String signature, boolean matchInherited) {
        this.signature = signature;
        this.matchInherited = matchInherited;
        MethodSignatureParser parser = new MethodSignatureParser((TokenStream)new CommonTokenStream((TokenSource)new MethodSignatureLexer((CharStream)CharStreams.fromString((String)(signature + " *(..)")))));
        new MethodSignatureParserBaseVisitor<Void>(){

            @Override
            public Void visitMethodPattern(MethodSignatureParser.MethodPatternContext ctx) {
                TypeMatcher.this.targetTypePattern = Pattern.compile((String)new TypeVisitor().visitTargetTypePattern(ctx.targetTypePattern()));
                return null;
            }
        }.visit((ParseTree)parser.methodPattern());
    }

    public TypeMatcher(String signature) {
        this(signature, false);
    }

    public boolean matches(@Nullable JavaType type) {
        return this.matchesTargetType(TypeUtils.asFullyQualified(type));
    }

    public boolean matches(@Nullable TypeTree tt) {
        return tt != null && this.matches(tt.getType());
    }

    public boolean matchesPackage(String packageName) {
        return this.targetTypePattern.matcher(packageName).matches() || this.targetTypePattern.matcher(packageName.replaceAll("\\.\\*$", "." + this.signature.substring(this.signature.lastIndexOf(46) + 1))).matches();
    }

    boolean matchesTargetType(@Nullable JavaType.FullyQualified type) {
        if (type == null) {
            return false;
        }
        if (this.targetTypePattern.matcher(type.getFullyQualifiedName()).matches()) {
            return true;
        }
        if (!"java.lang.Object".equals(type.getFullyQualifiedName()) && this.matchesTargetType(type.getSupertype() == null ? JavaType.ShallowClass.build("java.lang.Object") : type.getSupertype())) {
            return true;
        }
        if (this.matchInherited) {
            if (this.matchesTargetType(type.getSupertype())) {
                return true;
            }
            for (JavaType.FullyQualified anInterface : type.getInterfaces()) {
                if (!this.matchesTargetType(anInterface)) continue;
                return true;
            }
        }
        return false;
    }

    public Pattern getTargetTypePattern() {
        return this.targetTypePattern;
    }

    public String getSignature() {
        return this.signature;
    }

    public boolean isMatchInherited() {
        return this.matchInherited;
    }
}

