/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import org.openrewrite.Cursor;
import org.openrewrite.Incubating;
import org.openrewrite.Tree;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplateSemanticallyEqual;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.internal.template.JavaTemplateJavaExtension;
import org.openrewrite.java.internal.template.JavaTemplateParser;
import org.openrewrite.java.internal.template.Substitutions;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaCoordinates;
import org.openrewrite.template.SourceTemplate;

public class JavaTemplate
implements SourceTemplate<J, JavaCoordinates> {
    private final String code;
    private final int parameterCount;
    private final Consumer<String> onAfterVariableSubstitution;
    private final JavaTemplateParser templateParser;

    private JavaTemplate(boolean contextSensitive, JavaParser.Builder<?, ?> javaParser, String code, Set<String> imports, Consumer<String> onAfterVariableSubstitution, Consumer<String> onBeforeParseTemplate) {
        this.code = code;
        this.onAfterVariableSubstitution = onAfterVariableSubstitution;
        this.parameterCount = StringUtils.countOccurrences((String)code, (String)"#{");
        this.templateParser = new JavaTemplateParser(contextSensitive, javaParser, onAfterVariableSubstitution, onBeforeParseTemplate, imports);
    }

    public String getCode() {
        return this.code;
    }

    public <J2 extends J> J2 apply(Cursor scope, JavaCoordinates coordinates, Object ... parameters) {
        if (!(scope.getValue() instanceof J)) {
            throw new IllegalArgumentException("`scope` must point to a J instance.");
        }
        if (parameters.length != this.parameterCount) {
            throw new IllegalArgumentException("This template requires " + this.parameterCount + " parameters.");
        }
        Substitutions substitutions = new Substitutions(this.code, parameters);
        String substitutedTemplate = substitutions.substitute();
        this.onAfterVariableSubstitution.accept(substitutedTemplate);
        return (J2)((J)new JavaTemplateJavaExtension(this.templateParser, substitutions, substitutedTemplate, coordinates).getMixin().visit((Tree)scope.getValue(), (Object)0, scope.getParentOrThrow()));
    }

    @Incubating(since="8.0.0")
    public static boolean matches(String template, Cursor cursor) {
        return JavaTemplate.builder(template).build().matches(cursor);
    }

    @Incubating(since="7.38.0")
    public boolean matches(Cursor cursor) {
        return this.matcher(cursor).find();
    }

    @Incubating(since="7.38.0")
    public Matcher matcher(Cursor cursor) {
        return new Matcher(cursor);
    }

    public static <J2 extends J> J2 apply(String template, Cursor scope, JavaCoordinates coordinates, Object ... parameters) {
        return JavaTemplate.builder(template).build().apply(scope, coordinates, parameters);
    }

    public static Builder builder(String code) {
        return new Builder(code);
    }

    public static Builder compile(JavaVisitor<?> owner, String name, P0 p) {
        return new PatternBuilder(name).build(owner);
    }

    public static Builder compile(JavaVisitor<?> owner, String name, P1<?> p) {
        return new PatternBuilder(name).build(owner);
    }

    public static Builder compile(JavaVisitor<?> owner, String name, P2<?, ?> p) {
        return new PatternBuilder(name).build(owner);
    }

    public static Builder compile(JavaVisitor<?> owner, String name, P3<?, ?, ?> p) {
        return new PatternBuilder(name).build(owner);
    }

    public static Builder compile(JavaVisitor<?> owner, String name, P4<?, ?, ?, ?> p) {
        return new PatternBuilder(name).build(owner);
    }

    public static Builder compile(JavaVisitor<?> owner, String name, P5<?, ?, ?, ?, ?> p) {
        return new PatternBuilder(name).build(owner);
    }

    public static Builder compile(JavaVisitor<?> owner, String name, P6<?, ?, ?, ?, ?, ?> p) {
        return new PatternBuilder(name).build(owner);
    }

    public static Builder compile(JavaVisitor<?> owner, String name, P7<?, ?, ?, ?, ?, ?, ?> p) {
        return new PatternBuilder(name).build(owner);
    }

    public static Builder compile(JavaVisitor<?> owner, String name, P8<?, ?, ?, ?, ?, ?, ?, ?> p) {
        return new PatternBuilder(name).build(owner);
    }

    public static Builder compile(JavaVisitor<?> owner, String name, P9<?, ?, ?, ?, ?, ?, ?, ?, ?> p) {
        return new PatternBuilder(name).build(owner);
    }

    public static Builder compile(JavaVisitor<?> owner, String name, P10<?, ?, ?, ?, ?, ?, ?, ?, ?, ?> p) {
        return new PatternBuilder(name).build(owner);
    }

    public static Builder compile(JavaVisitor<?> owner, String name, F0<?> f) {
        return new PatternBuilder(name).build(owner);
    }

    public static Builder compile(JavaVisitor<?> owner, String name, F1<?, ?> f) {
        return new PatternBuilder(name).build(owner);
    }

    public static Builder compile(JavaVisitor<?> owner, String name, F2<?, ?, ?> f) {
        return new PatternBuilder(name).build(owner);
    }

    public static Builder compile(JavaVisitor<?> owner, String name, F3<?, ?, ?, ?> f) {
        return new PatternBuilder(name).build(owner);
    }

    public static Builder compile(JavaVisitor<?> owner, String name, F4<?, ?, ?, ?, ?> f) {
        return new PatternBuilder(name).build(owner);
    }

    public static Builder compile(JavaVisitor<?> owner, String name, F5<?, ?, ?, ?, ?, ?> f) {
        return new PatternBuilder(name).build(owner);
    }

    public static Builder compile(JavaVisitor<?> owner, String name, F6<?, ?, ?, ?, ?, ?, ?> f) {
        return new PatternBuilder(name).build(owner);
    }

    public static Builder compile(JavaVisitor<?> owner, String name, F7<?, ?, ?, ?, ?, ?, ?, ?> f) {
        return new PatternBuilder(name).build(owner);
    }

    public static Builder compile(JavaVisitor<?> owner, String name, F8<?, ?, ?, ?, ?, ?, ?, ?, ?> f) {
        return new PatternBuilder(name).build(owner);
    }

    public static Builder compile(JavaVisitor<?> owner, String name, F9<?, ?, ?, ?, ?, ?, ?, ?, ?, ?> f) {
        return new PatternBuilder(name).build(owner);
    }

    public static Builder compile(JavaVisitor<?> owner, String name, F10<?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?> f) {
        return new PatternBuilder(name).build(owner);
    }

    public static class Builder {
        private final String code;
        private final Set<String> imports = new HashSet<String>();
        private boolean contextSensitive;
        private JavaParser.Builder<?, ?> javaParser = JavaParser.fromJavaVersion();
        private Consumer<String> onAfterVariableSubstitution = s -> {};
        private Consumer<String> onBeforeParseTemplate = s -> {};

        Builder(String code) {
            this.code = code.trim();
        }

        public Builder contextSensitive() {
            this.contextSensitive = true;
            return this;
        }

        public Builder imports(String ... fullyQualifiedTypeNames) {
            for (String typeName : fullyQualifiedTypeNames) {
                this.validateImport(typeName);
                this.imports.add("import " + typeName + ";\n");
            }
            return this;
        }

        public Builder staticImports(String ... fullyQualifiedMemberTypeNames) {
            for (String typeName : fullyQualifiedMemberTypeNames) {
                this.validateImport(typeName);
                this.imports.add("import static " + typeName + ";\n");
            }
            return this;
        }

        private void validateImport(String typeName) {
            if (StringUtils.isBlank((String)typeName)) {
                throw new IllegalArgumentException("Imports must not be blank");
            }
            if (typeName.startsWith("import ") || typeName.startsWith("static ")) {
                throw new IllegalArgumentException("Imports are expressed as fully-qualified names and should not include an \"import \" or \"static \" prefix");
            }
            if (typeName.endsWith(";") || typeName.endsWith("\n")) {
                throw new IllegalArgumentException("Imports are expressed as fully-qualified names and should not include a suffixed terminator");
            }
        }

        public Builder javaParser(JavaParser.Builder<?, ?> javaParser) {
            this.javaParser = javaParser;
            return this;
        }

        public Builder doAfterVariableSubstitution(Consumer<String> afterVariableSubstitution) {
            this.onAfterVariableSubstitution = afterVariableSubstitution;
            return this;
        }

        public Builder doBeforeParseTemplate(Consumer<String> beforeParseTemplate) {
            this.onBeforeParseTemplate = beforeParseTemplate;
            return this;
        }

        public JavaTemplate build() {
            return new JavaTemplate(this.contextSensitive, this.javaParser, this.code, this.imports, this.onAfterVariableSubstitution, this.onBeforeParseTemplate);
        }
    }

    @Incubating(since="7.38.0")
    public final class Matcher {
        private final Cursor cursor;
        private JavaTemplateSemanticallyEqual.TemplateMatchResult matchResult;

        Matcher(Cursor cursor) {
            this.cursor = cursor;
        }

        public boolean find() {
            this.matchResult = JavaTemplateSemanticallyEqual.matchesTemplate(JavaTemplate.this, this.cursor);
            return this.matchResult.isMatch();
        }

        public J parameter(int i) {
            return this.matchResult.getMatchedParameters().get(i);
        }

        public Cursor getCursor() {
            return this.cursor;
        }

        public JavaTemplateSemanticallyEqual.TemplateMatchResult getMatchResult() {
            return this.matchResult;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Matcher)) {
                return false;
            }
            Matcher other = (Matcher)o;
            Cursor this$cursor = this.getCursor();
            Cursor other$cursor = other.getCursor();
            if (this$cursor == null ? other$cursor != null : !this$cursor.equals(other$cursor)) {
                return false;
            }
            JavaTemplateSemanticallyEqual.TemplateMatchResult this$matchResult = this.getMatchResult();
            JavaTemplateSemanticallyEqual.TemplateMatchResult other$matchResult = other.getMatchResult();
            return !(this$matchResult == null ? other$matchResult != null : !((Object)this$matchResult).equals(other$matchResult));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Cursor $cursor = this.getCursor();
            result = result * 59 + ($cursor == null ? 43 : $cursor.hashCode());
            JavaTemplateSemanticallyEqual.TemplateMatchResult $matchResult = this.getMatchResult();
            result = result * 59 + ($matchResult == null ? 43 : ((Object)$matchResult).hashCode());
            return result;
        }

        @NonNull
        public String toString() {
            return "JavaTemplate.Matcher(cursor=" + this.getCursor() + ", matchResult=" + this.getMatchResult() + ")";
        }
    }

    static final class PatternBuilder {
        private final String name;

        public Builder build(JavaVisitor<?> owner) {
            try {
                Class<?> templateClass = Class.forName(((Object)owner).getClass().getName() + "_" + this.name, true, ((Object)owner).getClass().getClassLoader());
                Method getTemplate = templateClass.getDeclaredMethod("getTemplate", JavaVisitor.class);
                return (Builder)getTemplate.invoke(null, new Object[]{owner});
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }

        public PatternBuilder(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PatternBuilder)) {
                return false;
            }
            PatternBuilder other = (PatternBuilder)o;
            String this$name = this.getName();
            String other$name = other.getName();
            return !(this$name == null ? other$name != null : !this$name.equals(other$name));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            return result;
        }

        @NonNull
        public String toString() {
            return "JavaTemplate.PatternBuilder(name=" + this.getName() + ")";
        }
    }

    public static interface F10<R, P1, P2, P3, P4, P5, P6, P7, P8, P9, P10> {
        public R accept(P1 var1, P2 var2, P3 var3, P4 var4, P5 var5, P6 var6, P7 var7, P8 var8, P9 var9, P10 var10) throws Exception;
    }

    public static interface F9<R, P1, P2, P3, P4, P5, P6, P7, P8, P9> {
        public R accept(P1 var1, P2 var2, P3 var3, P4 var4, P5 var5, P6 var6, P7 var7, P8 var8, P9 var9) throws Exception;
    }

    public static interface F8<R, P1, P2, P3, P4, P5, P6, P7, P8> {
        public R accept(P1 var1, P2 var2, P3 var3, P4 var4, P5 var5, P6 var6, P7 var7, P8 var8) throws Exception;
    }

    public static interface F7<R, P1, P2, P3, P4, P5, P6, P7> {
        public R accept(P1 var1, P2 var2, P3 var3, P4 var4, P5 var5, P6 var6, P7 var7) throws Exception;
    }

    public static interface F6<R, P1, P2, P3, P4, P5, P6> {
        public R accept(P1 var1, P2 var2, P3 var3, P4 var4, P5 var5, P6 var6) throws Exception;
    }

    public static interface F5<R, P1, P2, P3, P4, P5> {
        public R accept(P1 var1, P2 var2, P3 var3, P4 var4, P5 var5) throws Exception;
    }

    public static interface F4<R, P1, P2, P3, P4> {
        public R accept(P1 var1, P2 var2, P3 var3, P4 var4) throws Exception;
    }

    public static interface F3<R, P1, P2, P3> {
        public R accept(P1 var1, P2 var2, P3 var3) throws Exception;
    }

    public static interface F2<R, P1, P2> {
        public R accept(P1 var1, P2 var2) throws Exception;
    }

    public static interface F1<R, P1> {
        public R accept(P1 var1) throws Exception;
    }

    public static interface F0<R> {
        public R accept() throws Exception;
    }

    public static interface P10<P1, P2, P3, P4, P5, P6, P7, P8, P9, P10> {
        public void accept(P1 var1, P2 var2, P3 var3, P4 var4, P5 var5, P6 var6, P7 var7, P8 var8, P9 var9, P10 var10) throws Exception;
    }

    public static interface P9<P1, P2, P3, P4, P5, P6, P7, P8, P9> {
        public void accept(P1 var1, P2 var2, P3 var3, P4 var4, P5 var5, P6 var6, P7 var7, P8 var8, P9 var9) throws Exception;
    }

    public static interface P8<P1, P2, P3, P4, P5, P6, P7, P8> {
        public void accept(P1 var1, P2 var2, P3 var3, P4 var4, P5 var5, P6 var6, P7 var7, P8 var8) throws Exception;
    }

    public static interface P7<P1, P2, P3, P4, P5, P6, P7> {
        public void accept(P1 var1, P2 var2, P3 var3, P4 var4, P5 var5, P6 var6, P7 var7) throws Exception;
    }

    public static interface P6<P1, P2, P3, P4, P5, P6> {
        public void accept(P1 var1, P2 var2, P3 var3, P4 var4, P5 var5, P6 var6) throws Exception;
    }

    public static interface P5<P1, P2, P3, P4, P5> {
        public void accept(P1 var1, P2 var2, P3 var3, P4 var4, P5 var5) throws Exception;
    }

    public static interface P4<P1, P2, P3, P4> {
        public void accept(P1 var1, P2 var2, P3 var3, P4 var4) throws Exception;
    }

    public static interface P3<P1, P2, P3> {
        public void accept(P1 var1, P2 var2, P3 var3) throws Exception;
    }

    public static interface P2<P1, P2> {
        public void accept(P1 var1, P2 var2) throws Exception;
    }

    public static interface P1<P1> {
        public void accept(P1 var1) throws Exception;
    }

    public static interface P0 {
        public void accept() throws Exception;
    }
}

