/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.List;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.tree.JavaType;

public class JavaTypeVisitor<P> {
    private Cursor cursor = new Cursor(null, (Object)"root");

    public Cursor getCursor() {
        return this.cursor;
    }

    public void setCursor(Cursor cursor) {
        this.cursor = cursor;
    }

    public <JT extends JavaType> @Nullable List<JT> visit(@Nullable List<JT> javaTypes, P p) {
        return ListUtils.map(javaTypes, jt -> this.visit((JavaType)jt, p));
    }

    public @Nullable JavaType preVisit(JavaType javaType, P p) {
        return javaType;
    }

    public @Nullable JavaType postVisit(JavaType javaType, P p) {
        return javaType;
    }

    public JavaType visitNonNull(JavaType javaType, P p) {
        JavaType t = this.visit(javaType, p);
        assert (t != null);
        return t;
    }

    public JavaType visit(@Nullable JavaType javaType, P p) {
        if (javaType != null) {
            this.cursor = new Cursor(this.cursor, (Object)javaType);
            if ((javaType = this.preVisit(javaType, p)) instanceof JavaType.Array) {
                javaType = this.visitArray((JavaType.Array)javaType, p);
            } else if (javaType instanceof JavaType.Class) {
                javaType = this.visitClass((JavaType.Class)javaType, p);
            } else if (javaType instanceof JavaType.GenericTypeVariable) {
                javaType = this.visitGenericTypeVariable((JavaType.GenericTypeVariable)javaType, p);
            } else if (javaType instanceof JavaType.Intersection) {
                javaType = this.visitIntersection((JavaType.Intersection)javaType, p);
            } else if (javaType instanceof JavaType.MultiCatch) {
                javaType = this.visitMultiCatch((JavaType.MultiCatch)javaType, p);
            } else if (javaType instanceof JavaType.Parameterized) {
                javaType = this.visitParameterized((JavaType.Parameterized)javaType, p);
            } else if (javaType instanceof JavaType.Primitive) {
                javaType = this.visitPrimitive((JavaType.Primitive)javaType, p);
            } else if (javaType instanceof JavaType.Method) {
                javaType = this.visitMethod((JavaType.Method)javaType, p);
            } else if (javaType instanceof JavaType.Variable) {
                javaType = this.visitVariable((JavaType.Variable)javaType, p);
            }
            if (javaType != null) {
                javaType = this.postVisit(javaType, p);
            }
            this.cursor = this.cursor.getParentOrThrow();
            return javaType;
        }
        return null;
    }

    public JavaType visitMultiCatch(JavaType.MultiCatch multiCatch, P p) {
        return multiCatch.withThrowableTypes(ListUtils.map(multiCatch.getThrowableTypes(), tt -> this.visit((JavaType)tt, p)));
    }

    public JavaType visitArray(JavaType.Array array, P p) {
        JavaType.Array a = array;
        a = a.withElemType(this.visit(a.getElemType(), p));
        a = a.withAnnotations(this.visit(a.getAnnotations(), p));
        return a;
    }

    public JavaType visitClass(JavaType.Class aClass, P p) {
        JavaType.Class c = aClass;
        c = c.withSupertype((JavaType.FullyQualified)this.visit(c.getSupertype(), p));
        c = c.withOwningClass((JavaType.FullyQualified)this.visit(c.getOwningClass(), p));
        c = c.withAnnotations(ListUtils.map(c.getAnnotations(), a -> (JavaType.FullyQualified)this.visit((JavaType)a, p)));
        c = c.withInterfaces(ListUtils.map(c.getInterfaces(), i -> (JavaType.FullyQualified)this.visit((JavaType)i, p)));
        c = c.withMembers(ListUtils.map(c.getMembers(), m -> (JavaType.Variable)this.visit((JavaType)m, p)));
        c = c.withMethods(ListUtils.map(c.getMethods(), m -> (JavaType.Method)this.visit((JavaType)m, p)));
        c = c.withTypeParameters(ListUtils.map(c.getTypeParameters(), t -> this.visit((JavaType)t, p)));
        return c;
    }

    public JavaType visitGenericTypeVariable(JavaType.GenericTypeVariable generic, P p) {
        JavaType.GenericTypeVariable g = generic;
        g = g.withBounds(ListUtils.map(g.getBounds(), bound -> this.visit((JavaType)bound, p)));
        return g;
    }

    public JavaType visitIntersection(JavaType.Intersection intersection, P p) {
        JavaType.Intersection i = intersection;
        i = i.withBounds(ListUtils.map(i.getBounds(), bound -> this.visit((JavaType)bound, p)));
        return i;
    }

    public JavaType visitMethod(JavaType.Method method, P p) {
        JavaType.Method m = method;
        m = m.withDeclaringType((JavaType.FullyQualified)this.visit(m.getDeclaringType(), p));
        m = m.withReturnType(this.visit(m.getReturnType(), p));
        m = m.withParameterTypes(ListUtils.map(m.getParameterTypes(), pt -> this.visit((JavaType)pt, p)));
        m = m.withThrownExceptions(ListUtils.map(m.getThrownExceptions(), t -> (JavaType.FullyQualified)this.visit((JavaType)t, p)));
        m = m.withAnnotations(ListUtils.map(m.getAnnotations(), a -> (JavaType.FullyQualified)this.visit((JavaType)a, p)));
        return m;
    }

    public JavaType visitParameterized(JavaType.Parameterized parameterized, P p) {
        JavaType.Parameterized pa = parameterized;
        pa = pa.withType((JavaType.FullyQualified)this.visit(pa.getType(), p));
        pa = pa.withTypeParameters(ListUtils.map(pa.getTypeParameters(), t -> this.visit((JavaType)t, p)));
        return pa;
    }

    public JavaType visitPrimitive(JavaType.Primitive primitive, P p) {
        return primitive;
    }

    public JavaType visitVariable(JavaType.Variable variable, P p) {
        JavaType.Variable v = variable;
        v = v.withOwner(this.visit(v.getOwner(), p));
        v = v.withType(this.visit(variable.getType(), p));
        v = v.withAnnotations(ListUtils.map(v.getAnnotations(), a -> (JavaType.FullyQualified)this.visit((JavaType)a, p)));
        return v;
    }
}

