/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.text.ParseException;
import java.text.RuleBasedCollator;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Tree;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.ImplementInterface;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.FindAnnotations;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.marker.Markers;

public class ExtractInterface {

    public static final class ImplementAndAddOverrideAnnotations
    extends JavaIsoVisitor<ExecutionContext> {
        private final String fullyQualifiedInterfaceName;

        @Override
        public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext ctx) {
            if (classDecl.getType() != null && classDecl.getType().getFullyQualifiedName().equals(this.fullyQualifiedInterfaceName)) {
                return classDecl;
            }
            this.maybeAddImport(this.fullyQualifiedInterfaceName);
            JavaType.ShallowClass type = JavaType.ShallowClass.build(this.fullyQualifiedInterfaceName);
            final J.Block body = classDecl.getBody();
            Cursor parent = this.getCursor().getParent();
            assert (parent != null);
            J.ClassDeclaration implementing = (J.ClassDeclaration)new ImplementInterface(classDecl, type).visitNonNull(classDecl, ctx, parent);
            return (J.ClassDeclaration)new JavaIsoVisitor<ExecutionContext>(){

                @Override
                public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, ExecutionContext ctx) {
                    if (this.getCursor().getParentTreeCursor().getValue() == body) {
                        try {
                            if (!method.hasModifier(J.Modifier.Type.Public) || method.hasModifier(J.Modifier.Type.Static) || method.isConstructor()) {
                                return method;
                            }
                            if (FindAnnotations.find(method, "@java.lang.Override").isEmpty()) {
                                return (J.MethodDeclaration)JavaTemplate.apply("@Override", this.getCursor(), method.getCoordinates().addAnnotation(Comparator.comparing(J.Annotation::getSimpleName, new RuleBasedCollator("< Override"))), new Object[0]);
                            }
                            return method;
                        }
                        catch (ParseException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    return super.visitMethodDeclaration(method, ctx);
                }
            }.visitNonNull(implementing, ctx, this.getCursor().getParentOrThrow());
        }

        @Generated
        public ImplementAndAddOverrideAnnotations(String fullyQualifiedInterfaceName) {
            this.fullyQualifiedInterfaceName = fullyQualifiedInterfaceName;
        }

        @Generated
        public String getFullyQualifiedInterfaceName() {
            return this.fullyQualifiedInterfaceName;
        }

        @NonNull
        @Generated
        public String toString() {
            return "ExtractInterface.ImplementAndAddOverrideAnnotations(fullyQualifiedInterfaceName=" + this.getFullyQualifiedInterfaceName() + ")";
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ImplementAndAddOverrideAnnotations)) {
                return false;
            }
            ImplementAndAddOverrideAnnotations other = (ImplementAndAddOverrideAnnotations)((Object)o);
            if (!other.canEqual((Object)this)) {
                return false;
            }
            String this$fullyQualifiedInterfaceName = this.getFullyQualifiedInterfaceName();
            String other$fullyQualifiedInterfaceName = other.getFullyQualifiedInterfaceName();
            return !(this$fullyQualifiedInterfaceName == null ? other$fullyQualifiedInterfaceName != null : !this$fullyQualifiedInterfaceName.equals(other$fullyQualifiedInterfaceName));
        }

        @Generated
        protected boolean canEqual(@Nullable Object other) {
            return other instanceof ImplementAndAddOverrideAnnotations;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $fullyQualifiedInterfaceName = this.getFullyQualifiedInterfaceName();
            result = result * 59 + ($fullyQualifiedInterfaceName == null ? 43 : $fullyQualifiedInterfaceName.hashCode());
            return result;
        }
    }

    public static final class CreateInterface
    extends JavaIsoVisitor<ExecutionContext> {
        private final String fullyQualifiedInterfaceName;

        public J postVisit(J tree, ExecutionContext ctx) {
            if (tree instanceof JavaSourceFile) {
                JavaSourceFile c = (JavaSourceFile)Objects.requireNonNull(tree);
                String pkg = c.getPackageDeclaration() == null ? "" : Arrays.stream(c.getPackageDeclaration().getExpression().printTrimmed(this.getCursor()).split("\\.")).map(subpackage -> "..").collect(Collectors.joining("/", "../", "/"));
                String interfacePkg = JavaType.ShallowClass.build(this.fullyQualifiedInterfaceName).getPackageName();
                if (!interfacePkg.isEmpty()) {
                    c = c.withPackageDeclaration(new J.Package(Tree.randomId(), c.getPackageDeclaration() == null ? Space.EMPTY : c.getPackageDeclaration().getPrefix(), Markers.EMPTY, (Expression)TypeTree.build(interfacePkg).withPrefix(Space.format(" ")), c.getPackageDeclaration() == null ? Collections.emptyList() : c.getPackageDeclaration().getAnnotations()));
                }
                c = c.withSourcePath(c.getSourcePath().resolve(pkg + this.fullyQualifiedInterfaceName.replace('.', '/') + ".java").normalize());
                return c;
            }
            return (J)super.postVisit((Tree)tree, (Object)ctx);
        }

        @Override
        public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext ctx) {
            J.ClassDeclaration c = classDecl;
            c = c.withKind(J.ClassDeclaration.Kind.Type.Interface);
            c = c.withBody(c.getBody().withStatements(ListUtils.map(c.getBody().getStatements(), s -> s instanceof J.MethodDeclaration ? s : null)));
            c = c.withName(c.getName().withSimpleName(this.fullyQualifiedInterfaceName.substring(this.fullyQualifiedInterfaceName.lastIndexOf(46) + 1)));
            c = c.withType(JavaType.ShallowClass.build(this.fullyQualifiedInterfaceName).withKind(JavaType.FullyQualified.Kind.Interface));
            return (J.ClassDeclaration)this.autoFormat(super.visitClassDeclaration(c, ctx), ctx);
        }

        @Override
        public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, ExecutionContext ctx) {
            if (method.hasModifier(J.Modifier.Type.Static) || !method.hasModifier(J.Modifier.Type.Public) || method.isConstructor()) {
                return null;
            }
            return method.withModifiers(ListUtils.map(method.getModifiers(), m -> m.getType() == J.Modifier.Type.Public || m.getType() == J.Modifier.Type.Final || m.getType() == J.Modifier.Type.Native ? null : m)).withBody(null);
        }

        @Generated
        public CreateInterface(String fullyQualifiedInterfaceName) {
            this.fullyQualifiedInterfaceName = fullyQualifiedInterfaceName;
        }

        @Generated
        public String getFullyQualifiedInterfaceName() {
            return this.fullyQualifiedInterfaceName;
        }

        @NonNull
        @Generated
        public String toString() {
            return "ExtractInterface.CreateInterface(fullyQualifiedInterfaceName=" + this.getFullyQualifiedInterfaceName() + ")";
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CreateInterface)) {
                return false;
            }
            CreateInterface other = (CreateInterface)((Object)o);
            if (!other.canEqual((Object)this)) {
                return false;
            }
            String this$fullyQualifiedInterfaceName = this.getFullyQualifiedInterfaceName();
            String other$fullyQualifiedInterfaceName = other.getFullyQualifiedInterfaceName();
            return !(this$fullyQualifiedInterfaceName == null ? other$fullyQualifiedInterfaceName != null : !this$fullyQualifiedInterfaceName.equals(other$fullyQualifiedInterfaceName));
        }

        @Generated
        protected boolean canEqual(@Nullable Object other) {
            return other instanceof CreateInterface;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $fullyQualifiedInterfaceName = this.getFullyQualifiedInterfaceName();
            result = result * 59 + ($fullyQualifiedInterfaceName == null ? 43 : $fullyQualifiedInterfaceName.hashCode());
            return result;
        }
    }
}

