/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.search;

import java.util.Iterator;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.AnnotationMatcher;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.service.AnnotationService;
import org.openrewrite.java.table.MethodCalls;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.marker.SearchResult;

public final class FindDeprecatedMethods
extends Recipe {
    private static final AnnotationMatcher DEPRECATED_MATCHER = new AnnotationMatcher("@java.lang.Deprecated");
    private final transient MethodCalls deprecatedMethodCalls = new MethodCalls(this);
    @Option(displayName="Method pattern", description="A method pattern that is used to find matching method invocations.", example="java.util.List add(..)", required=false)
    private final @Nullable String methodPattern;
    @Option(displayName="Ignore deprecated scopes", description="When set to `true` deprecated methods used within deprecated methods or classes will be ignored.", required=false)
    private final @Nullable Boolean ignoreDeprecatedScopes;

    public String getDisplayName() {
        return "Find uses of deprecated methods";
    }

    public String getInstanceNameSuffix() {
        if (this.methodPattern != null) {
            return "matching `" + this.methodPattern + "`";
        }
        return super.getInstanceNameSuffix();
    }

    public String getDescription() {
        return "Find uses of deprecated methods in any API.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final MethodMatcher methodMatcher = this.methodPattern == null || this.methodPattern.isEmpty() ? null : new MethodMatcher(this.methodPattern, true);
        return Preconditions.check((TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J visit(@Nullable Tree tree, ExecutionContext ctx) {
                if (tree instanceof JavaSourceFile) {
                    JavaSourceFile cu = (JavaSourceFile)Objects.requireNonNull(tree);
                    for (JavaType.Method method : cu.getTypesInUse().getUsedMethods()) {
                        if (methodMatcher != null && !methodMatcher.matches(method)) continue;
                        for (JavaType.FullyQualified annotation : method.getAnnotations()) {
                            if (!TypeUtils.isOfClassType(annotation, "java.lang.Deprecated")) continue;
                            return (J)SearchResult.found((Tree)cu);
                        }
                    }
                }
                return (J)tree;
            }
        }, (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            @Override
            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J m = super.visitMethodInvocation(method, ctx);
                if (method.getMethodType() != null) {
                    for (JavaType.FullyQualified annotation : method.getMethodType().getAnnotations()) {
                        JavaSourceFile javaSourceFile;
                        if (methodMatcher != null && !methodMatcher.matches(method) || !TypeUtils.isOfClassType(annotation, "java.lang.Deprecated")) continue;
                        if (Boolean.TRUE.equals(FindDeprecatedMethods.this.ignoreDeprecatedScopes)) {
                            Iterator cursorPath = this.getCursor().getPathAsCursors();
                            while (cursorPath.hasNext()) {
                                Cursor ancestor = (Cursor)cursorPath.next();
                                if (ancestor.getValue() instanceof J.MethodDeclaration && this.isDeprecated(ancestor)) {
                                    return m;
                                }
                                if (!(ancestor.getValue() instanceof J.ClassDeclaration) || !this.isDeprecated(ancestor)) continue;
                                return m;
                            }
                        }
                        if ((javaSourceFile = (JavaSourceFile)this.getCursor().firstEnclosing(JavaSourceFile.class)) != null) {
                            FindDeprecatedMethods.this.deprecatedMethodCalls.insertRow(ctx, new MethodCalls.Row(javaSourceFile.getSourcePath().toString(), method.printTrimmed(this.getCursor()), method.getMethodType().getDeclaringType().getFullyQualifiedName(), method.getSimpleName(), method.getArguments().stream().map(Expression::getType).map(String::valueOf).collect(Collectors.joining(", "))));
                        }
                        m = (J.MethodInvocation)SearchResult.found((Tree)m);
                    }
                }
                return m;
            }

            private boolean isDeprecated(Cursor cursor) {
                return this.service(AnnotationService.class).matches(cursor, DEPRECATED_MATCHER);
            }
        });
    }

    @Generated
    public FindDeprecatedMethods(@Nullable String methodPattern, @Nullable Boolean ignoreDeprecatedScopes) {
        this.methodPattern = methodPattern;
        this.ignoreDeprecatedScopes = ignoreDeprecatedScopes;
    }

    @Generated
    public MethodCalls getDeprecatedMethodCalls() {
        return this.deprecatedMethodCalls;
    }

    @Generated
    public @Nullable String getMethodPattern() {
        return this.methodPattern;
    }

    @Generated
    public @Nullable Boolean getIgnoreDeprecatedScopes() {
        return this.ignoreDeprecatedScopes;
    }

    @NonNull
    @Generated
    public String toString() {
        return "FindDeprecatedMethods(deprecatedMethodCalls=" + (Object)((Object)this.getDeprecatedMethodCalls()) + ", methodPattern=" + this.getMethodPattern() + ", ignoreDeprecatedScopes=" + this.getIgnoreDeprecatedScopes() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindDeprecatedMethods)) {
            return false;
        }
        FindDeprecatedMethods other = (FindDeprecatedMethods)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$ignoreDeprecatedScopes = this.getIgnoreDeprecatedScopes();
        Boolean other$ignoreDeprecatedScopes = other.getIgnoreDeprecatedScopes();
        if (this$ignoreDeprecatedScopes == null ? other$ignoreDeprecatedScopes != null : !((Object)this$ignoreDeprecatedScopes).equals(other$ignoreDeprecatedScopes)) {
            return false;
        }
        String this$methodPattern = this.getMethodPattern();
        String other$methodPattern = other.getMethodPattern();
        return !(this$methodPattern == null ? other$methodPattern != null : !this$methodPattern.equals(other$methodPattern));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof FindDeprecatedMethods;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $ignoreDeprecatedScopes = this.getIgnoreDeprecatedScopes();
        result = result * 59 + ($ignoreDeprecatedScopes == null ? 43 : ((Object)$ignoreDeprecatedScopes).hashCode());
        String $methodPattern = this.getMethodPattern();
        result = result * 59 + ($methodPattern == null ? 43 : $methodPattern.hashCode());
        return result;
    }
}

