/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.jspecify.annotations.Nullable;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.java.FormalParameterVisitor;
import org.openrewrite.java.TypeVisitor;
import org.openrewrite.java.internal.grammar.MethodSignatureLexer;
import org.openrewrite.java.internal.grammar.MethodSignatureParser;
import org.openrewrite.java.internal.grammar.MethodSignatureParserBaseVisitor;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TypeUtils;

public class MethodMatcher {
    private static final String ASPECTJ_DOT_PATTERN = StringUtils.aspectjNameToPattern((String)".");
    private static final String ASPECTJ_DOTDOT_PATTERN = StringUtils.aspectjNameToPattern((String)"..");
    private static final Pattern EMPTY_ARGUMENTS_PATTERN = Pattern.compile("");
    private static final Pattern ANY_ARGUMENTS_PATTERN = Pattern.compile(".*");
    private @Nullable String targetTypeAspectJ;
    private @Nullable Pattern targetTypePattern;
    private @Nullable Pattern methodNamePattern;
    private Pattern argumentPattern;
    private @Nullable String targetType;
    private @Nullable String methodName;
    private final boolean matchOverrides;

    public MethodMatcher(String signature, @Nullable Boolean matchOverrides) {
        this(signature, Boolean.TRUE.equals(matchOverrides));
    }

    public MethodMatcher(String signature, boolean matchOverrides) {
        this.matchOverrides = matchOverrides;
        MethodSignatureParser parser = new MethodSignatureParser((TokenStream)new CommonTokenStream((TokenSource)new MethodSignatureLexer((CharStream)CharStreams.fromString((String)signature))));
        new MethodSignatureParserBaseVisitor<Void>(){

            @Override
            public Void visitMethodPattern(MethodSignatureParser.MethodPatternContext ctx) {
                MethodSignatureParser.TargetTypePatternContext targetTypePatternContext = ctx.targetTypePattern();
                String pattern = (String)new TypeVisitor().visitTargetTypePattern(targetTypePatternContext);
                MethodMatcher.this.targetTypeAspectJ = pattern;
                if (MethodMatcher.isPlainIdentifier(targetTypePatternContext)) {
                    MethodMatcher.this.targetType = pattern;
                } else {
                    MethodMatcher.this.targetTypePattern = Pattern.compile(StringUtils.aspectjNameToPattern((String)pattern));
                }
                if (MethodMatcher.isPlainIdentifier(ctx.simpleNamePattern())) {
                    StringBuilder builder = new StringBuilder();
                    for (ParseTree child : ctx.simpleNamePattern().children) {
                        builder.append(child.getText());
                    }
                    MethodMatcher.this.methodName = builder.toString();
                } else {
                    StringBuilder builder = new StringBuilder();
                    for (ParseTree child : ctx.simpleNamePattern().children) {
                        builder.append(StringUtils.aspectjNameToPattern((String)child.getText()));
                    }
                    MethodMatcher.this.methodNamePattern = Pattern.compile(builder.toString());
                }
                if (ctx.formalParametersPattern().formalsPattern() == null) {
                    MethodMatcher.this.argumentPattern = EMPTY_ARGUMENTS_PATTERN;
                } else if (MethodMatcher.matchAllArguments(ctx.formalParametersPattern().formalsPattern())) {
                    MethodMatcher.this.argumentPattern = ANY_ARGUMENTS_PATTERN;
                } else {
                    MethodMatcher.this.argumentPattern = Pattern.compile(new FormalParameterVisitor().visitFormalParametersPattern(ctx.formalParametersPattern()));
                }
                return null;
            }
        }.visit((ParseTree)parser.methodPattern());
    }

    private static boolean matchAllArguments(MethodSignatureParser.FormalsPatternContext context) {
        return context.dotDot() != null && context.formalsPatternAfterDotDot() == null;
    }

    private static boolean isPlainIdentifier(MethodSignatureParser.TargetTypePatternContext context) {
        return context.BANG() == null && context.AND() == null && context.OR() == null && context.classNameOrInterface().DOTDOT().isEmpty() && context.classNameOrInterface().WILDCARD().isEmpty();
    }

    private static boolean isPlainIdentifier(MethodSignatureParser.SimpleNamePatternContext context) {
        return context.WILDCARD().isEmpty();
    }

    public MethodMatcher(J.MethodDeclaration method, boolean matchOverrides) {
        this(MethodMatcher.methodPattern(method), matchOverrides);
    }

    public MethodMatcher(String signature) {
        this(signature, false);
    }

    public MethodMatcher(J.MethodDeclaration method) {
        this(method, false);
    }

    public MethodMatcher(JavaType.Method method) {
        this(MethodMatcher.methodPattern(method), false);
    }

    @Deprecated
    public Pattern getTargetTypePattern() {
        return this.targetTypePattern != null ? this.targetTypePattern : Pattern.compile(Objects.requireNonNull(this.targetType));
    }

    @Deprecated
    public Pattern getMethodNamePattern() {
        return this.methodNamePattern != null ? this.methodNamePattern : Pattern.compile(Objects.requireNonNull(this.methodName));
    }

    @Deprecated
    public Pattern getArgumentPattern() {
        return this.argumentPattern;
    }

    private boolean matchesTargetTypeName(String fullyQualifiedTypeName) {
        return this.targetType != null && TypeUtils.fullyQualifiedNamesAreEqual(this.targetType, fullyQualifiedTypeName) || this.targetTypePattern != null && this.targetTypePattern.matcher(fullyQualifiedTypeName).matches();
    }

    boolean matchesTargetType(@Nullable JavaType.FullyQualified type) {
        return (type == null || type instanceof JavaType.Unknown) && "*..*".equals(this.targetTypeAspectJ) || TypeUtils.isOfTypeWithName(type, this.matchOverrides, this::matchesTargetTypeName);
    }

    private boolean matchesMethodName(String methodName) {
        return this.methodName != null && this.methodName.equals(methodName) || this.methodNamePattern != null && this.methodNamePattern.matcher(methodName).matches();
    }

    private boolean matchesParameterTypes(List<JavaType> parameterTypes) {
        if (this.argumentPattern == ANY_ARGUMENTS_PATTERN) {
            return true;
        }
        if (this.argumentPattern == EMPTY_ARGUMENTS_PATTERN) {
            return parameterTypes.isEmpty();
        }
        StringJoiner joiner = new StringJoiner(",");
        for (JavaType javaType : parameterTypes) {
            String s = MethodMatcher.typePattern(javaType);
            if (s == null) continue;
            joiner.add(s);
        }
        return this.argumentPattern.matcher(joiner.toString()).matches();
    }

    public boolean matches(@Nullable JavaType.Method type) {
        if (type == null) {
            return false;
        }
        if (!this.matchesTargetType(type.getDeclaringType())) {
            return false;
        }
        if (!this.matchesMethodName(type.getName())) {
            return false;
        }
        return this.matchesParameterTypes(type.getParameterTypes());
    }

    public boolean matches(@Nullable MethodCall methodCall) {
        if (methodCall == null) {
            return false;
        }
        return this.matches(methodCall.getMethodType());
    }

    public boolean matches(@Nullable Expression maybeMethod) {
        return maybeMethod instanceof MethodCall && this.matches((MethodCall)maybeMethod);
    }

    public boolean matches(J.MethodDeclaration method, J.ClassDeclaration enclosing) {
        boolean matchesTargetType;
        if (enclosing.getType() == null) {
            return false;
        }
        boolean bl = matchesTargetType = this.targetTypePattern != null && "[^.]*".equals(this.targetTypePattern.pattern()) || this.matchesTargetType(enclosing.getType());
        if (!matchesTargetType) {
            return false;
        }
        if (method.getMethodType() != null && !this.matchesMethodName(method.getMethodType().getName())) {
            return false;
        }
        List<JavaType> parameterTypes = method.getParameters().stream().map(MethodMatcher::variableDeclarationsType).filter(Objects::nonNull).collect(Collectors.toList());
        return this.matchesParameterTypes(parameterTypes);
    }

    public boolean matches(J.MethodDeclaration method, J.NewClass enclosing) {
        boolean matchesTargetType;
        if (enclosing.getType() == null) {
            return false;
        }
        boolean bl = matchesTargetType = this.targetTypePattern != null && "[^.]*".equals(this.targetTypePattern.pattern()) || TypeUtils.isAssignableTo(this.targetType, enclosing.getType());
        if (!matchesTargetType) {
            return false;
        }
        if (method.getMethodType() != null && !this.matchesMethodName(method.getMethodType().getName())) {
            return false;
        }
        List<JavaType> parameterTypes = method.getParameters().stream().map(MethodMatcher::variableDeclarationsType).filter(Objects::nonNull).collect(Collectors.toList());
        return this.matchesParameterTypes(parameterTypes);
    }

    private static @Nullable JavaType variableDeclarationsType(Statement v) {
        if (v instanceof J.VariableDeclarations) {
            J.VariableDeclarations vd = (J.VariableDeclarations)v;
            List<J.VariableDeclarations.NamedVariable> variables = vd.getVariables();
            if (!variables.isEmpty() && variables.get(0).getType() != null) {
                return variables.get(0).getType();
            }
            if (vd.getTypeAsFullyQualified() != null) {
                return vd.getTypeAsFullyQualified();
            }
            return vd.getTypeExpression() != null ? vd.getTypeExpression().getType() : null;
        }
        return null;
    }

    public boolean matches(@Nullable J.MethodInvocation method, boolean matchUnknownTypes) {
        if (method == null) {
            return false;
        }
        if (method.getMethodType() == null) {
            return matchUnknownTypes && this.matchesAllowingUnknownTypes(method);
        }
        return this.matches(method.getMethodType());
    }

    private boolean matchesAllowingUnknownTypes(J.MethodInvocation method) {
        if (!this.matchesMethodName(method.getSimpleName())) {
            return false;
        }
        if (method.getSelect() != null && method.getSelect() instanceof J.Identifier && !this.matchesSelectBySimpleNameAlone((J.Identifier)method.getSelect())) {
            return false;
        }
        String argumentSignature = this.argumentsFromExpressionTypes(method);
        Pattern relaxedArgumentPattern = Pattern.compile(this.argumentPattern.pattern().replaceAll("((?:[a-zA-Z0-9]+\\.?)+)", "($1|" + JavaType.Unknown.getInstance().getFullyQualifiedName() + ")"));
        return relaxedArgumentPattern.matcher(argumentSignature).matches();
    }

    private boolean matchesSelectBySimpleNameAlone(J.Identifier select) {
        if (this.targetType != null) {
            return this.targetType.equals(select.getSimpleName()) || this.targetType.endsWith('.' + select.getSimpleName());
        }
        return this.targetTypePattern.matcher(select.getSimpleName()).matches() || Pattern.compile(this.targetTypePattern.pattern().replaceAll(".*" + Pattern.quote(ASPECTJ_DOT_PATTERN), "").replaceAll(".*" + Pattern.quote(ASPECTJ_DOTDOT_PATTERN), "")).matcher(select.getSimpleName()).matches();
    }

    private String argumentsFromExpressionTypes(J.MethodInvocation method) {
        StringJoiner joiner = new StringJoiner(",");
        for (Expression expr : method.getArguments()) {
            JavaType exprType = expr.getType();
            String s = exprType == null ? JavaType.Unknown.getInstance().getFullyQualifiedName() : MethodMatcher.typePattern(exprType);
            joiner.add(s);
        }
        return joiner.toString();
    }

    public boolean isFullyQualifiedClassReference(J.FieldAccess fieldAccess) {
        if (this.methodName != null && !this.methodName.equals(fieldAccess.getName().getSimpleName())) {
            return false;
        }
        if (this.methodNamePattern != null && !this.methodNamePattern.matcher(fieldAccess.getName().getSimpleName()).matches()) {
            return false;
        }
        Expression target = fieldAccess.getTarget();
        if (target instanceof J.Identifier) {
            return this.targetType != null && this.targetType.equals(((J.Identifier)target).getSimpleName()) || this.targetTypePattern != null && this.targetTypePattern.matcher(((J.Identifier)target).getSimpleName()).matches();
        }
        if (target instanceof J.FieldAccess) {
            return ((J.FieldAccess)target).isFullyQualifiedClassReference(this.targetType != null ? this.targetType : this.targetTypePattern.pattern());
        }
        return false;
    }

    private static @Nullable String typePattern(JavaType type) {
        if (type instanceof JavaType.Primitive) {
            if (type.equals(JavaType.Primitive.String)) {
                return ((JavaType.Primitive)type).getClassName();
            }
            return ((JavaType.Primitive)type).getKeyword();
        }
        if (type instanceof JavaType.Unknown) {
            return "*";
        }
        if (type instanceof JavaType.FullyQualified) {
            return ((JavaType.FullyQualified)type).getFullyQualifiedName();
        }
        if (type instanceof JavaType.Array) {
            JavaType elemType = ((JavaType.Array)type).getElemType();
            return MethodMatcher.typePattern(elemType) + "[]";
        }
        return null;
    }

    public static String methodPattern(J.MethodDeclaration method) {
        assert (method.getMethodType() != null);
        return MethodMatcher.methodPattern(method.getMethodType());
    }

    public static String methodPattern(JavaType.Method method) {
        StringJoiner parameters = new StringJoiner(",");
        for (JavaType javaType : method.getParameterTypes()) {
            String s = MethodMatcher.typePattern(javaType);
            if (s == null) continue;
            parameters.add(s);
        }
        return MethodMatcher.typePattern(method.getDeclaringType()) + " " + method.getName() + "(" + parameters + ")";
    }

    public String toString() {
        return (this.targetType != null ? this.targetType : this.targetTypePattern.pattern()) + ' ' + (this.methodName != null ? this.methodName : this.methodNamePattern.pattern()) + '(' + this.argumentPattern.pattern() + ')';
    }

    @Generated
    public boolean isMatchOverrides() {
        return this.matchOverrides;
    }
}

