/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.RemoveImport;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.Flag;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.java.tree.TypedTree;
import org.openrewrite.marker.Markers;
import org.openrewrite.marker.SearchResult;

public final class ChangeType
extends Recipe {
    @Option(displayName="Old fully-qualified type name", description="Fully-qualified class name of the original type.", example="org.junit.Assume")
    private final String oldFullyQualifiedTypeName;
    @Option(displayName="New fully-qualified type name", description="Fully-qualified class name of the replacement type, or the name of a primitive such as \"int\". The `OuterClassName$NestedClassName` naming convention should be used for nested classes.", example="org.junit.jupiter.api.Assumptions")
    private final String newFullyQualifiedTypeName;
    @Option(displayName="Ignore type definition", description="When set to `true` the definition of the old type will be left untouched. This is useful when you're replacing usage of a class but don't want to rename it.", required=false)
    private final @Nullable Boolean ignoreDefinition;

    public String getDisplayName() {
        return "Change type";
    }

    public String getInstanceNameSuffix() {
        String newShort;
        String oldShort = this.oldFullyQualifiedTypeName.substring(this.oldFullyQualifiedTypeName.lastIndexOf(46) + 1);
        if (oldShort.equals(newShort = this.newFullyQualifiedTypeName.substring(this.newFullyQualifiedTypeName.lastIndexOf(46) + 1))) {
            return String.format("`%s` to `%s`", this.oldFullyQualifiedTypeName, this.newFullyQualifiedTypeName);
        }
        return String.format("`%s` to `%s`", oldShort, newShort);
    }

    public String getDescription() {
        return "Change a given type to another.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        JavaIsoVisitor<ExecutionContext> condition = new JavaIsoVisitor<ExecutionContext>(){

            public J visit(@Nullable Tree tree, ExecutionContext ctx) {
                if (tree instanceof JavaSourceFile) {
                    JavaSourceFile cu = (JavaSourceFile)Objects.requireNonNull(tree);
                    if (!Boolean.TRUE.equals(ChangeType.this.ignoreDefinition) && ChangeType.containsClassDefinition(cu, ChangeType.this.oldFullyQualifiedTypeName)) {
                        return (J)SearchResult.found((Tree)cu);
                    }
                    return (J)new UsesType(ChangeType.this.oldFullyQualifiedTypeName, true).visitNonNull(cu, ctx);
                }
                return (J)tree;
            }
        };
        return Preconditions.check((TreeVisitor)condition, (TreeVisitor)new ChangeTypeVisitor(this.oldFullyQualifiedTypeName, this.newFullyQualifiedTypeName, this.ignoreDefinition));
    }

    public static boolean containsClassDefinition(JavaSourceFile sourceFile, final String fullyQualifiedTypeName) {
        AtomicBoolean found = new AtomicBoolean(false);
        JavaIsoVisitor<AtomicBoolean> visitor = new JavaIsoVisitor<AtomicBoolean>(){

            public @Nullable J visit(@Nullable Tree tree, AtomicBoolean found) {
                if (found.get()) {
                    return (J)tree;
                }
                return (J)super.visit(tree, (Object)found);
            }

            @Override
            public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, AtomicBoolean found) {
                if (found.get()) {
                    return classDecl;
                }
                if (classDecl.getType() != null && TypeUtils.isOfClassType(classDecl.getType(), fullyQualifiedTypeName)) {
                    found.set(true);
                    return classDecl;
                }
                return super.visitClassDeclaration(classDecl, found);
            }
        };
        visitor.visit(sourceFile, found);
        return found.get();
    }

    public static JavaType.FullyQualified getTopLevelClassName(JavaType.FullyQualified classType) {
        if (classType.getOwningClass() == null || TypeUtils.fullyQualifiedNamesAreEqual(classType.getFullyQualifiedName(), classType.getOwningClass().getFullyQualifiedName())) {
            return classType;
        }
        return ChangeType.getTopLevelClassName(classType.getOwningClass());
    }

    private static boolean hasSameFQN(J.Import import_, JavaType targetType) {
        JavaType.FullyQualified type = TypeUtils.asFullyQualified(targetType);
        String fqn = type != null ? type.getFullyQualifiedName() : null;
        JavaType.FullyQualified curType = TypeUtils.asFullyQualified(Optional.ofNullable(import_.getQualid()).map(J.FieldAccess::getType).orElse(null));
        String curFqn = curType != null ? curType.getFullyQualifiedName() : null;
        return fqn != null && fqn.equals(curFqn);
    }

    @Generated
    public ChangeType(String oldFullyQualifiedTypeName, String newFullyQualifiedTypeName, @Nullable Boolean ignoreDefinition) {
        this.oldFullyQualifiedTypeName = oldFullyQualifiedTypeName;
        this.newFullyQualifiedTypeName = newFullyQualifiedTypeName;
        this.ignoreDefinition = ignoreDefinition;
    }

    @Generated
    public String getOldFullyQualifiedTypeName() {
        return this.oldFullyQualifiedTypeName;
    }

    @Generated
    public String getNewFullyQualifiedTypeName() {
        return this.newFullyQualifiedTypeName;
    }

    @Generated
    public @Nullable Boolean getIgnoreDefinition() {
        return this.ignoreDefinition;
    }

    @NonNull
    @Generated
    public String toString() {
        return "ChangeType(oldFullyQualifiedTypeName=" + this.getOldFullyQualifiedTypeName() + ", newFullyQualifiedTypeName=" + this.getNewFullyQualifiedTypeName() + ", ignoreDefinition=" + this.getIgnoreDefinition() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChangeType)) {
            return false;
        }
        ChangeType other = (ChangeType)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$ignoreDefinition = this.getIgnoreDefinition();
        Boolean other$ignoreDefinition = other.getIgnoreDefinition();
        if (this$ignoreDefinition == null ? other$ignoreDefinition != null : !((Object)this$ignoreDefinition).equals(other$ignoreDefinition)) {
            return false;
        }
        String this$oldFullyQualifiedTypeName = this.getOldFullyQualifiedTypeName();
        String other$oldFullyQualifiedTypeName = other.getOldFullyQualifiedTypeName();
        if (this$oldFullyQualifiedTypeName == null ? other$oldFullyQualifiedTypeName != null : !this$oldFullyQualifiedTypeName.equals(other$oldFullyQualifiedTypeName)) {
            return false;
        }
        String this$newFullyQualifiedTypeName = this.getNewFullyQualifiedTypeName();
        String other$newFullyQualifiedTypeName = other.getNewFullyQualifiedTypeName();
        return !(this$newFullyQualifiedTypeName == null ? other$newFullyQualifiedTypeName != null : !this$newFullyQualifiedTypeName.equals(other$newFullyQualifiedTypeName));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof ChangeType;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $ignoreDefinition = this.getIgnoreDefinition();
        result = result * 59 + ($ignoreDefinition == null ? 43 : ((Object)$ignoreDefinition).hashCode());
        String $oldFullyQualifiedTypeName = this.getOldFullyQualifiedTypeName();
        result = result * 59 + ($oldFullyQualifiedTypeName == null ? 43 : $oldFullyQualifiedTypeName.hashCode());
        String $newFullyQualifiedTypeName = this.getNewFullyQualifiedTypeName();
        result = result * 59 + ($newFullyQualifiedTypeName == null ? 43 : $newFullyQualifiedTypeName.hashCode());
        return result;
    }

    private static class ChangeTypeVisitor
    extends JavaVisitor<ExecutionContext> {
        private final JavaType.Class originalType;
        private final JavaType targetType;
        private @Nullable J.Identifier importAlias;
        private final @Nullable Boolean ignoreDefinition;
        private final Map<JavaType, JavaType> oldNameToChangedType = new IdentityHashMap<JavaType, JavaType>();
        private final Set<String> topLevelClassnames = new HashSet<String>();

        private ChangeTypeVisitor(String oldFullyQualifiedTypeName, String newFullyQualifiedTypeName, @Nullable Boolean ignoreDefinition) {
            this.originalType = JavaType.ShallowClass.build(oldFullyQualifiedTypeName);
            this.targetType = JavaType.buildType(newFullyQualifiedTypeName);
            this.ignoreDefinition = ignoreDefinition;
            this.importAlias = null;
        }

        public J visit(@Nullable Tree tree, ExecutionContext ctx) {
            if (tree instanceof JavaSourceFile) {
                JavaType.FullyQualified fq;
                JavaSourceFile cu = (JavaSourceFile)tree;
                if (!Boolean.TRUE.equals(this.ignoreDefinition) && (fq = TypeUtils.asFullyQualified(this.targetType)) != null) {
                    ChangeClassDefinition changeClassDefinition = new ChangeClassDefinition(this.originalType.getFullyQualifiedName(), fq.getFullyQualifiedName());
                    cu = (JavaSourceFile)changeClassDefinition.visitNonNull(cu, ctx);
                }
                return (J)super.visit((Tree)cu, (Object)ctx);
            }
            return (J)super.visit(tree, (Object)ctx);
        }

        @Override
        public J visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext ctx) {
            J.ClassDeclaration cd = (J.ClassDeclaration)super.visitClassDeclaration(classDecl, ctx);
            if (cd.getType() != null) {
                this.topLevelClassnames.add(ChangeType.getTopLevelClassName(cd.getType()).getFullyQualifiedName());
            }
            return cd;
        }

        @Override
        public J visitImport(J.Import import_, ExecutionContext ctx) {
            if (ChangeType.hasSameFQN(import_, this.originalType) && import_.getAlias() != null) {
                this.importAlias = import_.getAlias();
            }
            return import_;
        }

        @Override
        public @Nullable JavaType visitType(@Nullable JavaType javaType, ExecutionContext ctx) {
            return this.updateType(javaType);
        }

        private void addImport(JavaType.FullyQualified owningClass) {
            if (this.importAlias != null) {
                this.maybeAddImport(owningClass.getPackageName(), owningClass.getClassName(), null, this.importAlias.getSimpleName(), true);
            }
            this.maybeAddImport(owningClass.getPackageName(), owningClass.getClassName(), null, null, true);
        }

        public @Nullable J postVisit(J tree, ExecutionContext ctx) {
            J j = (J)super.postVisit((Tree)tree, (Object)ctx);
            if (j instanceof J.ArrayType) {
                J.ArrayType arrayType = (J.ArrayType)j;
                JavaType type = this.updateType(arrayType.getType());
                j = arrayType.withType(type);
            } else if (j instanceof J.MethodDeclaration) {
                J.MethodDeclaration method = (J.MethodDeclaration)j;
                JavaType.Method mt = this.updateType(method.getMethodType());
                j = method.withMethodType(mt).withName(method.getName().withType(mt));
            } else if (j instanceof J.MethodInvocation) {
                J.MethodInvocation method = (J.MethodInvocation)j;
                JavaType.Method mt = this.updateType(method.getMethodType());
                j = method.withMethodType(mt).withName(method.getName().withType(mt));
            } else if (j instanceof J.NewClass) {
                J.NewClass n = (J.NewClass)j;
                j = n.withConstructorType(this.updateType(n.getConstructorType()));
            } else if (tree instanceof TypedTree) {
                j = ((TypedTree)tree).withType(this.updateType(((TypedTree)tree).getType()));
            } else if (tree instanceof JavaSourceFile) {
                JavaType.FullyQualified fullyQualifiedTarget;
                JavaSourceFile sf = (JavaSourceFile)tree;
                if (this.targetType instanceof JavaType.FullyQualified) {
                    for (J.Import anImport : sf.getImports()) {
                        JavaType maybeType;
                        if (anImport.isStatic() || !((maybeType = anImport.getQualid().getType()) instanceof JavaType.FullyQualified)) continue;
                        JavaType.FullyQualified type = (JavaType.FullyQualified)maybeType;
                        if (this.originalType.getFullyQualifiedName().equals(type.getFullyQualifiedName())) {
                            sf = (JavaSourceFile)new RemoveImport(this.originalType.getFullyQualifiedName()).visitNonNull(sf, ctx, this.getCursor().getParentOrThrow());
                            continue;
                        }
                        if (this.originalType.getOwningClass() == null || !this.originalType.getOwningClass().getFullyQualifiedName().equals(type.getFullyQualifiedName())) continue;
                        sf = (JavaSourceFile)new RemoveImport(this.originalType.getOwningClass().getFullyQualifiedName()).visitNonNull(sf, ctx, this.getCursor().getParentOrThrow());
                    }
                }
                if ((fullyQualifiedTarget = TypeUtils.asFullyQualified(this.targetType)) != null) {
                    JavaType.FullyQualified owningClass = fullyQualifiedTarget.getOwningClass();
                    if (!this.topLevelClassnames.contains(ChangeType.getTopLevelClassName(fullyQualifiedTarget).getFullyQualifiedName()) && this.hasNoConflictingImport(sf)) {
                        if (owningClass != null && !"java.lang".equals(fullyQualifiedTarget.getPackageName())) {
                            this.addImport(owningClass);
                        }
                        if (!"java.lang".equals(fullyQualifiedTarget.getPackageName())) {
                            this.addImport(fullyQualifiedTarget);
                        }
                    }
                }
                j = sf.withImports(ListUtils.map(sf.getImports(), i -> (J.Import)this.visitAndCast((Tree)i, ctx, (x$0, x$1) -> super.visitImport((J.Import)x$0, x$1))));
            }
            return j;
        }

        @Override
        public J visitFieldAccess(J.FieldAccess fieldAccess, ExecutionContext ctx) {
            if (fieldAccess.isFullyQualifiedClassReference(this.originalType.getFullyQualifiedName())) {
                if (this.targetType instanceof JavaType.FullyQualified) {
                    return this.updateOuterClassTypes((Expression)TypeTree.build(((JavaType.FullyQualified)this.targetType).getFullyQualifiedName()).withPrefix(fieldAccess.getPrefix()));
                }
                if (this.targetType instanceof JavaType.Primitive) {
                    return new J.Primitive(fieldAccess.getId(), fieldAccess.getPrefix(), Markers.EMPTY, (JavaType.Primitive)this.targetType);
                }
            } else {
                StringBuilder maybeClass = new StringBuilder();
                Expression target = fieldAccess;
                while (target != null) {
                    if (target instanceof J.FieldAccess) {
                        J.FieldAccess fa = target;
                        maybeClass.insert(0, fa.getSimpleName()).insert(0, '.');
                        target = fa.getTarget();
                        continue;
                    }
                    if (target instanceof J.Identifier) {
                        maybeClass.insert(0, ((J.Identifier)target).getSimpleName());
                        target = null;
                        continue;
                    }
                    maybeClass = new StringBuilder("__NOT_IT__");
                    break;
                }
                JavaType.ShallowClass oldType = JavaType.ShallowClass.build(this.originalType.getFullyQualifiedName());
                if (maybeClass.toString().equals(oldType.getClassName())) {
                    this.maybeRemoveImport(oldType.getOwningClass());
                    Expression e = this.updateOuterClassTypes((Expression)TypeTree.build(((JavaType.FullyQualified)this.targetType).getClassName()).withPrefix(fieldAccess.getPrefix()));
                    if (e instanceof J.Identifier && e.getType() == null) {
                        J.Identifier i = (J.Identifier)e;
                        e = i.withType(this.targetType);
                    }
                    return e;
                }
                if (maybeClass.toString().equals(oldType.getFullyQualifiedName().replace('$', '.'))) {
                    this.maybeRemoveImport(oldType.getOwningClass());
                    return this.updateOuterClassTypes((Expression)TypeTree.build(((JavaType.FullyQualified)this.targetType).getFullyQualifiedName()).withPrefix(fieldAccess.getPrefix()));
                }
            }
            return super.visitFieldAccess(fieldAccess, ctx);
        }

        @Override
        public J visitIdentifier(J.Identifier ident, ExecutionContext ctx) {
            if (Boolean.TRUE.equals(this.ignoreDefinition) && this.getCursor().getParent() != null && this.getCursor().getParent().getValue() instanceof J.ClassDeclaration) {
                return super.visitIdentifier(ident, ctx);
            }
            if (TypeUtils.isOfClassType(ident.getType(), this.originalType.getFullyQualifiedName())) {
                String className = this.originalType.getClassName();
                JavaType.FullyQualified iType = TypeUtils.asFullyQualified(ident.getType());
                if (iType != null && iType.getOwningClass() != null) {
                    className = this.originalType.getFullyQualifiedName().substring(iType.getOwningClass().getFullyQualifiedName().length() + 1);
                }
                JavaSourceFile sf = (JavaSourceFile)this.getCursor().firstEnclosing(JavaSourceFile.class);
                if (ident.getSimpleName().equals(className)) {
                    if (this.targetType instanceof JavaType.FullyQualified) {
                        if (((JavaType.FullyQualified)this.targetType).getOwningClass() != null) {
                            return this.updateOuterClassTypes((Expression)((Expression)TypeTree.build(((JavaType.FullyQualified)this.targetType).getClassName())).withType(null).withPrefix(ident.getPrefix()));
                        }
                        ident = sf != null && this.hasNoConflictingImport(sf) ? ident.withSimpleName(((JavaType.FullyQualified)this.targetType).getClassName()) : ident.withSimpleName(((JavaType.FullyQualified)this.targetType).getFullyQualifiedName());
                    } else if (this.targetType instanceof JavaType.Primitive) {
                        ident = ident.withSimpleName(((JavaType.Primitive)this.targetType).getKeyword());
                    }
                }
                if (sf != null) {
                    for (J.Import anImport : sf.getImports()) {
                        JavaType.FullyQualified fqn;
                        if (!anImport.isStatic() || anImport.getQualid().getTarget().getType() == null || (fqn = TypeUtils.asFullyQualified(anImport.getQualid().getTarget().getType())) == null || !TypeUtils.isOfClassType(fqn, this.originalType.getFullyQualifiedName()) || !ident.getSimpleName().equals(anImport.getQualid().getSimpleName())) continue;
                        JavaType.FullyQualified targetFqn = (JavaType.FullyQualified)this.targetType;
                        this.maybeAddImport(targetFqn.getFullyQualifiedName(), ident.getSimpleName());
                        break;
                    }
                }
            }
            ident = ident.withType(this.updateType(ident.getType()));
            return (J)this.visitAndCast(ident, ctx, (x$0, x$1) -> super.visitIdentifier((J.Identifier)x$0, x$1));
        }

        @Override
        public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
            if (method.getMethodType() != null && method.getMethodType().hasFlags(Flag.Static) && method.getMethodType().getDeclaringType().isAssignableFrom(this.originalType)) {
                JavaSourceFile cu = (JavaSourceFile)this.getCursor().firstEnclosingOrThrow(JavaSourceFile.class);
                for (J.Import anImport : cu.getImports()) {
                    JavaType.FullyQualified fqn;
                    if (!anImport.isStatic() || anImport.getQualid().getTarget().getType() == null || (fqn = TypeUtils.asFullyQualified(anImport.getQualid().getTarget().getType())) == null || !TypeUtils.isOfClassType(fqn, this.originalType.getFullyQualifiedName()) || !method.getSimpleName().equals(anImport.getQualid().getSimpleName())) continue;
                    JavaType.FullyQualified targetFqn = (JavaType.FullyQualified)this.targetType;
                    this.addImport(targetFqn);
                    this.maybeAddImport(targetFqn.getFullyQualifiedName(), method.getName().getSimpleName());
                    break;
                }
            }
            return super.visitMethodInvocation(method, ctx);
        }

        private Expression updateOuterClassTypes(Expression typeTree) {
            if (typeTree instanceof J.FieldAccess) {
                JavaType.FullyQualified type = (JavaType.FullyQualified)this.targetType;
                if (type.getOwningClass() == null) {
                    typeTree.withType(this.updateType(this.targetType));
                }
                Stack<Expression> typeStack = new Stack<Expression>();
                typeStack.push(typeTree);
                Stack<JavaType.FullyQualified> attrStack = new Stack<JavaType.FullyQualified>();
                attrStack.push(type);
                Expression t = ((J.FieldAccess)typeTree).getTarget();
                while (true) {
                    typeStack.push(t);
                    if (t instanceof J.FieldAccess) {
                        if (Character.isUpperCase(((J.FieldAccess)t).getSimpleName().charAt(0)) && ((JavaType.FullyQualified)attrStack.peek()).getOwningClass() != null) {
                            attrStack.push(((JavaType.FullyQualified)attrStack.peek()).getOwningClass());
                        }
                        t = ((J.FieldAccess)t).getTarget();
                        continue;
                    }
                    if (t instanceof J.Identifier) break;
                }
                if (Character.isUpperCase(((J.Identifier)t).getSimpleName().charAt(0)) && ((JavaType.FullyQualified)attrStack.peek()).getOwningClass() != null) {
                    attrStack.push(((JavaType.FullyQualified)attrStack.peek()).getOwningClass());
                }
                Expression attributed = null;
                Expression e = (Expression)typeStack.pop();
                while (true) {
                    if (e instanceof J.Identifier) {
                        attributed = attrStack.size() == typeStack.size() + 1 ? ((J.Identifier)e).withType((JavaType)attrStack.pop()) : e;
                    } else if (e instanceof J.FieldAccess) {
                        attributed = attrStack.size() == typeStack.size() + 1 ? ((J.FieldAccess)e).withTarget(attributed).withType((JavaType)attrStack.pop()) : ((J.FieldAccess)e).withTarget(attributed);
                    }
                    if (typeStack.isEmpty()) break;
                    e = (Expression)typeStack.pop();
                }
                assert (attributed != null);
                return attributed;
            }
            return typeTree;
        }

        private @Nullable JavaType updateType(@Nullable JavaType oldType) {
            if (oldType == null || oldType instanceof JavaType.Unknown) {
                return oldType;
            }
            JavaType type = this.oldNameToChangedType.get(oldType);
            if (type != null) {
                return type;
            }
            if (oldType instanceof JavaType.Parameterized) {
                JavaType.Parameterized pt = (JavaType.Parameterized)oldType;
                if (this.isTargetFullyQualifiedType(pt = pt.withTypeParameters(ListUtils.map(pt.getTypeParameters(), tp -> {
                    JavaType.FullyQualified tpFq;
                    if (tp instanceof JavaType.FullyQualified && this.isTargetFullyQualifiedType(tpFq = (JavaType.FullyQualified)tp)) {
                        return this.updateType(tpFq);
                    }
                    return tp;
                })))) {
                    pt = pt.withType((JavaType.FullyQualified)this.updateType(pt.getType()));
                }
                this.oldNameToChangedType.put(oldType, pt);
                this.oldNameToChangedType.put(pt, pt);
                return pt;
            }
            if (oldType instanceof JavaType.FullyQualified) {
                JavaType.FullyQualified original = TypeUtils.asFullyQualified(oldType);
                if (this.isTargetFullyQualifiedType(original)) {
                    this.oldNameToChangedType.put(oldType, this.targetType);
                    return this.targetType;
                }
            } else {
                if (oldType instanceof JavaType.GenericTypeVariable) {
                    JavaType.GenericTypeVariable gtv = (JavaType.GenericTypeVariable)oldType;
                    gtv = gtv.withBounds(ListUtils.map(gtv.getBounds(), b -> {
                        if (b instanceof JavaType.FullyQualified && this.isTargetFullyQualifiedType((JavaType.FullyQualified)b)) {
                            return this.updateType((JavaType)b);
                        }
                        return b;
                    }));
                    this.oldNameToChangedType.put(oldType, gtv);
                    this.oldNameToChangedType.put(gtv, gtv);
                    return gtv;
                }
                if (oldType instanceof JavaType.Variable) {
                    JavaType.Variable variable = (JavaType.Variable)oldType;
                    variable = variable.withOwner(this.updateType(variable.getOwner()));
                    variable = variable.withType(this.updateType(variable.getType()));
                    this.oldNameToChangedType.put(oldType, variable);
                    this.oldNameToChangedType.put(variable, variable);
                    return variable;
                }
                if (oldType instanceof JavaType.Array) {
                    JavaType.Array array = (JavaType.Array)oldType;
                    array = array.withElemType(this.updateType(array.getElemType()));
                    this.oldNameToChangedType.put(oldType, array);
                    this.oldNameToChangedType.put(array, array);
                    return array;
                }
            }
            return oldType;
        }

        private @Nullable JavaType.Method updateType(@Nullable JavaType.Method oldMethodType) {
            if (oldMethodType != null) {
                JavaType.Method method = (JavaType.Method)this.oldNameToChangedType.get(oldMethodType);
                if (method != null) {
                    return method;
                }
                method = oldMethodType;
                method = method.withDeclaringType((JavaType.FullyQualified)this.updateType(method.getDeclaringType())).withReturnType(this.updateType(method.getReturnType())).withParameterTypes(ListUtils.map(method.getParameterTypes(), this::updateType));
                this.oldNameToChangedType.put(oldMethodType, method);
                this.oldNameToChangedType.put(method, method);
                return method;
            }
            return null;
        }

        private boolean isTargetFullyQualifiedType(@Nullable JavaType.FullyQualified fq) {
            return fq != null && TypeUtils.isOfClassType(fq, this.originalType.getFullyQualifiedName()) && this.targetType instanceof JavaType.FullyQualified;
        }

        private boolean hasNoConflictingImport(JavaSourceFile sf) {
            JavaType.FullyQualified oldType = TypeUtils.asFullyQualified(this.originalType);
            JavaType.FullyQualified newType = TypeUtils.asFullyQualified(this.targetType);
            if (oldType == null || newType == null) {
                return false;
            }
            for (J.Import anImport : sf.getImports()) {
                JavaType.FullyQualified currType = TypeUtils.asFullyQualified(anImport.getQualid().getType());
                if (currType == null || TypeUtils.isOfType(currType, oldType) || TypeUtils.isOfType(currType, newType) || !currType.getClassName().equals(newType.getClassName())) continue;
                return false;
            }
            return true;
        }
    }

    private static class ChangeClassDefinition
    extends JavaIsoVisitor<ExecutionContext> {
        private final JavaType.Class originalType;
        private final JavaType.Class targetType;
        private final MethodMatcher originalConstructor;

        private ChangeClassDefinition(String oldFullyQualifiedTypeName, String newFullyQualifiedTypeName) {
            this.originalType = JavaType.ShallowClass.build(oldFullyQualifiedTypeName);
            this.targetType = JavaType.ShallowClass.build(newFullyQualifiedTypeName);
            this.originalConstructor = new MethodMatcher(oldFullyQualifiedTypeName + "<constructor>(..)");
        }

        public J visit(@Nullable Tree tree, ExecutionContext ctx) {
            if (tree instanceof JavaSourceFile) {
                String newFqn;
                String oldFqn;
                Path newPath;
                String oldPath;
                JavaSourceFile cu = (JavaSourceFile)tree;
                for (J.ClassDeclaration declaration : cu.getClasses()) {
                    String fqn = declaration.getType().getFullyQualifiedName();
                    if (!fqn.equals(this.originalType.getFullyQualifiedName())) continue;
                    this.getCursor().putMessage("UPDATE_PACKAGE", (Object)true);
                    break;
                }
                if (this.updatePath(cu, oldPath = cu.getSourcePath().toString().replace('\\', '/'), (newPath = Paths.get(oldPath.replaceFirst(oldFqn = this.fqnToPath(this.originalType.getFullyQualifiedName()), newFqn = this.fqnToPath(this.targetType.getFullyQualifiedName())), new String[0])).toString())) {
                    cu = cu.withSourcePath(newPath);
                }
                return (J)super.visit((Tree)cu, (Object)ctx);
            }
            return (J)super.visit(tree, (Object)ctx);
        }

        private String fqnToPath(String fullyQualifiedName) {
            int index = fullyQualifiedName.indexOf("$");
            String topLevelClassName = index == -1 ? fullyQualifiedName : fullyQualifiedName.substring(0, index);
            return topLevelClassName.replace('.', '/');
        }

        private boolean updatePath(JavaSourceFile sf, String oldPath, String newPath) {
            return !oldPath.equals(newPath) && sf.getClasses().stream().anyMatch(o -> !J.Modifier.hasModifier(o.getModifiers(), J.Modifier.Type.Private) && o.getType() != null && !o.getType().getFullyQualifiedName().contains("$") && TypeUtils.isOfClassType(o.getType(), ChangeType.getTopLevelClassName(this.originalType).getFullyQualifiedName()));
        }

        @Override
        public J.Package visitPackage(J.Package pkg, ExecutionContext ctx) {
            JavaType.FullyQualified fq;
            String original;
            Boolean updatePackage = (Boolean)this.getCursor().pollNearestMessage("UPDATE_PACKAGE");
            if (updatePackage != null && updatePackage.booleanValue() && (original = pkg.getExpression().printTrimmed(this.getCursor()).replaceAll("\\s", "")).equals(this.originalType.getPackageName()) && (fq = TypeUtils.asFullyQualified(this.targetType)) != null) {
                if (fq.getPackageName().isEmpty()) {
                    this.getCursor().putMessageOnFirstEnclosing(J.CompilationUnit.class, "UPDATE_PREFIX", (Object)true);
                    return null;
                }
                String newPkg = this.targetType.getPackageName();
                return (J.Package)JavaTemplate.builder(newPkg).contextSensitive().build().apply(this.getCursor(), pkg.getCoordinates().replace(), new Object[0]);
            }
            return pkg;
        }

        @Override
        public J.Import visitImport(J.Import _import, ExecutionContext ctx) {
            Boolean updatePrefix = (Boolean)this.getCursor().pollNearestMessage("UPDATE_PREFIX");
            if (updatePrefix != null && updatePrefix.booleanValue()) {
                _import = _import.withPrefix(Space.EMPTY);
            }
            return super.visitImport(_import, ctx);
        }

        @Override
        public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext ctx) {
            J cd = super.visitClassDeclaration(classDecl, ctx);
            Boolean updatePrefix = (Boolean)this.getCursor().pollNearestMessage("UPDATE_PREFIX");
            if (updatePrefix != null && updatePrefix.booleanValue()) {
                cd = ((J.ClassDeclaration)cd).withPrefix(Space.EMPTY);
            }
            if (TypeUtils.isOfClassType(classDecl.getType(), this.originalType.getFullyQualifiedName())) {
                String newClassName = this.getNewClassName(this.targetType);
                cd = ((J.ClassDeclaration)cd).withName(((J.ClassDeclaration)cd).getName().withSimpleName(newClassName));
                cd = ((J.ClassDeclaration)cd).withType(this.updateType(((J.ClassDeclaration)cd).getType()));
            }
            return cd;
        }

        @Override
        public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, ExecutionContext ctx) {
            if (method.isConstructor() && this.originalConstructor.matches(method.getMethodType())) {
                method = method.withName(method.getName().withSimpleName(this.targetType.getClassName()));
                method = method.withMethodType(this.updateType(method.getMethodType()));
            }
            return super.visitMethodDeclaration(method, ctx);
        }

        private String getNewClassName(JavaType.FullyQualified fq) {
            return fq.getOwningClass() == null ? fq.getClassName() : fq.getFullyQualifiedName().substring(fq.getOwningClass().getFullyQualifiedName().length() + 1);
        }

        private JavaType updateType(@Nullable JavaType oldType) {
            JavaType.FullyQualified original;
            if (oldType instanceof JavaType.FullyQualified && this.isTargetFullyQualifiedType(original = TypeUtils.asFullyQualified(oldType))) {
                return this.targetType;
            }
            return oldType;
        }

        private @Nullable JavaType.Method updateType(@Nullable JavaType.Method mt) {
            if (mt != null) {
                return mt.withDeclaringType((JavaType.FullyQualified)this.updateType(mt.getDeclaringType())).withReturnType(this.updateType(mt.getReturnType())).withParameterTypes(ListUtils.map(mt.getParameterTypes(), this::updateType));
            }
            return null;
        }

        private boolean isTargetFullyQualifiedType(@Nullable JavaType.FullyQualified fq) {
            return fq != null && TypeUtils.isOfClassType(fq, this.originalType.getFullyQualifiedName());
        }
    }
}

