/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.search;

import java.util.Objects;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import lombok.Generated;
import org.openrewrite.Tree;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.marker.SearchResult;

public class UsesType<P>
extends JavaIsoVisitor<P> {
    @Nullable
    private final String fullyQualifiedType;
    @Nullable
    private final Predicate<JavaType> typePattern;
    @Nullable
    private final Boolean includeImplicit;

    public UsesType(String fullyQualifiedType, @Nullable Boolean includeImplicit) {
        if (fullyQualifiedType.contains("*")) {
            int dotdot;
            this.fullyQualifiedType = null;
            this.typePattern = fullyQualifiedType.indexOf(42) == fullyQualifiedType.length() - 1 ? ((dotdot = fullyQualifiedType.indexOf("..")) == -1 && fullyQualifiedType.charAt(fullyQualifiedType.length() - 2) == '.' ? UsesType.packagePattern(fullyQualifiedType.substring(0, fullyQualifiedType.length() - 2)) : (dotdot == fullyQualifiedType.length() - 3 ? UsesType.packagePrefixPattern(fullyQualifiedType.substring(0, dotdot)) : UsesType.genericPattern(Pattern.compile(StringUtils.aspectjNameToPattern((String)fullyQualifiedType))))) : UsesType.genericPattern(Pattern.compile(StringUtils.aspectjNameToPattern((String)fullyQualifiedType)));
        } else {
            this.fullyQualifiedType = fullyQualifiedType;
            this.typePattern = null;
        }
        this.includeImplicit = includeImplicit;
    }

    public J visit(@Nullable Tree tree, P p) {
        if (tree instanceof JavaSourceFile) {
            JavaSourceFile cu;
            JavaSourceFile c = cu = (JavaSourceFile)Objects.requireNonNull(tree);
            for (JavaType type : c.getTypesInUse().getTypesInUse()) {
                JavaType checkType = type instanceof JavaType.Primitive ? type : TypeUtils.asFullyQualified(type);
                if ((c = this.maybeMark(c, checkType)) == cu) continue;
                return c;
            }
            for (J.Import anImport : c.getImports()) {
                if (!(anImport.isStatic() ? (c = this.maybeMark(c, TypeUtils.asFullyQualified(anImport.getQualid().getTarget().getType()))) != cu : (c = this.maybeMark(c, TypeUtils.asFullyQualified(anImport.getQualid().getType()))) != cu)) continue;
                return c;
            }
            if (Boolean.TRUE.equals(this.includeImplicit)) {
                for (JavaType.Method method : c.getTypesInUse().getUsedMethods()) {
                    if ((c = this.maybeMark(c, method.getDeclaringType())) != cu) {
                        return c;
                    }
                    if ((c = this.maybeMark(c, method.getReturnType())) != cu) {
                        return c;
                    }
                    for (JavaType parameterType : method.getParameterTypes()) {
                        if ((c = this.maybeMark(c, parameterType)) == cu) continue;
                        return c;
                    }
                }
            }
        }
        return (J)tree;
    }

    private JavaSourceFile maybeMark(JavaSourceFile c, @Nullable JavaType type) {
        if (type == null) {
            return c;
        }
        if (this.typePattern != null && TypeUtils.isAssignableTo(this.typePattern, type) || this.fullyQualifiedType != null && TypeUtils.isAssignableTo(this.fullyQualifiedType, type)) {
            return (JavaSourceFile)SearchResult.found((Tree)c);
        }
        return c;
    }

    private static Predicate<JavaType> genericPattern(Pattern pattern) {
        return type -> {
            if (type instanceof JavaType.FullyQualified) {
                return pattern.matcher(((JavaType.FullyQualified)type).getFullyQualifiedName()).matches();
            }
            if (type instanceof JavaType.Primitive) {
                return pattern.matcher(((JavaType.Primitive)type).getKeyword()).matches();
            }
            return false;
        };
    }

    private static Predicate<JavaType> packagePattern(String name) {
        return type -> type instanceof JavaType.FullyQualified && ((JavaType.FullyQualified)type).getFullyQualifiedName().startsWith(name) && ((JavaType.FullyQualified)type).getPackageName().equals(name);
    }

    private static Predicate<JavaType> packagePrefixPattern(String prefix) {
        String subPackagePrefix = prefix + ".";
        return type -> {
            if (type instanceof JavaType.FullyQualified) {
                String packageName = ((JavaType.FullyQualified)type).getPackageName();
                return packageName.equals(prefix) || packageName.startsWith(subPackagePrefix);
            }
            return false;
        };
    }

    @Nullable
    @Generated
    public String getFullyQualifiedType() {
        return this.fullyQualifiedType;
    }

    @Nullable
    @Generated
    public Predicate<JavaType> getTypePattern() {
        return this.typePattern;
    }
}

