/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.search;

import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.J;
import org.openrewrite.marker.SearchResult;

public final class ResultOfMethodCallIgnored
extends Recipe {
    @Option(displayName="Method pattern", description="A method pattern that is used to find matching method invocations.", example="java.io.File mkdir*()")
    private final String methodPattern;
    @Option(displayName="Match on overrides", description="When enabled, find methods that are overrides of the method pattern.", required=false)
    @Nullable
    private final Boolean matchOverrides;

    public String getDisplayName() {
        return "Result of method call ignored";
    }

    public String getDescription() {
        return "Find locations where the result of the method call is being ignored.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final MethodMatcher methodMatcher = new MethodMatcher(this.methodPattern, this.matchOverrides);
        return new JavaIsoVisitor<ExecutionContext>(){

            @Override
            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J m = super.visitMethodInvocation(method, ctx);
                if (methodMatcher.matches(method) && this.getCursor().getParentTreeCursor().getValue() instanceof J.Block) {
                    m = (J.MethodInvocation)SearchResult.found((Tree)m);
                }
                return m;
            }
        };
    }

    @Generated
    public ResultOfMethodCallIgnored(String methodPattern, @Nullable Boolean matchOverrides) {
        this.methodPattern = methodPattern;
        this.matchOverrides = matchOverrides;
    }

    @Generated
    public String getMethodPattern() {
        return this.methodPattern;
    }

    @Nullable
    @Generated
    public Boolean getMatchOverrides() {
        return this.matchOverrides;
    }

    @NonNull
    @Generated
    public String toString() {
        return "ResultOfMethodCallIgnored(methodPattern=" + this.getMethodPattern() + ", matchOverrides=" + this.getMatchOverrides() + ")";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ResultOfMethodCallIgnored)) {
            return false;
        }
        ResultOfMethodCallIgnored other = (ResultOfMethodCallIgnored)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$matchOverrides = this.getMatchOverrides();
        Boolean other$matchOverrides = other.getMatchOverrides();
        if (this$matchOverrides == null ? other$matchOverrides != null : !((Object)this$matchOverrides).equals(other$matchOverrides)) {
            return false;
        }
        String this$methodPattern = this.getMethodPattern();
        String other$methodPattern = other.getMethodPattern();
        return !(this$methodPattern == null ? other$methodPattern != null : !this$methodPattern.equals(other$methodPattern));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ResultOfMethodCallIgnored;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $matchOverrides = this.getMatchOverrides();
        result = result * 59 + ($matchOverrides == null ? 43 : ((Object)$matchOverrides).hashCode());
        String $methodPattern = this.getMethodPattern();
        result = result * 59 + ($methodPattern == null ? 43 : $methodPattern.hashCode());
        return result;
    }
}

