/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.search;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.marker.SearchResult;

public final class FindEmptyMethods
extends Recipe {
    @Option(displayName="Match on overrides", description="When enabled, find methods that are overrides of the method pattern.", required=false)
    @Nullable
    private final Boolean matchOverrides;

    public String getDisplayName() {
        return "Find methods with empty bodies";
    }

    public String getDescription() {
        return "Find methods with empty bodies and single public no arg constructors.";
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-S1186");
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){

            @Override
            public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext ctx) {
                if (classDecl.hasModifier(J.Modifier.Type.Abstract)) {
                    return classDecl;
                }
                if (this.hasSinglePublicNoArgsConstructor(classDecl.getBody().getStatements())) {
                    this.getCursor().putMessage("CHECK_CONSTRUCTOR", (Object)true);
                }
                return super.visitClassDeclaration(classDecl, ctx);
            }

            @Override
            public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, ExecutionContext ctx) {
                Boolean checkConstructor = null;
                if (method.isConstructor()) {
                    checkConstructor = this.getCursor().getNearestMessage("CHECK_CONSTRUCTOR") != null;
                }
                if (checkConstructor != null && checkConstructor.booleanValue() || this.isEmptyMethod(method)) {
                    method = (J.MethodDeclaration)SearchResult.found((Tree)method);
                }
                return super.visitMethodDeclaration(method, ctx);
            }

            private boolean isEmptyMethod(J.MethodDeclaration method) {
                return !method.isConstructor() && !this.isInterfaceMethod(method) && (FindEmptyMethods.this.matchOverrides == null || FindEmptyMethods.this.matchOverrides == false && !TypeUtils.isOverride(method.getMethodType()) || FindEmptyMethods.this.matchOverrides != false) && (method.getBody() == null || method.getBody().getStatements().isEmpty() && method.getBody().getEnd().getComments().isEmpty());
            }

            private boolean isInterfaceMethod(J.MethodDeclaration method) {
                return method.getMethodType().getDeclaringType() != null && method.getMethodType().getDeclaringType().getKind() == JavaType.FullyQualified.Kind.Interface && !method.hasModifier(J.Modifier.Type.Default);
            }

            private boolean hasSinglePublicNoArgsConstructor(List<Statement> classStatements) {
                List constructors = classStatements.stream().filter(o -> o instanceof J.MethodDeclaration).map(o -> (J.MethodDeclaration)o).filter(J.MethodDeclaration::isConstructor).collect(Collectors.toList());
                return constructors.size() == 1 && ((J.MethodDeclaration)constructors.get(0)).hasModifier(J.Modifier.Type.Public) && ((J.MethodDeclaration)constructors.get(0)).getParameters().size() == 1 && ((J.MethodDeclaration)constructors.get(0)).getParameters().get(0) instanceof J.Empty;
            }
        };
    }

    @Generated
    public FindEmptyMethods(@Nullable Boolean matchOverrides) {
        this.matchOverrides = matchOverrides;
    }

    @Nullable
    @Generated
    public Boolean getMatchOverrides() {
        return this.matchOverrides;
    }

    @NonNull
    @Generated
    public String toString() {
        return "FindEmptyMethods(matchOverrides=" + this.getMatchOverrides() + ")";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindEmptyMethods)) {
            return false;
        }
        FindEmptyMethods other = (FindEmptyMethods)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$matchOverrides = this.getMatchOverrides();
        Boolean other$matchOverrides = other.getMatchOverrides();
        return !(this$matchOverrides == null ? other$matchOverrides != null : !((Object)this$matchOverrides).equals(other$matchOverrides));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof FindEmptyMethods;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $matchOverrides = this.getMatchOverrides();
        result = result * 59 + ($matchOverrides == null ? 43 : ((Object)$matchOverrides).hashCode());
        return result;
    }
}

