/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.search;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.AnnotationMatcher;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.marker.SearchResult;

public final class FindAnnotations
extends Recipe {
    @Option(displayName="Annotation pattern", description="An annotation pattern, expressed as a method pattern.", example="@java.lang.SuppressWarnings(\"deprecation\")")
    private final String annotationPattern;
    @Option(displayName="Match on meta annotations", description="When enabled, matches on meta annotations of the annotation pattern.", required=false)
    @Nullable
    private final Boolean matchMetaAnnotations;

    public String getDisplayName() {
        return "Find annotations";
    }

    public String getDescription() {
        return "Find all annotations matching the annotation pattern.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final AnnotationMatcher annotationMatcher = new AnnotationMatcher(this.annotationPattern, this.matchMetaAnnotations);
        return Preconditions.check((TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J visit(@Nullable Tree tree, ExecutionContext ctx) {
                if (tree instanceof JavaSourceFile) {
                    JavaSourceFile cu = (JavaSourceFile)Objects.requireNonNull(tree);
                    for (JavaType type : cu.getTypesInUse().getTypesInUse()) {
                        if (!annotationMatcher.matchesAnnotationOrMetaAnnotation(TypeUtils.asFullyQualified(type))) continue;
                        return (J)SearchResult.found((Tree)cu);
                    }
                }
                return (J)super.visit(tree, (Object)ctx);
            }

            @Override
            public J.Annotation visitAnnotation(J.Annotation annotation, ExecutionContext ctx) {
                J a = super.visitAnnotation(annotation, ctx);
                if (annotationMatcher.matches(annotation)) {
                    a = (J.Annotation)SearchResult.found((Tree)a);
                }
                return a;
            }
        }, (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            @Override
            public J.Annotation visitAnnotation(J.Annotation annotation, ExecutionContext ctx) {
                J a = super.visitAnnotation(annotation, ctx);
                if (annotationMatcher.matches(annotation)) {
                    a = (J.Annotation)SearchResult.found((Tree)a);
                }
                return a;
            }
        });
    }

    public static Set<J.Annotation> find(J j, String annotationPattern) {
        return FindAnnotations.find(j, annotationPattern, false);
    }

    public static Set<J.Annotation> find(J j, String annotationPattern, boolean matchMetaAnnotations) {
        return ((HashSet)TreeVisitor.collect(new FindAnnotations(annotationPattern, matchMetaAnnotations).getVisitor(), (Tree)j, new HashSet())).stream().filter(a -> a instanceof J.Annotation).map(a -> (J.Annotation)a).collect(Collectors.toSet());
    }

    @Generated
    public FindAnnotations(String annotationPattern, @Nullable Boolean matchMetaAnnotations) {
        this.annotationPattern = annotationPattern;
        this.matchMetaAnnotations = matchMetaAnnotations;
    }

    @Generated
    public String getAnnotationPattern() {
        return this.annotationPattern;
    }

    @Nullable
    @Generated
    public Boolean getMatchMetaAnnotations() {
        return this.matchMetaAnnotations;
    }

    @NonNull
    @Generated
    public String toString() {
        return "FindAnnotations(annotationPattern=" + this.getAnnotationPattern() + ", matchMetaAnnotations=" + this.getMatchMetaAnnotations() + ")";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindAnnotations)) {
            return false;
        }
        FindAnnotations other = (FindAnnotations)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$matchMetaAnnotations = this.getMatchMetaAnnotations();
        Boolean other$matchMetaAnnotations = other.getMatchMetaAnnotations();
        if (this$matchMetaAnnotations == null ? other$matchMetaAnnotations != null : !((Object)this$matchMetaAnnotations).equals(other$matchMetaAnnotations)) {
            return false;
        }
        String this$annotationPattern = this.getAnnotationPattern();
        String other$annotationPattern = other.getAnnotationPattern();
        return !(this$annotationPattern == null ? other$annotationPattern != null : !this$annotationPattern.equals(other$annotationPattern));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof FindAnnotations;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $matchMetaAnnotations = this.getMatchMetaAnnotations();
        result = result * 59 + ($matchMetaAnnotations == null ? 43 : ((Object)$matchMetaAnnotations).hashCode());
        String $annotationPattern = this.getAnnotationPattern();
        result = result * 59 + ($annotationPattern == null ? 43 : $annotationPattern.hashCode());
        return result;
    }
}

