/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.recipes;

import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.marker.SearchResult;

public class MissingOptionExample
extends Recipe {
    public String getDisplayName() {
        return "Find missing `@Option` `example` values";
    }

    public String getDescription() {
        return "Find `@Option` annotations that are missing `example` values for documentation.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check(new UsesType("org.openrewrite.Option", false), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            @Override
            public J.Annotation visitAnnotation(J.Annotation annotation, ExecutionContext executionContext) {
                J.VariableDeclarations variableDeclarations;
                J an = super.visitAnnotation(annotation, executionContext);
                if (!TypeUtils.isOfClassType(annotation.getType(), "org.openrewrite.Option") || ((J.Annotation)an).getArguments() == null) {
                    return an;
                }
                boolean hasExample = ((J.Annotation)an).getArguments().stream().anyMatch(exp -> {
                    Expression variable;
                    if (exp instanceof J.Assignment && (variable = ((J.Assignment)exp).getVariable()) instanceof J.Identifier) {
                        String simpleName = ((J.Identifier)variable).getSimpleName();
                        return "example".equals(simpleName) || "valid".equals(simpleName);
                    }
                    return false;
                });
                if (hasExample) {
                    return an;
                }
                Cursor parent = this.getCursor().getParent();
                if (parent != null && parent.getValue() instanceof J.VariableDeclarations && (variableDeclarations = (J.VariableDeclarations)parent.getValue()).getTypeExpression() != null && TypeUtils.isOfClassType(variableDeclarations.getTypeExpression().getType(), "java.lang.Boolean")) {
                    return an;
                }
                return (J.Annotation)SearchResult.found((Tree)an, (String)"Missing example value for documentation");
            }
        });
    }
}

