/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.util.Collections;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Tree;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.cleanup.UnnecessaryParenthesesVisitor;
import org.openrewrite.java.search.SemanticallyEqual;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;

public class SimplifyBooleanExpressionVisitor
extends JavaVisitor<ExecutionContext> {
    private final MethodMatcher isEmpty = new MethodMatcher("java.lang.String isEmpty()");

    @Override
    public J visitBinary(J.Binary binary, ExecutionContext ctx) {
        J j = super.visitBinary(binary, ctx);
        J.Binary asBinary = (J.Binary)j;
        if (asBinary.getOperator() == J.Binary.Type.And) {
            if (this.isLiteralFalse(asBinary.getLeft())) {
                j = asBinary.getLeft();
            } else if (this.isLiteralFalse(asBinary.getRight())) {
                j = asBinary.getRight().withPrefix(asBinary.getRight().getPrefix().withWhitespace(""));
            } else if (this.isLiteralTrue(asBinary.getLeft())) {
                j = asBinary.getRight();
            } else if (this.isLiteralTrue(asBinary.getRight())) {
                j = asBinary.getLeft().withPrefix(asBinary.getLeft().getPrefix().withWhitespace(""));
            } else if (!(asBinary.getLeft() instanceof MethodCall) && SemanticallyEqual.areEqual(asBinary.getLeft(), asBinary.getRight())) {
                j = asBinary.getLeft();
            }
        } else if (asBinary.getOperator() == J.Binary.Type.Or) {
            if (this.isLiteralTrue(asBinary.getLeft())) {
                j = asBinary.getLeft();
            } else if (this.isLiteralTrue(asBinary.getRight())) {
                j = asBinary.getRight().withPrefix(asBinary.getRight().getPrefix().withWhitespace(""));
            } else if (this.isLiteralFalse(asBinary.getLeft())) {
                j = asBinary.getRight();
            } else if (this.isLiteralFalse(asBinary.getRight())) {
                j = asBinary.getLeft().withPrefix(asBinary.getLeft().getPrefix().withWhitespace(""));
            } else if (!(asBinary.getLeft() instanceof MethodCall) && SemanticallyEqual.areEqual(asBinary.getLeft(), asBinary.getRight())) {
                j = asBinary.getLeft();
            }
        } else if (asBinary.getOperator() == J.Binary.Type.Equal) {
            if (this.isLiteralTrue(asBinary.getLeft())) {
                if (this.shouldSimplifyEqualsOn(asBinary.getRight())) {
                    j = asBinary.getRight().withPrefix(asBinary.getRight().getPrefix().withWhitespace(""));
                }
            } else if (this.isLiteralTrue(asBinary.getRight())) {
                if (this.shouldSimplifyEqualsOn(asBinary.getLeft())) {
                    j = asBinary.getLeft().withPrefix(asBinary.getLeft().getPrefix().withWhitespace(" "));
                }
            } else {
                j = this.maybeReplaceCompareWithNull(asBinary, true);
            }
        } else if (asBinary.getOperator() == J.Binary.Type.NotEqual) {
            if (this.isLiteralFalse(asBinary.getLeft())) {
                if (this.shouldSimplifyEqualsOn(asBinary.getRight())) {
                    j = asBinary.getRight().withPrefix(asBinary.getRight().getPrefix().withWhitespace(""));
                }
            } else if (this.isLiteralFalse(asBinary.getRight())) {
                if (this.shouldSimplifyEqualsOn(asBinary.getLeft())) {
                    j = asBinary.getLeft().withPrefix(asBinary.getLeft().getPrefix().withWhitespace(" "));
                }
            } else {
                j = this.maybeReplaceCompareWithNull(asBinary, false);
            }
        }
        if (asBinary != j) {
            j = j.withPrefix(asBinary.getPrefix());
        }
        return j;
    }

    @Override
    public <T extends J> J visitParentheses(J.Parentheses<T> parens, ExecutionContext ctx) {
        J j = super.visitParentheses(parens, ctx);
        if (j != parens && j instanceof J.Parentheses) {
            j = (J)new UnnecessaryParenthesesVisitor().visit(j, ctx, this.getCursor().getParentOrThrow());
        }
        return j;
    }

    @Override
    public J visitUnary(J.Unary unary, ExecutionContext ctx) {
        J j = super.visitUnary(unary, ctx);
        if (j instanceof J.Unary) {
            J.Unary asUnary = (J.Unary)j;
            if (asUnary.getOperator() == J.Unary.Type.Not) {
                j = this.unpackExpression(asUnary.getExpression(), j);
            }
            if (asUnary != j) {
                j = j.withPrefix(asUnary.getPrefix());
            }
        }
        return j;
    }

    private J unpackExpression(Expression expr, J j) {
        if (this.isLiteralTrue(expr)) {
            j = ((J.Literal)expr).withValue(false).withValueSource("false");
        } else if (this.isLiteralFalse(expr)) {
            j = ((J.Literal)expr).withValue(true).withValueSource("true");
        } else if (expr instanceof J.Unary && ((J.Unary)expr).getOperator() == J.Unary.Type.Not) {
            j = ((J.Unary)expr).getExpression();
        } else if (expr instanceof J.Parentheses) {
            Object parenthesized = ((J.Parentheses)expr).getTree();
            if (parenthesized instanceof J.Binary) {
                J.Binary binary = (J.Binary)parenthesized;
                J.Binary.Type negated = this.negate(binary.getOperator());
                if (negated != binary.getOperator()) {
                    j = binary.withOperator(negated).withPrefix(j.getPrefix());
                }
            } else if (parenthesized instanceof J.Unary) {
                J.Unary unary1 = (J.Unary)parenthesized;
                J.Unary.Type operator = unary1.getOperator();
                if (operator == J.Unary.Type.Not) {
                    j = unary1.getExpression().withPrefix(j.getPrefix());
                }
            } else if (parenthesized instanceof Expression) {
                j = this.unpackExpression((Expression)parenthesized, j);
            }
        }
        return j;
    }

    private J.Binary.Type negate(J.Binary.Type operator) {
        switch (operator) {
            case LessThan: {
                return J.Binary.Type.GreaterThanOrEqual;
            }
            case GreaterThan: {
                return J.Binary.Type.LessThanOrEqual;
            }
            case LessThanOrEqual: {
                return J.Binary.Type.GreaterThan;
            }
            case GreaterThanOrEqual: {
                return J.Binary.Type.LessThan;
            }
            case Equal: {
                return J.Binary.Type.NotEqual;
            }
            case NotEqual: {
                return J.Binary.Type.Equal;
            }
        }
        return operator;
    }

    @Override
    public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext executionContext) {
        J j = super.visitMethodInvocation(method, executionContext);
        J.MethodInvocation asMethod = (J.MethodInvocation)j;
        Expression select = asMethod.getSelect();
        if (this.isEmpty.matches(asMethod) && select instanceof J.Literal && select.getType() == JavaType.Primitive.String) {
            return this.booleanLiteral(method, J.Literal.isLiteralValue(select, ""));
        }
        return j;
    }

    private boolean isLiteralTrue(@Nullable Expression expression) {
        return expression instanceof J.Literal && ((J.Literal)expression).getValue() == Boolean.valueOf(true);
    }

    private boolean isLiteralFalse(@Nullable Expression expression) {
        return expression instanceof J.Literal && ((J.Literal)expression).getValue() == Boolean.valueOf(false);
    }

    private boolean isNullLiteral(Expression expression) {
        return expression instanceof J.Literal && ((J.Literal)expression).getType() == JavaType.Primitive.Null;
    }

    private boolean isNonNullLiteral(Expression expression) {
        return expression instanceof J.Literal && ((J.Literal)expression).getType() != JavaType.Primitive.Null;
    }

    private J maybeReplaceCompareWithNull(J.Binary asBinary, boolean valueIfEqual) {
        Expression left = asBinary.getLeft();
        Expression right = asBinary.getRight();
        boolean leftIsNull = this.isNullLiteral(left);
        boolean rightIsNull = this.isNullLiteral(right);
        if (leftIsNull && rightIsNull) {
            return this.booleanLiteral(asBinary, valueIfEqual);
        }
        boolean leftIsNonNullLiteral = this.isNonNullLiteral(left);
        boolean rightIsNonNullLiteral = this.isNonNullLiteral(right);
        if (leftIsNull && rightIsNonNullLiteral || rightIsNull && leftIsNonNullLiteral) {
            return this.booleanLiteral(asBinary, !valueIfEqual);
        }
        return asBinary;
    }

    private J.Literal booleanLiteral(J j, boolean value) {
        return new J.Literal(Tree.randomId(), j.getPrefix(), j.getMarkers(), value, String.valueOf(value), Collections.emptyList(), JavaType.Primitive.Boolean);
    }

    protected boolean shouldSimplifyEqualsOn(J j) {
        return true;
    }
}

