/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.openrewrite.Cursor;
import org.openrewrite.Tree;
import org.openrewrite.internal.PropertyPlaceholderHelper;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.internal.grammar.TemplateParameterLexer;
import org.openrewrite.java.internal.grammar.TemplateParameterParser;
import org.openrewrite.java.search.SemanticallyEqual;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaCoordinates;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.java.tree.TypedTree;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.Markers;

class JavaTemplateSemanticallyEqual
extends SemanticallyEqual {
    JavaTemplateSemanticallyEqual() {
    }

    static TemplateMatchResult matchesTemplate(JavaTemplate template, Cursor input) {
        JavaCoordinates coordinates;
        if (input.getValue() instanceof Expression) {
            coordinates = ((Expression)input.getValue()).getCoordinates().replace();
        } else if (input.getValue() instanceof Statement) {
            coordinates = ((Statement)input.getValue()).getCoordinates().replace();
        } else {
            throw new IllegalArgumentException("Only expressions and statements can be matched against a template: " + input.getClass());
        }
        J[] parameters = JavaTemplateSemanticallyEqual.createTemplateParameters(template.getCode());
        try {
            Object templateTree = template.apply(input, coordinates, (Object[])parameters);
            return JavaTemplateSemanticallyEqual.matchTemplate(templateTree, input);
        }
        catch (RuntimeException e) {
            return new TemplateMatchResult(false, Collections.emptyList());
        }
    }

    private static J[] createTemplateParameters(String code) {
        String previous;
        PropertyPlaceholderHelper propertyPlaceholderHelper = new PropertyPlaceholderHelper("#{", "}", null);
        ArrayList parameters = new ArrayList();
        String substituted = code;
        HashMap typedPatternByName = new HashMap();
        while (!(previous = substituted).equals(substituted = propertyPlaceholderHelper.replacePlaceholders(substituted, key -> {
            String s;
            if (!key.isEmpty()) {
                TemplateParameterParser parser = new TemplateParameterParser((TokenStream)new CommonTokenStream((TokenSource)new TemplateParameterLexer((CharStream)CharStreams.fromString((String)key))));
                parser.removeErrorListeners();
                parser.addErrorListener((ANTLRErrorListener)new BaseErrorListener(){

                    public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
                        throw new IllegalArgumentException(String.format("Syntax error at line %d:%d %s.", line, charPositionInLine, msg), (Throwable)e);
                    }
                });
                TemplateParameterParser.MatcherPatternContext ctx = parser.matcherPattern();
                if (ctx.typedPattern() == null) {
                    String paramName = ctx.parameterName().Identifier().getText();
                    s = (String)typedPatternByName.get(paramName);
                    if (s == null) {
                        throw new IllegalArgumentException("The parameter " + paramName + " must be defined before it is referenced.");
                    }
                } else {
                    TemplateParameterParser.TypedPatternContext typedPattern = ctx.typedPattern();
                    s = JavaTemplateSemanticallyEqual.typedParameter(key, typedPattern);
                    String name = null;
                    if (typedPattern.parameterName() != null) {
                        name = typedPattern.parameterName().Identifier().getText();
                        typedPatternByName.put(name, s);
                    }
                    Markers markers = Markers.build(Collections.singleton(new TemplateParameter(Tree.randomId(), s, name)));
                    parameters.add(new J.Empty(Tree.randomId(), Space.EMPTY, markers));
                }
            } else {
                throw new IllegalArgumentException("Only typed placeholders are allowed.");
            }
            return s;
        }))) {
        }
        return parameters.toArray(new J[0]);
    }

    private static String typedParameter(String key, TemplateParameterParser.TypedPatternContext typedPattern) {
        String matcherName = typedPattern.patternType().matcherName().Identifier().getText();
        List<TemplateParameterParser.MatcherParameterContext> params = typedPattern.patternType().matcherParameter();
        if ("any".equals(matcherName)) {
            String fqn = params.size() == 1 ? (params.get(0).Identifier() != null ? params.get(0).Identifier().getText() : params.get(0).FullyQualifiedName().getText()) : "java.lang.Object";
            return fqn.replace("$", ".");
        }
        throw new IllegalArgumentException("Invalid template matcher '" + key + "'");
    }

    private static TemplateMatchResult matchTemplate(J templateTree, Cursor cursor) {
        if (templateTree == cursor.getValue()) {
            return new TemplateMatchResult(false, Collections.emptyList());
        }
        JavaTemplateSemanticallyEqualVisitor semanticallyEqualVisitor = new JavaTemplateSemanticallyEqualVisitor();
        semanticallyEqualVisitor.visit(templateTree, (J)cursor.getValue(), cursor.getParentOrThrow());
        return new TemplateMatchResult(semanticallyEqualVisitor.isEqual(), new ArrayList<J>(semanticallyEqualVisitor.matchedParameters.keySet()));
    }

    static final class TemplateMatchResult {
        private final boolean match;
        private final List<J> matchedParameters;

        public TemplateMatchResult(boolean match, List<J> matchedParameters) {
            this.match = match;
            this.matchedParameters = matchedParameters;
        }

        public boolean isMatch() {
            return this.match;
        }

        public List<J> getMatchedParameters() {
            return this.matchedParameters;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TemplateMatchResult)) {
                return false;
            }
            TemplateMatchResult other = (TemplateMatchResult)o;
            if (this.isMatch() != other.isMatch()) {
                return false;
            }
            List<J> this$matchedParameters = this.getMatchedParameters();
            List<J> other$matchedParameters = other.getMatchedParameters();
            return !(this$matchedParameters == null ? other$matchedParameters != null : !((Object)this$matchedParameters).equals(other$matchedParameters));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isMatch() ? 79 : 97);
            List<J> $matchedParameters = this.getMatchedParameters();
            result = result * 59 + ($matchedParameters == null ? 43 : ((Object)$matchedParameters).hashCode());
            return result;
        }

        @NonNull
        public String toString() {
            return "JavaTemplateSemanticallyEqual.TemplateMatchResult(match=" + this.isMatch() + ", matchedParameters=" + this.getMatchedParameters() + ")";
        }
    }

    private static class JavaTemplateSemanticallyEqualVisitor
    extends SemanticallyEqual.SemanticallyEqualVisitor {
        final Map<J, String> matchedParameters = new LinkedHashMap<J, String>();

        public JavaTemplateSemanticallyEqualVisitor() {
            super(true);
        }

        private boolean matchTemplateParameterPlaceholder(J.Empty empty, J j) {
            if (j instanceof TypedTree && !(j instanceof J.Primitive)) {
                TemplateParameter marker = (TemplateParameter)empty.getMarkers().getMarkers().get(0);
                if (marker.name != null) {
                    for (Map.Entry<J, String> matchedParameter : this.matchedParameters.entrySet()) {
                        if (!matchedParameter.getValue().equals(marker.name) || SemanticallyEqual.areEqual(matchedParameter.getKey(), j)) continue;
                        return false;
                    }
                }
                if ("java.lang.Object".equals(marker.typeName) || TypeUtils.isAssignableTo(marker.typeName, ((TypedTree)j).getType())) {
                    this.registerMatch(j, marker.name);
                    return true;
                }
            }
            return false;
        }

        private void registerMatch(J j, @Nullable String name) {
            this.matchedParameters.put(j, name);
        }

        @Override
        public J.Empty visitEmpty(J.Empty empty, J j) {
            if (this.isEqual.get()) {
                if (JavaTemplateSemanticallyEqualVisitor.isTemplateParameterPlaceholder(empty)) {
                    this.isEqual.set(this.matchTemplateParameterPlaceholder(empty, j));
                    return empty;
                }
                if (!(j instanceof J.Empty)) {
                    this.isEqual.set(false);
                    return empty;
                }
                J.Empty compareTo = (J.Empty)j;
                if (this.nullMissMatch(empty.getType(), compareTo.getType())) {
                    this.isEqual.set(false);
                    return empty;
                }
            }
            return empty;
        }

        private static boolean isTemplateParameterPlaceholder(J.Empty empty) {
            Markers markers = empty.getMarkers();
            return markers.getMarkers().size() == 1 && markers.getMarkers().get(0) instanceof TemplateParameter;
        }
    }

    private static final class TemplateParameter
    implements Marker {
        private final UUID id;
        private final String typeName;
        @Nullable
        private final String name;

        public TemplateParameter(UUID id, String typeName, @Nullable String name) {
            this.id = id;
            this.typeName = typeName;
            this.name = name;
        }

        public UUID getId() {
            return this.id;
        }

        public String getTypeName() {
            return this.typeName;
        }

        @Nullable
        public String getName() {
            return this.name;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TemplateParameter)) {
                return false;
            }
            TemplateParameter other = (TemplateParameter)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
                return false;
            }
            String this$typeName = this.getTypeName();
            String other$typeName = other.getTypeName();
            if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            return !(this$name == null ? other$name != null : !this$name.equals(other$name));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            String $typeName = this.getTypeName();
            result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            return result;
        }

        @NonNull
        public String toString() {
            return "JavaTemplateSemanticallyEqual.TemplateParameter(id=" + this.getId() + ", typeName=" + this.getTypeName() + ", name=" + this.getName() + ")";
        }

        @NonNull
        public TemplateParameter withId(UUID id) {
            return this.id == id ? this : new TemplateParameter(id, this.typeName, this.name);
        }

        @NonNull
        public TemplateParameter withTypeName(String typeName) {
            return this.typeName == typeName ? this : new TemplateParameter(this.id, typeName, this.name);
        }

        @NonNull
        public TemplateParameter withName(@Nullable String name) {
            return this.name == name ? this : new TemplateParameter(this.id, this.typeName, name);
        }
    }
}

