/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.recipes;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.Space;

public class UseJavaParserBuilderInJavaTemplate
extends Recipe {
    public String getDisplayName() {
        return "Use `JavaParser.Builder` when constructing `JavaTemplate`";
    }

    public String getDescription() {
        return "Because we can now clone `JavaParser.Builder`, there is no need to fully build the parser inside a `Supplier<JavaParser>`. This also makes room for `JavaTemplate` to add shared `JavaTypeCache` implementations to parsers used to compile templates.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final MethodMatcher SUPPLIER_BASED_JAVA_PARSER = new MethodMatcher("org.openrewrite.java.JavaTemplate$Builder javaParser(java.util.function.Supplier)");
        final MethodMatcher JAVA_PARSER_BUILD = new MethodMatcher("org.openrewrite.java.JavaParser$Builder build()");
        return Preconditions.check(new UsesMethod(SUPPLIER_BASED_JAVA_PARSER), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            @Override
            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J m = super.visitMethodInvocation(method, ctx);
                if (SUPPLIER_BASED_JAVA_PARSER.matches((J.MethodInvocation)m)) {
                    final AtomicReference builder = new AtomicReference();
                    new JavaIsoVisitor<Integer>(){

                        @Override
                        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, Integer p) {
                            if (JAVA_PARSER_BUILD.matches(method)) {
                                builder.set((J.MethodInvocation)Objects.requireNonNull(method.getSelect()).withPrefix(Space.EMPTY));
                            }
                            return super.visitMethodInvocation(method, p);
                        }
                    }.visit(((J.MethodInvocation)m).getArguments().get(0), 0);
                    if (builder.get() != null) {
                        m = ((J.MethodInvocation)m).withArguments((List)Collections.singletonList((Expression)builder.get()));
                    }
                }
                return m;
            }
        });
    }
}

