/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.search;

import java.util.Objects;
import java.util.regex.Pattern;
import org.openrewrite.Tree;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.Flag;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.marker.SearchResult;

public class UsesType<P>
extends JavaIsoVisitor<P> {
    private final Pattern typePattern;
    @Nullable
    private final Boolean includeImplicit;

    public UsesType(String fullyQualifiedType, @Nullable Boolean includeImplicit) {
        this.typePattern = Pattern.compile(StringUtils.aspectjNameToPattern((String)fullyQualifiedType));
        this.includeImplicit = includeImplicit;
    }

    public J visit(@Nullable Tree tree, P p) {
        if (tree instanceof JavaSourceFile) {
            JavaSourceFile cu;
            JavaSourceFile c = cu = (JavaSourceFile)Objects.requireNonNull(tree);
            for (JavaType.Method method : c.getTypesInUse().getUsedMethods()) {
                if ((Boolean.TRUE.equals(this.includeImplicit) || method.hasFlags(Flag.Static)) && (c = this.maybeMark(c, method.getDeclaringType())) != cu) {
                    return c;
                }
                if (!Boolean.TRUE.equals(this.includeImplicit)) continue;
                if ((c = this.maybeMark(c, method.getReturnType())) != cu) {
                    return c;
                }
                for (JavaType parameterType : method.getParameterTypes()) {
                    if ((c = this.maybeMark(c, parameterType)) == cu) continue;
                    return c;
                }
            }
            for (JavaType type : c.getTypesInUse().getTypesInUse()) {
                JavaType checkType = type instanceof JavaType.Primitive ? type : TypeUtils.asFullyQualified(type);
                if ((c = this.maybeMark(c, checkType)) == cu) continue;
                return c;
            }
            for (J.Import anImport : c.getImports()) {
                if (!(anImport.isStatic() ? (c = this.maybeMark(c, TypeUtils.asFullyQualified(anImport.getQualid().getTarget().getType()))) != cu : (c = this.maybeMark(c, TypeUtils.asFullyQualified(anImport.getQualid().getType()))) != cu)) continue;
                return c;
            }
        }
        return (J)tree;
    }

    private JavaSourceFile maybeMark(JavaSourceFile c, @Nullable JavaType type) {
        if (type == null) {
            return c;
        }
        if (TypeUtils.isAssignableTo(this.typePattern, type)) {
            return (JavaSourceFile)SearchResult.found((Tree)c);
        }
        return c;
    }
}

