/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.IdentityHashMap;
import org.openrewrite.ExecutionContext;
import org.openrewrite.InMemoryExecutionContext;
import org.openrewrite.Incubating;
import org.openrewrite.PrintOutputCapture;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaPrinter;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.Space;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.Range;

@Incubating(since="7.18.0")
public class UpdateSourcePositions
extends Recipe {
    public String getDisplayName() {
        return "Update source positions";
    }

    public String getDescription() {
        return "Calculate start position and length for every LST element.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final IdentityHashMap positionMap = new IdentityHashMap();
        final PositionPrintOutputCapture ppoc = new PositionPrintOutputCapture();
        final JavaPrinter<ExecutionContext> printer = new JavaPrinter<ExecutionContext>(){
            final JavaPrinter<ExecutionContext> spacePrinter = new JavaPrinter();

            @Nullable
            public J visit(@Nullable Tree tree, PrintOutputCapture<ExecutionContext> outputCapture) {
                if (tree == null) {
                    return null;
                }
                J t = (J)tree;
                PositionPrintOutputCapture prefix = new PositionPrintOutputCapture(ppoc.pos, ppoc.line, ppoc.column);
                this.spacePrinter.visitSpace(t.getPrefix(), Space.Location.ANY, prefix);
                Range.Position startPosition = new Range.Position(prefix.pos, prefix.line, prefix.column);
                t = (J)super.visit(tree, outputCapture);
                Range.Position endPosition = new Range.Position(ppoc.pos, ppoc.line, ppoc.column);
                positionMap.put(t, new Range(Tree.randomId(), startPosition, endPosition));
                return t;
            }

            @Override
            protected void visitModifier(J.Modifier modifier, PrintOutputCapture<ExecutionContext> p) {
                if (modifier == null) {
                    return;
                }
                PositionPrintOutputCapture prefix = new PositionPrintOutputCapture(ppoc.pos, ppoc.line, ppoc.column);
                this.spacePrinter.visitSpace(modifier.getPrefix(), Space.Location.ANY, prefix);
                Range.Position startPosition = new Range.Position(prefix.pos, prefix.line, prefix.column);
                super.visitModifier(modifier, p);
                Range.Position endPosition = new Range.Position(ppoc.pos, ppoc.line, ppoc.column);
                positionMap.put(modifier, new Range(Tree.randomId(), startPosition, endPosition));
            }
        };
        return new JavaVisitor<ExecutionContext>(){
            boolean firstVisit = true;

            @Nullable
            public J visit(@Nullable Tree tree, ExecutionContext ctx) {
                Range range;
                if (tree == null) {
                    return null;
                }
                if (this.firstVisit) {
                    tree = printer.visit(tree, (Object)ppoc);
                    this.firstVisit = false;
                }
                if ((range = (Range)positionMap.get(tree)) != null) {
                    J t = (J)tree.withMarkers(tree.getMarkers().add((Marker)range));
                    return (J)super.visit((Tree)t, (Object)ctx);
                }
                return (J)super.visit(tree, (Object)ctx);
            }
        };
    }

    private static class PositionPrintOutputCapture
    extends PrintOutputCapture<ExecutionContext> {
        int pos = 0;
        int line = 1;
        int column = 0;
        private boolean lineBoundary;

        public PositionPrintOutputCapture() {
            super((Object)new InMemoryExecutionContext());
        }

        public PositionPrintOutputCapture(int pos, int line, int column) {
            this();
            this.pos = pos;
            this.line = line;
            this.column = column;
        }

        public PrintOutputCapture<ExecutionContext> append(char c) {
            ++this.pos;
            if (this.lineBoundary) {
                ++this.line;
                this.column = 0;
                this.lineBoundary = false;
            } else {
                ++this.column;
            }
            if (c == '\n') {
                this.lineBoundary = true;
            }
            return this;
        }

        public PrintOutputCapture<ExecutionContext> append(@Nullable String text) {
            if (text != null) {
                if (this.lineBoundary) {
                    ++this.line;
                    this.column = 0;
                    this.lineBoundary = false;
                }
                int length = text.length();
                this.pos += length;
                int numberOfLines = 0;
                int indexOfLastNewLine = -1;
                for (int i = 0; i < length; ++i) {
                    if (text.charAt(i) != '\n') continue;
                    indexOfLastNewLine = i;
                    ++numberOfLines;
                }
                if (numberOfLines > 0) {
                    this.line += numberOfLines;
                    this.column = length - indexOfLastNewLine;
                } else {
                    this.column += length;
                }
            }
            return this;
        }
    }
}

