/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.style;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.openrewrite.internal.StreamUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaStyle;
import org.openrewrite.java.style.Deserializer;
import org.openrewrite.java.style.Serializer;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.Space;

@JsonDeserialize(using=Deserializer.class)
@JsonSerialize(using=Serializer.class)
public class ImportLayoutStyle
implements JavaStyle {
    private final int classCountToUseStarImport;
    private final int nameCountToUseStarImport;
    private final List<Block> layout;
    private final List<Block> blocksNoCatchalls;
    private final List<Block> blocksOnlyCatchalls;

    public ImportLayoutStyle(int classCountToUseStarImport, int nameCountToUseStarImport, List<Block> layout) {
        this.classCountToUseStarImport = classCountToUseStarImport;
        this.nameCountToUseStarImport = nameCountToUseStarImport;
        this.layout = layout;
        Map<Boolean, List<Block>> blockGroups = layout.stream().collect(Collectors.partitioningBy(block -> block instanceof Block.AllOthers));
        this.blocksNoCatchalls = blockGroups.get(false);
        this.blocksOnlyCatchalls = blockGroups.get(true);
    }

    public List<JRightPadded<J.Import>> orderImports(List<JRightPadded<J.Import>> originalImports) {
        LayoutState layoutState = new LayoutState();
        ArrayList<JRightPadded<J.Import>> orderedImports = new ArrayList<JRightPadded<J.Import>>();
        for (JRightPadded<J.Import> anImport : originalImports) {
            boolean accepted = false;
            for (Block block : this.blocksNoCatchalls) {
                if (!block.accept(layoutState, anImport)) continue;
                accepted = true;
                break;
            }
            if (accepted) continue;
            for (Block block : this.blocksOnlyCatchalls) {
                if (block.accept(layoutState, anImport)) break;
            }
        }
        int importIndex = 0;
        String extraLineSpace = "";
        for (Block block : this.layout) {
            if (block instanceof Block.BlankLines) {
                extraLineSpace = "";
                for (int i = 0; i < ((Block.BlankLines)block).getCount(); ++i) {
                    extraLineSpace = extraLineSpace + "\n";
                }
                continue;
            }
            for (JRightPadded<J.Import> orderedImport : block.orderedImports(layoutState, this.classCountToUseStarImport, this.nameCountToUseStarImport)) {
                Space prefix;
                Space space = prefix = importIndex == 0 ? originalImports.get(0).getElement().getPrefix() : orderedImport.getElement().getPrefix().withWhitespace(extraLineSpace + "\n");
                if (!orderedImport.getElement().getPrefix().equals(prefix)) {
                    orderedImports.add(orderedImport.withElement(orderedImport.getElement().withPrefix(prefix)));
                } else {
                    orderedImports.add(orderedImport);
                }
                extraLineSpace = "";
                ++importIndex;
            }
        }
        return orderedImports;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("classWildcards=").append(this.classCountToUseStarImport).append(", staticWildcards=").append(this.nameCountToUseStarImport).append('\n');
        for (Block block : this.layout) {
            s.append(block).append("\n");
        }
        return s.toString();
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ImportLayoutStyle)) {
            return false;
        }
        ImportLayoutStyle other = (ImportLayoutStyle)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getClassCountToUseStarImport() != other.getClassCountToUseStarImport()) {
            return false;
        }
        if (this.getNameCountToUseStarImport() != other.getNameCountToUseStarImport()) {
            return false;
        }
        List<Block> this$layout = this.getLayout();
        List<Block> other$layout = other.getLayout();
        return !(this$layout == null ? other$layout != null : !((Object)this$layout).equals(other$layout));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ImportLayoutStyle;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getClassCountToUseStarImport();
        result = result * 59 + this.getNameCountToUseStarImport();
        List<Block> $layout = this.getLayout();
        result = result * 59 + ($layout == null ? 43 : ((Object)$layout).hashCode());
        return result;
    }

    public int getClassCountToUseStarImport() {
        return this.classCountToUseStarImport;
    }

    public int getNameCountToUseStarImport() {
        return this.nameCountToUseStarImport;
    }

    public List<Block> getLayout() {
        return this.layout;
    }

    public List<Block> getBlocksNoCatchalls() {
        return this.blocksNoCatchalls;
    }

    public List<Block> getBlocksOnlyCatchalls() {
        return this.blocksOnlyCatchalls;
    }

    public static interface Block {
        public boolean accept(LayoutState var1, JRightPadded<J.Import> var2);

        public List<JRightPadded<J.Import>> orderedImports(LayoutState var1, int var2, int var3);

        public static class AllOthers
        extends ImportPackage {
            private final boolean statik;
            private Collection<ImportPackage> packageImports = Collections.emptyList();

            public AllOthers(boolean statik) {
                super(statik, "*", true);
                this.statik = statik;
            }

            public void setPackageImports(Collection<ImportPackage> packageImports) {
                this.packageImports = packageImports;
            }

            @Override
            public boolean isStatic() {
                return this.statik;
            }

            @Override
            public boolean accept(LayoutState layoutState, JRightPadded<J.Import> anImport) {
                boolean b = true;
                for (ImportPackage pi : this.packageImports) {
                    if (!pi.accept(layoutState, anImport)) continue;
                    b = false;
                    break;
                }
                if (b) {
                    super.accept(layoutState, anImport);
                }
                return anImport.getElement().isStatic() == this.statik;
            }

            @Override
            public String toString() {
                return "import " + (this.statik ? "static " : "") + "all other imports";
            }
        }

        public static class ImportPackage
        implements Block {
            static final Comparator<JRightPadded<J.Import>> IMPORT_SORTING = (i1, i2) -> {
                String[] import1 = ((J.Import)i1.getElement()).getQualid().printTrimmed().split("\\.");
                String[] import2 = ((J.Import)i2.getElement()).getQualid().printTrimmed().split("\\.");
                for (int i = 0; i < Math.min(import1.length, import2.length); ++i) {
                    int diff = import1[i].compareTo(import2[i]);
                    if (diff == 0) continue;
                    return diff;
                }
                if (import1.length == import2.length) {
                    return 0;
                }
                return import1.length > import2.length ? 1 : -1;
            };
            private final Boolean statik;
            private final Pattern packageWildcard;

            public ImportPackage(Boolean statik, String packageWildcard, boolean withSubpackages) {
                this.statik = statik;
                this.packageWildcard = Pattern.compile(packageWildcard.replace(".", "\\.").replace("*", withSubpackages ? ".+" : "[^.]+"));
            }

            public boolean isStatic() {
                return this.statik;
            }

            public Pattern getPackageWildcard() {
                return this.packageWildcard;
            }

            @Override
            public boolean accept(LayoutState layoutState, JRightPadded<J.Import> anImport) {
                if (anImport.getElement().isStatic() == this.statik.booleanValue() && this.packageWildcard.matcher(anImport.getElement().getQualid().printTrimmed()).matches()) {
                    layoutState.claimImport(this, anImport);
                    return true;
                }
                return false;
            }

            @Override
            public List<JRightPadded<J.Import>> orderedImports(LayoutState layoutState, int classCountToUseStarImport, int nameCountToUseStarImport) {
                List<JRightPadded<J.Import>> imports = layoutState.getImports(this);
                Map groupedImports = imports.stream().sorted(IMPORT_SORTING).collect(Collectors.groupingBy(this::packageOrOuterClassName, LinkedHashMap::new, Collectors.toList()));
                ArrayList<JRightPadded<J.Import>> ordered = new ArrayList<JRightPadded<J.Import>>(imports.size());
                for (List importGroup : groupedImports.values()) {
                    JRightPadded toStar = (JRightPadded)importGroup.get(0);
                    boolean statik1 = ((J.Import)toStar.getElement()).isStatic();
                    int threshold = statik1 ? nameCountToUseStarImport : classCountToUseStarImport;
                    boolean starImportExists = importGroup.stream().anyMatch(it -> ((J.Import)it.getElement()).getQualid().getSimpleName().equals("*"));
                    if (importGroup.size() >= threshold || starImportExists && importGroup.size() > 1) {
                        J.FieldAccess qualid = ((J.Import)toStar.getElement()).getQualid();
                        J.Identifier name = qualid.getName();
                        Set typeNamesInThisGroup = importGroup.stream().map(im -> ((J.Import)im.getElement()).getClassName()).collect(Collectors.toSet());
                        Optional<String> oneOfTheTypesIsInAnotherGroupToo = groupedImports.values().stream().filter(group -> group != importGroup).flatMap(group -> group.stream().filter(im -> typeNamesInThisGroup.contains(((J.Import)im.getElement()).getClassName()))).map(im -> ((J.Import)im.getElement()).getTypeName()).findAny();
                        if (starImportExists || !oneOfTheTypesIsInAnotherGroupToo.isPresent()) {
                            ordered.add(toStar.withElement(((J.Import)toStar.getElement()).withQualid(qualid.withName(name.withName("*")))));
                            continue;
                        }
                    }
                    Predicate predicate = StreamUtils.distinctBy(t -> ((J.Import)t.getElement()).printTrimmed());
                    for (JRightPadded importJRightPadded : importGroup) {
                        if (!predicate.test(importJRightPadded)) continue;
                        ordered.add(importJRightPadded);
                    }
                }
                ordered.sort(IMPORT_SORTING);
                return ordered;
            }

            @NotNull
            private String packageOrOuterClassName(JRightPadded<J.Import> anImport) {
                String typeName = anImport.getElement().getTypeName();
                if (anImport.getElement().isStatic()) {
                    return typeName;
                }
                String className = anImport.getElement().getClassName();
                if (className.contains(".")) {
                    return anImport.getElement().getPackageName() + className.substring(0, className.lastIndexOf(46));
                }
                return anImport.getElement().getPackageName();
            }

            public String toString() {
                return "import " + (this.statik != false ? "static " : "") + this.packageWildcard;
            }
        }

        public static class BlankLines
        implements Block {
            private int count = 1;

            private int getCount() {
                return this.count;
            }

            @Override
            public boolean accept(LayoutState layoutState, JRightPadded<J.Import> anImport) {
                return false;
            }

            @Override
            public List<JRightPadded<J.Import>> orderedImports(LayoutState layoutState, int classCountToUseStarImport, int nameCountToUseStartImport) {
                return Collections.emptyList();
            }

            public String toString() {
                return "<blank line>" + (this.count > 1 ? " (x" + this.count + ")" : "");
            }
        }
    }

    private static class LayoutState {
        Map<Block, List<JRightPadded<J.Import>>> imports = new HashMap<Block, List<JRightPadded<J.Import>>>();

        private LayoutState() {
        }

        public void claimImport(Block block, JRightPadded<J.Import> impoort) {
            this.imports.computeIfAbsent(block, b -> new ArrayList()).add(impoort);
        }

        public List<JRightPadded<J.Import>> getImports(Block block) {
            return this.imports.getOrDefault(block, Collections.emptyList());
        }
    }

    public static class Builder {
        private final List<Block> blocks = new ArrayList<Block>();
        private int classCountToUseStarImport = 5;
        private int nameCountToUseStarImport = 3;

        public Builder importAllOthers() {
            this.blocks.add(new Block.AllOthers(false));
            return this;
        }

        public Builder importStaticAllOthers() {
            this.blocks.add(new Block.AllOthers(true));
            return this;
        }

        public Builder blankLine() {
            if (!this.blocks.isEmpty() && this.blocks.get(this.blocks.size() - 1) instanceof Block.BlankLines) {
                ((Block.BlankLines)this.blocks.get(this.blocks.size() - 1)).count++;
            } else {
                this.blocks.add(new Block.BlankLines());
            }
            return this;
        }

        public Builder importPackage(String packageWildcard, Boolean withSubpackages) {
            this.blocks.add(new Block.ImportPackage(false, packageWildcard, withSubpackages));
            return this;
        }

        public Builder importPackage(String packageWildcard) {
            return this.importPackage(packageWildcard, true);
        }

        public Builder staticImportPackage(String packageWildcard, Boolean withSubpackages) {
            this.blocks.add(new Block.ImportPackage(true, packageWildcard, withSubpackages));
            return this;
        }

        public Builder staticImportPackage(String packageWildcard) {
            return this.staticImportPackage(packageWildcard, true);
        }

        public Builder classCountToUseStarImport(int classCountToUseStarImport) {
            this.classCountToUseStarImport = classCountToUseStarImport;
            return this;
        }

        public Builder nameCountToUseStarImport(int nameCountToUseStarImport) {
            this.nameCountToUseStarImport = nameCountToUseStarImport;
            return this;
        }

        public ImportLayoutStyle build() {
            assert (this.blocks.stream().anyMatch(it -> it instanceof Block.AllOthers && ((Block.AllOthers)it).isStatic())) : "There must be at least one block that accepts all static imports, but no such block was found in the specified layout";
            assert (this.blocks.stream().anyMatch(it -> it instanceof Block.AllOthers && !((Block.AllOthers)it).isStatic())) : "There must be at least one block that accepts all non-static imports, but no such block was found in the specified layout";
            for (Block block : this.blocks) {
                if (!(block instanceof Block.AllOthers)) continue;
                ((Block.AllOthers)block).setPackageImports(this.blocks.stream().filter(b -> b.getClass().equals(Block.ImportPackage.class)).map(Block.ImportPackage.class::cast).collect(Collectors.toList()));
            }
            return new ImportLayoutStyle(this.classCountToUseStarImport, this.nameCountToUseStarImport, this.blocks);
        }
    }
}

