/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import org.openrewrite.Cursor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.cleanup.ExplicitInitializationStyle;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.TypeUtils;

public final class ExplicitInitializationVisitor<P>
extends JavaIsoVisitor<P> {
    private final ExplicitInitializationStyle style;

    @Override
    public J.VariableDeclarations.NamedVariable visitVariable(J.VariableDeclarations.NamedVariable variable, P p) {
        J.Literal literalInit;
        J v = super.visitVariable(variable, (Object)p);
        Cursor variableDeclsCursor = this.getCursor().dropParentUntil(J.class::isInstance);
        if (!(variableDeclsCursor.dropParentUntil(J.class::isInstance).dropParentUntil(J.class::isInstance).getValue() instanceof J.ClassDeclaration)) {
            return v;
        }
        JavaType.Primitive primitive = TypeUtils.asPrimitive(variable.getType());
        JavaType.Array array = TypeUtils.asArray(variable.getType());
        J tree = (J)variableDeclsCursor.getValue();
        if (!(tree instanceof J.VariableDeclarations)) {
            return v;
        }
        J.VariableDeclarations variableDecls = (J.VariableDeclarations)tree;
        J.Literal literal = literalInit = variable.getInitializer() instanceof J.Literal ? (J.Literal)variable.getInitializer() : null;
        if (literalInit != null && !variableDecls.hasModifier(J.Modifier.Type.Final)) {
            if (TypeUtils.asFullyQualified(variable.getType()) != null && JavaType.Primitive.Null.equals(literalInit.getType())) {
                v = ((J.VariableDeclarations.NamedVariable)v).withInitializer(null);
            } else if (primitive != null && !Boolean.TRUE.equals(this.style.getOnlyObjectReferences())) {
                switch (primitive) {
                    case Boolean: {
                        if (literalInit.getValue() != Boolean.valueOf(false)) break;
                        v = ((J.VariableDeclarations.NamedVariable)v).withInitializer(null);
                        break;
                    }
                    case Char: {
                        if (literalInit.getValue() == null || ((Character)literalInit.getValue()).charValue() != '\u0000') break;
                        v = ((J.VariableDeclarations.NamedVariable)v).withInitializer(null);
                        break;
                    }
                    case Int: 
                    case Long: 
                    case Short: {
                        if (literalInit.getValue() == null || ((Number)literalInit.getValue()).intValue() != 0) break;
                        v = ((J.VariableDeclarations.NamedVariable)v).withInitializer(null);
                    }
                }
            } else if (array != null && JavaType.Primitive.Null.equals(literalInit.getType())) {
                v = ((J.VariableDeclarations.NamedVariable)v).withInitializer(null).withDimensionsAfterName(ListUtils.map(((J.VariableDeclarations.NamedVariable)v).getDimensionsAfterName(), (i, dim) -> i == 0 ? dim.withBefore(Space.EMPTY) : dim));
            }
        }
        return v;
    }

    public ExplicitInitializationVisitor(ExplicitInitializationStyle style) {
        this.style = style;
    }

    public ExplicitInitializationStyle getStyle() {
        return this.style;
    }

    @NonNull
    public String toString() {
        return "ExplicitInitializationVisitor(style=" + this.getStyle() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExplicitInitializationVisitor)) {
            return false;
        }
        ExplicitInitializationVisitor other = (ExplicitInitializationVisitor)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ExplicitInitializationStyle this$style = this.getStyle();
        ExplicitInitializationStyle other$style = other.getStyle();
        return !(this$style == null ? other$style != null : !((Object)this$style).equals(other$style));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ExplicitInitializationVisitor;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        ExplicitInitializationStyle $style = this.getStyle();
        result = result * 59 + ($style == null ? 43 : ((Object)$style).hashCode());
        return result;
    }
}

