/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.ArrayList;
import java.util.List;
import org.openrewrite.ExecutionContext;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.AnnotationMatcher;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.java.tree.TypeUtils;

public final class RemoveAnnotationVisitor
extends JavaIsoVisitor<ExecutionContext> {
    private final AnnotationMatcher annotationMatcher;

    @Override
    public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext ctx) {
        J c = super.visitClassDeclaration(classDecl, ctx);
        J.Annotation annotationRemoved = (J.Annotation)this.getCursor().pollMessage("annotationRemoved");
        List<J.Annotation> leadingAnnotations = classDecl.getLeadingAnnotations();
        if (annotationRemoved != null && !leadingAnnotations.isEmpty()) {
            if (leadingAnnotations.get(0) == annotationRemoved && leadingAnnotations.size() == 1) {
                c = !((J.ClassDeclaration)c).getModifiers().isEmpty() ? ((J.ClassDeclaration)c).withModifiers(Space.formatFirstPrefix(((J.ClassDeclaration)c).getModifiers(), Space.firstPrefix(((J.ClassDeclaration)c).getModifiers()).withWhitespace(""))) : (((J.ClassDeclaration)c).getPadding().getTypeParameters() != null ? ((J.ClassDeclaration)c).getPadding().withTypeParameters(((J.ClassDeclaration)c).getPadding().getTypeParameters().withBefore(((J.ClassDeclaration)c).getPadding().getTypeParameters().getBefore().withWhitespace(""))) : ((J.ClassDeclaration)c).withName(((J.ClassDeclaration)c).getName().withPrefix(((J.ClassDeclaration)c).getName().getPrefix().withWhitespace(""))));
            } else {
                List<J.Annotation> newLeadingAnnotations = this.removeAnnotationOrEmpty(leadingAnnotations, annotationRemoved);
                if (!newLeadingAnnotations.isEmpty()) {
                    c = ((J.ClassDeclaration)c).withLeadingAnnotations(newLeadingAnnotations);
                }
            }
        }
        return c;
    }

    @Override
    public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, ExecutionContext ctx) {
        J m = super.visitMethodDeclaration(method, ctx);
        J.Annotation annotationRemoved = (J.Annotation)this.getCursor().pollMessage("annotationRemoved");
        List<J.Annotation> leadingAnnotations = method.getLeadingAnnotations();
        if (annotationRemoved != null && !leadingAnnotations.isEmpty()) {
            if (leadingAnnotations.get(0) == annotationRemoved && leadingAnnotations.size() == 1) {
                m = !((J.MethodDeclaration)m).getModifiers().isEmpty() ? ((J.MethodDeclaration)m).withModifiers(Space.formatFirstPrefix(((J.MethodDeclaration)m).getModifiers(), Space.firstPrefix(((J.MethodDeclaration)m).getModifiers()).withWhitespace(""))) : (((J.MethodDeclaration)m).getPadding().getTypeParameters() != null ? ((J.MethodDeclaration)m).getPadding().withTypeParameters(((J.MethodDeclaration)m).getPadding().getTypeParameters().withPrefix(((J.MethodDeclaration)m).getPadding().getTypeParameters().getPrefix().withWhitespace(""))) : (((J.MethodDeclaration)m).getReturnTypeExpression() != null ? ((J.MethodDeclaration)m).withReturnTypeExpression((TypeTree)((J.MethodDeclaration)m).getReturnTypeExpression().withPrefix(((J.MethodDeclaration)m).getReturnTypeExpression().getPrefix().withWhitespace(""))) : ((J.MethodDeclaration)m).withName(((J.MethodDeclaration)m).getName().withPrefix(((J.MethodDeclaration)m).getName().getPrefix().withWhitespace("")))));
            } else {
                List<J.Annotation> newLeadingAnnotations = this.removeAnnotationOrEmpty(leadingAnnotations, annotationRemoved);
                if (!newLeadingAnnotations.isEmpty()) {
                    m = ((J.MethodDeclaration)m).withLeadingAnnotations(newLeadingAnnotations);
                }
            }
        }
        return m;
    }

    @Override
    public J.VariableDeclarations visitVariableDeclarations(J.VariableDeclarations multiVariable, ExecutionContext ctx) {
        J v = super.visitVariableDeclarations(multiVariable, ctx);
        J.Annotation annotationRemoved = (J.Annotation)this.getCursor().pollMessage("annotationRemoved");
        List<J.Annotation> leadingAnnotations = multiVariable.getLeadingAnnotations();
        if (annotationRemoved != null && !leadingAnnotations.isEmpty()) {
            if (leadingAnnotations.get(0) == annotationRemoved && leadingAnnotations.size() == 1) {
                if (!((J.VariableDeclarations)v).getModifiers().isEmpty()) {
                    v = ((J.VariableDeclarations)v).withModifiers(Space.formatFirstPrefix(((J.VariableDeclarations)v).getModifiers(), Space.firstPrefix(((J.VariableDeclarations)v).getModifiers()).withWhitespace("")));
                } else if (((J.VariableDeclarations)v).getTypeExpression() != null) {
                    v = ((J.VariableDeclarations)v).withTypeExpression((TypeTree)((J.VariableDeclarations)v).getTypeExpression().withPrefix(((J.VariableDeclarations)v).getTypeExpression().getPrefix().withWhitespace("")));
                }
            } else {
                List<J.Annotation> newLeadingAnnotations = this.removeAnnotationOrEmpty(leadingAnnotations, annotationRemoved);
                if (!newLeadingAnnotations.isEmpty()) {
                    v = ((J.VariableDeclarations)v).withLeadingAnnotations(newLeadingAnnotations);
                }
            }
        }
        return v;
    }

    @Override
    public J.Annotation visitAnnotation(J.Annotation annotation, ExecutionContext ctx) {
        if (this.annotationMatcher.matches(annotation)) {
            this.getCursor().getParentOrThrow().putMessage("annotationRemoved", (Object)annotation);
            this.maybeRemoveImport(TypeUtils.asFullyQualified(annotation.getType()));
            return null;
        }
        return super.visitAnnotation(annotation, ctx);
    }

    private List<J.Annotation> removeAnnotationOrEmpty(List<J.Annotation> leadingAnnotations, J.Annotation targetAnnotation) {
        J.Annotation nextAnnotation;
        int index = leadingAnnotations.indexOf(targetAnnotation);
        ArrayList<J.Annotation> newLeadingAnnotations = new ArrayList<J.Annotation>();
        if (index == 0 && !(nextAnnotation = leadingAnnotations.get(1)).getPrefix().equals(targetAnnotation.getPrefix())) {
            newLeadingAnnotations.add(nextAnnotation.withPrefix(targetAnnotation.getPrefix()));
            for (int i = 2; i < leadingAnnotations.size(); ++i) {
                newLeadingAnnotations.add(leadingAnnotations.get(i));
            }
        }
        return newLeadingAnnotations;
    }

    public RemoveAnnotationVisitor(AnnotationMatcher annotationMatcher) {
        this.annotationMatcher = annotationMatcher;
    }

    public AnnotationMatcher getAnnotationMatcher() {
        return this.annotationMatcher;
    }

    @NonNull
    public String toString() {
        return "RemoveAnnotationVisitor(annotationMatcher=" + this.getAnnotationMatcher() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RemoveAnnotationVisitor)) {
            return false;
        }
        RemoveAnnotationVisitor other = (RemoveAnnotationVisitor)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AnnotationMatcher this$annotationMatcher = this.getAnnotationMatcher();
        AnnotationMatcher other$annotationMatcher = other.getAnnotationMatcher();
        return !(this$annotationMatcher == null ? other$annotationMatcher != null : !this$annotationMatcher.equals(other$annotationMatcher));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof RemoveAnnotationVisitor;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        AnnotationMatcher $annotationMatcher = this.getAnnotationMatcher();
        result = result * 59 + ($annotationMatcher == null ? 43 : $annotationMatcher.hashCode());
        return result;
    }
}

