/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.cleanup.EmptyBlockStyle;
import org.openrewrite.java.cleanup.EmptyBlockVisitor;
import org.openrewrite.java.style.IntelliJ;
import org.openrewrite.java.tree.J;

public class EmptyBlock
extends Recipe {
    public String getDisplayName() {
        return "Remove empty blocks";
    }

    public String getDescription() {
        return "Remove empty blocks that effectively do nothing.";
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new EmptyBlockFromCompilationUnitStyle();
    }

    private static class EmptyBlockFromCompilationUnitStyle
    extends JavaIsoVisitor<ExecutionContext> {
        private EmptyBlockFromCompilationUnitStyle() {
        }

        @Override
        public J.CompilationUnit visitCompilationUnit(J.CompilationUnit cu, ExecutionContext executionContext) {
            EmptyBlockStyle style = (EmptyBlockStyle)cu.getStyle(EmptyBlockStyle.class);
            if (style == null) {
                style = IntelliJ.emptyBlock();
            }
            this.doAfterVisit(new EmptyBlockVisitor(style));
            return cu;
        }
    }
}

