/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.internal.FormatFirstClassPrefix;
import org.openrewrite.java.style.ImportLayoutStyle;
import org.openrewrite.java.style.IntelliJ;
import org.openrewrite.java.tree.Flag;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.TypeUtils;

public class RemoveUnusedImports
extends Recipe {
    public String getDisplayName() {
        return "Remove unused imports";
    }

    public String getDescription() {
        return "Remove imports for types that are not referenced.";
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new RemoveUnusedImportsVisitor();
    }

    private static class RemoveUnusedImportsVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private RemoveUnusedImportsVisitor() {
        }

        @Override
        public J.CompilationUnit visitCompilationUnit(J.CompilationUnit cu, ExecutionContext ctx) {
            ImportLayoutStyle layoutStyle = Optional.ofNullable((ImportLayoutStyle)cu.getStyle(ImportLayoutStyle.class)).orElse(IntelliJ.importLayout());
            HashMap<String, Set> methodsAndFieldsByTypeName = new HashMap<String, Set>();
            HashMap<String, Set> typesByPackage = new HashMap<String, Set>();
            for (JavaType javaType : cu.getTypesInUse()) {
                if (javaType instanceof JavaType.Variable) {
                    JavaType.Variable variable = (JavaType.Variable)javaType;
                    JavaType.FullyQualified fq = TypeUtils.asFullyQualified(variable.getType());
                    if (fq == null) continue;
                    methodsAndFieldsByTypeName.computeIfAbsent(fq.getFullyQualifiedName(), f -> new HashSet()).add(variable.getName());
                    continue;
                }
                if (javaType instanceof JavaType.Method) {
                    JavaType.Method method2 = (JavaType.Method)javaType;
                    if (!method2.hasFlags(Flag.Static)) continue;
                    methodsAndFieldsByTypeName.computeIfAbsent(method2.getDeclaringType().getFullyQualifiedName(), t -> new HashSet()).add(method2.getName());
                    continue;
                }
                if (!(javaType instanceof JavaType.FullyQualified)) continue;
                JavaType.FullyQualified fullyQualified = (JavaType.FullyQualified)javaType;
                typesByPackage.computeIfAbsent(fullyQualified.getPackageName(), f -> new HashSet()).add(fullyQualified);
            }
            boolean changed = false;
            ArrayList<JRightPadded<J.Import>> importsWithUsage = new ArrayList<JRightPadded<J.Import>>();
            for (JRightPadded<J.Import> anImport : cu.getPadding().getImports()) {
                J.Import elem = anImport.getElement();
                J.FieldAccess qualid = elem.getQualid();
                J.Identifier name = qualid.getName();
                if (anImport.getElement().isStatic()) {
                    Set methodsAndFields = (Set)methodsAndFieldsByTypeName.get(anImport.getElement().getTypeName());
                    if (methodsAndFields == null) {
                        changed = true;
                        continue;
                    }
                    if ("*".equals(qualid.getSimpleName())) {
                        if (methodsAndFields.size() < layoutStyle.getNameCountToUseStarImport()) {
                            methodsAndFields.stream().sorted().forEach(method -> importsWithUsage.add(anImport.withElement(elem.withQualid(qualid.withName(name.withName((String)method))))));
                            changed = true;
                            continue;
                        }
                        importsWithUsage.add(anImport);
                        continue;
                    }
                    if (methodsAndFields.contains(qualid.getSimpleName())) {
                        importsWithUsage.add(anImport);
                        continue;
                    }
                    changed = true;
                    continue;
                }
                Set types = (Set)typesByPackage.get(anImport.getElement().getPackageName());
                if (types == null) {
                    changed = true;
                    continue;
                }
                if ("*".equals(anImport.getElement().getQualid().getSimpleName())) {
                    if (types.size() < layoutStyle.getClassCountToUseStarImport()) {
                        ArrayList<String> toSort = new ArrayList<String>();
                        for (JavaType.FullyQualified type : types) {
                            String typeClassName = type.getClassName();
                            toSort.add(typeClassName);
                        }
                        toSort.sort(null);
                        ArrayList<JRightPadded<J.Import>> unfoldedWildcardImports = new ArrayList<JRightPadded<J.Import>>(toSort.size());
                        for (String typeClassName : toSort) {
                            JRightPadded<J.Import> importJRightPadded = anImport.withElement(new J.Import(Tree.randomId(), elem.getPrefix(), elem.getMarkers(), elem.getPadding().getStatic(), elem.getQualid().withName(name.withName(typeClassName))));
                            unfoldedWildcardImports.add(importJRightPadded);
                        }
                        importsWithUsage.addAll(ListUtils.map(unfoldedWildcardImports, (index, paddedImport) -> {
                            if (index != 0) {
                                paddedImport = paddedImport.withElement(((J.Import)paddedImport.getElement()).withPrefix(Space.format("\n")));
                            }
                            return paddedImport;
                        }));
                        changed = true;
                        continue;
                    }
                    importsWithUsage.add(anImport);
                    continue;
                }
                if (types.stream().filter(c -> ((J.Import)anImport.getElement()).isFromType(c.getFullyQualifiedName())).findAny().isPresent()) {
                    importsWithUsage.add(anImport);
                    continue;
                }
                changed = true;
            }
            J.CompilationUnit compilationUnit = cu = changed ? cu.getPadding().withImports(importsWithUsage) : cu;
            if (changed) {
                this.doAfterVisit(new FormatFirstClassPrefix());
                if (cu.getPackageDeclaration() == null) {
                    cu = cu.withImports(ListUtils.mapFirst(cu.getImports(), i -> this.autoFormat(i, ctx)));
                }
            }
            return cu;
        }
    }
}

