/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.List;
import org.openrewrite.Cursor;
import org.openrewrite.Tree;
import org.openrewrite.TreePrinter;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.tree.Comment;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JContainer;
import org.openrewrite.java.tree.JLeftPadded;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.Markers;

public class JavaPrinter<P>
extends JavaVisitor<P> {
    private static final String PRINTER_ACC_KEY = "printed";
    private final TreePrinter<P> treePrinter;

    public JavaPrinter(TreePrinter<P> treePrinter) {
        this.treePrinter = treePrinter;
    }

    @NonNull
    protected StringBuilder getPrinter() {
        StringBuilder acc = (StringBuilder)this.getCursor().getRoot().getNearestMessage(PRINTER_ACC_KEY);
        if (acc == null) {
            acc = new StringBuilder();
            this.getCursor().getRoot().putMessage(PRINTER_ACC_KEY, (Object)acc);
        }
        return acc;
    }

    public String print(J j, P p) {
        this.setCursor(new Cursor(null, (Object)"EPSILON"));
        this.visit((Tree)j, (Object)p);
        return this.getPrinter().toString();
    }

    @Nullable
    public J visit(@Nullable Tree tree, P p) {
        if (tree == null) {
            return (J)this.defaultValue(null, p);
        }
        StringBuilder printerAcc = this.getPrinter();
        this.treePrinter.doBefore(tree, printerAcc, p);
        tree = super.visit(tree, p);
        if (tree != null) {
            this.treePrinter.doAfter(tree, printerAcc, p);
        }
        return (J)tree;
    }

    protected void visit(@Nullable List<? extends J> nodes, P p) {
        if (nodes != null) {
            for (J j : nodes) {
                this.visit((Tree)j, (Object)p);
            }
        }
    }

    protected void visitRightPadded(List<? extends JRightPadded<? extends J>> nodes, JRightPadded.Location location, String suffixBetween, P p) {
        StringBuilder acc = this.getPrinter();
        for (int i = 0; i < nodes.size(); ++i) {
            JRightPadded<? extends J> node = nodes.get(i);
            this.visit((Tree)node.getElement(), (Object)p);
            this.visitSpace(node.getAfter(), location.getAfterLocation(), p);
            if (i >= nodes.size() - 1) continue;
            acc.append(suffixBetween);
        }
    }

    protected void visitContainer(String before, @Nullable JContainer<? extends J> container, JContainer.Location location, String suffixBetween, @Nullable String after, P p) {
        if (container == null) {
            return;
        }
        StringBuilder acc = this.getPrinter();
        this.visitSpace(container.getBefore(), location.getBeforeLocation(), p);
        acc.append(before);
        this.visitRightPadded(container.getPadding().getElements(), location.getElementLocation(), suffixBetween, p);
        acc.append(after == null ? "" : after);
    }

    @Override
    public Space visitSpace(Space space, Space.Location loc, P p) {
        StringBuilder acc = this.getPrinter();
        acc.append(space.getWhitespace());
        for (Comment comment : space.getComments()) {
            this.visitMarkers(comment.getMarkers(), p);
            switch (comment.getStyle()) {
                case LINE: {
                    acc.append("//").append(comment.getText());
                    break;
                }
                case BLOCK: {
                    acc.append("/*").append(comment.getText()).append("*/");
                    break;
                }
                case JAVADOC: {
                    acc.append("/**").append(comment.getText()).append("*/");
                }
            }
            acc.append(comment.getSuffix());
        }
        return space;
    }

    protected void visitLeftPadded(@Nullable String prefix, @Nullable JLeftPadded<? extends J> leftPadded, JLeftPadded.Location location, P p) {
        if (leftPadded != null) {
            StringBuilder acc = this.getPrinter();
            this.visitSpace(leftPadded.getBefore(), location.getBeforeLocation(), p);
            if (prefix != null) {
                acc.append(prefix);
            }
            this.visit((Tree)leftPadded.getElement(), (Object)p);
        }
    }

    protected void visitRightPadded(@Nullable JRightPadded<? extends J> rightPadded, JRightPadded.Location location, @Nullable String suffix, P p) {
        if (rightPadded != null) {
            StringBuilder acc = this.getPrinter();
            this.visit((Tree)rightPadded.getElement(), (Object)p);
            this.visitSpace(rightPadded.getAfter(), location.getAfterLocation(), p);
            if (suffix != null) {
                acc.append(suffix);
            }
        }
    }

    public <M extends Marker> M visitMarker(Marker marker, P p) {
        StringBuilder acc = this.getPrinter();
        this.treePrinter.doBefore((Tree)marker, acc, p);
        acc.append(marker.print(this.treePrinter, p));
        this.treePrinter.doAfter((Tree)marker, acc, p);
        return (M)marker;
    }

    public Markers visitMarkers(Markers markers, P p) {
        StringBuilder acc = this.getPrinter();
        this.treePrinter.doBefore((Tree)markers, acc, p);
        Markers m = super.visitMarkers(markers, p);
        this.treePrinter.doAfter((Tree)markers, acc, p);
        return m;
    }

    protected void visitModifiers(Iterable<J.Modifier> modifiers, P p) {
        StringBuilder acc = this.getPrinter();
        for (J.Modifier mod : modifiers) {
            this.visit(mod.getAnnotations(), p);
            String keyword = "";
            switch (mod.getType()) {
                case Default: {
                    keyword = "default";
                    break;
                }
                case Public: {
                    keyword = "public";
                    break;
                }
                case Protected: {
                    keyword = "protected";
                    break;
                }
                case Private: {
                    keyword = "private";
                    break;
                }
                case Abstract: {
                    keyword = "abstract";
                    break;
                }
                case Static: {
                    keyword = "static";
                    break;
                }
                case Final: {
                    keyword = "final";
                    break;
                }
                case Native: {
                    keyword = "native";
                    break;
                }
                case Strictfp: {
                    keyword = "strictfp";
                    break;
                }
                case Synchronized: {
                    keyword = "synchronized";
                    break;
                }
                case Transient: {
                    keyword = "transient";
                    break;
                }
                case Volatile: {
                    keyword = "volatile";
                }
            }
            this.visitSpace(mod.getPrefix(), Space.Location.MODIFIER_PREFIX, p);
            this.visitMarkers(mod.getMarkers(), p);
            acc.append(keyword);
        }
    }

    @Override
    public J visitAnnotation(J.Annotation annotation, P p) {
        this.visitSpace(annotation.getPrefix(), Space.Location.ANNOTATION_PREFIX, p);
        this.visitMarkers(annotation.getMarkers(), p);
        StringBuilder acc = this.getPrinter();
        acc.append("@");
        this.visit((Tree)annotation.getAnnotationType(), (Object)p);
        this.visitContainer("(", annotation.getPadding().getArguments(), JContainer.Location.ANNOTATION_ARGUMENTS, ",", ")", p);
        return annotation;
    }

    @Override
    public J visitAnnotatedType(J.AnnotatedType annotatedType, P p) {
        this.visitSpace(annotatedType.getPrefix(), Space.Location.ANNOTATED_TYPE_PREFIX, p);
        this.visitMarkers(annotatedType.getMarkers(), p);
        this.visit(annotatedType.getAnnotations(), p);
        this.visit((Tree)annotatedType.getTypeExpression(), (Object)p);
        return annotatedType;
    }

    @Override
    public J visitArrayDimension(J.ArrayDimension arrayDimension, P p) {
        this.visitSpace(arrayDimension.getPrefix(), Space.Location.DIMENSION_PREFIX, p);
        this.visitMarkers(arrayDimension.getMarkers(), p);
        StringBuilder acc = this.getPrinter();
        acc.append("[");
        this.visitRightPadded(arrayDimension.getPadding().getIndex(), JRightPadded.Location.ARRAY_INDEX, "]", p);
        return arrayDimension;
    }

    @Override
    public J visitArrayType(J.ArrayType arrayType, P p) {
        this.visitSpace(arrayType.getPrefix(), Space.Location.ARRAY_TYPE_PREFIX, p);
        this.visitMarkers(arrayType.getMarkers(), p);
        this.visit((Tree)arrayType.getElementType(), (Object)p);
        StringBuilder acc = this.getPrinter();
        for (JRightPadded<Space> d : arrayType.getDimensions()) {
            this.visitSpace(d.getElement(), Space.Location.DIMENSION, p);
            acc.append('[');
            this.visitSpace(d.getAfter(), Space.Location.DIMENSION_SUFFIX, p);
            acc.append(']');
        }
        return arrayType;
    }

    @Override
    public J visitAssert(J.Assert azzert, P p) {
        this.visitSpace(azzert.getPrefix(), Space.Location.ASSERT_PREFIX, p);
        this.visitMarkers(azzert.getMarkers(), p);
        StringBuilder acc = this.getPrinter();
        acc.append("assert");
        this.visit((Tree)azzert.getCondition(), (Object)p);
        return azzert;
    }

    @Override
    public J visitAssignment(J.Assignment assignment, P p) {
        this.visitSpace(assignment.getPrefix(), Space.Location.ASSIGNMENT_PREFIX, p);
        this.visitMarkers(assignment.getMarkers(), p);
        this.visit((Tree)assignment.getVariable(), (Object)p);
        this.visitLeftPadded("=", assignment.getPadding().getAssignment(), JLeftPadded.Location.ASSIGNMENT, p);
        return assignment;
    }

    @Override
    public J visitAssignmentOperation(J.AssignmentOperation assignOp, P p) {
        String keyword = "";
        switch (assignOp.getOperator()) {
            case Addition: {
                keyword = "+=";
                break;
            }
            case Subtraction: {
                keyword = "-=";
                break;
            }
            case Multiplication: {
                keyword = "*=";
                break;
            }
            case Division: {
                keyword = "/=";
                break;
            }
            case Modulo: {
                keyword = "%=";
                break;
            }
            case BitAnd: {
                keyword = "&=";
                break;
            }
            case BitOr: {
                keyword = "|=";
                break;
            }
            case BitXor: {
                keyword = "^=";
                break;
            }
            case LeftShift: {
                keyword = "<<=";
                break;
            }
            case RightShift: {
                keyword = ">>=";
                break;
            }
            case UnsignedRightShift: {
                keyword = ">>>=";
            }
        }
        this.visitSpace(assignOp.getPrefix(), Space.Location.ASSIGNMENT_OPERATION_PREFIX, p);
        this.visitMarkers(assignOp.getMarkers(), p);
        this.visit((Tree)assignOp.getVariable(), (Object)p);
        this.visitSpace(assignOp.getPadding().getOperator().getBefore(), Space.Location.ASSIGNMENT_OPERATION_OPERATOR, p);
        StringBuilder acc = this.getPrinter();
        acc.append(keyword);
        this.visit((Tree)assignOp.getAssignment(), (Object)p);
        return assignOp;
    }

    @Override
    public J visitBinary(J.Binary binary, P p) {
        String keyword = "";
        switch (binary.getOperator()) {
            case Addition: {
                keyword = "+";
                break;
            }
            case Subtraction: {
                keyword = "-";
                break;
            }
            case Multiplication: {
                keyword = "*";
                break;
            }
            case Division: {
                keyword = "/";
                break;
            }
            case Modulo: {
                keyword = "%";
                break;
            }
            case LessThan: {
                keyword = "<";
                break;
            }
            case GreaterThan: {
                keyword = ">";
                break;
            }
            case LessThanOrEqual: {
                keyword = "<=";
                break;
            }
            case GreaterThanOrEqual: {
                keyword = ">=";
                break;
            }
            case Equal: {
                keyword = "==";
                break;
            }
            case NotEqual: {
                keyword = "!=";
                break;
            }
            case BitAnd: {
                keyword = "&";
                break;
            }
            case BitOr: {
                keyword = "|";
                break;
            }
            case BitXor: {
                keyword = "^";
                break;
            }
            case LeftShift: {
                keyword = "<<";
                break;
            }
            case RightShift: {
                keyword = ">>";
                break;
            }
            case UnsignedRightShift: {
                keyword = ">>>";
                break;
            }
            case Or: {
                keyword = "||";
                break;
            }
            case And: {
                keyword = "&&";
            }
        }
        this.visitSpace(binary.getPrefix(), Space.Location.BINARY_PREFIX, p);
        this.visitMarkers(binary.getMarkers(), p);
        this.visit((Tree)binary.getLeft(), (Object)p);
        this.visitSpace(binary.getPadding().getOperator().getBefore(), Space.Location.BINARY_OPERATOR, p);
        StringBuilder acc = this.getPrinter();
        acc.append(keyword);
        this.visit((Tree)binary.getRight(), (Object)p);
        return binary;
    }

    @Override
    public J visitBlock(J.Block block, P p) {
        this.visitSpace(block.getPrefix(), Space.Location.BLOCK_PREFIX, p);
        this.visitMarkers(block.getMarkers(), p);
        StringBuilder acc = this.getPrinter();
        if (block.isStatic()) {
            acc.append("static");
            this.visitRightPadded(block.getPadding().getStatic(), JRightPadded.Location.STATIC_INIT, p);
        }
        acc.append('{');
        this.visitStatements(block.getPadding().getStatements(), JRightPadded.Location.BLOCK_STATEMENT, p);
        this.visitSpace(block.getEnd(), Space.Location.BLOCK_END, p);
        acc.append('}');
        return block;
    }

    private void visitStatements(List<JRightPadded<Statement>> statements, JRightPadded.Location location, P p) {
        for (JRightPadded<Statement> paddedStat : statements) {
            this.visitStatement(paddedStat, location, p);
        }
    }

    private void visitStatement(@Nullable JRightPadded<Statement> paddedStat, JRightPadded.Location location, P p) {
        if (paddedStat == null) {
            return;
        }
        this.visit((Tree)paddedStat.getElement(), (Object)p);
        this.visitSpace(paddedStat.getAfter(), location.getAfterLocation(), p);
        StringBuilder acc = this.getPrinter();
        Statement s = paddedStat.getElement();
        while (true) {
            if (s instanceof J.Assert || s instanceof J.Assignment || s instanceof J.AssignmentOperation || s instanceof J.Break || s instanceof J.Continue || s instanceof J.DoWhileLoop || s instanceof J.Empty || s instanceof J.MethodInvocation || s instanceof J.NewClass || s instanceof J.Return || s instanceof J.Throw || s instanceof J.Unary || s instanceof J.VariableDeclarations) {
                acc.append(';');
                return;
            }
            if (s instanceof J.MethodDeclaration && ((J.MethodDeclaration)s).getBody() == null) {
                acc.append(';');
                return;
            }
            if (!(s instanceof J.Label)) break;
            s = ((J.Label)s).getStatement();
        }
    }

    @Override
    public J visitBreak(J.Break breakStatement, P p) {
        this.visitSpace(breakStatement.getPrefix(), Space.Location.BREAK_PREFIX, p);
        this.visitMarkers(breakStatement.getMarkers(), p);
        StringBuilder acc = this.getPrinter();
        acc.append("break");
        this.visit((Tree)breakStatement.getLabel(), (Object)p);
        return breakStatement;
    }

    @Override
    public J visitCase(J.Case caze, P p) {
        this.visitSpace(caze.getPrefix(), Space.Location.CASE_PREFIX, p);
        this.visitMarkers(caze.getMarkers(), p);
        StringBuilder acc = this.getPrinter();
        Expression elem = caze.getPattern();
        if (elem instanceof J.Identifier && ((J.Identifier)elem).getSimpleName().equals("default")) {
            acc.append("default");
        } else {
            acc.append("case");
            this.visit((Tree)elem, (Object)p);
        }
        this.visitSpace(caze.getPadding().getStatements().getBefore(), Space.Location.CASE, p);
        acc.append(':');
        this.visitStatements(caze.getPadding().getStatements().getPadding().getElements(), JRightPadded.Location.CASE, p);
        return caze;
    }

    @Override
    public J visitCatch(J.Try.Catch catzh, P p) {
        this.visitSpace(catzh.getPrefix(), Space.Location.CATCH_PREFIX, p);
        this.visitMarkers(catzh.getMarkers(), p);
        StringBuilder acc = this.getPrinter();
        acc.append("catch");
        this.visit((Tree)catzh.getParameter(), (Object)p);
        this.visit((Tree)catzh.getBody(), (Object)p);
        return catzh;
    }

    @Override
    public J visitClassDeclaration(J.ClassDeclaration classDecl, P p) {
        String kind = "";
        switch (classDecl.getKind()) {
            case Class: {
                kind = "class";
                break;
            }
            case Enum: {
                kind = "enum";
                break;
            }
            case Interface: {
                kind = "interface";
                break;
            }
            case Annotation: {
                kind = "@interface";
            }
        }
        this.visitSpace(classDecl.getPrefix(), Space.Location.CLASS_DECLARATION_PREFIX, p);
        this.visitMarkers(classDecl.getMarkers(), p);
        this.visitSpace(Space.EMPTY, Space.Location.ANNOTATIONS, p);
        this.visit(classDecl.getLeadingAnnotations(), p);
        this.visitModifiers(classDecl.getModifiers(), p);
        this.visit(classDecl.getAnnotations().getKind().getAnnotations(), p);
        this.visitSpace(classDecl.getAnnotations().getKind().getPrefix(), Space.Location.CLASS_KIND, p);
        StringBuilder acc = this.getPrinter();
        acc.append(kind);
        this.visit((Tree)classDecl.getName(), (Object)p);
        this.visitContainer("<", classDecl.getPadding().getTypeParameters(), JContainer.Location.TYPE_PARAMETERS, ",", ">", p);
        this.visitLeftPadded("extends", classDecl.getPadding().getExtends(), JLeftPadded.Location.EXTENDS, p);
        this.visitContainer(classDecl.getKind().equals((Object)J.ClassDeclaration.Kind.Type.Interface) ? "extends" : "implements", classDecl.getPadding().getImplements(), JContainer.Location.IMPLEMENTS, ",", null, p);
        this.visit((Tree)classDecl.getBody(), (Object)p);
        return classDecl;
    }

    @Override
    public J visitCompilationUnit(J.CompilationUnit cu, P p) {
        this.visitSpace(cu.getPrefix(), Space.Location.COMPILATION_UNIT_PREFIX, p);
        this.visitMarkers(cu.getMarkers(), p);
        this.visitRightPadded(cu.getPadding().getPackageDeclaration(), JRightPadded.Location.PACKAGE, ";", p);
        this.visitRightPadded(cu.getPadding().getImports(), JRightPadded.Location.IMPORT, ";", p);
        StringBuilder acc = this.getPrinter();
        if (!cu.getImports().isEmpty()) {
            acc.append(";");
        }
        this.visit(cu.getClasses(), p);
        this.visitSpace(cu.getEof(), Space.Location.COMPILATION_UNIT_EOF, p);
        return cu;
    }

    @Override
    public J visitContinue(J.Continue continueStatement, P p) {
        this.visitSpace(continueStatement.getPrefix(), Space.Location.CONTINUE_PREFIX, p);
        this.visitMarkers(continueStatement.getMarkers(), p);
        StringBuilder acc = this.getPrinter();
        acc.append("continue");
        this.visit((Tree)continueStatement.getLabel(), (Object)p);
        return continueStatement;
    }

    @Override
    public <T extends J> J visitControlParentheses(J.ControlParentheses<T> controlParens, P p) {
        this.visitSpace(controlParens.getPrefix(), Space.Location.CONTROL_PARENTHESES_PREFIX, p);
        this.visitMarkers(controlParens.getMarkers(), p);
        StringBuilder acc = this.getPrinter();
        acc.append('(');
        this.visitRightPadded(controlParens.getPadding().getTree(), JRightPadded.Location.PARENTHESES, ")", p);
        return controlParens;
    }

    @Override
    public J visitDoWhileLoop(J.DoWhileLoop doWhileLoop, P p) {
        this.visitSpace(doWhileLoop.getPrefix(), Space.Location.DO_WHILE_PREFIX, p);
        this.visitMarkers(doWhileLoop.getMarkers(), p);
        StringBuilder acc = this.getPrinter();
        acc.append("do");
        this.visitStatement(doWhileLoop.getPadding().getBody(), JRightPadded.Location.WHILE_BODY, p);
        this.visitLeftPadded("while", doWhileLoop.getPadding().getWhileCondition(), JLeftPadded.Location.WHILE_CONDITION, p);
        return doWhileLoop;
    }

    @Override
    public J visitElse(J.If.Else elze, P p) {
        this.visitSpace(elze.getPrefix(), Space.Location.ELSE_PREFIX, p);
        this.visitMarkers(elze.getMarkers(), p);
        StringBuilder acc = this.getPrinter();
        acc.append("else");
        this.visitStatement(elze.getPadding().getBody(), JRightPadded.Location.IF_ELSE, p);
        return elze;
    }

    @Override
    public J visitEnumValue(J.EnumValue enoom, P p) {
        this.visitSpace(enoom.getPrefix(), Space.Location.ENUM_VALUE_PREFIX, p);
        this.visitMarkers(enoom.getMarkers(), p);
        this.visit(enoom.getAnnotations(), p);
        this.visit((Tree)enoom.getName(), (Object)p);
        J.NewClass initializer = enoom.getInitializer();
        if (enoom.getInitializer() != null) {
            this.visitSpace(initializer.getPrefix(), Space.Location.NEW_CLASS_PREFIX, p);
            this.visitSpace(initializer.getNew(), Space.Location.NEW_PREFIX, p);
            this.visitContainer("(", initializer.getPadding().getArguments(), JContainer.Location.NEW_CLASS_ARGUMENTS, ",", ")", p);
            this.visit((Tree)initializer.getBody(), (Object)p);
        }
        return enoom;
    }

    @Override
    public J visitEnumValueSet(J.EnumValueSet enums, P p) {
        this.visitSpace(enums.getPrefix(), Space.Location.ENUM_VALUE_SET_PREFIX, p);
        this.visitMarkers(enums.getMarkers(), p);
        this.visitRightPadded(enums.getPadding().getEnums(), JRightPadded.Location.ENUM_VALUE, ",", p);
        StringBuilder acc = this.getPrinter();
        if (enums.isTerminatedWithSemicolon()) {
            acc.append(';');
        }
        return enums;
    }

    @Override
    public J visitFieldAccess(J.FieldAccess fieldAccess, P p) {
        this.visitSpace(fieldAccess.getPrefix(), Space.Location.FIELD_ACCESS_PREFIX, p);
        this.visitMarkers(fieldAccess.getMarkers(), p);
        this.visit((Tree)fieldAccess.getTarget(), (Object)p);
        this.visitLeftPadded(".", fieldAccess.getPadding().getName(), JLeftPadded.Location.FIELD_ACCESS_NAME, p);
        return fieldAccess;
    }

    @Override
    public J visitForLoop(J.ForLoop forLoop, P p) {
        this.visitSpace(forLoop.getPrefix(), Space.Location.FOR_PREFIX, p);
        this.visitMarkers(forLoop.getMarkers(), p);
        StringBuilder acc = this.getPrinter();
        acc.append("for");
        J.ForLoop.Control ctrl = forLoop.getControl();
        this.visitSpace(ctrl.getPrefix(), Space.Location.FOR_CONTROL_PREFIX, p);
        acc.append('(');
        this.visitRightPadded(ctrl.getPadding().getInit(), JRightPadded.Location.FOR_INIT, ";", p);
        this.visitRightPadded(ctrl.getPadding().getCondition(), JRightPadded.Location.FOR_CONDITION, ";", p);
        this.visitRightPadded(ctrl.getPadding().getUpdate(), JRightPadded.Location.FOR_UPDATE, ",", p);
        acc.append(')');
        this.visitStatement(forLoop.getPadding().getBody(), JRightPadded.Location.FOR_BODY, p);
        return forLoop;
    }

    @Override
    public J visitForEachLoop(J.ForEachLoop forEachLoop, P p) {
        this.visitSpace(forEachLoop.getPrefix(), Space.Location.FOR_EACH_LOOP_PREFIX, p);
        this.visitMarkers(forEachLoop.getMarkers(), p);
        StringBuilder acc = this.getPrinter();
        acc.append("for");
        J.ForEachLoop.Control ctrl = forEachLoop.getControl();
        this.visitSpace(ctrl.getPrefix(), Space.Location.FOR_EACH_CONTROL_PREFIX, p);
        acc.append('(');
        this.visitRightPadded(ctrl.getPadding().getVariable(), JRightPadded.Location.FOREACH_VARIABLE, ":", p);
        this.visitRightPadded(ctrl.getPadding().getIterable(), JRightPadded.Location.FOREACH_ITERABLE, "", p);
        acc.append(')');
        this.visitStatement(forEachLoop.getPadding().getBody(), JRightPadded.Location.FOR_BODY, p);
        return forEachLoop;
    }

    @Override
    public J visitIdentifier(J.Identifier ident, P p) {
        this.visitSpace(ident.getPrefix(), Space.Location.IDENTIFIER_PREFIX, p);
        this.visitMarkers(ident.getMarkers(), p);
        StringBuilder acc = this.getPrinter();
        acc.append(ident.getSimpleName());
        return ident;
    }

    @Override
    public J visitIf(J.If iff, P p) {
        this.visitSpace(iff.getPrefix(), Space.Location.IF_PREFIX, p);
        this.visitMarkers(iff.getMarkers(), p);
        StringBuilder acc = this.getPrinter();
        acc.append("if");
        this.visit((Tree)iff.getIfCondition(), (Object)p);
        this.visitStatement(iff.getPadding().getThenPart(), JRightPadded.Location.IF_THEN, p);
        this.visit((Tree)iff.getElsePart(), (Object)p);
        return iff;
    }

    @Override
    public J visitImport(J.Import impoort, P p) {
        StringBuilder acc = this.getPrinter();
        this.visitSpace(impoort.getPrefix(), Space.Location.IMPORT_PREFIX, p);
        this.visitMarkers(impoort.getMarkers(), p);
        acc.append("import");
        if (impoort.isStatic()) {
            this.visitSpace(impoort.getPadding().getStatic().getBefore(), Space.Location.STATIC_IMPORT, p);
            acc.append("static");
        }
        this.visit((Tree)impoort.getQualid(), (Object)p);
        return impoort;
    }

    @Override
    public J visitInstanceOf(J.InstanceOf instanceOf, P p) {
        this.visitSpace(instanceOf.getPrefix(), Space.Location.INSTANCEOF_PREFIX, p);
        this.visitMarkers(instanceOf.getMarkers(), p);
        this.visitRightPadded(instanceOf.getPadding().getExpr(), JRightPadded.Location.INSTANCEOF, "instanceof", p);
        this.visit((Tree)instanceOf.getClazz(), (Object)p);
        return instanceOf;
    }

    @Override
    public J visitLabel(J.Label label, P p) {
        this.visitSpace(label.getPrefix(), Space.Location.LABEL_PREFIX, p);
        this.visitMarkers(label.getMarkers(), p);
        this.visitRightPadded(label.getPadding().getLabel(), JRightPadded.Location.LABEL, ":", p);
        this.visit((Tree)label.getStatement(), (Object)p);
        return label;
    }

    @Override
    public J visitLambda(J.Lambda lambda, P p) {
        StringBuilder acc = this.getPrinter();
        this.visitSpace(lambda.getPrefix(), Space.Location.LAMBDA_PREFIX, p);
        this.visitMarkers(lambda.getMarkers(), p);
        this.visitSpace(lambda.getParameters().getPrefix(), Space.Location.LAMBDA_PARAMETERS_PREFIX, p);
        this.visitMarkers(lambda.getParameters().getMarkers(), p);
        if (lambda.getParameters().isParenthesized()) {
            acc.append('(');
            this.visitRightPadded(lambda.getParameters().getPadding().getParams(), JRightPadded.Location.LAMBDA_PARAM, ",", p);
            acc.append(')');
        } else {
            this.visitRightPadded(lambda.getParameters().getPadding().getParams(), JRightPadded.Location.LAMBDA_PARAM, ",", p);
        }
        this.visitSpace(lambda.getArrow(), Space.Location.LAMBDA_ARROW_PREFIX, p);
        acc.append("->");
        this.visit((Tree)lambda.getBody(), (Object)p);
        return lambda;
    }

    @Override
    public J visitLiteral(J.Literal literal, P p) {
        this.visitSpace(literal.getPrefix(), Space.Location.LITERAL_PREFIX, p);
        this.visitMarkers(literal.getMarkers(), p);
        StringBuilder acc = this.getPrinter();
        J.Literal.ModifiedUtf8Surrogate modifiedUtf8Surrogate = literal.getModifiedUtf8Surrogate();
        if (modifiedUtf8Surrogate != null) {
            acc.append(modifiedUtf8Surrogate.getEscapeSequence()).append(modifiedUtf8Surrogate.getCodePoint());
        } else {
            acc.append(literal.getValueSource());
        }
        return literal;
    }

    @Override
    public J visitMemberReference(J.MemberReference memberRef, P p) {
        this.visitSpace(memberRef.getPrefix(), Space.Location.MEMBER_REFERENCE_PREFIX, p);
        this.visitMarkers(memberRef.getMarkers(), p);
        this.visitRightPadded(memberRef.getPadding().getContaining(), JRightPadded.Location.MEMBER_REFERENCE_CONTAINING, p);
        this.getPrinter().append("::");
        this.visitContainer("<", memberRef.getPadding().getTypeParameters(), JContainer.Location.TYPE_PARAMETERS, ",", ">", p);
        this.visitLeftPadded("", memberRef.getPadding().getReference(), JLeftPadded.Location.MEMBER_REFERENCE_NAME, p);
        return memberRef;
    }

    @Override
    public J visitMethodDeclaration(J.MethodDeclaration method, P p) {
        this.visitSpace(method.getPrefix(), Space.Location.METHOD_DECLARATION_PREFIX, p);
        this.visitMarkers(method.getMarkers(), p);
        this.visitSpace(Space.EMPTY, Space.Location.ANNOTATIONS, p);
        this.visit(method.getLeadingAnnotations(), p);
        this.visitModifiers(method.getModifiers(), p);
        J.TypeParameters typeParameters = method.getAnnotations().getTypeParameters();
        if (typeParameters != null) {
            this.visit(typeParameters.getAnnotations(), p);
            this.visitSpace(typeParameters.getPrefix(), Space.Location.TYPE_PARAMETERS, p);
            this.visitMarkers(typeParameters.getMarkers(), p);
            StringBuilder acc = this.getPrinter();
            acc.append("<");
            this.visitRightPadded(typeParameters.getPadding().getTypeParameters(), JRightPadded.Location.TYPE_PARAMETER, ",", p);
            acc.append(">");
        }
        this.visit((Tree)method.getReturnTypeExpression(), (Object)p);
        this.visit(method.getAnnotations().getName().getAnnotations(), p);
        this.visit((Tree)method.getName(), (Object)p);
        this.visitContainer("(", method.getPadding().getParameters(), JContainer.Location.METHOD_DECLARATION_PARAMETERS, ",", ")", p);
        this.visitContainer("throws", method.getPadding().getThrows(), JContainer.Location.THROWS, ",", null, p);
        this.visit((Tree)method.getBody(), (Object)p);
        this.visitLeftPadded("default", method.getPadding().getDefaultValue(), JLeftPadded.Location.METHOD_DECLARATION_DEFAULT_VALUE, p);
        return method;
    }

    @Override
    public J visitMethodInvocation(J.MethodInvocation method, P p) {
        this.visitSpace(method.getPrefix(), Space.Location.METHOD_INVOCATION_PREFIX, p);
        this.visitMarkers(method.getMarkers(), p);
        this.visitRightPadded(method.getPadding().getSelect(), JRightPadded.Location.METHOD_SELECT, ".", p);
        this.visitContainer("<", method.getPadding().getTypeParameters(), JContainer.Location.TYPE_PARAMETERS, ",", ">", p);
        this.visit((Tree)method.getName(), (Object)p);
        this.visitContainer("(", method.getPadding().getArguments(), JContainer.Location.METHOD_INVOCATION_ARGUMENTS, ",", ")", p);
        return method;
    }

    @Override
    public J visitMultiCatch(J.MultiCatch multiCatch, P p) {
        this.visitSpace(multiCatch.getPrefix(), Space.Location.MULTI_CATCH_PREFIX, p);
        this.visitMarkers(multiCatch.getMarkers(), p);
        this.visitRightPadded(multiCatch.getPadding().getAlternatives(), JRightPadded.Location.CATCH_ALTERNATIVE, "|", p);
        return multiCatch;
    }

    @Override
    public J visitVariableDeclarations(J.VariableDeclarations multiVariable, P p) {
        StringBuilder acc = this.getPrinter();
        this.visitSpace(multiVariable.getPrefix(), Space.Location.VARIABLE_DECLARATIONS_PREFIX, p);
        this.visitMarkers(multiVariable.getMarkers(), p);
        this.visitSpace(Space.EMPTY, Space.Location.ANNOTATIONS, p);
        this.visit(multiVariable.getLeadingAnnotations(), p);
        this.visitModifiers(multiVariable.getModifiers(), p);
        this.visit((Tree)multiVariable.getTypeExpression(), (Object)p);
        for (JLeftPadded<Space> dim : multiVariable.getDimensionsBeforeName()) {
            this.visitSpace(dim.getBefore(), Space.Location.DIMENSION_PREFIX, p);
            acc.append('[');
            this.visitSpace(dim.getElement(), Space.Location.DIMENSION, p);
            acc.append(']');
        }
        if (multiVariable.getVarargs() != null) {
            this.visitSpace(multiVariable.getVarargs(), Space.Location.VARARGS, p);
            acc.append("...");
        }
        this.visitRightPadded(multiVariable.getPadding().getVariables(), JRightPadded.Location.NAMED_VARIABLE, ",", p);
        return multiVariable;
    }

    @Override
    public J visitNewArray(J.NewArray newArray, P p) {
        StringBuilder acc = this.getPrinter();
        this.visitSpace(newArray.getPrefix(), Space.Location.NEW_ARRAY_PREFIX, p);
        this.visitMarkers(newArray.getMarkers(), p);
        if (newArray.getTypeExpression() != null) {
            acc.append("new");
        }
        this.visit((Tree)newArray.getTypeExpression(), (Object)p);
        this.visit(newArray.getDimensions(), p);
        this.visitContainer("{", newArray.getPadding().getInitializer(), JContainer.Location.NEW_ARRAY_INITIALIZER, ",", "}", p);
        return newArray;
    }

    @Override
    public J visitNewClass(J.NewClass newClass, P p) {
        StringBuilder acc = this.getPrinter();
        this.visitSpace(newClass.getPrefix(), Space.Location.NEW_CLASS_PREFIX, p);
        this.visitMarkers(newClass.getMarkers(), p);
        this.visitRightPadded(newClass.getPadding().getEnclosing(), JRightPadded.Location.NEW_CLASS_ENCLOSING, ".", p);
        this.visitSpace(newClass.getNew(), Space.Location.NEW_PREFIX, p);
        acc.append("new");
        this.visit((Tree)newClass.getClazz(), (Object)p);
        this.visitContainer("(", newClass.getPadding().getArguments(), JContainer.Location.NEW_CLASS_ARGUMENTS, ",", ")", p);
        this.visit((Tree)newClass.getBody(), (Object)p);
        return newClass;
    }

    @Override
    public J visitPackage(J.Package pkg, P p) {
        StringBuilder acc = this.getPrinter();
        pkg.getAnnotations().forEach(a -> this.visitAnnotation((J.Annotation)a, p));
        this.visitSpace(pkg.getPrefix(), Space.Location.PACKAGE_PREFIX, p);
        this.visitMarkers(pkg.getMarkers(), p);
        acc.append("package");
        this.visit((Tree)pkg.getExpression(), (Object)p);
        return pkg;
    }

    @Override
    public J visitParameterizedType(J.ParameterizedType type, P p) {
        this.visitSpace(type.getPrefix(), Space.Location.PARAMETERIZED_TYPE_PREFIX, p);
        this.visitMarkers(type.getMarkers(), p);
        this.visit((Tree)type.getClazz(), (Object)p);
        this.visitContainer("<", type.getPadding().getTypeParameters(), JContainer.Location.TYPE_PARAMETERS, ",", ">", p);
        return type;
    }

    @Override
    public J visitPrimitive(J.Primitive primitive, P p) {
        String keyword;
        switch (primitive.getType()) {
            case Boolean: {
                keyword = "boolean";
                break;
            }
            case Byte: {
                keyword = "byte";
                break;
            }
            case Char: {
                keyword = "char";
                break;
            }
            case Double: {
                keyword = "double";
                break;
            }
            case Float: {
                keyword = "float";
                break;
            }
            case Int: {
                keyword = "int";
                break;
            }
            case Long: {
                keyword = "long";
                break;
            }
            case Short: {
                keyword = "short";
                break;
            }
            case Void: {
                keyword = "void";
                break;
            }
            case String: {
                keyword = "String";
                break;
            }
            case Wildcard: {
                keyword = "*";
                break;
            }
            case None: {
                throw new IllegalStateException("Unable to print None primitive");
            }
            case Null: {
                throw new IllegalStateException("Unable to print Null primitive");
            }
            default: {
                throw new IllegalStateException("Unable to print non-primitive type");
            }
        }
        StringBuilder acc = this.getPrinter();
        this.visitSpace(primitive.getPrefix(), Space.Location.PRIMITIVE_PREFIX, p);
        this.visitMarkers(primitive.getMarkers(), p);
        acc.append(keyword);
        return primitive;
    }

    @Override
    public <T extends J> J visitParentheses(J.Parentheses<T> parens, P p) {
        StringBuilder acc = this.getPrinter();
        this.visitSpace(parens.getPrefix(), Space.Location.PARENTHESES_PREFIX, p);
        this.visitMarkers(parens.getMarkers(), p);
        acc.append("(");
        this.visitRightPadded(parens.getPadding().getTree(), JRightPadded.Location.PARENTHESES, ")", p);
        return parens;
    }

    @Override
    public J visitReturn(J.Return retrn, P p) {
        StringBuilder acc = this.getPrinter();
        this.visitSpace(retrn.getPrefix(), Space.Location.RETURN_PREFIX, p);
        this.visitMarkers(retrn.getMarkers(), p);
        acc.append("return");
        this.visit((Tree)retrn.getExpression(), (Object)p);
        return retrn;
    }

    @Override
    public J visitSwitch(J.Switch switzh, P p) {
        StringBuilder acc = this.getPrinter();
        this.visitSpace(switzh.getPrefix(), Space.Location.SWITCH_PREFIX, p);
        this.visitMarkers(switzh.getMarkers(), p);
        acc.append("switch");
        this.visit((Tree)switzh.getSelector(), (Object)p);
        this.visit((Tree)switzh.getCases(), (Object)p);
        return switzh;
    }

    @Override
    public J visitSynchronized(J.Synchronized synch, P p) {
        StringBuilder acc = this.getPrinter();
        this.visitSpace(synch.getPrefix(), Space.Location.SYNCHRONIZED_PREFIX, p);
        this.visitMarkers(synch.getMarkers(), p);
        acc.append("synchronized");
        this.visit((Tree)synch.getLock(), (Object)p);
        this.visit((Tree)synch.getBody(), (Object)p);
        return synch;
    }

    @Override
    public J visitTernary(J.Ternary ternary, P p) {
        this.visitSpace(ternary.getPrefix(), Space.Location.TERNARY_PREFIX, p);
        this.visitMarkers(ternary.getMarkers(), p);
        this.visit((Tree)ternary.getCondition(), (Object)p);
        this.visitLeftPadded("?", ternary.getPadding().getTruePart(), JLeftPadded.Location.TERNARY_TRUE, p);
        this.visitLeftPadded(":", ternary.getPadding().getFalsePart(), JLeftPadded.Location.TERNARY_FALSE, p);
        return ternary;
    }

    @Override
    public J visitThrow(J.Throw thrown, P p) {
        StringBuilder acc = this.getPrinter();
        this.visitSpace(thrown.getPrefix(), Space.Location.THROW_PREFIX, p);
        this.visitMarkers(thrown.getMarkers(), p);
        acc.append("throw");
        this.visit((Tree)thrown.getException(), (Object)p);
        return thrown;
    }

    @Override
    public J visitTry(J.Try tryable, P p) {
        StringBuilder acc = this.getPrinter();
        this.visitSpace(tryable.getPrefix(), Space.Location.TRY_PREFIX, p);
        this.visitMarkers(tryable.getMarkers(), p);
        acc.append("try");
        if (tryable.getPadding().getResources() != null) {
            this.visitSpace(tryable.getPadding().getResources().getBefore(), Space.Location.TRY_RESOURCES, p);
            acc.append('(');
            List<JRightPadded<J.Try.Resource>> resources = tryable.getPadding().getResources().getPadding().getElements();
            for (int i = 0; i < resources.size(); ++i) {
                JRightPadded<J.Try.Resource> resource = resources.get(i);
                this.visitSpace(resource.getElement().getPrefix(), Space.Location.TRY_RESOURCE, p);
                this.visitMarkers(resource.getElement().getMarkers(), p);
                this.visit((Tree)resource.getElement().getVariableDeclarations(), (Object)p);
                if (i < resources.size() - 1 || resource.getElement().isTerminatedWithSemicolon()) {
                    acc.append(';');
                }
                this.visitSpace(resource.getAfter(), Space.Location.TRY_RESOURCE_SUFFIX, p);
            }
            acc.append(')');
        }
        this.visit((Tree)tryable.getBody(), (Object)p);
        this.visit(tryable.getCatches(), p);
        this.visitLeftPadded("finally", tryable.getPadding().getFinally(), JLeftPadded.Location.TRY_FINALLY, p);
        return tryable;
    }

    @Override
    public J visitTypeParameter(J.TypeParameter typeParam, P p) {
        this.visitSpace(typeParam.getPrefix(), Space.Location.TYPE_PARAMETERS_PREFIX, p);
        this.visitMarkers(typeParam.getMarkers(), p);
        this.visit(typeParam.getAnnotations(), p);
        this.visit((Tree)typeParam.getName(), (Object)p);
        this.visitContainer("extends", typeParam.getPadding().getBounds(), JContainer.Location.TYPE_BOUNDS, "&", "", p);
        return typeParam;
    }

    @Override
    public J visitUnary(J.Unary unary, P p) {
        StringBuilder acc = this.getPrinter();
        this.visitSpace(unary.getPrefix(), Space.Location.UNARY_PREFIX, p);
        this.visitMarkers(unary.getMarkers(), p);
        switch (unary.getOperator()) {
            case PreIncrement: {
                acc.append("++");
                this.visit((Tree)unary.getExpression(), (Object)p);
                break;
            }
            case PreDecrement: {
                acc.append("--");
                this.visit((Tree)unary.getExpression(), (Object)p);
                break;
            }
            case PostIncrement: {
                this.visit((Tree)unary.getExpression(), (Object)p);
                this.visitSpace(unary.getPadding().getOperator().getBefore(), Space.Location.UNARY_OPERATOR, p);
                acc.append("++");
                break;
            }
            case PostDecrement: {
                this.visit((Tree)unary.getExpression(), (Object)p);
                this.visitSpace(unary.getPadding().getOperator().getBefore(), Space.Location.UNARY_OPERATOR, p);
                acc.append("--");
                break;
            }
            case Positive: {
                acc.append("+");
                this.visit((Tree)unary.getExpression(), (Object)p);
                break;
            }
            case Negative: {
                acc.append("-");
                this.visit((Tree)unary.getExpression(), (Object)p);
                break;
            }
            case Complement: {
                acc.append("~");
                this.visit((Tree)unary.getExpression(), (Object)p);
                break;
            }
            default: {
                acc.append("!");
                this.visit((Tree)unary.getExpression(), (Object)p);
            }
        }
        return unary;
    }

    @Override
    public J visitVariable(J.VariableDeclarations.NamedVariable variable, P p) {
        StringBuilder acc = this.getPrinter();
        this.visitSpace(variable.getPrefix(), Space.Location.VARIABLE_PREFIX, p);
        this.visitMarkers(variable.getMarkers(), p);
        this.visit((Tree)variable.getName(), (Object)p);
        for (JLeftPadded<Space> dimension : variable.getDimensionsAfterName()) {
            this.visitSpace(dimension.getBefore(), Space.Location.DIMENSION_PREFIX, p);
            acc.append('[');
            this.visitSpace(dimension.getElement(), Space.Location.DIMENSION, p);
            acc.append(']');
        }
        this.visitLeftPadded("=", variable.getPadding().getInitializer(), JLeftPadded.Location.VARIABLE_INITIALIZER, p);
        return variable;
    }

    @Override
    public J visitWhileLoop(J.WhileLoop whileLoop, P p) {
        StringBuilder acc = this.getPrinter();
        this.visitSpace(whileLoop.getPrefix(), Space.Location.WHILE_PREFIX, p);
        this.visitMarkers(whileLoop.getMarkers(), p);
        acc.append("while");
        this.visit((Tree)whileLoop.getCondition(), (Object)p);
        this.visitStatement(whileLoop.getPadding().getBody(), JRightPadded.Location.WHILE_BODY, p);
        return whileLoop;
    }

    @Override
    public J visitWildcard(J.Wildcard wildcard, P p) {
        StringBuilder acc = this.getPrinter();
        this.visitSpace(wildcard.getPrefix(), Space.Location.WILDCARD_PREFIX, p);
        this.visitMarkers(wildcard.getMarkers(), p);
        acc.append('?');
        if (wildcard.getPadding().getBound() != null) {
            switch (wildcard.getBound()) {
                case Extends: {
                    this.visitSpace(wildcard.getPadding().getBound().getBefore(), Space.Location.WILDCARD_BOUND, p);
                    acc.append("extends");
                    break;
                }
                case Super: {
                    this.visitSpace(wildcard.getPadding().getBound().getBefore(), Space.Location.WILDCARD_BOUND, p);
                    acc.append("super");
                }
            }
        }
        this.visit((Tree)wildcard.getBoundedType(), (Object)p);
        return wildcard;
    }
}

