/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.Flag;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.NameTree;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.marker.Markers;

public final class ChangeType
extends Recipe {
    @Option(displayName="Old fully-qualified type name", description="Fully-qualified class name of the original type.")
    private final String oldFullyQualifiedTypeName;
    @Option(displayName="New fully-qualified type name", description="Fully-qualified class name of the replacement type, the replacement type can also defined as a primitive.")
    private final String newFullyQualifiedTypeName;

    public String getDisplayName() {
        return "Change type";
    }

    public String getDescription() {
        return "Change a given type to another.";
    }

    public boolean causesAnotherCycle() {
        return true;
    }

    public JavaVisitor<ExecutionContext> getVisitor() {
        return new ChangeTypeVisitor(this.newFullyQualifiedTypeName);
    }

    protected JavaVisitor<ExecutionContext> getSingleSourceApplicableTest() {
        return new UsesType<ExecutionContext>(this.oldFullyQualifiedTypeName);
    }

    public ChangeType(String oldFullyQualifiedTypeName, String newFullyQualifiedTypeName) {
        this.oldFullyQualifiedTypeName = oldFullyQualifiedTypeName;
        this.newFullyQualifiedTypeName = newFullyQualifiedTypeName;
    }

    public String getOldFullyQualifiedTypeName() {
        return this.oldFullyQualifiedTypeName;
    }

    public String getNewFullyQualifiedTypeName() {
        return this.newFullyQualifiedTypeName;
    }

    @NonNull
    public String toString() {
        return "ChangeType(oldFullyQualifiedTypeName=" + this.getOldFullyQualifiedTypeName() + ", newFullyQualifiedTypeName=" + this.getNewFullyQualifiedTypeName() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChangeType)) {
            return false;
        }
        ChangeType other = (ChangeType)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$oldFullyQualifiedTypeName = this.getOldFullyQualifiedTypeName();
        String other$oldFullyQualifiedTypeName = other.getOldFullyQualifiedTypeName();
        if (this$oldFullyQualifiedTypeName == null ? other$oldFullyQualifiedTypeName != null : !this$oldFullyQualifiedTypeName.equals(other$oldFullyQualifiedTypeName)) {
            return false;
        }
        String this$newFullyQualifiedTypeName = this.getNewFullyQualifiedTypeName();
        String other$newFullyQualifiedTypeName = other.getNewFullyQualifiedTypeName();
        return !(this$newFullyQualifiedTypeName == null ? other$newFullyQualifiedTypeName != null : !this$newFullyQualifiedTypeName.equals(other$newFullyQualifiedTypeName));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ChangeType;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $oldFullyQualifiedTypeName = this.getOldFullyQualifiedTypeName();
        result = result * 59 + ($oldFullyQualifiedTypeName == null ? 43 : $oldFullyQualifiedTypeName.hashCode());
        String $newFullyQualifiedTypeName = this.getNewFullyQualifiedTypeName();
        result = result * 59 + ($newFullyQualifiedTypeName == null ? 43 : $newFullyQualifiedTypeName.hashCode());
        return result;
    }

    private class ChangeTypeVisitor
    extends JavaVisitor<ExecutionContext> {
        private final JavaType targetType;
        private final JavaType.Class originalType;

        private ChangeTypeVisitor(String targetType) {
            this.originalType = JavaType.Class.build(ChangeType.this.oldFullyQualifiedTypeName);
            JavaType type = JavaType.Primitive.fromKeyword(targetType);
            if (type == null) {
                type = JavaType.Class.build(targetType);
            }
            this.targetType = type;
        }

        @Override
        public J visitCompilationUnit(J.CompilationUnit cu, ExecutionContext ctx) {
            if (this.targetType instanceof JavaType.FullyQualified) {
                this.maybeAddImport((JavaType.FullyQualified)this.targetType);
            }
            this.maybeRemoveImport(ChangeType.this.oldFullyQualifiedTypeName);
            return super.visitCompilationUnit(cu, ctx);
        }

        @Override
        public <N extends NameTree> N visitTypeName(N name, ExecutionContext ctx) {
            JavaType.FullyQualified oldTypeAsClass = TypeUtils.asFullyQualified(name.getType());
            NameTree n = (NameTree)this.visitAndCast(name, ctx, (x$0, x$1) -> super.visitTypeName(x$0, x$1));
            if (!(name instanceof TypeTree) && oldTypeAsClass != null && oldTypeAsClass.getFullyQualifiedName().equals(ChangeType.this.oldFullyQualifiedTypeName)) {
                n = (NameTree)n.withType(this.targetType);
            }
            return (N)n;
        }

        @Override
        public J visitAnnotation(J.Annotation annotation, ExecutionContext ctx) {
            J.Annotation a = (J.Annotation)this.visitAndCast(annotation, ctx, (x$0, x$1) -> super.visitAnnotation((J.Annotation)x$0, x$1));
            return a.withAnnotationType(this.transformName(a.getAnnotationType()));
        }

        @Override
        public J visitArrayType(J.ArrayType arrayType, ExecutionContext ctx) {
            J.ArrayType a = (J.ArrayType)this.visitAndCast(arrayType, ctx, (x$0, x$1) -> super.visitArrayType((J.ArrayType)x$0, x$1));
            return a.withElementType(this.transformName(a.getElementType()));
        }

        @Override
        public J visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext ctx) {
            J.ClassDeclaration c = (J.ClassDeclaration)this.visitAndCast(classDecl, ctx, (x$0, x$1) -> super.visitClassDeclaration((J.ClassDeclaration)x$0, x$1));
            if (c.getExtends() != null) {
                c = c.withExtends(this.transformName(c.getExtends()));
            }
            if (c.getImplements() != null) {
                c = c.withImplements(ListUtils.map(c.getImplements(), this::transformName));
            }
            return c;
        }

        @Override
        public J visitFieldAccess(J.FieldAccess fieldAccess, ExecutionContext ctx) {
            J.FieldAccess f = (J.FieldAccess)this.visitAndCast(fieldAccess, ctx, (x$0, x$1) -> super.visitFieldAccess((J.FieldAccess)x$0, x$1));
            if (f.isFullyQualifiedClassReference(ChangeType.this.oldFullyQualifiedTypeName)) {
                if (this.targetType instanceof JavaType.FullyQualified) {
                    return TypeTree.build(((JavaType.FullyQualified)this.targetType).getFullyQualifiedName()).withPrefix(f.getPrefix());
                }
                if (this.targetType instanceof JavaType.Primitive) {
                    return new J.Primitive(f.getId(), f.getPrefix(), Markers.EMPTY, (JavaType.Primitive)this.targetType);
                }
            }
            return f;
        }

        @Override
        public J visitIdentifier(J.Identifier ident, ExecutionContext ctx) {
            J.Identifier i = (J.Identifier)this.visitAndCast(ident, ctx, (x$0, x$1) -> super.visitIdentifier((J.Identifier)x$0, x$1));
            if (TypeUtils.isOfClassType(i.getType(), ChangeType.this.oldFullyQualifiedTypeName) && i.getSimpleName().equals(this.originalType.getClassName())) {
                if (this.targetType instanceof JavaType.FullyQualified) {
                    i = i.withName(((JavaType.FullyQualified)this.targetType).getClassName());
                } else if (this.targetType instanceof JavaType.Primitive) {
                    i = i.withName(((JavaType.Primitive)this.targetType).getKeyword());
                }
                i = i.withType(this.targetType);
            }
            return i;
        }

        @Override
        public J visitMethodDeclaration(J.MethodDeclaration method, ExecutionContext ctx) {
            J.MethodDeclaration m = (J.MethodDeclaration)this.visitAndCast(method, ctx, (x$0, x$1) -> super.visitMethodDeclaration((J.MethodDeclaration)x$0, x$1));
            return m.withThrows((m = m.withReturnTypeExpression(this.transformName(m.getReturnTypeExpression()))).getThrows() == null ? null : ListUtils.map(m.getThrows(), this::transformName));
        }

        @Override
        public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
            JavaType.FullyQualified selectType;
            J.MethodInvocation m = (J.MethodInvocation)this.visitAndCast(method, ctx, (x$0, x$1) -> super.visitMethodInvocation((J.MethodInvocation)x$0, x$1));
            if (m.getSelect() instanceof NameTree && m.getType() != null && m.getType().hasFlags(Flag.Static)) {
                m = m.withSelect(this.transformName(m.getSelect()));
            }
            if (m.getSelect() != null && (selectType = TypeUtils.asFullyQualified(m.getSelect().getType())) != null && selectType.getFullyQualifiedName().equals(ChangeType.this.oldFullyQualifiedTypeName)) {
                m = m.withSelect((Expression)m.getSelect().withType(this.targetType));
            }
            if (m.getType() != null && m.getType().getDeclaringType().getFullyQualifiedName().equals(ChangeType.this.oldFullyQualifiedTypeName) && this.targetType instanceof JavaType.FullyQualified) {
                m = m.withDeclaringType((JavaType.FullyQualified)this.targetType);
            }
            return m;
        }

        @Override
        public J visitMultiCatch(J.MultiCatch multiCatch, ExecutionContext ctx) {
            J.MultiCatch m = (J.MultiCatch)this.visitAndCast(multiCatch, ctx, (x$0, x$1) -> super.visitMultiCatch((J.MultiCatch)x$0, x$1));
            return m.withAlternatives(ListUtils.map(m.getAlternatives(), this::transformName));
        }

        @Override
        public J visitVariableDeclarations(J.VariableDeclarations multiVariable, ExecutionContext ctx) {
            J.VariableDeclarations m = (J.VariableDeclarations)this.visitAndCast(multiVariable, ctx, (x$0, x$1) -> super.visitVariableDeclarations((J.VariableDeclarations)x$0, x$1));
            if (!(multiVariable.getTypeExpression() instanceof J.MultiCatch)) {
                m = m.withTypeExpression(this.transformName(m.getTypeExpression()));
            }
            return m;
        }

        public J.VariableDeclarations.NamedVariable visitVariable(J.VariableDeclarations.NamedVariable variable, ExecutionContext ctx) {
            J.VariableDeclarations.NamedVariable v = (J.VariableDeclarations.NamedVariable)this.visitAndCast(variable, ctx, (x$0, x$1) -> super.visitVariable((J.VariableDeclarations.NamedVariable)x$0, x$1));
            JavaType.FullyQualified varType = TypeUtils.asFullyQualified(variable.getType());
            if (varType != null && varType.getFullyQualifiedName().equals(ChangeType.this.oldFullyQualifiedTypeName)) {
                v = v.withType(this.targetType).withName(v.getName().withType(this.targetType));
            }
            return v;
        }

        @Override
        public J visitNewArray(J.NewArray newArray, ExecutionContext ctx) {
            J.NewArray n = (J.NewArray)this.visitAndCast(newArray, ctx, (x$0, x$1) -> super.visitNewArray((J.NewArray)x$0, x$1));
            return n.withTypeExpression(this.transformName(n.getTypeExpression()));
        }

        @Override
        public J visitNewClass(J.NewClass newClass, ExecutionContext ctx) {
            J.NewClass n = (J.NewClass)this.visitAndCast(newClass, ctx, (x$0, x$1) -> super.visitNewClass((J.NewClass)x$0, x$1));
            return n.withClazz(this.transformName(n.getClazz()));
        }

        @Override
        public J visitTypeCast(J.TypeCast typeCast, ExecutionContext ctx) {
            J.TypeCast t = (J.TypeCast)this.visitAndCast(typeCast, ctx, (x$0, x$1) -> super.visitTypeCast((J.TypeCast)x$0, x$1));
            return t.withClazz(t.getClazz().withTree(this.transformName(t.getClazz().getTree())));
        }

        @Override
        public J visitTypeParameter(J.TypeParameter typeParam, ExecutionContext ctx) {
            J.TypeParameter t;
            t = t.withBounds((t = (J.TypeParameter)this.visitAndCast(typeParam, ctx, (x$0, x$1) -> super.visitTypeParameter((J.TypeParameter)x$0, x$1))).getBounds() == null ? null : ListUtils.map(t.getBounds(), this::transformName));
            return t.withName(this.transformName(t.getName()));
        }

        @Override
        public J visitWildcard(J.Wildcard wildcard, ExecutionContext ctx) {
            J.Wildcard w = (J.Wildcard)this.visitAndCast(wildcard, ctx, (x$0, x$1) -> super.visitWildcard((J.Wildcard)x$0, x$1));
            return w.withBoundedType(this.transformName(w.getBoundedType()));
        }

        private <T extends J> T transformName(@Nullable T nameField) {
            if (nameField instanceof NameTree) {
                JavaType.FullyQualified nameTreeClass = TypeUtils.asFullyQualified(((NameTree)nameField).getType());
                String name = this.targetType instanceof JavaType.FullyQualified ? ((JavaType.FullyQualified)this.targetType).getClassName() : ((JavaType.Primitive)this.targetType).getKeyword();
                if (nameTreeClass != null && nameTreeClass.getFullyQualifiedName().equals(ChangeType.this.oldFullyQualifiedTypeName)) {
                    return (T)J.Identifier.build(Tree.randomId(), nameField.getPrefix(), Markers.EMPTY, name, this.targetType);
                }
            }
            return nameField;
        }
    }
}

