/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.nio.file.Paths;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.marker.JavaSearchResult;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.Flag;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.NameTree;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.Markers;

public final class ChangePackage
extends Recipe {
    @Option(displayName="Old package name", description="The package name to replace.")
    private final String oldPackageName;
    @Option(displayName="New package name", description="New package name to replace the old package name with.")
    private final String newPackageName;
    @Option(displayName="Recursive", description="Recursively change subpackage names", required=false)
    @Nullable
    private final Boolean recursive;

    public String getDisplayName() {
        return "Rename package name";
    }

    public String getDescription() {
        return "A recipe that will rename a package name in package statements, imports, and fully-qualified types.";
    }

    protected JavaVisitor<ExecutionContext> getSingleSourceApplicableTest() {
        return new JavaIsoVisitor<ExecutionContext>(){

            @Override
            public J.CompilationUnit visitCompilationUnit(J.CompilationUnit cu, ExecutionContext executionContext) {
                String original;
                if (cu.getPackageDeclaration() != null && (original = cu.getPackageDeclaration().getExpression().printTrimmed().replaceAll("\\s", "")).startsWith(ChangePackage.this.oldPackageName)) {
                    return cu.withMarkers(cu.getMarkers().addIfAbsent((Marker)new JavaSearchResult(Tree.randomId(), ChangePackage.this)));
                }
                this.doAfterVisit(new UsesType(ChangePackage.this.oldPackageName + ".*"));
                return cu;
            }
        };
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new ChangePackageVisitor();
    }

    public ChangePackage(String oldPackageName, String newPackageName, @Nullable Boolean recursive) {
        this.oldPackageName = oldPackageName;
        this.newPackageName = newPackageName;
        this.recursive = recursive;
    }

    public String getOldPackageName() {
        return this.oldPackageName;
    }

    public String getNewPackageName() {
        return this.newPackageName;
    }

    @Nullable
    public Boolean getRecursive() {
        return this.recursive;
    }

    @NonNull
    public String toString() {
        return "ChangePackage(oldPackageName=" + this.getOldPackageName() + ", newPackageName=" + this.getNewPackageName() + ", recursive=" + this.getRecursive() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChangePackage)) {
            return false;
        }
        ChangePackage other = (ChangePackage)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$recursive = this.getRecursive();
        Boolean other$recursive = other.getRecursive();
        if (this$recursive == null ? other$recursive != null : !((Object)this$recursive).equals(other$recursive)) {
            return false;
        }
        String this$oldPackageName = this.getOldPackageName();
        String other$oldPackageName = other.getOldPackageName();
        if (this$oldPackageName == null ? other$oldPackageName != null : !this$oldPackageName.equals(other$oldPackageName)) {
            return false;
        }
        String this$newPackageName = this.getNewPackageName();
        String other$newPackageName = other.getNewPackageName();
        return !(this$newPackageName == null ? other$newPackageName != null : !this$newPackageName.equals(other$newPackageName));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ChangePackage;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $recursive = this.getRecursive();
        result = result * 59 + ($recursive == null ? 43 : ((Object)$recursive).hashCode());
        String $oldPackageName = this.getOldPackageName();
        result = result * 59 + ($oldPackageName == null ? 43 : $oldPackageName.hashCode());
        String $newPackageName = this.getNewPackageName();
        result = result * 59 + ($newPackageName == null ? 43 : $newPackageName.hashCode());
        return result;
    }

    @NonNull
    public ChangePackage withRecursive(@Nullable Boolean recursive) {
        return this.recursive == recursive ? this : new ChangePackage(this.oldPackageName, this.newPackageName, recursive);
    }

    private class ChangePackageVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private static final String RENAME_TO_KEY = "renameTo";
        private static final String RENAME_FROM_KEY = "renameFrom";
        private final JavaType.Class newPackageType;
        private final JavaType.Class oldPackageType;

        private ChangePackageVisitor() {
            this.newPackageType = JavaType.Class.build(ChangePackage.this.newPackageName);
            this.oldPackageType = JavaType.Class.build(ChangePackage.this.oldPackageName);
        }

        @Override
        public J.Annotation visitAnnotation(J.Annotation annotation, ExecutionContext ctx) {
            J a = super.visitAnnotation(annotation, ctx);
            if (((J.Annotation)a).getAnnotationType() instanceof J.FieldAccess && ((J.FieldAccess)((J.Annotation)a).getAnnotationType()).isFullyQualifiedClassReference(ChangePackage.this.oldPackageName)) {
                a = ((J.Annotation)a).withAnnotationType(this.transformName(((J.Annotation)a).getAnnotationType()));
            }
            return a;
        }

        @Override
        public J.ArrayType visitArrayType(J.ArrayType arrayType, ExecutionContext ctx) {
            J a = super.visitArrayType(arrayType, ctx);
            return ((J.ArrayType)a).withElementType(this.transformName(((J.ArrayType)a).getElementType()));
        }

        @Override
        public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext ctx) {
            J c = super.visitClassDeclaration(classDecl, ctx);
            String changingTo = (String)this.getCursor().getNearestMessage(RENAME_TO_KEY);
            if (changingTo != null && classDecl.getType() != null) {
                if (((J.ClassDeclaration)c).getExtends() != null) {
                    c = ((J.ClassDeclaration)c).withExtends(this.transformName(((J.ClassDeclaration)c).getExtends()));
                }
                if (((J.ClassDeclaration)c).getImplements() != null) {
                    c = ((J.ClassDeclaration)c).withImplements(ListUtils.map(((J.ClassDeclaration)c).getImplements(), this::transformName));
                }
            }
            return c;
        }

        @Override
        public J.CompilationUnit visitCompilationUnit(J.CompilationUnit cu, ExecutionContext ctx) {
            J c = super.visitCompilationUnit(cu, ctx);
            String changingTo = (String)this.getCursor().getMessage(RENAME_TO_KEY);
            if (changingTo != null) {
                String path = ((J.CompilationUnit)c).getSourcePath().toString().replace('\\', '/');
                String changingFrom = (String)this.getCursor().getMessage(RENAME_FROM_KEY);
                assert (changingFrom != null);
                c = ((J.CompilationUnit)c).withSourcePath(Paths.get(path.replaceFirst(changingFrom.replace('.', '/'), changingTo.replace('.', '/')), new String[0]));
            }
            return c;
        }

        @Override
        public J.FieldAccess visitFieldAccess(J.FieldAccess fieldAccess, ExecutionContext ctx) {
            J f = super.visitFieldAccess(fieldAccess, ctx);
            if (!(!((J.FieldAccess)f).isFullyQualifiedClassReference(ChangePackage.this.oldPackageName) || this.getCursor().getParent() == null || this.getCursor().getParent().getValue() instanceof J.FieldAccess && ((J.FieldAccess)this.getCursor().getParent().getValue()).isFullyQualifiedClassReference(ChangePackage.this.newPackageName))) {
                f = (J.FieldAccess)TypeTree.build(((JavaType.FullyQualified)this.newPackageType).getFullyQualifiedName()).withPrefix(((J.FieldAccess)f).getPrefix());
            }
            return f;
        }

        @Override
        public J.Identifier visitIdentifier(J.Identifier ident, ExecutionContext ctx) {
            J i = super.visitIdentifier(ident, ctx);
            if (TypeUtils.isOfClassType(((J.Identifier)i).getType(), ChangePackage.this.oldPackageName) && ((J.Identifier)i).getSimpleName().equals(this.oldPackageType.getClassName())) {
                i = ((J.Identifier)i).withName(this.newPackageType.getClassName()).withType(this.newPackageType);
            }
            return i;
        }

        @Override
        public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, ExecutionContext ctx) {
            J m = super.visitMethodDeclaration(method, ctx);
            return ((J.MethodDeclaration)m).withThrows(((J.MethodDeclaration)(m = ((J.MethodDeclaration)m).withReturnTypeExpression(this.transformName(((J.MethodDeclaration)m).getReturnTypeExpression())))).getThrows() == null ? null : ListUtils.map(((J.MethodDeclaration)m).getThrows(), this::transformName));
        }

        @Override
        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
            JavaType.FullyQualified selectType;
            J m = super.visitMethodInvocation(method, ctx);
            if (((J.MethodInvocation)m).getSelect() instanceof NameTree && ((J.MethodInvocation)m).getType() != null && ((J.MethodInvocation)m).getType().hasFlags(Flag.Static)) {
                m = ((J.MethodInvocation)m).withSelect(this.transformName(((J.MethodInvocation)m).getSelect()));
            }
            if (((J.MethodInvocation)m).getSelect() != null && (selectType = TypeUtils.asFullyQualified(((J.MethodInvocation)m).getSelect().getType())) != null && selectType.getFullyQualifiedName().equals(ChangePackage.this.oldPackageName)) {
                m = ((J.MethodInvocation)m).withSelect((Expression)((J.MethodInvocation)m).getSelect().withType(this.newPackageType));
            }
            if (((J.MethodInvocation)m).getType() != null && ((J.MethodInvocation)m).getType().getDeclaringType().getFullyQualifiedName().equals(ChangePackage.this.oldPackageName)) {
                m = ((J.MethodInvocation)m).withDeclaringType(this.newPackageType);
            }
            return m;
        }

        @Override
        public J.MultiCatch visitMultiCatch(J.MultiCatch multiCatch, ExecutionContext ctx) {
            J m = super.visitMultiCatch(multiCatch, ctx);
            return ((J.MultiCatch)m).withAlternatives(ListUtils.map(((J.MultiCatch)m).getAlternatives(), this::transformName));
        }

        @Override
        public J.NewArray visitNewArray(J.NewArray newArray, ExecutionContext ctx) {
            J n = super.visitNewArray(newArray, ctx);
            return ((J.NewArray)n).withTypeExpression(this.transformName(((J.NewArray)n).getTypeExpression()));
        }

        @Override
        public J.NewClass visitNewClass(J.NewClass newClass, ExecutionContext ctx) {
            J n = super.visitNewClass(newClass, ctx);
            return ((J.NewClass)n).withClazz(this.transformName(((J.NewClass)n).getClazz()));
        }

        @Override
        public J.Package visitPackage(J.Package pkg, ExecutionContext context) {
            String original = pkg.getExpression().printTrimmed().replaceAll("\\s", "");
            this.getCursor().putMessageOnFirstEnclosing(J.CompilationUnit.class, RENAME_FROM_KEY, (Object)original);
            if (original.equals(ChangePackage.this.oldPackageName)) {
                this.getCursor().putMessageOnFirstEnclosing(J.CompilationUnit.class, RENAME_TO_KEY, (Object)ChangePackage.this.newPackageName);
                pkg = (J.Package)pkg.withTemplate(this.template(ChangePackage.this.newPackageName).build(), pkg.getCoordinates().replace(), new Object[0]);
            } else if ((ChangePackage.this.recursive == null || ChangePackage.this.recursive.booleanValue()) && original.startsWith(ChangePackage.this.oldPackageName) && !original.startsWith(ChangePackage.this.newPackageName)) {
                String changingTo = ChangePackage.this.newPackageName + original.substring(ChangePackage.this.oldPackageName.length());
                this.getCursor().putMessageOnFirstEnclosing(J.CompilationUnit.class, RENAME_TO_KEY, (Object)changingTo);
                pkg = (J.Package)pkg.withTemplate(this.template(changingTo).build(), pkg.getCoordinates().replace(), new Object[0]);
            }
            return pkg;
        }

        @Override
        public J.TypeCast visitTypeCast(J.TypeCast typeCast, ExecutionContext ctx) {
            J t = super.visitTypeCast(typeCast, ctx);
            return ((J.TypeCast)t).withClazz(((J.TypeCast)t).getClazz().withTree(this.transformName(((J.TypeCast)t).getClazz().getTree())));
        }

        @Override
        public <N extends NameTree> N visitTypeName(N name, ExecutionContext ctx) {
            Object n = super.visitTypeName(name, ctx);
            JavaType.FullyQualified oldType = TypeUtils.asFullyQualified(name.getType());
            if (!(name instanceof TypeTree) && oldType != null && oldType.getFullyQualifiedName().equals(ChangePackage.this.oldPackageName)) {
                n = (NameTree)n.withType(this.newPackageType);
            }
            return n;
        }

        @Override
        public J.TypeParameter visitTypeParameter(J.TypeParameter typeParam, ExecutionContext ctx) {
            J t;
            t = ((J.TypeParameter)t).withBounds(((J.TypeParameter)(t = super.visitTypeParameter(typeParam, ctx))).getBounds() == null ? null : ListUtils.map(((J.TypeParameter)t).getBounds(), this::transformName));
            return ((J.TypeParameter)t).withName(this.transformName(((J.TypeParameter)t).getName()));
        }

        @Override
        public J.VariableDeclarations.NamedVariable visitVariable(J.VariableDeclarations.NamedVariable variable, ExecutionContext ctx) {
            J v = super.visitVariable(variable, ctx);
            JavaType.FullyQualified varType = TypeUtils.asFullyQualified(variable.getType());
            if (varType != null && varType.getFullyQualifiedName().equals(ChangePackage.this.oldPackageName)) {
                v = ((J.VariableDeclarations.NamedVariable)v).withType(this.newPackageType).withName(((J.VariableDeclarations.NamedVariable)v).getName().withType(this.newPackageType));
            }
            return v;
        }

        @Override
        public J.VariableDeclarations visitVariableDeclarations(J.VariableDeclarations multiVariable, ExecutionContext ctx) {
            J m = super.visitVariableDeclarations(multiVariable, ctx);
            if (!(multiVariable.getTypeExpression() instanceof J.MultiCatch)) {
                m = ((J.VariableDeclarations)m).withTypeExpression(this.transformName(((J.VariableDeclarations)m).getTypeExpression()));
            }
            return m;
        }

        @Override
        public J.Wildcard visitWildcard(J.Wildcard wildcard, ExecutionContext ctx) {
            J w = super.visitWildcard(wildcard, ctx);
            return ((J.Wildcard)w).withBoundedType(this.transformName(((J.Wildcard)w).getBoundedType()));
        }

        private <T extends J> T transformName(@Nullable T nameField) {
            if (nameField instanceof NameTree) {
                JavaType.FullyQualified nameTree = TypeUtils.asFullyQualified(((NameTree)nameField).getType());
                String name = this.newPackageType.getClassName();
                if (nameTree != null && nameTree.getFullyQualifiedName().equals(ChangePackage.this.oldPackageName)) {
                    return (T)J.Identifier.build(Tree.randomId(), nameField.getPrefix(), Markers.EMPTY, name, this.newPackageType);
                }
            }
            return nameField;
        }
    }
}

