/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.format;

import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.format.SpacesVisitor;
import org.openrewrite.java.style.EmptyForInitializerPadStyle;
import org.openrewrite.java.style.EmptyForIteratorPadStyle;
import org.openrewrite.java.style.IntelliJ;
import org.openrewrite.java.style.SpacesStyle;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;

public class Spaces
extends Recipe {
    public String getDisplayName() {
        return "Spaces";
    }

    public String getDescription() {
        return "Format whitespace in Java code.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new SpacesFromCompilationUnitStyle();
    }

    public static <J2 extends J> J2 formatSpaces(J j, Cursor cursor) {
        SourceFile cu = (SourceFile)cursor.firstEnclosingOrThrow(SourceFile.class);
        SpacesStyle style = (SpacesStyle)cu.getStyle(SpacesStyle.class);
        return (J2)((J)new SpacesVisitor(style == null ? IntelliJ.spaces() : style, (EmptyForInitializerPadStyle)cu.getStyle(EmptyForInitializerPadStyle.class), (EmptyForIteratorPadStyle)cu.getStyle(EmptyForIteratorPadStyle.class)).visitNonNull(j, 0, cursor));
    }

    private static class SpacesFromCompilationUnitStyle
    extends JavaIsoVisitor<ExecutionContext> {
        private SpacesFromCompilationUnitStyle() {
        }

        @Override
        public JavaSourceFile visitJavaSourceFile(JavaSourceFile cu, ExecutionContext executionContext) {
            SpacesStyle style = (SpacesStyle)((SourceFile)cu).getStyle(SpacesStyle.class);
            if (style == null) {
                style = IntelliJ.spaces();
            }
            this.doAfterVisit(new SpacesVisitor(style, (EmptyForInitializerPadStyle)((SourceFile)cu).getStyle(EmptyForInitializerPadStyle.class), (EmptyForIteratorPadStyle)((SourceFile)cu).getStyle(EmptyForIteratorPadStyle.class)));
            return super.visitJavaSourceFile(cu, executionContext);
        }
    }
}

