/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.util.Optional;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.format.SpacesVisitor;
import org.openrewrite.java.style.Checkstyle;
import org.openrewrite.java.style.IntelliJ;
import org.openrewrite.java.style.SpacesStyle;
import org.openrewrite.java.style.TypecastParenPadStyle;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;

public class TypecastParenPad
extends Recipe {
    public String getDisplayName() {
        return "Typecast parenthesis padding";
    }

    public String getDescription() {
        return "Fixes whitespace padding between a typecast type identifier and the enclosing left and right parenthesis. For example, when configured to remove spacing, `( int ) 0L;` becomes `(int) 0L;`.";
    }

    public JavaIsoVisitor<ExecutionContext> getVisitor() {
        return new TypecastParenPadVisitor();
    }

    private static class TypecastParenPadVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        SpacesStyle spacesStyle;
        TypecastParenPadStyle typecastParenPadStyle;

        private TypecastParenPadVisitor() {
        }

        @Override
        public JavaSourceFile visitJavaSourceFile(JavaSourceFile javaSourceFile, ExecutionContext ctx) {
            SourceFile cu = (SourceFile)javaSourceFile;
            this.spacesStyle = Optional.ofNullable((SpacesStyle)cu.getStyle(SpacesStyle.class)).orElse(IntelliJ.spaces());
            this.typecastParenPadStyle = Optional.ofNullable((TypecastParenPadStyle)cu.getStyle(TypecastParenPadStyle.class)).orElse(Checkstyle.typecastParenPadStyle());
            this.spacesStyle = this.spacesStyle.withWithin(this.spacesStyle.getWithin().withTypeCastParentheses(this.typecastParenPadStyle.getSpace()));
            return super.visitJavaSourceFile((JavaSourceFile)cu, ctx);
        }

        @Override
        public J.TypeCast visitTypeCast(J.TypeCast typeCast, ExecutionContext ctx) {
            J tc = super.visitTypeCast(typeCast, ctx);
            tc = (J.TypeCast)new SpacesVisitor(this.spacesStyle, null, null, tc).visitNonNull(tc, ctx, this.getCursor().getParentTreeCursor().fork());
            return tc;
        }
    }
}

