/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.time.Duration;
import java.util.Collections;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;

public class NoValueOfOnStringType
extends Recipe {
    private static final MethodMatcher VALUE_OF = new MethodMatcher("java.lang.String valueOf(..)");

    public String getDisplayName() {
        return "Unnecessary String#valueOf(..)";
    }

    public String getDescription() {
        return "Replace unnecessary `String#valueOf(..)` method invocations with the argument directly. This occurs when the argument to `String#valueOf(arg)` is a string literal, such as `String.valueOf(\"example\")`. Or, when the `String#valueOf(..)` invocation is used in a concatenation, such as `\"example\" + String.valueOf(\"example\")`.";
    }

    protected UsesMethod<ExecutionContext> getSingleSourceApplicableTest() {
        return new UsesMethod<ExecutionContext>(new MethodMatcher("java.lang.String valueOf(..)"));
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-1153");
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(4L);
    }

    public JavaVisitor<ExecutionContext> getVisitor() {
        return new JavaVisitor<ExecutionContext>(){
            private final JavaTemplate t = JavaTemplate.builder(() -> (this).getCursor(), "#{any(java.lang.String)}").build();

            @Override
            public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                Expression argument;
                if (VALUE_OF.matches(method.getSelect())) {
                    return method;
                }
                J.MethodInvocation mi = (J.MethodInvocation)super.visitMethodInvocation(method, ctx);
                if (VALUE_OF.matches(mi) && mi.getArguments().size() == 1 && (TypeUtils.isString((argument = mi.getArguments().get(0)).getType()) || this.removeValueOfFromBinaryExpression(argument))) {
                    return mi.withTemplate(this.t, mi.getCoordinates().replace(), argument);
                }
                return mi;
            }

            private boolean removeValueOfFromBinaryExpression(Expression argument) {
                if (TypeUtils.asPrimitive(argument.getType()) != null) {
                    J parent;
                    J j = parent = this.getCursor().getParent() != null ? (J)this.getCursor().getParent().firstEnclosing(J.class) : null;
                    if (parent instanceof J.Binary) {
                        J.Binary b = (J.Binary)parent;
                        JavaType otherType = b.getRight() == this.getCursor().getValue() ? b.getLeft().getType() : b.getRight().getType();
                        return TypeUtils.isString(otherType) && b.getOperator() == J.Binary.Type.Addition;
                    }
                }
                return false;
            }
        };
    }
}

