/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.cleanup.DefaultComesLast;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.marker.Marker;

public class MinimumSwitchCases
extends Recipe {
    public String getDisplayName() {
        return "`switch` statements should have at least 3 `case` clauses";
    }

    public String getDescription() {
        return "`switch` statements are useful when many code paths branch depending on the value of a single expression. For just one or two code paths, the code will be more readable with `if` statements.";
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-1301");
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(5L);
    }

    public JavaVisitor<ExecutionContext> getVisitor() {
        return new JavaVisitor<ExecutionContext>(){
            final JavaTemplate ifElseIfPrimitive = JavaTemplate.builder(() -> (this).getCursor(), "if(#{any()} == #{any()}) {\n} else if(#{any()} == #{any()}) {\n}").build();
            final JavaTemplate ifElseIfString = JavaTemplate.builder(() -> (this).getCursor(), "if(#{any(java.lang.String)}.equals(#{any(java.lang.String)})) {\n} else if(#{any(java.lang.String)}.equals(#{any(java.lang.String)})) {\n}").build();
            final JavaTemplate ifElseIfEnum = JavaTemplate.builder(() -> (this).getCursor(), "if(#{any()} == #{}) {\n} else if(#{any()} == #{}) {\n}").build();
            final JavaTemplate ifElsePrimitive = JavaTemplate.builder(() -> (this).getCursor(), "if(#{any()} == #{any()}) {\n} else {\n}").build();
            final JavaTemplate ifElseString = JavaTemplate.builder(() -> (this).getCursor(), "if(#{any(java.lang.String)}.equals(#{any(java.lang.String)})) {\n} else {\n}").build();
            final JavaTemplate ifElseEnum = JavaTemplate.builder(() -> (this).getCursor(), "if(#{any()} == #{}) {\n} else {\n}").build();
            final JavaTemplate ifPrimitive = JavaTemplate.builder(() -> (this).getCursor(), "if(#{any()} == #{any()}) {\n}").build();
            final JavaTemplate ifString = JavaTemplate.builder(() -> (this).getCursor(), "if(#{any(java.lang.String)}.equals(#{any(java.lang.String)})) {\n}").build();
            final JavaTemplate ifEnum = JavaTemplate.builder(() -> (this).getCursor(), "if(#{any()} == #{}) {\n}").build();

            @Override
            public J visitBlock(J.Block block, ExecutionContext executionContext) {
                return block.withStatements(ListUtils.flatMap(block.getStatements(), statement -> {
                    Statement visited = (Statement)this.visit((Tree)statement, executionContext, this.getCursor());
                    if (!(visited instanceof J.Switch) || !visited.getMarkers().findFirst(DefaultOnly.class).isPresent()) {
                        return visited;
                    }
                    J.Case defaultCase = (J.Case)((J.Switch)visited).getCases().getStatements().get(0);
                    return ListUtils.map(defaultCase.getStatements(), caseStatement -> {
                        if (caseStatement instanceof J.Break) {
                            return null;
                        }
                        return this.autoFormat(caseStatement, executionContext, this.getCursor());
                    });
                }));
            }

            @Override
            public J visitSwitch(J.Switch switzh, ExecutionContext ctx) {
                if (switzh.getCases().getStatements().size() < 3) {
                    J.If generatedIf;
                    J.Switch sortedSwitch = (J.Switch)new DefaultComesLast().getVisitor().visit((Tree)switzh, (Object)ctx);
                    assert (sortedSwitch != null);
                    J.Case[] cases = new J.Case[2];
                    int i = 0;
                    List<Statement> statements = sortedSwitch.getCases().getStatements();
                    for (int j = 0; j < statements.size(); ++j) {
                        Statement statement = statements.get(j);
                        if (!(statement instanceof J.Case)) continue;
                        J.Case aCase = (J.Case)statement;
                        if (aCase.getType() == J.Case.Type.Rule) {
                            if (aCase.getExpressions().size() > 1 || !(aCase.getBody() instanceof Statement)) {
                                return super.visitSwitch(switzh, ctx);
                            }
                        } else {
                            Statement lastStatement;
                            Statement statement2 = lastStatement = aCase.getStatements().isEmpty() ? null : aCase.getStatements().get(aCase.getStatements().size() - 1);
                            if (j != statements.size() - 1 && !(lastStatement instanceof J.Break) && !(lastStatement instanceof J.Return)) {
                                return super.visitSwitch(switzh, ctx);
                            }
                        }
                        cases[i++] = aCase;
                    }
                    if (i == 0) {
                        return super.visitSwitch(switzh, ctx);
                    }
                    Expression tree = sortedSwitch.getSelector().getTree();
                    if (TypeUtils.isString(tree.getType())) {
                        if (cases[1] == null) {
                            if (this.isDefault(cases[0])) {
                                return switzh.withMarkers(switzh.getMarkers().add((Marker)new DefaultOnly()));
                            }
                            generatedIf = (J.If)switzh.withTemplate(this.ifString, switzh.getCoordinates().replace(), cases[0].getPattern(), tree);
                        } else {
                            generatedIf = this.isDefault(cases[1]) ? (J.If)switzh.withTemplate(this.ifElseString, switzh.getCoordinates().replace(), cases[0].getPattern(), tree) : (J.If)switzh.withTemplate(this.ifElseIfString, switzh.getCoordinates().replace(), cases[0].getPattern(), tree, cases[1].getPattern(), tree);
                        }
                    } else if (this.switchesOnEnum(switzh)) {
                        if (cases[1] == null) {
                            if (this.isDefault(cases[0])) {
                                return switzh.withMarkers(switzh.getMarkers().add((Marker)new DefaultOnly()));
                            }
                            generatedIf = (J.If)switzh.withTemplate(this.ifEnum, switzh.getCoordinates().replace(), tree, this.enumIdentToFieldAccessString(cases[0].getPattern()));
                        } else {
                            generatedIf = this.isDefault(cases[1]) ? (J.If)switzh.withTemplate(this.ifElseEnum, switzh.getCoordinates().replace(), tree, this.enumIdentToFieldAccessString(cases[0].getPattern())) : (J.If)switzh.withTemplate(this.ifElseIfEnum, switzh.getCoordinates().replace(), tree, this.enumIdentToFieldAccessString(cases[0].getPattern()), tree, this.enumIdentToFieldAccessString(cases[1].getPattern()));
                        }
                    } else if (cases[1] == null) {
                        if (this.isDefault(cases[0])) {
                            return switzh.withMarkers(switzh.getMarkers().add((Marker)new DefaultOnly()));
                        }
                        generatedIf = (J.If)switzh.withTemplate(this.ifPrimitive, switzh.getCoordinates().replace(), tree, cases[0].getPattern());
                    } else {
                        generatedIf = this.isDefault(cases[1]) ? (J.If)switzh.withTemplate(this.ifElsePrimitive, switzh.getCoordinates().replace(), tree, cases[0].getPattern()) : (J.If)switzh.withTemplate(this.ifElseIfPrimitive, switzh.getCoordinates().replace(), tree, cases[0].getPattern(), tree, cases[1].getPattern());
                    }
                    List<Statement> thenStatements = this.getStatements(cases[0]);
                    generatedIf = generatedIf.withThenPart(((J.Block)generatedIf.getThenPart()).withStatements(ListUtils.map(thenStatements, s -> s instanceof J.Break ? null : s)));
                    if (cases[1] != null) {
                        assert (generatedIf.getElsePart() != null);
                        if (this.isDefault(cases[1])) {
                            generatedIf = generatedIf.withElsePart(generatedIf.getElsePart().withBody(((J.Block)generatedIf.getElsePart().getBody()).withStatements(ListUtils.map(this.getStatements(cases[1]), s -> s instanceof J.Break ? null : s))));
                        } else {
                            J.If elseIf = (J.If)generatedIf.getElsePart().getBody();
                            generatedIf = generatedIf.withElsePart(generatedIf.getElsePart().withBody(elseIf.withThenPart(((J.Block)elseIf.getThenPart()).withStatements(ListUtils.map(this.getStatements(cases[1]), s -> s instanceof J.Break ? null : s)))));
                        }
                    }
                    return this.autoFormat(generatedIf, ctx);
                }
                return super.visitSwitch(switzh, ctx);
            }

            private List<Statement> getStatements(J.Case aCase) {
                ArrayList<Statement> statements = new ArrayList<Statement>();
                for (Statement statement : aCase.getType() == J.Case.Type.Rule ? Collections.singletonList((Statement)aCase.getBody()) : aCase.getStatements()) {
                    if (statement instanceof J.Block) {
                        statements.addAll(((J.Block)statement).getStatements());
                        continue;
                    }
                    statements.add(statement);
                }
                return statements;
            }

            private boolean isDefault(J.Case caze) {
                return caze.getPattern() instanceof J.Identifier && ((J.Identifier)caze.getPattern()).getSimpleName().equals("default");
            }

            private boolean switchesOnEnum(J.Switch switzh) {
                JavaType selectorType = switzh.getSelector().getTree().getType();
                return selectorType instanceof JavaType.Class && ((JavaType.Class)selectorType).getKind() == JavaType.FullyQualified.Kind.Enum;
            }

            private String enumIdentToFieldAccessString(Expression casePattern) {
                String caseType = Objects.requireNonNull(TypeUtils.asFullyQualified(casePattern.getType())).getClassName();
                if (casePattern instanceof J.FieldAccess) {
                    return caseType + "." + ((J.FieldAccess)casePattern).getSimpleName();
                }
                return caseType + "." + ((J.Identifier)casePattern).getSimpleName();
            }
        };
    }

    private static final class DefaultOnly
    implements Marker {
        private final UUID id;

        public DefaultOnly() {
            this.id = Tree.randomId();
        }

        public UUID getId() {
            return this.id;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DefaultOnly)) {
                return false;
            }
            DefaultOnly other = (DefaultOnly)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @NonNull
        public String toString() {
            return "MinimumSwitchCases.DefaultOnly(id=" + this.getId() + ")";
        }

        @NonNull
        public DefaultOnly withId(UUID id) {
            return this.id == id ? this : new DefaultOnly(id);
        }

        public DefaultOnly(UUID id) {
            this.id = id;
        }
    }
}

