/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.time.Duration;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.format.TabsAndIndentsVisitor;
import org.openrewrite.java.style.IntelliJ;
import org.openrewrite.java.style.TabsAndIndentsStyle;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.Loop;
import org.openrewrite.java.tree.Statement;

public class ControlFlowIndentation
extends Recipe {
    public String getDisplayName() {
        return "Control flow statement indentation";
    }

    public String getDescription() {
        return "Program flow control statements like `if`, `while`, and `for` can omit curly braces when they apply to only a single statement. This recipe ensures that any statements which follow that statement are correctly indented to show they are not part of the flow control statement.";
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-2681");
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(5L);
    }

    public JavaIsoVisitor<ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){
            TabsAndIndentsStyle tabsAndIndentsStyle;

            @Override
            public JavaSourceFile visitJavaSourceFile(JavaSourceFile cu, ExecutionContext executionContext) {
                TabsAndIndentsStyle style = (TabsAndIndentsStyle)((SourceFile)cu).getStyle(TabsAndIndentsStyle.class);
                if (style == null) {
                    style = IntelliJ.tabsAndIndents();
                }
                this.tabsAndIndentsStyle = style;
                return super.visitJavaSourceFile(cu, executionContext);
            }

            @Override
            public J.Block visitBlock(J.Block block, ExecutionContext executionContext) {
                J b = super.visitBlock(block, executionContext);
                AtomicBoolean foundControlFlowRequiringReformatting = new AtomicBoolean(false);
                return ((J.Block)b).withStatements(ListUtils.map(((J.Block)b).getStatements(), (i, statement) -> {
                    if (foundControlFlowRequiringReformatting.get() || this.shouldReformat((Statement)statement)) {
                        foundControlFlowRequiringReformatting.set(true);
                        return (Statement)new TabsAndIndentsVisitor(this.tabsAndIndentsStyle).visit((Tree)statement, executionContext, this.getCursor());
                    }
                    return statement;
                }));
            }

            boolean shouldReformat(Statement s) {
                if (s instanceof J.If) {
                    return this.shouldReformat((J.If)s);
                }
                if (s instanceof Loop) {
                    Statement body = ((Loop)s).getBody();
                    return !(body instanceof J.Block);
                }
                return false;
            }

            boolean shouldReformat(J.If s) {
                Statement thenPart = s.getThenPart();
                if (!(thenPart instanceof J.Block)) {
                    return true;
                }
                return this.shouldReformat(s.getElsePart());
            }

            boolean shouldReformat(@Nullable J.If.Else s) {
                if (s == null) {
                    return false;
                }
                Statement body = s.getBody();
                if (body instanceof J.If) {
                    return this.shouldReformat((J.If)body);
                }
                return !(body instanceof J.Block);
            }
        };
    }
}

