/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.util.Collections;
import java.util.List;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.UnwrapParentheses;
import org.openrewrite.java.style.EqualsAvoidsNullStyle;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Space;

public final class EqualsAvoidsNullVisitor<P>
extends JavaIsoVisitor<P> {
    private static final MethodMatcher STRING_EQUALS = new MethodMatcher("String equals(java.lang.Object)");
    private static final MethodMatcher STRING_EQUALS_IGNORE_CASE = new MethodMatcher("String equalsIgnoreCase(java.lang.String)");
    private final EqualsAvoidsNullStyle style;

    @Override
    public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, P p) {
        J m = super.visitMethodInvocation(method, (Object)p);
        if (((J.MethodInvocation)m).getSelect() == null) {
            return m;
        }
        if ((STRING_EQUALS.matches((J.MethodInvocation)m) || !Boolean.TRUE.equals(this.style.getIgnoreEqualsIgnoreCase()) && STRING_EQUALS_IGNORE_CASE.matches((J.MethodInvocation)m)) && ((J.MethodInvocation)m).getArguments().get(0) instanceof J.Literal && !(((J.MethodInvocation)m).getSelect() instanceof J.Literal)) {
            J.Binary potentialNullCheck;
            J.Binary binary;
            J parent = (J)this.getCursor().getParentTreeCursor().getValue();
            if (parent instanceof J.Binary && (binary = (J.Binary)parent).getOperator() == J.Binary.Type.And && binary.getLeft() instanceof J.Binary && (this.isNullLiteral((potentialNullCheck = (J.Binary)binary.getLeft()).getLeft()) && this.matchesSelect(potentialNullCheck.getRight(), ((J.MethodInvocation)m).getSelect()) || this.isNullLiteral(potentialNullCheck.getRight()) && this.matchesSelect(potentialNullCheck.getLeft(), ((J.MethodInvocation)m).getSelect()))) {
                this.doAfterVisit(new RemoveUnnecessaryNullCheck(binary));
            }
            m = ((J.MethodInvocation)m).withSelect(((J.Literal)((J.MethodInvocation)m).getArguments().get(0)).withPrefix(((J.MethodInvocation)m).getSelect().getPrefix())).withArguments((List)Collections.singletonList((Expression)((J.MethodInvocation)m).getSelect().withPrefix(Space.EMPTY)));
        }
        return m;
    }

    private boolean isNullLiteral(Expression expression) {
        return expression instanceof J.Literal && ((J.Literal)expression).getType() == JavaType.Primitive.Null;
    }

    private boolean matchesSelect(Expression expression, Expression select) {
        return expression.printTrimmed(this.getCursor()).replaceAll("\\s", "").equals(select.printTrimmed(this.getCursor()).replaceAll("\\s", ""));
    }

    public EqualsAvoidsNullVisitor(EqualsAvoidsNullStyle style) {
        this.style = style;
    }

    public EqualsAvoidsNullStyle getStyle() {
        return this.style;
    }

    @NonNull
    public String toString() {
        return "EqualsAvoidsNullVisitor(style=" + this.getStyle() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EqualsAvoidsNullVisitor)) {
            return false;
        }
        EqualsAvoidsNullVisitor other = (EqualsAvoidsNullVisitor)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        EqualsAvoidsNullStyle this$style = this.getStyle();
        EqualsAvoidsNullStyle other$style = other.getStyle();
        return !(this$style == null ? other$style != null : !((Object)this$style).equals(other$style));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof EqualsAvoidsNullVisitor;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        EqualsAvoidsNullStyle $style = this.getStyle();
        result = result * 59 + ($style == null ? 43 : ((Object)$style).hashCode());
        return result;
    }

    private static class RemoveUnnecessaryNullCheck<P>
    extends JavaVisitor<P> {
        private final J.Binary scope;

        public RemoveUnnecessaryNullCheck(J.Binary scope) {
            this.scope = scope;
        }

        @Override
        public J visitBinary(J.Binary binary, P p) {
            J parens = (J)this.getCursor().getParentTreeCursor().getValue();
            if (parens instanceof J.Parentheses) {
                this.doAfterVisit(new UnwrapParentheses((J.Parentheses)parens));
            }
            if (this.scope.isScope(binary)) {
                return binary.getRight().withPrefix(Space.EMPTY);
            }
            return super.visitBinary(binary, p);
        }
    }
}

