/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.dataflow.internal;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openrewrite.Cursor;
import org.openrewrite.Incubating;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.Flag;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;

@FunctionalInterface
@Incubating(since="7.25.0")
public interface InvocationMatcher {
    public boolean matches(Expression var1);

    default public AdvancedInvocationMatcher advanced() {
        return new AdvancedInvocationMatcher(this);
    }

    public static InvocationMatcher fromMethodMatcher(MethodMatcher methodMatcher) {
        return methodMatcher::matches;
    }

    public static InvocationMatcher fromInvocationMatchers(Collection<InvocationMatcher> matchers) {
        if (matchers.isEmpty()) {
            return expression -> false;
        }
        if (matchers.size() == 1) {
            return matchers.iterator().next();
        }
        return expression -> matchers.stream().anyMatch(matcher -> matcher.matches(expression));
    }

    public static InvocationMatcher fromMethodMatchers(MethodMatcher ... methodMatchers) {
        return InvocationMatcher.fromInvocationMatchers(Stream.of(methodMatchers).map(InvocationMatcher::fromMethodMatcher).collect(Collectors.toList()));
    }

    public static InvocationMatcher fromMethodMatchers(Collection<MethodMatcher> matchers) {
        return InvocationMatcher.fromInvocationMatchers(matchers.stream().map(InvocationMatcher::fromMethodMatcher).collect(Collectors.toList()));
    }

    public static class AdvancedInvocationMatcher {
        InvocationMatcher matcher;

        public boolean isSelect(Cursor cursor) {
            Expression expression = AdvancedInvocationMatcher.ensureCursorIsExpression(cursor);
            assert (expression == cursor.getValue()) : "expression != cursor.getValue()";
            J.MethodInvocation maybeMethodInvocation = (J.MethodInvocation)cursor.getParentOrThrow().firstEnclosing(J.MethodInvocation.class);
            return maybeMethodInvocation != null && maybeMethodInvocation.getSelect() == expression && this.matcher.matches(maybeMethodInvocation);
        }

        public boolean isAnyArgument(Cursor cursor) {
            Expression expression = AdvancedInvocationMatcher.ensureCursorIsExpression(cursor);
            return AdvancedInvocationMatcher.nearestMethodCall(cursor).map(call -> call.getArguments().contains(expression) && this.matcher.matches((Expression)call)).orElse(false);
        }

        public boolean isFirstParameter(Cursor cursor) {
            return this.isParameter(cursor, 0);
        }

        public boolean isParameter(Cursor cursor, int parameterIndex) {
            Expression expression = AdvancedInvocationMatcher.ensureCursorIsExpression(cursor);
            if (parameterIndex < 0) {
                throw new IllegalArgumentException("parameterIndex < 0");
            }
            return AdvancedInvocationMatcher.nearestMethodCall(cursor).map(call -> {
                int finalParameterIndex;
                List<Expression> arguments = call.getArguments();
                if (parameterIndex >= arguments.size()) {
                    return false;
                }
                if (AdvancedInvocationMatcher.doesMethodHaveVarargs(call) && (finalParameterIndex = AdvancedInvocationMatcher.getType(call).map(JavaType.Method::getParameterTypes).map(List::size).map(size -> size - 1).orElse(-1).intValue()) == parameterIndex) {
                    List<Expression> varargs = arguments.subList(finalParameterIndex, arguments.size());
                    return varargs.contains(expression) && this.matcher.matches((Expression)call);
                }
                return arguments.get(parameterIndex) == expression && this.matcher.matches((Expression)call);
            }).orElse(false);
        }

        private static boolean doesMethodHaveVarargs(MethodCall expression) {
            return AdvancedInvocationMatcher.getType(expression).map(type -> type.hasFlags(Flag.Varargs)).orElse(false);
        }

        private static Optional<JavaType.Method> getType(MethodCall expression) {
            return Optional.ofNullable(expression.getMethodType());
        }

        private static Optional<MethodCall> nearestMethodCall(Cursor cursor) {
            J closestJ = (J)cursor.getParentTreeCursor().getValue();
            if (closestJ instanceof MethodCall) {
                return Optional.of((MethodCall)closestJ);
            }
            return Optional.empty();
        }

        private static Expression ensureCursorIsExpression(Cursor cursor) {
            if (cursor.getValue() instanceof Expression) {
                return (Expression)cursor.getValue();
            }
            throw new IllegalArgumentException("Cursor is not an expression. Was " + cursor.getValue().getClass());
        }

        private AdvancedInvocationMatcher(InvocationMatcher matcher) {
            this.matcher = matcher;
        }
    }
}

