/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collections;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.HasTypes;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;

public class BigDecimalRoundingConstantsToEnums
extends Recipe {
    private static final String BIG_DECIMAL_FQN = BigDecimal.class.getName();
    private static final String ROUNDING_MODE_FQN = RoundingMode.class.getName();
    private static final MethodMatcher BIG_DECIMAL_DIVIDE_METHOD_MATCHER = new MethodMatcher(BIG_DECIMAL_FQN + " divide(java.math.BigDecimal, int)");
    private static final MethodMatcher BIG_DECIMAL_DIVIDE_WITH_SCALE_METHOD_MATCHER = new MethodMatcher(BIG_DECIMAL_FQN + " divide(java.math.BigDecimal, int, int)");
    private static final MethodMatcher BIG_DECIMAL_SET_SCALE_METHOD_MATCHER = new MethodMatcher(BIG_DECIMAL_FQN + " setScale(int, int)");
    private static final ThreadLocal<JavaParser> JAVA_PARSER_THREAD_LOCAL = ThreadLocal.withInitial(() -> JavaParser.fromJavaVersion().build());

    public String getDisplayName() {
        return "`BigDecimal` rounding constants to `RoundingMode` enums";
    }

    public String getDescription() {
        return "Convert `BigDecimal` rounding constants to the equivalent `RoundingMode` enum.";
    }

    @Nullable
    protected TreeVisitor<?, ExecutionContext> getApplicableTest() {
        return new HasTypes(Collections.singletonList(BIG_DECIMAL_FQN)).getVisitor();
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){

            @Override
            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext executionContext) {
                J mi = super.visitMethodInvocation(method, executionContext);
                if ((BIG_DECIMAL_DIVIDE_METHOD_MATCHER.matches((J.MethodInvocation)mi) || BIG_DECIMAL_SET_SCALE_METHOD_MATCHER.matches((J.MethodInvocation)mi)) && this.isConvertibleBigDecimalConstant(((J.MethodInvocation)mi).getArguments().get(1))) {
                    mi = (J.MethodInvocation)mi.withTemplate(this.template("(#{}, #{})").imports(ROUNDING_MODE_FQN).javaParser((JavaParser)JAVA_PARSER_THREAD_LOCAL.get()).build(), ((J.MethodInvocation)mi).getCoordinates().replaceArguments(), ((J.MethodInvocation)mi).getArguments().get(0), this.getTemplateValue(((J.MethodInvocation)mi).getArguments().get(1)));
                    this.maybeAddImport(ROUNDING_MODE_FQN);
                } else if (BIG_DECIMAL_DIVIDE_WITH_SCALE_METHOD_MATCHER.matches((J.MethodInvocation)mi) && this.isConvertibleBigDecimalConstant(((J.MethodInvocation)mi).getArguments().get(2))) {
                    mi = (J.MethodInvocation)mi.withTemplate(this.template("(#{}, #{}, #{})").imports(ROUNDING_MODE_FQN).javaParser((JavaParser)JAVA_PARSER_THREAD_LOCAL.get()).build(), ((J.MethodInvocation)mi).getCoordinates().replaceArguments(), ((J.MethodInvocation)mi).getArguments().get(0), ((J.MethodInvocation)mi).getArguments().get(1), this.getTemplateValue(((J.MethodInvocation)mi).getArguments().get(2)));
                    this.maybeAddImport(ROUNDING_MODE_FQN);
                }
                return mi;
            }

            private boolean isConvertibleBigDecimalConstant(J elem) {
                J.FieldAccess fa;
                boolean isBigDecimal = false;
                if (elem instanceof J.Literal) {
                    isBigDecimal = true;
                } else if (elem instanceof J.FieldAccess && ((J.FieldAccess)elem).getTarget().getType() instanceof JavaType.FullyQualified && (fa = (J.FieldAccess)elem).getTarget().getType() != null && BIG_DECIMAL_FQN.equals(((JavaType.FullyQualified)fa.getTarget().getType()).getFullyQualifiedName())) {
                    isBigDecimal = true;
                }
                return isBigDecimal;
            }

            @Nullable
            private String getTemplateValue(J elem) {
                String roundingName = null;
                if (elem instanceof J.FieldAccess && ((J.FieldAccess)elem).getTarget().getType() instanceof JavaType.FullyQualified) {
                    J.FieldAccess fa = (J.FieldAccess)elem;
                    if (fa.getTarget().getType() != null && BIG_DECIMAL_FQN.equals(((JavaType.FullyQualified)fa.getTarget().getType()).getFullyQualifiedName())) {
                        roundingName = fa.getSimpleName();
                    }
                } else if (elem instanceof J.Literal) {
                    roundingName = ((J.Literal)elem).getValueSource();
                }
                if (roundingName != null) {
                    switch (roundingName) {
                        case "ROUND_UP": 
                        case "0": {
                            return "RoundingMode.UP";
                        }
                        case "ROUND_DOWN": 
                        case "1": {
                            return "RoundingMode.DOWN";
                        }
                        case "ROUND_CEILING": 
                        case "2": {
                            return "RoundingMode.CEILING";
                        }
                        case "ROUND_FLOOR": 
                        case "3": {
                            return "RoundingMode.FLOOR";
                        }
                        case "ROUND_HALF_UP": 
                        case "4": {
                            return "RoundingMode.HALF_UP";
                        }
                        case "ROUND_HALF_DOWN": 
                        case "5": {
                            return "RoundingMode.HALF_DOWN";
                        }
                        case "ROUND_HALF_EVEN": 
                        case "6": {
                            return "RoundingMode.HALF_EVEN";
                        }
                        case "ROUND_UNNECESSARY": 
                        case "7": {
                            return "RoundingMode.UNNECESSARY";
                        }
                    }
                }
                return null;
            }
        };
    }
}

