/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.Collections;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.AnnotationMatcher;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.Space;
import org.openrewrite.marker.Markers;

public final class RemoveAnnotation
extends Recipe {
    private static final J.Block EMPTY_BLOCK = new J.Block(Tree.randomId(), Space.EMPTY, Markers.EMPTY, new JRightPadded<Boolean>(false, Space.EMPTY, Markers.EMPTY), Collections.emptyList(), Space.EMPTY);
    @Option(displayName="Annotation pattern", description="An annotation pattern, expressed as a pointcut expression.", example="@java.lang.SuppressWarnings(\"deprecation\")")
    private final String annotationPattern;

    public String getDisplayName() {
        return "Remove annotation";
    }

    public String getDescription() {
        return "Remove matching annotations wherever they occur";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final AnnotationMatcher annotationMatcher = new AnnotationMatcher(this.annotationPattern);
        return new JavaIsoVisitor<ExecutionContext>(){

            @Override
            public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext ctx) {
                J c = super.visitClassDeclaration(classDecl, ctx);
                Boolean annotationRemoved = (Boolean)this.getCursor().pollMessage("annotationRemoved");
                if (annotationRemoved != null && annotationRemoved.booleanValue()) {
                    c = this.autoFormat(((J.ClassDeclaration)c).withBody(EMPTY_BLOCK), ctx, this.getCursor().getParentOrThrow()).withBody(((J.ClassDeclaration)c).getBody());
                }
                return c;
            }

            @Override
            public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, ExecutionContext ctx) {
                J m = super.visitMethodDeclaration(method, ctx);
                Boolean annotationRemoved = (Boolean)this.getCursor().pollMessage("annotationRemoved");
                if (annotationRemoved != null && annotationRemoved.booleanValue()) {
                    m = this.autoFormat(((J.MethodDeclaration)m).withBody(null), ctx, this.getCursor().getParentOrThrow()).withBody(((J.MethodDeclaration)m).getBody());
                }
                return m;
            }

            @Override
            public J.Annotation visitAnnotation(J.Annotation annotation, ExecutionContext ctx) {
                if (annotationMatcher.matches(annotation)) {
                    this.getCursor().getParentOrThrow().putMessage("annotationRemoved", (Object)true);
                    return null;
                }
                return super.visitAnnotation(annotation, ctx);
            }
        };
    }

    public RemoveAnnotation(String annotationPattern) {
        this.annotationPattern = annotationPattern;
    }

    public String getAnnotationPattern() {
        return this.annotationPattern;
    }

    @NonNull
    public String toString() {
        return "RemoveAnnotation(annotationPattern=" + this.getAnnotationPattern() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RemoveAnnotation)) {
            return false;
        }
        RemoveAnnotation other = (RemoveAnnotation)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$annotationPattern = this.getAnnotationPattern();
        String other$annotationPattern = other.getAnnotationPattern();
        return !(this$annotationPattern == null ? other$annotationPattern != null : !this$annotationPattern.equals(other$annotationPattern));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof RemoveAnnotation;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $annotationPattern = this.getAnnotationPattern();
        result = result * 59 + ($annotationPattern == null ? 43 : $annotationPattern.hashCode());
        return result;
    }
}

