/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.J;

public class UseListSort
extends Recipe {
    public String getDisplayName() {
        return "Replace invocations of `Collections#sort(List, Comparator)` with `List#sort(Comparator)`";
    }

    public String getDescription() {
        return "The `java.util.Collections#sort(..)` implementation defers to the `java.util.List#sort(Comparator)`, replaced it with the `java.util.List#sort(Comparator)` implementation for better readability.";
    }

    @Nullable
    protected TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        return new UsesMethod<ExecutionContext>(new MethodMatcher("java.util.Collections sort(..)"));
    }

    protected JavaIsoVisitor<ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){
            final MethodMatcher csM = new MethodMatcher("java.util.Collections sort(..)");

            @Override
            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext executionContext) {
                J mi = super.visitMethodInvocation(method, executionContext);
                if (this.csM.matches((J.MethodInvocation)mi)) {
                    this.maybeRemoveImport("java.util.Collections");
                    if (((J.MethodInvocation)mi).getArguments().size() == 1) {
                        return (J.MethodInvocation)mi.withTemplate(JavaTemplate.builder(() -> this.getCursor().getParent(), "#{any(java.util.List)}.sort(null)").imports("java.util.List").build(), ((J.MethodInvocation)mi).getCoordinates().replace(), ((J.MethodInvocation)mi).getArguments().get(0));
                    }
                    return (J.MethodInvocation)mi.withTemplate(JavaTemplate.builder(() -> this.getCursor().getParent(), "#{any(java.util.List)}.sort(#{any(java.util.Comparator)})").imports("java.util.List", "java.util.Comparator").build(), ((J.MethodInvocation)mi).getCoordinates().replace(), ((J.MethodInvocation)mi).getArguments().get(0), ((J.MethodInvocation)mi).getArguments().get(1));
                }
                return mi;
            }
        };
    }
}

